/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.test.model.response;

import org.odpi.openmetadata.accessservices.analyticsmodeling.model.response.AnalyticsMessage;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.JsonMocks;
import org.odpi.openmetadata.accessservices.analyticsmodeling.test.utils.TestUtilities;
import org.testng.annotations.Test;

public class AnalyticsMessageTest {
    private static final String SEVERITY = "error";
    private static final String ERROR_TITLE = "Error title";
    private static final String ERROR_DETAIL = "Error Detail";
    private static final String HTTP_STATUS = "200";
    private static final String CODE = "CODE";
    String master = JsonMocks.getError("200", "CODE", "Error title", "Error Detail", "error");
    String master_empty = String.format("{%n  \"meta\" : {%n    \"severity\" : \"%s\"%n  }%n}", "error");

    @Test
    public void toJson() {
        AnalyticsMessage obj = new AnalyticsMessage();
        obj.setCode(CODE);
        obj.setStatus(HTTP_STATUS);
        obj.setDetail(ERROR_DETAIL);
        obj.setTitle(ERROR_TITLE);
        obj.setSeverity(SEVERITY);
        TestUtilities.assertObjectJson(obj, this.master);
    }

    @Test
    public void toJsonEmpty() {
        AnalyticsMessage obj = new AnalyticsMessage();
        TestUtilities.assertObjectJson(obj, this.master_empty);
    }

    @Test
    public void fromJson() {
        AnalyticsMessage obj = TestUtilities.readObjectJson(this.master, AnalyticsMessage.class);
        TestUtilities.assertObjectJson(obj, this.master);
    }
}

