/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.client;

import org.odpi.openmetadata.accessservices.analyticsmodeling.api.AnalyticsModelingSynchronization;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.AnalyticsModelingRestClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class SynchronizationClient
implements AnalyticsModelingSynchronization {
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private AnalyticsModelingRestClient restClient;

    public SynchronizationClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Synchronization Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Synchronization Client Constructor");
        this.restClient = new AnalyticsModelingRestClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public SynchronizationClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Synchronization Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Synchronization Client Constructor");
        this.restClient = new AnalyticsModelingRestClient(serverName, serverPlatformURLRoot);
    }

    public SynchronizationClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Synchronization Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Synchronization Client Constructor");
        this.restClient = new AnalyticsModelingRestClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SynchronizationClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Synchronization Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Synchronization Client Constructor");
        this.restClient = new AnalyticsModelingRestClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public SynchronizationClient(String serverName, String serverPlatformURLRoot, AnalyticsModelingRestClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Synchronization Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Synchronization Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public ResponseContainerAssets createArtifact(String userId, String serverCapability, AnalyticsAsset artifact) throws AnalyticsModelingCheckedException, PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createArtifact";
        this.invalidParameterHandler.validateUserId(userId, "createArtifact");
        return this.restClient.createAssets(userId, serverCapability, artifact);
    }

    public ResponseContainerAssets updateArtifact(String userId, String serverCapability, AnalyticsAsset artifact) throws AnalyticsModelingCheckedException, PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateArtifact";
        this.invalidParameterHandler.validateUserId(userId, "updateArtifact");
        return this.restClient.updateAssets(userId, serverCapability, artifact);
    }

    public ResponseContainerAssets deleteArtifact(String userId, String serverCapability, String identifier) throws AnalyticsModelingCheckedException, PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "deleteArtifact";
        this.invalidParameterHandler.validateUserId(userId, "deleteArtifact");
        return this.restClient.deleteAssets(userId, serverCapability, identifier);
    }
}

