/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ModuleTableFilter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabaseSchema;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerSchemaTables;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AnalyticsModelingOMASAPIResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AssetsResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.DatabasesResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.ModuleResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.SchemaTablesResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.SchemasResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class AnalyticsModelingRestClient
extends FFDCRESTClient {
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final String urlTemplateResource = "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/";
    private final String urlTemplateSynchronization = "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}";
    private final String urlTemplateSynchronizationWithGUID = "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}&serverCapabilityGUID={3}";

    public AnalyticsModelingRestClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public AnalyticsModelingRestClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AnalyticsModelingRestClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public AnalyticsModelingRestClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public List<ResponseContainerDatabase> getDatabases(String userId, int startFrom, int pageSize) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getDatabases";
        String url = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/databases?startFrom={2}&pageSize={3}";
        AnalyticsModelingOMASAPIResponse response = (AnalyticsModelingOMASAPIResponse)this.callGetRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, url, new Object[]{this.serverName, userId, startFrom, pageSize});
        this.handleFailedResponse(response, methodName);
        return ((DatabasesResponse)response).getDatabasesList();
    }

    public List<ResponseContainerDatabaseSchema> getSchemas(String userId, String databaseGuid, int startFrom, int pageSize) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getSchemas";
        String url = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/{2}/schemas?startFrom={3}&pageSize={4}";
        AnalyticsModelingOMASAPIResponse response = (AnalyticsModelingOMASAPIResponse)this.callGetRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, url, new Object[]{this.serverName, userId, databaseGuid, startFrom, pageSize});
        this.handleFailedResponse(response, methodName);
        return ((SchemasResponse)response).getSchemaList();
    }

    public ResponseContainerSchemaTables getTables(String userId, String databaseGuid, String catalog, String schema) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getTables";
        String url = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/{2}/tables?catalog={3}&schema={4}";
        AnalyticsModelingOMASAPIResponse response = (AnalyticsModelingOMASAPIResponse)this.callPostRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, url, null, new Object[]{this.serverName, userId, databaseGuid, catalog, schema});
        this.handleFailedResponse(response, methodName);
        return ((SchemaTablesResponse)response).getTableList();
    }

    public ResponseContainerModule getModule(String userId, String databaseGuid, String catalog, String schema, ModuleTableFilter request) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getModule";
        String url = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/{2}/physicalModule?catalog={3}&schema={4}";
        AnalyticsModelingOMASAPIResponse response = (AnalyticsModelingOMASAPIResponse)this.callPostRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, url, request, new Object[]{this.serverName, userId, databaseGuid, catalog, schema});
        this.handleFailedResponse(response, methodName);
        return ((ModuleResponse)response).getModule();
    }

    public ResponseContainerAssets createAssets(String user, String serverCapability, String serverCapabilityGUID, AnalyticsAsset artifact) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createAssets";
        AnalyticsModelingOMASAPIResponse response = serverCapabilityGUID == null ? (AnalyticsModelingOMASAPIResponse)this.callPostRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}", artifact, new Object[]{this.serverName, user, serverCapability}) : (AnalyticsModelingOMASAPIResponse)this.callPostRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}&serverCapabilityGUID={3}", artifact, new Object[]{this.serverName, user, serverCapability, serverCapabilityGUID});
        this.handleFailedResponse(response, methodName);
        return ((AssetsResponse)response).getAssetList();
    }

    public ResponseContainerAssets updateAssets(String user, String serverCapability, String serverCapabilityGUID, AnalyticsAsset artifact) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateAssets";
        AnalyticsModelingOMASAPIResponse response = serverCapabilityGUID == null ? (AnalyticsModelingOMASAPIResponse)this.callPutRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}", artifact, new Object[]{this.serverName, user, serverCapability}) : (AnalyticsModelingOMASAPIResponse)this.callPutRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}&serverCapabilityGUID={3}", artifact, new Object[]{this.serverName, user, serverCapability, serverCapabilityGUID});
        this.handleFailedResponse(response, methodName);
        return ((AssetsResponse)response).getAssetList();
    }

    public ResponseContainerAssets deleteAssets(String user, String serverCapability, String serverCapabilityGUID, String identifier) throws PropertyServerException, AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "deleteAssets";
        AnalyticsModelingOMASAPIResponse response = serverCapabilityGUID == null ? (AnalyticsModelingOMASAPIResponse)this.callDeleteRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}&identifier={3}", null, new Object[]{this.serverName, user, serverCapability, identifier}) : (AnalyticsModelingOMASAPIResponse)this.callDeleteRESTCall(methodName, AnalyticsModelingOMASAPIResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/analytics-modeling/users/{1}/sync?serverCapability={2}&serverCapabilityGUID={3}&identifier={4}", null, new Object[]{this.serverName, user, serverCapability, serverCapabilityGUID, identifier});
        this.handleFailedResponse(response, methodName);
        return ((AssetsResponse)response).getAssetList();
    }

    private void handleFailedResponse(AnalyticsModelingOMASAPIResponse response, String methodName) throws AnalyticsModelingCheckedException, InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.restExceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)response);
        if (response.getRelatedHTTPCode() != 200) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAIL_REST_CALL.getMessageDefinition(new String[]{methodName, response.getExceptionErrorMessage()}), ((Object)((Object)this)).getClass().getSimpleName(), methodName);
        }
    }
}

