/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.analyticsmodeling.client.ImportClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.SynchronizationClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.common.AnalyticsModelingTestBase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest
extends AnalyticsModelingTestBase {
    private static final AnalyticsAsset ARTIFACT = new AnalyticsAsset();
    private static final int INVALID_PAGE_SIZE = -5;
    private static final int INVALID_START_FROM = -4;
    private static final String EXCEPTION_EXPECTED = "(exception expected)";
    private static final String GUID_DB = "12345";
    private static final String TESTCASENAME = "InvalidParameterTest";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(TESTCASENAME);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceCode(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceName(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceDescription(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceWiki());
        thisTest.testImportClient_getDatabase(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testImportClient_getSchema(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testImportClient_getTables(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testImportClient_getModule(serverName, serverPlatformRootURL, userId, auditLog);
        thisTest.testSynchronizationClient_CreateArtifact(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testImportClient_getDatabase(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        ImportClient client = this.getImportClient(serverName, serverPlatformRootURL, auditLog, TESTCASENAME);
        this.testInvalidUser_getDatabase(client);
        this.testStartFrom_getDatabase(userId, client);
        this.testPageSize_getDatabase(userId, client);
    }

    private void testPageSize_getDatabase(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testPageSize_getDatabase";
        try {
            client.getDatabases(userId, 0, -5);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testPageSize_getDatabase(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testPageSize_getDatabase", unexpectedError);
            }
            return;
        }
    }

    private void testStartFrom_getDatabase(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testStartFrom_getDatabase";
        try {
            client.getDatabases(userId, -4, 0);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testStartFrom_getDatabase(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testStartFrom_getDatabase", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidUser_getDatabase(ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_getDatabase";
        try {
            client.getDatabases(null, 0, 0);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getDatabase(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getDatabase", unexpectedError);
            }
            return;
        }
    }

    private void testImportClient_getSchema(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        ImportClient client = this.getImportClient(serverName, serverPlatformRootURL, auditLog, TESTCASENAME);
        this.testInvalidUser_getSchemas(client);
        this.testInvalidGuid_getSchemas(userId, client);
        this.testStartFrom_getSchemas(userId, client);
        this.testPageSize_getSchemas(userId, client);
    }

    private void testPageSize_getSchemas(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testPageSize_getSchemas";
        try {
            client.getSchemas(userId, GUID_DB, 0, -5);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testPageSize_getSchemas(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testPageSize_getSchemas", unexpectedError);
            }
            return;
        }
    }

    private void testStartFrom_getSchemas(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testStartFrom_getSchemas";
        try {
            client.getSchemas(userId, GUID_DB, -4, 0);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testStartFrom_getSchemas(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testStartFrom_getSchemas", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidGuid_getSchemas(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidGuid_getSchemas";
        try {
            client.getSchemas(userId, null, 0, 0);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidGuid_getSchemas(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidGuid_getSchemas", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidUser_getSchemas(ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_getSchemas";
        try {
            client.getSchemas(null, GUID_DB, 0, 0);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getSchemas(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getSchemas", unexpectedError);
            }
            return;
        }
    }

    private void testImportClient_getTables(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        ImportClient client = this.getImportClient(serverName, serverPlatformRootURL, auditLog, TESTCASENAME);
        this.testInvalidUser_getTables(client);
        this.testInvalidGuid_getTables(userId, client);
    }

    private void testInvalidGuid_getTables(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidGuid_getTables";
        try {
            client.getTables(userId, null, "catalog", "schema");
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidGuid_getTables(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidGuid_getTables", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidUser_getTables(ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_getTables";
        try {
            client.getTables(null, GUID_DB, "catalog", "schema");
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getTables(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getTables", unexpectedError);
            }
            return;
        }
    }

    private void testImportClient_getModule(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        ImportClient client = this.getImportClient(serverName, serverPlatformRootURL, auditLog, TESTCASENAME);
        this.testInvalidUser_getModule(client);
        this.testInvalidGuid_getModule(userId, client);
    }

    private void testInvalidGuid_getModule(String userId, ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidGuid_getModule";
        try {
            client.getModule(userId, null, "catalog", "schema", null);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidGuid_getModule(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidGuid_getModule", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidUser_getModule(ImportClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_getModule";
        try {
            client.getModule(null, GUID_DB, "catalog", "schema", null);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getModule(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_getModule", unexpectedError);
            }
            return;
        }
    }

    private void testSynchronizationClient_CreateArtifact(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        SynchronizationClient client = this.getSynchronizationClient(serverName, serverPlatformRootURL, auditLog, TESTCASENAME);
        this.testInvalidUser_CreateArtifact(client);
        this.testInvalidUser_UpdateArtifact(client);
        this.testInvalidUser_DeleteArtifact(client);
    }

    private void testInvalidUser_CreateArtifact(SynchronizationClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_CreateModule";
        try {
            client.createArtifact(null, "serverCapability", ARTIFACT);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_CreateModule(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_CreateModule", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidUser_UpdateArtifact(SynchronizationClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_UpdateArtifact";
        try {
            client.updateArtifact(null, "serverCapability", ARTIFACT);
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_UpdateArtifact(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_UpdateArtifact", unexpectedError);
            }
            return;
        }
    }

    private void testInvalidUser_DeleteArtifact(SynchronizationClient client) throws FVTUnexpectedCondition {
        String activityName = "testInvalidUser_DeleteArtifact";
        try {
            client.deleteArtifact(null, "serverCapability", "identifier");
            throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_DeleteArtifact(exception expected)");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            if (!(unexpectedError instanceof InvalidParameterException)) {
                throw new FVTUnexpectedCondition(TESTCASENAME, "testInvalidUser_DeleteArtifact", unexpectedError);
            }
            return;
        }
    }
}

