/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.common;

import org.odpi.openmetadata.accessservices.analyticsmodeling.client.AnalyticsModelingRestClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.ImportClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.SynchronizationClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.RepositoryService;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class AnalyticsModelingTestBase {
    protected static final int maxPageSize = 100;

    protected ImportClient getImportClient(String serverName, String serverPlatformRootURL, AuditLog auditLog, String testCaseName) throws FVTUnexpectedCondition {
        String activityName = "getImportClient";
        try {
            AnalyticsModelingRestClient restClient = new AnalyticsModelingRestClient(serverName, serverPlatformRootURL);
            return new ImportClient(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getImportClient", unexpectedError);
        }
    }

    protected SynchronizationClient getSynchronizationClient(String serverName, String serverPlatformRootURL, AuditLog auditLog, String testCaseName) throws FVTUnexpectedCondition {
        String activityName = "getSynchronizationClient";
        try {
            AnalyticsModelingRestClient restClient = new AnalyticsModelingRestClient(serverName, serverPlatformRootURL);
            return new SynchronizationClient(serverName, serverPlatformRootURL, restClient, 100);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getSynchronizationClient", unexpectedError);
        }
    }

    protected RepositoryService getRepositoryServiceClient(String serverName, String userId, String serverPlatformRootURL, String testCaseName) throws FVTUnexpectedCondition {
        String activityName = "getRepositoryServiceClient";
        try {
            return new RepositoryService(serverName, userId, serverPlatformRootURL, "getRepositoryServiceClient");
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getRepositoryServiceClient", unexpectedError);
        }
    }
}

