/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.synchronization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.SynchronizationClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.RepositoryService;
import org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.common.AnalyticsModelingTestBase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class SynchronizationTest
extends AnalyticsModelingTestBase {
    private static final String RESPONSE_DOES_NOT_CONTAIN_GUID_OF_THE_AFFECTED_ARTIFACT = ": (response does not contain GUID of the affected artifact)";
    private static final String TESTCASENAME = "SynchronizationTest";
    private static final String SERVERCAPABILITY = "ServerCapabilityAnalytiscModelingFVT_26";
    private static final String INPUT_FOLDER = "/src/test/resources/synchronization/input/";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(TESTCASENAME);
        results.incrementNumberOfTests();
        try {
            SynchronizationTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        SynchronizationTest thisTest = new SynchronizationTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceWiki());
        SynchronizationClient client = thisTest.getSynchronizationClient(serverName, serverPlatformRootURL, auditLog, TESTCASENAME);
        RepositoryService repositoryClient = thisTest.getRepositoryServiceClient(serverName, userId, serverPlatformRootURL, TESTCASENAME);
        SynchronizationTest.testCreateArtifact(repositoryClient, client, userId);
        SynchronizationTest.testUpdateArtifact(repositoryClient, client, userId);
        SynchronizationTest.testDeleteArtifact(client, userId);
    }

    private static void testCreateArtifact(RepositoryService repositoryClient, SynchronizationClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateArtifact";
        try {
            AnalyticsAsset artifact = SynchronizationTest.readObjectJson(INPUT_FOLDER, "create", AnalyticsAsset.class);
            repositoryClient.createRequiredEntities(artifact);
            ResponseContainerAssets assets = client.createArtifact(userId, SERVERCAPABILITY, null, artifact);
            if (assets.getAssetsList().size() != 1) {
                throw new FVTUnexpectedCondition(TESTCASENAME, activityName + RESPONSE_DOES_NOT_CONTAIN_GUID_OF_THE_AFFECTED_ARTIFACT);
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(TESTCASENAME, activityName, (Throwable)unexpectedError);
        }
    }

    private static void testUpdateArtifact(RepositoryService repositoryClient, SynchronizationClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testUpdateArtifact";
        try {
            AnalyticsAsset artifact = SynchronizationTest.readObjectJson(INPUT_FOLDER, "update", AnalyticsAsset.class);
            repositoryClient.createRequiredEntities(artifact);
            ResponseContainerAssets assets = client.updateArtifact(userId, SERVERCAPABILITY, null, artifact);
            if (assets.getAssetsList().size() != 1) {
                throw new FVTUnexpectedCondition(TESTCASENAME, activityName + RESPONSE_DOES_NOT_CONTAIN_GUID_OF_THE_AFFECTED_ARTIFACT);
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(TESTCASENAME, activityName, (Throwable)unexpectedError);
        }
    }

    private static void testDeleteArtifact(SynchronizationClient client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testDeleteArtifact";
        try {
            ResponseContainerAssets assets = client.deleteArtifact(userId, SERVERCAPABILITY, null, "iBASEMODULE");
            if (assets.getAssetsList().size() != 1) {
                throw new FVTUnexpectedCondition(TESTCASENAME, activityName + RESPONSE_DOES_NOT_CONTAIN_GUID_OF_THE_AFFECTED_ARTIFACT);
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(TESTCASENAME, activityName, (Throwable)unexpectedError);
        }
    }

    public static <T> T readObjectJson(String folder, String fileName, Class<T> cls) throws IOException {
        String root = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        String input = root + folder + fileName + ".json";
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(new String(Files.readAllBytes(Paths.get(input, new String[0]))), cls);
    }
}

