/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.analyticsmodeling.client.AnalyticsModelingRestClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.ImportClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.client.SynchronizationClient;
import org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.common.AnalyticsModelingTestBase;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest
extends AnalyticsModelingTestBase {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceCode(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceName(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceDescription(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceWiki());
        thisTest.testImportClient(serverName, serverPlatformRootURL, auditLog);
        thisTest.testSynchronizationClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testImportClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new ImportClient(serverName, serverPlatformRootURL, auditLog);
        new ImportClient(serverName, serverPlatformRootURL);
        new ImportClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new ImportClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AnalyticsModelingRestClient restClient = new AnalyticsModelingRestClient(serverName, serverPlatformRootURL);
        new ImportClient(serverName, serverPlatformRootURL, restClient, 100);
    }

    private void testSynchronizationClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new SynchronizationClient(serverName, serverPlatformRootURL, auditLog);
        new SynchronizationClient(serverName, serverPlatformRootURL);
        new SynchronizationClient(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new SynchronizationClient(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AnalyticsModelingRestClient restClient = new AnalyticsModelingRestClient(serverName, serverPlatformRootURL);
        new SynchronizationClient(serverName, serverPlatformRootURL, restClient, 100);
    }
}

