/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.fvt;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.fvt.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsMetadata;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataContainer;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataItem;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesUtilities;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class RepositoryService {
    private static final String ODBC_TYPE = "odbc_type";
    public static final String TYPE_SUFFIX = "_type";
    private final String context;
    HashMap<String, String> uid2guid = new HashMap();
    private final String userId;
    private final LocalRepositoryServicesClient client;
    protected OMRSRepositoryPropertiesUtilities propertyUtils = new OMRSRepositoryPropertiesUtilities();

    public RepositoryService(String serverName, String userId, String serverPlatformRootURL, String context) throws InvalidParameterException {
        this.context = context;
        this.userId = userId;
        this.client = new LocalRepositoryServicesClient("repository", serverPlatformRootURL + "/servers/" + serverName);
    }

    public void createRequiredEntities(AnalyticsAsset artifact) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        this.createReferencedEntitiesForMetadataLinks(artifact.getQualifiedName(), artifact.getContainer());
    }

    private void createReferencedEntitiesForMetadataLinks(String parentQName, List<? extends AnalyticsMetadata> list) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, UserNotAuthorizedException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            AnalyticsMetadata mtdObject = list.get(i);
            if (mtdObject instanceof MetadataItem) {
                this.createReferencedColumns(parentQName, i + 1, mtdObject);
                this.createReferencedEntitiesForMetadataLinks(mtdObject.getQualifiedName(), ((MetadataItem)mtdObject).getItem());
                continue;
            }
            if (!(mtdObject instanceof MetadataContainer)) continue;
            this.createReferencedEntitiesForMetadataLinks(mtdObject.getQualifiedName(), ((MetadataContainer)mtdObject).getContainer());
            this.createReferencedEntitiesForMetadataLinks(mtdObject.getQualifiedName(), ((MetadataContainer)mtdObject).getItem());
        }
    }

    private void createReferencedColumns(String parentQName, int position, AnalyticsMetadata mtdObject) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (mtdObject.getSourceGuid() == null) {
            return;
        }
        for (int j = 0; j < mtdObject.getSourceGuid().size(); ++j) {
            String guid;
            String id = (String)mtdObject.getSourceGuid().get(j);
            if (!this.uid2guid.containsKey(id)) {
                EntityDetail entity = this.createReferencedColumn(parentQName, ((MetadataItem)mtdObject).getExpression(), position);
                guid = entity.getGUID();
                this.uid2guid.put(id, entity.getGUID());
            } else {
                guid = this.uid2guid.get(id);
            }
            mtdObject.getSourceGuid().set(j, guid);
        }
    }

    protected EntityDetail createReferencedColumn(String parentQName, String columnName, int position) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String method = "createReferencedColumn";
        String columnQName = RepositoryService.buildQualifiedName(parentQName, "RelationalColumn", columnName);
        InstanceProperties properties = new EntityPropertiesBuilder(this.context, method, null).withStringProperty("qualifiedName", columnQName).withStringProperty("displayName", columnName).withIntegerProperty("position", position).build();
        return this.client.addEntity(this.userId, "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", properties, null, InstanceStatus.ACTIVE);
    }

    public void cleanRepository() throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException, PagingErrorException, EntityNotKnownException, EntityNotDeletedException {
        String[] types;
        for (String type : types = new String[]{"0921c83f-b2db-4086-a52c-0d10e52ca078", "eab811ec-556a-45f1-9091-bc7ac8face0f", "f20f5f45-1afb-41c1-9a09-34d8812626a4", "ce7e72b8-396a-4013-8688-f9d973067425", "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "646727c7-9ad4-46fa-b660-265489ad96c6"}) {
            if (!this.deleteEntitiesByType(type)) break;
        }
    }

    private boolean deleteEntitiesByType(String entityTypeGUID) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException, PagingErrorException, EntityNotKnownException, EntityNotDeletedException {
        List entities = this.client.findEntities(this.userId, entityTypeGUID, null, null, 0, null, null, null, null, null, 0);
        if (entities != null && !entities.isEmpty()) {
            for (EntityDetail entity : entities) {
                this.client.deleteEntity(this.userId, entityTypeGUID, entity.getType().getTypeDefName(), entity.getGUID());
                this.client.purgeEntity(this.userId, entityTypeGUID, entity.getType().getTypeDefName(), entity.getGUID());
            }
            return true;
        }
        return false;
    }

    public EntityDetail createDatabaseEntity(String dbName, String type, String version) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String qualifiedName = RepositoryService.buildQualifiedName("", "Database", dbName);
        InstanceProperties properties = new EntityPropertiesBuilder(this.context, "createDatabaseEntity", null).withStringProperty("qualifiedName", qualifiedName).withStringProperty("name", dbName).withStringProperty("type", type).withStringProperty("version", version).build();
        return this.client.addEntity(this.userId, "0921c83f-b2db-4086-a52c-0d10e52ca078", properties, null, InstanceStatus.ACTIVE);
    }

    public EntityDetail createDatabaseSchemaEntity(String guidDB, String schemaName) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException {
        String methodName = "createDatabaseSchemaEntity";
        EntityDetail db = this.client.getEntityDetail(this.userId, guidDB);
        String dbQName = this.getEntityQName(db, methodName);
        String qualifiedName = RepositoryService.buildQualifiedName(dbQName, "DeployedDatabaseSchema", schemaName);
        InstanceProperties properties = new EntityPropertiesBuilder(this.context, methodName, null).withStringProperty("qualifiedName", qualifiedName).withStringProperty("name", schemaName).build();
        EntityDetail schema = this.client.addEntity(this.userId, "eab811ec-556a-45f1-9091-bc7ac8face0f", properties, null, InstanceStatus.ACTIVE);
        this.client.addRelationship(this.userId, "b827683c-2924-4df3-a92d-7be1888e23c0", null, db.getGUID(), schema.getGUID(), InstanceStatus.ACTIVE);
        return schema;
    }

    String getEntityQName(EntityDetail entity, String methodName) {
        return this.propertyUtils.getStringProperty(this.context, "qualifiedName", entity.getProperties(), methodName);
    }

    public EntityDetail createSchemaTable(EntityDetail schema, String tableName) throws InvalidParameterException, TypeErrorException, EntityProxyOnlyException, ClassificationErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException, StatusNotSupportedException {
        String method = "createSchemaTable";
        List<Relationship> relationshipsRDBSchemaList = this.client.getRelationshipsForEntity(this.userId, schema.getGUID(), "815b004d-73c6-4728-9dd9-536f4fe803cd", 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, 0);
        String schemaQName = this.getEntityQName(schema, method);
        if (relationshipsRDBSchemaList == null || relationshipsRDBSchemaList.isEmpty()) {
            String relationalSchemaQName = RepositoryService.buildQualifiedName(schemaQName, "RelationalDBSchemaType", tableName);
            InstanceProperties properties = new EntityPropertiesBuilder(this.context, method, null).withStringProperty("qualifiedName", relationalSchemaQName).build();
            EntityDetail relationalDBSchemaType = this.client.addEntity(this.userId, "f20f5f45-1afb-41c1-9a09-34d8812626a4", properties, null, null);
            Relationship relationship = this.client.addRelationship(this.userId, "815b004d-73c6-4728-9dd9-536f4fe803cd", null, schema.getGUID(), relationalDBSchemaType.getGUID(), null);
            relationshipsRDBSchemaList = Arrays.asList(relationship);
        }
        Relationship relRDBSchema = (Relationship)relationshipsRDBSchemaList.get(0);
        EntityDetail entityRDBSchema = this.client.getEntityDetail(this.userId, relRDBSchema.getEntityTwoProxy().getGUID());
        String tableQName = RepositoryService.buildQualifiedName(this.getEntityQName(entityRDBSchema, method), "RelationalTable", tableName);
        InstanceProperties properties = new EntityPropertiesBuilder(this.context, method, null).withStringProperty("qualifiedName", tableQName).withStringProperty("displayName", tableName).build();
        EntityDetail entityTable = this.client.addEntity(this.userId, "ce7e72b8-396a-4013-8688-f9d973067425", properties, null, null);
        this.client.addRelationship(this.userId, "86b176a2-015c-44a6-8106-54d5d69ba661", null, entityRDBSchema.getGUID(), entityTable.getGUID(), null);
        return entityTable;
    }

    public EntityDetail addColumn(EntityDetail tableEntity, String columnName, String dataType, String vendorType, int position) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException, ClassificationErrorException, StatusNotSupportedException, EntityProxyOnlyException {
        String method = "addColumn";
        String columnQName = RepositoryService.buildQualifiedName(this.getEntityQName(tableEntity, method), "RelationalColumn", columnName);
        InstanceProperties columnTypeProperties = new EntityPropertiesBuilder(this.context, method, null).withStringProperty("qualifiedName", columnQName).withStringProperty("displayName", columnName).withIntegerProperty("position", position).build();
        EntityDetail columnEntity = this.client.addEntity(this.userId, "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", columnTypeProperties, null, null);
        this.client.addRelationship(this.userId, "0ffb9d87-7074-45da-a9b0-ae0859611133", null, tableEntity.getGUID(), columnEntity.getGUID(), null);
        if (dataType != null) {
            this.setColumnNoteLogProperty(columnEntity, ODBC_TYPE, dataType);
        }
        if (vendorType != null) {
            this.setColumnNoteLogProperty(columnEntity, "type", vendorType);
        }
        return columnEntity;
    }

    public void setColumnNoteLogProperty(EntityDetail columnEntity, String propName, String propValue) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException, EntityProxyOnlyException, ClassificationErrorException, StatusNotSupportedException {
        String methodName = "setColumnNoteLogProperty";
        EntityDetail columnTypeEntity = this.getColumnType(columnEntity);
        InstanceProperties ap = this.propertyUtils.getMapProperty(this.context, "additionalProperties", columnTypeEntity.getProperties(), methodName);
        if (ap == null) {
            ap = new InstanceProperties();
        }
        EntityPropertiesBuilder pb = new EntityPropertiesBuilder(this.context, methodName, ap);
        pb.withStringProperty(propName, propValue);
        MapPropertyValue mpv = new MapPropertyValue();
        mpv.setMapValues(ap);
        InstanceProperties properties = columnTypeEntity.getProperties();
        properties.setProperty("additionalProperties", (InstancePropertyValue)mpv);
        this.client.updateEntityProperties(this.userId, columnTypeEntity.getGUID(), properties);
    }

    private EntityDetail getColumnType(EntityDetail columnEntity) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException, EntityProxyOnlyException, ClassificationErrorException, StatusNotSupportedException {
        String method = "getColumnType";
        List columnToColumnType = this.client.getRelationshipsForEntity(this.userId, columnEntity.getGUID(), "4f798c0c-6769-4a2d-b489-d2714d89e0a4", 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, 0);
        if (columnToColumnType != null && !columnToColumnType.isEmpty()) {
            return this.client.getEntityDetail(this.userId, ((Relationship)columnToColumnType.get(0)).getEntityTwoProxy().getGUID());
        }
        String columnName = this.propertyUtils.getStringProperty(this.context, "displayName", columnEntity.getProperties(), method);
        String columnTypeQName = RepositoryService.buildQualifiedName(this.getEntityQName(columnEntity, method), "RelationalColumn", columnName + TYPE_SUFFIX);
        InstanceProperties columnTypeProperties = new EntityPropertiesBuilder(this.context, "getColumnType", null).withStringProperty("qualifiedName", columnTypeQName).build();
        EntityDetail columnNoteLogEntity = this.client.addEntity(this.userId, "646727c7-9ad4-46fa-b660-265489ad96c6", columnTypeProperties, null, null);
        this.client.addRelationship(this.userId, "4f798c0c-6769-4a2d-b489-d2714d89e0a4", null, columnEntity.getGUID(), columnNoteLogEntity.getGUID(), null);
        return columnNoteLogEntity;
    }

    private static String buildQualifiedName(String parentQualifiedName, String typeName, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(parentQualifiedName == null || parentQualifiedName.isEmpty() ? "" : parentQualifiedName + "::")).append("(").append(typeName).append(")").append("=").append(value);
        return sb.toString();
    }
}

