/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.contentmanager;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.analyticsmodeling.auditlog.AnalyticsModelingAuditCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class OMEntityDao {
    protected final OMRSRepositoryConnector enterpriseConnector;
    protected List<String> supportedZones;
    private final AuditLog auditLog;
    private String context;
    private static final List<InstanceStatus> FILTER_ACTIVE = Arrays.asList(InstanceStatus.ACTIVE);

    public OMEntityDao(OMRSRepositoryConnector enterpriseConnector, List<String> supportedZones, AuditLog auditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.auditLog = auditLog;
        this.supportedZones = supportedZones;
    }

    public void setContext(String value) {
        this.context = value;
    }

    public List<EntityDetail> findEntities(InstanceProperties matchProperties, String typeName, int fromElement, int pageSize) throws AnalyticsModelingCheckedException {
        List existingEntities;
        OMRSRepositoryHelper repositoryHelper = this.enterpriseConnector.getRepositoryHelper();
        TypeDef typeDef = repositoryHelper.getTypeDefByName("AnalyticsModelingOmas", typeName);
        try {
            this.auditLog.logMessage(this.context, AnalyticsModelingAuditCode.FIND_ENTITIES.getMessageDefinition(typeDef.getName(), matchProperties.toString()));
            existingEntities = this.enterpriseConnector.getMetadataCollection().findEntitiesByProperty("AnalyticsModelingOmas", typeDef.getGUID(), matchProperties, MatchCriteria.ALL, fromElement, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, SequencingOrder.ANY, pageSize);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException ex) {
            String keys = String.join((CharSequence)",", matchProperties.getInstanceProperties().keySet());
            String values = matchProperties.getInstanceProperties().values().stream().map(InstancePropertyValue::valueAsString).collect(Collectors.joining(","));
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.GET_ENTITY_EXCEPTION.getMessageDefinition(new String[]{keys, values}), this.getClass().getSimpleName(), "findEntities", ex);
        }
        return existingEntities;
    }

    public InstanceProperties buildMatchingInstanceProperties(Map<String, String> properties, boolean zoneRestricted) {
        InstanceProperties instanceProperties = new InstanceProperties();
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("AnalyticsModelingOmas", instanceProperties, entry.getKey(), entry.getValue(), "throw buildMatchingInstanceProperties");
            }
        }
        if (zoneRestricted && this.supportedZones != null && !this.supportedZones.isEmpty()) {
            instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("AnalyticsModelingOmas", instanceProperties, "zoneMembership", this.supportedZones, "throw buildMatchingInstanceProperties");
        }
        return instanceProperties;
    }

    public EntityDetail getEntityByGuid(String guid) throws AnalyticsModelingCheckedException {
        EntityDetail entity = null;
        try {
            entity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("AnalyticsModelingOmas", guid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.GET_ENTITY_EXCEPTION.getMessageDefinition(new String[]{"guid", guid}), this.getClass().getSimpleName(), "getEntityByGuid", ex);
        }
        if (entity == null) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.ENTITY_NOT_FOUND_EXCEPTION.getMessageDefinition(new String[]{"guid", guid}), this.getClass().getSimpleName(), "getEntityByGuid");
        }
        return entity;
    }

    private String getTypeDefGuidByName(String name) {
        return this.enterpriseConnector.getRepositoryHelper().getTypeDefByName("AnalyticsModelingOmas", name).getGUID();
    }

    public List<Relationship> getRelationshipsForEntity(EntityDetail entity, String relationshipType) throws AnalyticsModelingCheckedException {
        String relationshipTypeGuid = relationshipType == null ? null : this.getTypeDefGuidByName(relationshipType);
        try {
            return this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("AnalyticsModelingOmas", entity.getGUID(), relationshipTypeGuid, 0, FILTER_ACTIVE, null, null, null, 0);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.GET_RELATIONSHIP_EXCEPTION.getMessageDefinition(new String[]{relationshipType, this.getEntityQName(entity)}), this.getClass().getSimpleName(), "getRelationshipsForEntity", ex);
        }
    }

    public String getEntityQName(EntityDetail entity) {
        return this.enterpriseConnector.getRepositoryHelper().getStringProperty("AnalyticsModelingOmas", "qualifiedName", entity.getProperties(), this.context);
    }

    public String getEntityStringProperty(EntityDetail entity, String name) {
        return this.enterpriseConnector.getRepositoryHelper().getStringProperty("AnalyticsModelingOmas", name, entity.getProperties(), this.context);
    }

    public Boolean getEntityBooleanProperty(EntityDetail entity, String name) {
        return this.enterpriseConnector.getRepositoryHelper().getBooleanProperty("AnalyticsModelingOmas", name, entity.getProperties(), this.context);
    }

    public int getEntityIntProperty(EntityDetail entity, String name) {
        return this.enterpriseConnector.getRepositoryHelper().getIntProperty("AnalyticsModelingOmas", name, entity.getProperties(), this.context);
    }

    public String getStringProperty(String name, InstanceProperties properties) {
        return this.enterpriseConnector.getRepositoryHelper().getStringProperty("AnalyticsModelingOmas", name, properties, this.context);
    }

    public InstanceProperties getMapProperty(InstanceProperties properties, String name) {
        return this.enterpriseConnector.getRepositoryHelper().getMapProperty("AnalyticsModelingOmas", name, properties, this.context);
    }
}

