/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.ExecutionContext;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.IdentifierResolver;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaAttribute;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaType;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.builders.AnalyticsMetadataBuilder;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.AnalyticsMetadataConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAssetUtils;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsMetadata;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AssetReference;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataContainer;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataItem;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.QualifiedNameUtils;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class AnalyticsArtifactHandler {
    private AssetHandler<AnalyticsAsset> assetHandler;
    private SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private SchemaAttributeHandler<SchemaAttribute, SchemaType> metadataHandler;
    private AnalyticsMetadataConverter analyticsMetadataConverter;
    private ExecutionContext ctx;
    private IdentifierResolver resolver;
    private Map<String, String> newItem;
    private List<String> invalidAliases = new ArrayList<String>();

    public AnalyticsArtifactHandler(ExecutionContext ctx) {
        this.ctx = ctx;
        this.assetHandler = new AssetHandler((OpenMetadataAPIGenericConverter)new AssetConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), AnalyticsAsset.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
        this.schemaTypeHandler = new SchemaTypeHandler((OpenMetadataAPIGenericConverter)new SchemaTypeConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaType.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
        this.analyticsMetadataConverter = new AnalyticsMetadataConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName());
        this.metadataHandler = new SchemaAttributeHandler((OpenMetadataAPIGenericConverter)this.analyticsMetadataConverter, SchemaAttribute.class, (OpenMetadataAPIGenericConverter)new SchemaTypeConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaType.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
    }

    public AssetHandler<AnalyticsAsset> getAssetHandler() {
        return this.assetHandler;
    }

    public ResponseContainerAssets createAssets(String user, String serverCapability, String input) throws AnalyticsModelingCheckedException {
        String methodName = "createAssets";
        this.ctx.initializeSoftwareServerCapability(user, serverCapability);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> guids = new ArrayList<String>();
        try {
            AnalyticsAsset asset = (AnalyticsAsset)mapper.readValue(input, AnalyticsAsset.class);
            if (AnalyticsAssetUtils.hasMetadataModule(asset) || !AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.createModuleAsset(asset));
            }
            if (AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.createVisualizationAsset(asset));
            }
        }
        catch (JsonProcessingException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.INCORRECT_ARTIFACT_DEFINITION.getMessageDefinition(new String[]{input}), this.getClass().getSimpleName(), methodName, (Throwable)ex);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_CREATE_ARTIFACT.getMessageDefinition(), this.getClass().getSimpleName(), methodName, ex);
        }
        ResponseContainerAssets ret = new ResponseContainerAssets();
        ret.setAssetsList(guids);
        return ret;
    }

    private String createModuleAsset(AnalyticsAsset asset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.resolver = new IdentifierResolver(this.ctx, asset);
        String assetGUID = this.createAssetEntity(asset, true);
        String qualifiedName = asset.getQualifiedName();
        this.createAssetReferences(asset, assetGUID);
        String schemaTypeGUID = this.createSchemaType(asset, assetGUID);
        if (asset.getContainer() != null) {
            this.verifyOrder(asset.getContainer());
            for (MetadataContainer container : asset.getContainer()) {
                this.createContainer(container, schemaTypeGUID, assetGUID, false, qualifiedName);
            }
        }
        this.createItems(asset.getItem(), assetGUID, qualifiedName, schemaTypeGUID, false);
        return assetGUID;
    }

    private void createAssetReferences(AnalyticsAsset asset, String assetGUID) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetReferences";
        List<AssetReference> refAssets = asset.getReference();
        if (refAssets == null) {
            return;
        }
        for (AssetReference ref : refAssets) {
            if (ref.getGuid() == null) continue;
            this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "b827683c-2924-4df3-a92d-7be1888e23c0", null, null, assetGUID, ref.getGuid(), null, methodName);
        }
    }

    private String createSchemaType(AnalyticsAsset asset, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createSchemaType";
        SoftwareServerCapability ssc = this.ctx.getServerSoftwareCapability();
        SchemaTypeBuilder builder = new SchemaTypeBuilder(QualifiedNameUtils.buildQualifiedName(asset.getQualifiedName(), "ComplexSchemaType", asset.getType()), "786a6199-0ce8-47bf-b006-9ace1c5510e4", "ComplexSchemaType", this.ctx.getRepositoryHelper(), this.ctx.getServiceName(), this.ctx.getServerName());
        builder.setAnchors(this.ctx.getUserId(), assetGUID, methodName);
        String schemaTypeGUID = this.schemaTypeHandler.addSchemaType(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), builder, methodName);
        this.assetHandler.attachSchemaTypeToAsset(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), assetGUID, "assetGUID", schemaTypeGUID, "schemaTypeGUID", methodName);
        return schemaTypeGUID;
    }

    private String createAssetEntity(AnalyticsAsset asset, boolean bModuleAsset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createAsset";
        SoftwareServerCapability ssc = this.ctx.getServerSoftwareCapability();
        String assetTypeName = bModuleAsset ? "InformationView" : "DeployedReport";
        String assetTypeGuid = bModuleAsset ? "68d7b905-6438-43be-88cf-5de027b4aaaf" : "e9077f4f-955b-4d7b-b1f7-12ee769ff0c3";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(ssc.getQualifiedName(), assetTypeName, asset.getUid());
        asset.setQualifiedName(qualifiedName);
        String assetGUID = this.assetHandler.createAssetInRepository(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), qualifiedName, asset.getDisplayName(), asset.getDescription(), this.ctx.getSupportedZones(), null, 0, null, null, null, AnalyticsAssetUtils.buildAdditionalProperties(asset), assetTypeGuid, assetTypeName, null, methodName);
        this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "56315447-88a6-4235-ba91-fead86524ebf", null, null, ssc.getGUID(), assetGUID, null, methodName);
        return assetGUID;
    }

    private String createVisualizationAsset(AnalyticsAsset report) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.resolver == null || !AnalyticsAssetUtils.hasMetadataModule(report)) {
            this.resolver = new IdentifierResolver(this.ctx, report);
        }
        String assetGUID = this.createAssetEntity(report, false);
        String qualifiedName = report.getQualifiedName();
        this.createAssetReferences(report, assetGUID);
        String schemaTypeGUID = this.createSchemaType(report, assetGUID);
        if (report.getVisualization() != null) {
            this.verifyOrder(report.getVisualization());
            for (MetadataContainer container : report.getVisualization()) {
                this.createContainer(container, schemaTypeGUID, assetGUID, false, qualifiedName);
            }
        }
        return assetGUID;
    }

    private String updateVisualizationAsset(AnalyticsAsset report) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        String methodName = "updateModuleAsset";
        if (this.resolver == null || !AnalyticsAssetUtils.hasMetadataModule(report)) {
            this.resolver = new IdentifierResolver(this.ctx, report);
        }
        this.updateAssetAttributes(report, false);
        HashMap<String, EntityDetail> assetEntities = new HashMap<String, EntityDetail>();
        this.resolver.getSchemaAttributes(report.getQualifiedName(), methodName).forEach(entity -> assetEntities.put(this.ctx.getStringProperty("qualifiedName", entity.getProperties(), methodName), (EntityDetail)entity));
        String schemaTypeGUID = this.ctx.getRepositoryHandler().getEntityForRelationshipType(this.ctx.getUserId(), report.getGuid(), "DeployedReport", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName).getGUID();
        if (report.getVisualization() != null) {
            this.verifyOrder(report.getVisualization());
            for (MetadataContainer container : report.getVisualization()) {
                this.updateContainer(container, schemaTypeGUID, report.getGuid(), false, report.getQualifiedName(), assetEntities);
            }
        }
        for (EntityDetail entity2 : assetEntities.values()) {
            this.removeMetadataObject(entity2, methodName);
        }
        return report.getGuid();
    }

    private void verifyOrder(List<? extends SchemaAttribute> attributes) {
        if (attributes.stream().filter(att -> att.getElementPosition() != 0).count() != (long)attributes.size()) {
            for (int i = 0; i < attributes.size(); ++i) {
                attributes.get(i).setElementPosition(i + 1);
            }
        }
    }

    public String createContainer(MetadataContainer container, String parentGUID, String anchorGUID, boolean bNested, String parentQName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guid;
        String methodName = "createContainer";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", container.getIdentifier());
        container.setQualifiedName(qualifiedName);
        String string = guid = bNested ? this.metadataHandler.createNestedSchemaAttribute(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", qualifiedName, "qualifiedName", (SchemaAttributeBuilder)this.createAnalyticsMetadataBuilder(container, anchorGUID, true), methodName) : this.metadataHandler.createBeanInRepository(this.ctx.getUserId(), null, null, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, (OpenMetadataAPIGenericBuilder)this.createAnalyticsMetadataBuilder(container, anchorGUID, true), methodName);
        if (!bNested) {
            this.assetHandler.linkElementToElement(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "ComplexSchemaType", guid, "guid", "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, methodName);
        }
        if (this.newItem != null) {
            this.newItem.put(IdentifierResolver.getIdFromQName(qualifiedName, null), guid);
        }
        if (container.getContainer() != null) {
            this.verifyOrder(container.getContainer());
            for (MetadataContainer subContainer : container.getContainer()) {
                this.createContainer(subContainer, guid, anchorGUID, true, qualifiedName);
            }
        }
        this.createItems(container.getItem(), anchorGUID, qualifiedName, guid, true);
        return guid;
    }

    private String updateContainer(MetadataContainer container, String parentGUID, String anchorGUID, boolean bNested, String parentQName, Map<String, EntityDetail> assetEntities) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateContainer";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", container.getIdentifier());
        container.setQualifiedName(qualifiedName);
        EntityDetail entity = assetEntities.remove(qualifiedName);
        if (entity == null) {
            return this.createContainer(container, parentGUID, anchorGUID, bNested, parentQName);
        }
        AnalyticsMetadata containerOld = this.analyticsMetadataConverter.getNewBean(entity, methodName);
        container.prepareAnalyticsMetadataProperties();
        if (!container.equals(containerOld)) {
            this.metadataHandler.updateSchemaAttribute(this.ctx.getUserId(), null, null, entity.getGUID(), this.createAnalyticsMetadataBuilder(container, null, false).getInstanceProperties(methodName));
        }
        if (container.getContainer() != null) {
            this.verifyOrder(container.getContainer());
            for (MetadataContainer subContainer : container.getContainer()) {
                this.updateContainer(subContainer, entity.getGUID(), anchorGUID, true, qualifiedName, assetEntities);
            }
        }
        this.updateItems(container.getItem(), entity.getGUID(), anchorGUID, true, qualifiedName, assetEntities);
        return entity.getGUID();
    }

    public void createItem(MetadataItem item, String parentGUID, String anchorGUID, boolean bNested, String parentQName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createItem";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", item.getIdentifier());
        item.setQualifiedName(qualifiedName);
        String guid = bNested ? this.metadataHandler.createNestedSchemaAttribute(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", qualifiedName, "qualifiedName", (SchemaAttributeBuilder)this.createAnalyticsMetadataBuilder(item, anchorGUID, true), methodName) : this.metadataHandler.createBeanInRepository(this.ctx.getUserId(), null, null, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, (OpenMetadataAPIGenericBuilder)this.createAnalyticsMetadataBuilder(item, anchorGUID, true), methodName);
        item.setGuid(guid);
        if (!bNested) {
            this.assetHandler.linkElementToElement(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "ComplexSchemaType", guid, "guid", "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, methodName);
        }
        if (this.newItem != null) {
            this.newItem.put(IdentifierResolver.getIdFromQName(item.getQualifiedName(), null), guid);
        }
        this.createItems(item.getItem(), anchorGUID, qualifiedName, guid, true);
        this.resolver.addGuidForIdentifier(guid, IdentifierResolver.getIdFromQName(qualifiedName, null));
    }

    private void createItems(List<MetadataItem> items, String anchorGUID, String parentQName, String parentGUID, boolean bNested) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (items == null) {
            return;
        }
        ArrayList<MetadataItem> guidToItem = new ArrayList<MetadataItem>();
        for (MetadataItem item : items) {
            this.createItem(item, parentGUID, anchorGUID, bNested, parentQName);
            guidToItem.add(item);
        }
        guidToItem.forEach(this::createMetadataLink);
    }

    private boolean updateItem(MetadataItem item, String parentGUID, String anchorGUID, boolean bNested, String parentQName, Map<String, EntityDetail> assetEntities) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateItem";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", item.getIdentifier());
        item.setQualifiedName(qualifiedName);
        EntityDetail entity = assetEntities.remove(qualifiedName);
        if (entity == null) {
            this.createItem(item, parentGUID, anchorGUID, bNested, parentQName);
            return true;
        }
        AnalyticsMetadata itemOld = this.analyticsMetadataConverter.getNewBean(entity, methodName);
        item.prepareAnalyticsMetadataProperties();
        item.setGuid(entity.getGUID());
        if (!item.equals(itemOld)) {
            this.metadataHandler.updateSchemaAttribute(this.ctx.getUserId(), null, null, entity.getGUID(), this.createAnalyticsMetadataBuilder(item, null, false).getInstanceProperties(methodName));
        }
        this.updateItems(item.getItem(), entity.getGUID(), anchorGUID, true, qualifiedName, assetEntities);
        this.resolver.addGuidForIdentifier(entity.getGUID(), IdentifierResolver.getIdFromQName(qualifiedName, null));
        if (!Objects.equals(item.getSourceId(), itemOld.getSourceId()) || !Objects.equals(item.getSourceGuid(), itemOld.getSourceGuid())) {
            return true;
        }
        if (item.getSourceId() != null && this.invalidAliases != null) {
            for (String alias : this.invalidAliases) {
                for (String metadata : item.getSourceId()) {
                    if (!metadata.startsWith(alias)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void updateItems(List<MetadataItem> items, String parentGUID, String anchorGUID, boolean bNested, String parentQName, Map<String, EntityDetail> assetEntities) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (items == null) {
            return;
        }
        this.verifyOrder(items);
        ArrayList<MetadataItem> guidToItem = new ArrayList<MetadataItem>();
        for (MetadataItem item : items) {
            if (!this.updateItem(item, parentGUID, anchorGUID, bNested, parentQName, assetEntities)) continue;
            guidToItem.add(item);
        }
        guidToItem.forEach(this::updateMetadataLink);
    }

    private void createMetadataLink(MetadataItem item) {
        List<String> metadata;
        String methodName = "createMetadataLink";
        List<String> list = metadata = this.resolver.required() ? this.resolver.getItemGUIDs(item) : item.getSourceGuid();
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < metadata.size()) {
            String srcGUID = metadata.get(0);
            try {
                this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", null, null, item.getGuid(), srcGUID, null, methodName);
                metadata.remove(0);
            }
            catch (PropertyServerException | UserNotAuthorizedException e) {
                ++i;
            }
        }
    }

    private void updateMetadataLink(MetadataItem item) {
        String methodName = "updateMetadataLink";
        List<String> metadata = this.resolver.required() ? this.resolver.getItemGUIDs(item) : item.getSourceGuid();
        HashMap itemReferences = new HashMap();
        try {
            List list = this.ctx.getRepositoryHandler().getRelationshipsByType(this.ctx.getUserId(), item.getGuid(), "SchemaAttribute", "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", methodName);
            if (list != null) {
                list.forEach(relationship -> {
                    if (relationship.getEntityOneProxy().getGUID().equals(item.getGuid())) {
                        itemReferences.put(relationship.getEntityTwoProxy().getGUID(), relationship);
                    }
                });
            }
        }
        catch (PropertyServerException | UserNotAuthorizedException throwable) {
            // empty catch block
        }
        metadata.forEach(srcGUID -> {
            Relationship relationship = (Relationship)itemReferences.remove(srcGUID);
            if (relationship == null) {
                try {
                    this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", null, null, item.getGuid(), srcGUID, null, methodName);
                }
                catch (PropertyServerException | UserNotAuthorizedException throwable) {
                    // empty catch block
                }
            }
        });
        itemReferences.values().forEach(relationship -> {
            try {
                this.ctx.getRepositoryHandler().removeRelationship(this.ctx.getUserId(), null, null, relationship, methodName);
            }
            catch (PropertyServerException | UserNotAuthorizedException throwable) {
                // empty catch block
            }
        });
    }

    private AnalyticsMetadataBuilder createAnalyticsMetadataBuilder(AnalyticsMetadata src, String assetGUID, boolean bCreate) throws InvalidParameterException, PropertyServerException {
        String methodName = "createAnalyticsMetadataBuilder";
        src.prepareAnalyticsMetadataProperties();
        AnalyticsMetadataBuilder builder = new AnalyticsMetadataBuilder(src, null, this.ctx);
        if (assetGUID != null) {
            builder.setAnchors(this.ctx.getUserId(), assetGUID, methodName);
        }
        if (bCreate) {
            SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(src.getQualifiedName(), "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", this.ctx.getRepositoryHelper(), this.ctx.getServiceName(), this.ctx.getServerName());
            builder.setSchemaType(this.ctx.getUserId(), schemaTypeBuilder, methodName);
        }
        return builder;
    }

    public ResponseContainerAssets updateAssets(String user, String serverCapability, AnalyticsAsset asset) throws AnalyticsModelingCheckedException {
        String methodName = "updateAssets";
        this.ctx.initializeSoftwareServerCapability(user, serverCapability);
        ArrayList<String> guids = new ArrayList<String>();
        this.newItem = new HashMap<String, String>();
        try {
            if (AnalyticsAssetUtils.hasMetadataModule(asset)) {
                String guid = this.updateModuleAsset(asset);
                guids.add(guid);
                this.updateDependentAssets(guid);
            } else if (!AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.updateModuleAsset(asset));
            }
            if (AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.updateVisualizationAsset(asset));
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_UPDATE_ARTIFACT.getMessageDefinition(new String[]{user, asset.getQualifiedName(), ex.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, ex);
        }
        ResponseContainerAssets ret = new ResponseContainerAssets();
        ret.setAssetsList(guids);
        return ret;
    }

    private void updateDependentAssets(String guid) {
        String methodName = "updateDependentAssets";
        if (this.newItem.isEmpty()) {
            return;
        }
        AnalyticsMetadataConverter converter = new AnalyticsMetadataConverter(this.ctx.getRepositoryHelper(), this.ctx.getServerName(), this.ctx.getServiceName());
        try {
            List refAssets = this.ctx.getRepositoryHandler().getRelationshipsByType(this.ctx.getUserId(), guid, "Asset", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", methodName);
            List filter = refAssets.stream().map(r -> r.getEntityOneProxy().getGUID()).filter(g -> !guid.equals(g)).collect(Collectors.toList());
            List dependants = this.metadataHandler.getAttachedEntities(this.ctx.getUserId(), guid, "guid", "Asset", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", "Asset", 0, 0, methodName);
            for (EntityDetail entity : dependants) {
                AnalyticsAsset assetRepo;
                Optional<AssetReference> reference;
                if (!filter.contains(entity.getGUID()) || !(reference = (assetRepo = (AnalyticsAsset)this.assetHandler.getBeanFromEntity(this.ctx.getUserId(), entity, "entity", methodName)).getReference().stream().filter(ref -> guid.equals(ref.getGuid())).findFirst()).isPresent()) continue;
                String alias = reference.get().getAlias() + IdentifierResolver.NAME_SEPARATOR;
                Map<String, String> uid2guid = this.newItem.entrySet().stream().collect(Collectors.toMap(e -> alias + (String)e.getKey(), Map.Entry::getValue));
                List<EntityDetail> items = this.resolver.getSchemaAttributes(assetRepo.getQualifiedName(), methodName);
                for (EntityDetail item : items) {
                    this.updateDependentItemRelationship(item, converter, uid2guid);
                }
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {
            // empty catch block
        }
    }

    private void updateDependentItemRelationship(EntityDetail item, AnalyticsMetadataConverter converter, Map<String, String> uid2guid) throws PropertyServerException {
        String methodName = "updateDependentItemRelationship";
        AnalyticsMetadata metadata = converter.getNewBean(item, methodName);
        if (!(metadata instanceof MetadataItem)) {
            return;
        }
        List<String> sources = metadata.getSourceId();
        if (sources != null) {
            sources.forEach(uid -> {
                String guidReferenced = (String)uid2guid.get(uid);
                if (guidReferenced != null) {
                    try {
                        this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", null, null, item.getGUID(), guidReferenced, null, methodName);
                    }
                    catch (PropertyServerException | UserNotAuthorizedException throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private String updateModuleAsset(AnalyticsAsset asset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        String methodName = "updateModuleAsset";
        this.resolver = new IdentifierResolver(this.ctx, asset);
        this.updateAssetAttributes(asset, true);
        HashMap<String, EntityDetail> assetEntities = new HashMap<String, EntityDetail>();
        this.resolver.getSchemaAttributes(asset.getQualifiedName(), methodName).forEach(entity -> assetEntities.put(this.ctx.getStringProperty("qualifiedName", entity.getProperties(), methodName), (EntityDetail)entity));
        String assetGUID = asset.getGuid();
        String schemaTypeGUID = this.ctx.getRepositoryHandler().getEntityForRelationshipType(this.ctx.getUserId(), assetGUID, "InformationView", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName).getGUID();
        if (asset.getContainer() != null) {
            this.verifyOrder(asset.getContainer());
            for (MetadataContainer container : asset.getContainer()) {
                this.updateContainer(container, schemaTypeGUID, assetGUID, false, asset.getQualifiedName(), assetEntities);
            }
        }
        this.updateItems(asset.getItem(), schemaTypeGUID, assetGUID, false, asset.getQualifiedName(), assetEntities);
        for (EntityDetail entity2 : assetEntities.values()) {
            this.removeMetadataObject(entity2, methodName);
        }
        this.updateNewItemsReferences(asset);
        return assetGUID;
    }

    private void updateNewItemsReferences(AnalyticsAsset asset) {
        if (this.newItem.isEmpty()) {
            return;
        }
        this.updateNewItemsReferences(asset.getContainer());
        this.updateNewItemsReferences(asset.getItem());
        this.updateNewItemsReferences(asset.getVisualization());
    }

    private void updateNewItemsReferences(List<? extends AnalyticsMetadata> lstMetadata) {
        if (lstMetadata == null) {
            return;
        }
        for (AnalyticsMetadata analyticsMetadata : lstMetadata) {
            if (analyticsMetadata instanceof MetadataItem && analyticsMetadata.getSourceId() != null) {
                analyticsMetadata.getSourceId().forEach(src -> {
                    String guid = this.newItem.get(src);
                    if (guid != null) {
                        this.updateMetadataLink((MetadataItem)mtdObject);
                    }
                });
            }
            if (analyticsMetadata instanceof MetadataContainer) {
                this.updateNewItemsReferences(((MetadataContainer)analyticsMetadata).getContainer());
                this.updateNewItemsReferences(((MetadataContainer)analyticsMetadata).getItem());
                continue;
            }
            if (!(analyticsMetadata instanceof MetadataItem)) continue;
            this.updateNewItemsReferences(((MetadataItem)analyticsMetadata).getItem());
        }
    }

    public void removeMetadataObject(EntityDetail entity, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.ctx.getRepositoryHandler().removeEntity(this.ctx.getUserId(), null, null, entity.getGUID(), "entityGuid", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, methodName);
    }

    private boolean updateAssetAttributes(AnalyticsAsset asset, boolean bModuleAsset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        String methodName = "updateAssetAttributes";
        SoftwareServerCapability ssc = this.ctx.getServerSoftwareCapability();
        String assetTypeName = bModuleAsset ? "InformationView" : "DeployedReport";
        String assetTypeGuid = bModuleAsset ? "68d7b905-6438-43be-88cf-5de027b4aaaf" : "e9077f4f-955b-4d7b-b1f7-12ee769ff0c3";
        asset.setQualifiedName(QualifiedNameUtils.buildQualifiedName(ssc.getQualifiedName(), assetTypeName, asset.getUid()));
        AnalyticsAsset assetRepo = (AnalyticsAsset)this.assetHandler.getBeanByQualifiedName(this.ctx.getUserId(), assetTypeGuid, assetTypeName, asset.getQualifiedName(), "qualifiedName", methodName);
        asset.setGuid(assetRepo.getGuid());
        this.updateAssetReferences(asset, assetRepo);
        if (!asset.equals(assetRepo)) {
            this.assetHandler.updateAsset(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), asset.getGuid(), "assetGUID", asset.getQualifiedName(), asset.getDisplayName(), asset.getDescription(), AnalyticsAssetUtils.buildAdditionalProperties(asset), assetTypeGuid, assetTypeName, null, methodName);
            return true;
        }
        return false;
    }

    private void updateAssetReferences(AnalyticsAsset asset, AnalyticsAsset assetRepo) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetReferences";
        List<AssetReference> refAssets = asset.getReference();
        Map<String, Relationship> mapReferences = this.selectReferencedAssets(asset);
        if (refAssets != null) {
            for (AssetReference ref : refAssets) {
                Relationship assetRef;
                String alias;
                String guid = ref.getGuid();
                if (guid == null || (alias = ref.getAlias()) == null || alias.isEmpty() || (assetRef = mapReferences.remove(guid)) != null) continue;
                this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "b827683c-2924-4df3-a92d-7be1888e23c0", null, null, asset.getGuid(), guid, null, methodName);
            }
        }
        for (Relationship rel : mapReferences.values()) {
            AssetReference reference = AnalyticsAssetUtils.getAssetReferenceByGuid(assetRepo, rel.getEntityTwoProxy().getGUID());
            if (reference != null) {
                this.invalidAliases.add(reference.getAlias() + IdentifierResolver.NAME_SEPARATOR);
            }
            this.ctx.getRepositoryHandler().removeRelationship(this.ctx.getUserId(), null, null, rel, methodName);
        }
    }

    private Map<String, Relationship> selectReferencedAssets(AnalyticsAsset asset) throws UserNotAuthorizedException, PropertyServerException {
        List refAssetsOld = this.ctx.getRepositoryHandler().getRelationshipsByType(this.ctx.getUserId(), asset.getGuid(), "Asset", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", "selectReferencedAssets");
        HashMap<String, Relationship> mapReferences = new HashMap<String, Relationship>();
        if (refAssetsOld != null) {
            refAssetsOld.forEach(r -> {
                if (r.getEntityOneProxy().getGUID().equals(asset.getGuid())) {
                    mapReferences.put(r.getEntityTwoProxy().getGUID(), (Relationship)r);
                }
            });
        }
        return mapReferences;
    }
}

