/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class QualifiedNameUtils {
    public static final String SEPARATOR = "::";
    public static final String EQUALS = "=";
    public static final String OPEN_BRACKET = "(";
    public static final String CLOSE_BRACKET = ")";
    private static final String ID_SEPARATOR_REGEX = QualifiedNameUtils.escapeQualifiedNameRegExPattern("::" + "(" + "SchemaAttribute" + ")" + "=");

    public static String buildQualifiedName(String parentQualifiedName, String typeName, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(parentQualifiedName == null || parentQualifiedName.isEmpty() ? "" : parentQualifiedName + SEPARATOR).append(OPEN_BRACKET).append(typeName).append(CLOSE_BRACKET).append(EQUALS).append(value);
        return sb.toString();
    }

    public static List<String> extractIdentifiersFromQualifiedName(String qualifiedName) {
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(qualifiedName.split(ID_SEPARATOR_REGEX)).skip(1L).collect(Collectors.toList());
    }

    public static String escapeQualifiedNameRegExPattern(String input) {
        return input.replace(OPEN_BRACKET, "\\(").replace(CLOSE_BRACKET, "\\)");
    }
}

