/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ModuleTableFilter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabaseSchema;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerSchemaTables;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AnalyticsModelingOMASAPIResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AssetsResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.DatabasesResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.ErrorResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.ModuleResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.SchemaTablesResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.SchemasResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.server.AnalyticsModelingInstanceHandler;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.slf4j.LoggerFactory;

public class AnalyticsModelingRestServices {
    private static final String DATABASE_GUID = "databaseGUID";
    private AnalyticsModelingInstanceHandler instanceHandler = new AnalyticsModelingInstanceHandler();
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AnalyticsModelingRestServices.class), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceFullName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public RESTExceptionHandler getExceptionHandler() {
        return this.restExceptionHandler;
    }

    public AnalyticsModelingInstanceHandler getHandler() {
        return this.instanceHandler;
    }

    public InvalidParameterHandler getInvalidParameterHandler() {
        return this.invalidParameterHandler;
    }

    public AnalyticsModelingOMASAPIResponse getDatabases(String serverName, String userId, Integer startFrom, Integer pageSize) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getDatabases";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, null, null, startFrom, pageSize, methodName);
            DatabasesResponse response = new DatabasesResponse();
            List<ResponseContainerDatabase> databases = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getDatabases(userId, startFrom, pageSize);
            response.setDatabasesList(databases);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse getSchemas(String serverName, String userId, String databaseGuid, Integer startFrom, Integer pageSize) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getSchemas";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, databaseGuid, DATABASE_GUID, startFrom, pageSize, methodName);
            SchemasResponse response = new SchemasResponse();
            List<ResponseContainerDatabaseSchema> databasesSchemas = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getDatabaseSchemas(userId, databaseGuid, startFrom, pageSize);
            response.setSchemaList(databasesSchemas);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse getTables(String serverName, String userId, String databaseGuid, String schema) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getTables";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, databaseGuid, DATABASE_GUID, null, null, methodName);
            SchemaTablesResponse response = new SchemaTablesResponse();
            ResponseContainerSchemaTables tables = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getSchemaTables(databaseGuid, schema);
            response.setTableList(tables);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse getModule(String serverName, String userId, String databaseGuid, String catalog, String schema, ModuleTableFilter request) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getModule";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, databaseGuid, DATABASE_GUID, null, null, methodName);
            ModuleResponse response = new ModuleResponse();
            ResponseContainerModule module = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getModule(databaseGuid, catalog, schema, request);
            response.setModule(module);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse createArtifact(String serverName, String userId, String serverCapability, String artifact) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "createArtifact";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, null, null, null, null, methodName);
            AssetsResponse response = new AssetsResponse();
            ResponseContainerAssets assets = this.getHandler().getAnalyticsArtifactHandler(serverName, userId, methodName).createAssets(userId, serverCapability, artifact);
            response.setAssetList(assets);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse updateArtifact(String serverName, String userId, String serverCapability, AnalyticsAsset artifact) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "updateArtifact";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, null, null, null, null, methodName);
            AssetsResponse response = new AssetsResponse();
            ResponseContainerAssets assets = this.getHandler().getAnalyticsArtifactHandler(serverName, userId, methodName).updateAssets(userId, serverCapability, artifact);
            response.setAssetList(assets);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        catch (Exception e) {
            ret = this.handleExceptionResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse deleteArtifact(String serverName, String userId, String serverCapability, String identifier) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "deleteArtifact";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            this.validateUrlParameters(serverName, userId, null, null, null, null, methodName);
            AssetsResponse response = new AssetsResponse();
            ResponseContainerAssets assets = this.getHandler().getAnalyticsArtifactHandler(serverName, userId, methodName).deleteAssets(userId, serverCapability, identifier);
            response.setAssetList(assets);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        catch (Exception e) {
            ret = this.handleExceptionResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public void validateUrlParameters(String serverName, String userId, String guid, String guidParamName, Integer startFrom, Integer pageSize, String methodName) throws InvalidParameterException {
        this.getInvalidParameterHandler().validateUserId(userId, methodName);
        this.getInvalidParameterHandler().validateName(serverName, "serverName", methodName);
        if (guidParamName != null) {
            this.getInvalidParameterHandler().validateGUID(guid, guidParamName, methodName);
        }
        if (startFrom != null && pageSize != null) {
            this.getInvalidParameterHandler().validatePaging(startFrom.intValue(), pageSize.intValue(), methodName);
        }
    }

    private AnalyticsModelingOMASAPIResponse handleErrorResponse(AnalyticsModelingCheckedException error, String methodName) {
        ErrorResponse ret = new ErrorResponse(error);
        this.getExceptionHandler().captureThrowable((FFDCResponse)ret, (Throwable)error, methodName);
        return ret;
    }

    private AnalyticsModelingOMASAPIResponse handleInvalidParameterResponse(InvalidParameterException e, String methodName) {
        AnalyticsModelingCheckedException error = new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.INVALID_REQUEST_PARAMER.getMessageDefinition(new String[]{e.getParameterName()}), this.getClass().getSimpleName(), methodName, (Throwable)e);
        ErrorResponse ret = new ErrorResponse(error);
        this.getExceptionHandler().captureThrowable((FFDCResponse)ret, (Throwable)error, methodName);
        return ret;
    }

    private AnalyticsModelingOMASAPIResponse handleExceptionResponse(Exception e, String methodName) {
        AnalyticsModelingCheckedException error = new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{e.getClass().getName(), methodName, e.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, (Throwable)e);
        ErrorResponse ret = new ErrorResponse(error);
        this.getExceptionHandler().captureThrowable((FFDCResponse)ret, (Throwable)error, methodName);
        return ret;
    }
}

