/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.assets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.analyticsmodeling.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabaseSchema;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerSchemaTables;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Column;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.DataSource;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignColumn;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.MetadataModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.PrimaryKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Table;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.TableItem;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class DatabaseContextHandler {
    public static final String DATA_SOURCE_GUID = "dataSourceGUID";
    private OMEntityDao omEntityDao;
    private InvalidParameterHandler invalidParameterHandler;

    public DatabaseContextHandler(OMEntityDao omEntityDao, InvalidParameterHandler invalidParameterHandler) {
        this.omEntityDao = omEntityDao;
        this.invalidParameterHandler = invalidParameterHandler;
    }

    void setContext(String context) {
        this.omEntityDao.setContext(context);
    }

    public List<ResponseContainerDatabase> getDatabases(Integer startFrom, Integer pageSize) throws AnalyticsModelingCheckedException {
        this.setContext("getDatabases");
        InstanceProperties instanceProperties = this.omEntityDao.buildMatchingInstanceProperties(Collections.emptyMap(), true);
        List<EntityDetail> entities = this.omEntityDao.findEntities(instanceProperties, "Database", 0, 0);
        List ret = ((Stream)Optional.ofNullable(entities).map(Collection::stream).orElseGet(Stream::empty).parallel()).map(this::buildDatabase).filter(Objects::nonNull).collect(Collectors.toList());
        ret.sort(Comparator.comparing(rdb -> rdb.getDbName().toUpperCase()));
        return this.getPage(startFrom, pageSize, ret);
    }

    private <T> List<T> getPage(Integer startFrom, Integer pageSize, List<T> list) {
        int toElement;
        int n = toElement = pageSize == 0 ? list.size() : startFrom + pageSize;
        if (toElement > list.size()) {
            toElement = list.size();
        }
        return list.subList(startFrom, toElement);
    }

    private ResponseContainerDatabase buildDatabase(EntityDetail e) {
        ResponseContainerDatabase ret = new ResponseContainerDatabase();
        ret.setDbName(this.getEntityStringProperty(e, "name"));
        ret.setDbType(this.getEntityStringProperty(e, "type"));
        ret.setDbVersion(this.getEntityStringProperty(e, "version"));
        ret.setGUID(e.getGUID());
        return ret;
    }

    public List<ResponseContainerDatabaseSchema> getDatabaseSchemas(String guidDataSource, Integer startFrom, Integer pageSize) throws AnalyticsModelingCheckedException, InvalidParameterException {
        String context = "getDatabaseSchemas";
        this.setContext(context);
        this.invalidParameterHandler.validateGUID(guidDataSource, DATA_SOURCE_GUID, context);
        EntityDetail db = this.omEntityDao.getEntityByGuid(guidDataSource);
        String catalogName = this.getEntityStringProperty(db, "name");
        List<Relationship> db2SchemaRelationships = this.omEntityDao.getRelationshipsForEntity(db, "DataContentForDataSet");
        if (db2SchemaRelationships == null) {
            return Collections.emptyList();
        }
        List ret = db2SchemaRelationships.parallelStream().map(this::getSchemaEntityFromRelationship).filter(Objects::nonNull).map(e -> this.buildSchemaForRelationship(catalogName, (EntityDetail)e)).filter(Objects::nonNull).collect(Collectors.toList());
        ret.sort(Comparator.comparing(e -> e.getSchema()));
        return this.getPage(startFrom, pageSize, ret);
    }

    private ResponseContainerDatabaseSchema buildSchemaForRelationship(String catalogName, EntityDetail dbSchemaEntity) {
        String schemaName = this.getEntityStringProperty(dbSchemaEntity, "name");
        ResponseContainerDatabaseSchema schema = new ResponseContainerDatabaseSchema();
        schema.setCatalog(catalogName);
        schema.setSchema(schemaName);
        schema.setId(schema.buildId());
        return schema;
    }

    private EntityDetail getSchemaEntityFromRelationship(Relationship r) {
        return this.getEntityByGuidNoThrow(r.getEntityTwoProxy().getGUID());
    }

    public ResponseContainerSchemaTables getSchemaTables(String guidDataSource, String schema) throws AnalyticsModelingCheckedException, InvalidParameterException {
        String context = "getSchemaTables";
        this.setContext(context);
        this.invalidParameterHandler.validateGUID(guidDataSource, DATA_SOURCE_GUID, context);
        ResponseContainerSchemaTables ret = new ResponseContainerSchemaTables();
        EntityDetail dbSchemaEntity = this.getSchemaEntityByName(guidDataSource, schema);
        List tables = this.getTablesForSchema(dbSchemaEntity).parallelStream().map(t -> this.getEntityStringProperty((EntityDetail)t, "displayName")).filter(Objects::nonNull).collect(Collectors.toList());
        Collections.sort(tables);
        ret.setTablesList(tables);
        return ret;
    }

    private List<EntityDetail> getTablesForSchema(EntityDetail dbSchemaEntity) throws AnalyticsModelingCheckedException {
        List<Relationship> allDbSchemaToSchemaType = this.omEntityDao.getRelationshipsForEntity(dbSchemaEntity, "AssetSchemaType");
        if (allDbSchemaToSchemaType == null || allDbSchemaToSchemaType.isEmpty()) {
            return Collections.emptyList();
        }
        Relationship dbSchemaToSchemaType = allDbSchemaToSchemaType.get(0);
        EntityDetail dbSchemaTypeEntity = this.omEntityDao.getEntityByGuid(dbSchemaToSchemaType.getEntityTwoProxy().getGUID());
        List<Relationship> dbSchemaTypeToTableRelationships = this.omEntityDao.getRelationshipsForEntity(dbSchemaTypeEntity, "AttributeForSchema");
        return Optional.ofNullable(dbSchemaTypeToTableRelationships).map(Collection::stream).orElseGet(Stream::empty).map(this::getTableEntity).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private EntityDetail getTableEntity(Relationship relationship) {
        String tableGuid = relationship.getEntityTwoProxy().getGUID();
        return this.getEntityByGuidNoThrow(tableGuid);
    }

    public ResponseContainerModule getModule(String databaseGuid, String catalog, String schema) throws AnalyticsModelingCheckedException, InvalidParameterException {
        String context = "getModule";
        this.invalidParameterHandler.validateGUID(databaseGuid, DATA_SOURCE_GUID, context);
        this.setContext(context);
        ResponseContainerModule ret = new ResponseContainerModule();
        ret.setId(catalog + "_" + schema);
        ret.setModule(this.buildModule(databaseGuid, catalog, schema));
        return ret;
    }

    private MetadataModule buildModule(String databaseGuid, String catalog, String schema) throws AnalyticsModelingCheckedException {
        MetadataModule module = new MetadataModule();
        module.setIdentifier(catalog + "." + schema);
        module.setDataSource(Arrays.asList(this.buildDataSource(databaseGuid, catalog, schema)));
        return module;
    }

    private DataSource buildDataSource(String databaseGuid, String catalog, String schema) throws AnalyticsModelingCheckedException {
        DataSource ds = new DataSource();
        ds.setCatalog(catalog);
        ds.setSchema(schema);
        ds.setName(catalog + "." + schema);
        ds.setTable(this.buildTables(databaseGuid, schema));
        return ds;
    }

    private List<Table> buildTables(String databaseGuid, String schema) throws AnalyticsModelingCheckedException {
        EntityDetail schemaEntity = this.getSchemaEntityByName(databaseGuid, schema);
        List<EntityDetail> tables = this.getTablesForSchema(schemaEntity);
        List<Table> ret = tables.parallelStream().map(this::buildSingleTable).filter(Objects::nonNull).collect(Collectors.toList());
        ret.sort(Comparator.comparing(e -> e.getName()));
        return ret;
    }

    private Table buildSingleTable(EntityDetail entityTable) {
        List<Relationship> relationshipsTableColumns;
        Table ret = new Table();
        ret.setName(this.getEntityStringProperty(entityTable, "displayName"));
        try {
            relationshipsTableColumns = this.omEntityDao.getRelationshipsForEntity(entityTable, "NestedSchemaAttribute");
        }
        catch (AnalyticsModelingCheckedException e) {
            return null;
        }
        if (relationshipsTableColumns == null || relationshipsTableColumns.isEmpty()) {
            return null;
        }
        List<TableItem> items = ((Stream)relationshipsTableColumns.stream().parallel()).map(this::buildTableItems).filter(Objects::nonNull).collect(Collectors.toList());
        items.sort(Comparator.comparingInt(TableItem::getPosition));
        if (items.isEmpty()) {
            return null;
        }
        ret.setTableItem(items);
        this.processPrimaryKeys(ret, items);
        this.processForeignKeys(ret, items);
        return ret;
    }

    private void processPrimaryKeys(Table ret, List<TableItem> items) {
        List pk = items.stream().filter(v -> v.getPkName() != null).collect(Collectors.toList());
        if (pk != null && !pk.isEmpty()) {
            PrimaryKey pKey = new PrimaryKey();
            pKey.setName(((TableItem)pk.get(0)).getPkName());
            pKey.setKeyedColumn(pk.stream().map(v -> v.getColumn().getName()).sorted().collect(Collectors.toList()));
            ret.setPrimaryKey(Arrays.asList(pKey));
        }
    }

    private void processForeignKeys(Table table, List<TableItem> items) {
        List<TableItem> fKeys = items.stream().filter(v -> v.getReferencedColumns() != null).collect(Collectors.toList());
        if (fKeys.isEmpty()) {
            return;
        }
        HashMap<String, List> tablesFKs = new HashMap<String, List>();
        fKeys.forEach(v -> {
            List<EntityDetail> columnEntities = v.getReferencedColumns().stream().map(this::getEntityByGuidNoThrow).filter(Objects::nonNull).collect(Collectors.toList());
            if (columnEntities.isEmpty()) {
                return;
            }
            columnEntities.forEach(ce -> {
                ForeignColumn fkColumn = new ForeignColumn();
                fkColumn.setColumnName(v.getColumn().getName());
                fkColumn.setPkColumn(this.getEntityStringProperty((EntityDetail)ce, "displayName"));
                try {
                    EntityDetail tableEntity = this.getParentEntity((EntityDetail)ce, "NestedSchemaAttribute");
                    fkColumn.setPkTable(this.getEntityStringProperty(tableEntity, "displayName"));
                    ArrayList<ForeignColumn> theTableFKs = (ArrayList<ForeignColumn>)tablesFKs.get(tableEntity.getGUID());
                    if (theTableFKs == null) {
                        theTableFKs = new ArrayList<ForeignColumn>();
                        tablesFKs.put(tableEntity.getGUID(), theTableFKs);
                    }
                    theTableFKs.add(fkColumn);
                    try {
                        EntityDetail schemaEntity = this.getParentEntity(tableEntity, "AttributeForSchema");
                        fkColumn.setPkSchema(this.getEntityStringProperty(schemaEntity, "displayName"));
                    }
                    catch (AnalyticsModelingCheckedException exTable) {
                        return;
                    }
                }
                catch (AnalyticsModelingCheckedException exSchema) {
                    return;
                }
            });
        });
        tablesFKs.forEach((key, list) -> {
            ForeignKey fk = new ForeignKey();
            String parentTable = ((ForeignColumn)list.get(0)).getPkTable();
            fk.setName("FK_" + table.getName() + "_" + parentTable + "_" + String.join((CharSequence)"_", list.stream().map(v -> v.getColumnName()).collect(Collectors.toList())));
            fk.setFkColumn(list);
            ArrayList<ForeignKey> fks = table.getForeignKey();
            if (fks == null) {
                fks = new ArrayList<ForeignKey>();
                table.setForeignKey(fks);
            }
            fks.add(fk);
        });
        if (table.getForeignKey() != null && table.getForeignKey().size() > 1) {
            table.getForeignKey().sort(Comparator.comparing(e -> e.getName()));
        }
    }

    EntityDetail getEntityByGuidNoThrow(String guid) {
        try {
            return this.omEntityDao.getEntityByGuid(guid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private EntityDetail getParentEntity(EntityDetail child, String propertyName) throws AnalyticsModelingCheckedException {
        List<Relationship> columnRelationships = this.omEntityDao.getRelationshipsForEntity(child, propertyName);
        Relationship columnTableRelationship = columnRelationships.stream().filter(r -> child.getGUID().equals(r.getEntityTwoProxy().getGUID())).findFirst().get();
        EntityDetail tableEntity = this.omEntityDao.getEntityByGuid(columnTableRelationship.getEntityOneProxy().getGUID());
        return tableEntity;
    }

    private TableItem buildTableItems(Relationship tableTypeToColumns) {
        EntityDetail columnEntity;
        try {
            columnEntity = this.omEntityDao.getEntityByGuid(tableTypeToColumns.getEntityTwoProxy().getGUID());
        }
        catch (AnalyticsModelingCheckedException e) {
            return null;
        }
        TableItem item = new TableItem();
        Column tableColumn = new Column();
        item.setColumn(tableColumn);
        item.setPosition(this.getEntityIntProperty(columnEntity, "position"));
        tableColumn.setName(this.getEntityStringProperty(columnEntity, "displayName"));
        String pkName = this.getPrimaryKeyClassification(columnEntity);
        if (pkName != null && !pkName.isEmpty()) {
            item.setPkName(pkName);
        }
        tableColumn.setNullable(this.getEntityBooleanProperty(columnEntity, "isNullable"));
        List<String> fks = this.getReferencedColumn(columnEntity);
        if (fks != null && !fks.isEmpty()) {
            item.setReferencedColumns(fks);
        }
        try {
            EntityDetail columnTypeUniverse = this.getColumnType(columnEntity);
            InstanceProperties ap = this.getAdditiomalProperty(columnTypeUniverse.getProperties());
            tableColumn.setVendorType(this.omEntityDao.getStringProperty("data_type", ap));
            String length = this.omEntityDao.getStringProperty("length", ap);
            String dt = this.omEntityDao.getStringProperty("odbc_type", ap);
            tableColumn.setDatatype(length == null ? dt : dt + "(" + length + ")");
        }
        catch (AnalyticsModelingCheckedException e) {
            return null;
        }
        return item;
    }

    private String getPrimaryKeyClassification(EntityDetail columnEntity) {
        List classifications = columnEntity.getClassifications();
        if (classifications == null || classifications.isEmpty()) {
            return null;
        }
        Classification classification = classifications.stream().filter(e -> e.getName().equals("PrimaryKey")).findFirst().orElse(null);
        return classification == null ? null : this.omEntityDao.getStringProperty("name", classification.getProperties());
    }

    private EntityDetail getColumnType(EntityDetail column) throws AnalyticsModelingCheckedException {
        List<Relationship> columnToColumnType = this.omEntityDao.getRelationshipsForEntity(column, "AttachedNoteLog");
        return this.omEntityDao.getEntityByGuid(columnToColumnType.get(0).getEntityTwoProxy().getGUID());
    }

    private EntityDetail getSchemaEntityByName(String databaseGuid, String schema) throws AnalyticsModelingCheckedException {
        EntityDetail dbEntity = this.omEntityDao.getEntityByGuid(databaseGuid);
        List<Relationship> databaseToDbSchemaRelationships = this.omEntityDao.getRelationshipsForEntity(dbEntity, "DataContentForDataSet");
        return Optional.ofNullable(databaseToDbSchemaRelationships).map(Collection::stream).orElseGet(Stream::empty).map(r -> {
            EntityDetail dbSchemaEntity = this.getSchemaEntityFromRelationship((Relationship)r);
            if (dbSchemaEntity != null) {
                String schemaName = this.getEntityStringProperty(dbSchemaEntity, "name");
                if (schema != null && schema.equals(schemaName)) {
                    return dbSchemaEntity;
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.SCHEMA_UNKNOWN.getMessageDefinition(new String[]{schema}), this.getClass().getSimpleName(), "getSchemaEntityByName"));
    }

    private List<String> getReferencedColumn(EntityDetail columnEntity) {
        List<Relationship> columnForeignKeys;
        try {
            columnForeignKeys = this.omEntityDao.getRelationshipsForEntity(columnEntity, "ForeignKey");
        }
        catch (AnalyticsModelingCheckedException e) {
            return null;
        }
        if (columnForeignKeys == null || CollectionUtils.isEmpty(columnForeignKeys)) {
            return null;
        }
        String columnGuid = columnEntity.getGUID();
        return columnForeignKeys.stream().filter(v -> columnGuid.equals(v.getEntityTwoProxy().getGUID())).map(v -> v.getEntityOneProxy().getGUID()).collect(Collectors.toList());
    }

    private InstanceProperties getAdditiomalProperty(InstanceProperties properties) {
        return properties == null ? null : this.omEntityDao.getMapProperty(properties, "additionalProperties");
    }

    private String getEntityStringProperty(EntityDetail entity, String name) {
        return entity == null ? null : this.omEntityDao.getEntityStringProperty(entity, name);
    }

    private Boolean getEntityBooleanProperty(EntityDetail entity, String name) {
        return entity == null ? null : this.omEntityDao.getEntityBooleanProperty(entity, name);
    }

    private int getEntityIntProperty(EntityDetail entity, String name) {
        return entity == null ? null : Integer.valueOf(this.omEntityDao.getEntityIntProperty(entity, name));
    }
}

