/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.server;

import org.odpi.openmetadata.accessservices.analyticsmodeling.assets.DatabaseContextHandler;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.server.AnalyticsModelingOMASRegistration;
import org.odpi.openmetadata.accessservices.analyticsmodeling.server.AnalyticsModelingServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstanceHandler;

public class AnalyticsModelingInstanceHandler
extends OCFOMASServiceInstanceHandler {
    public AnalyticsModelingInstanceHandler() {
        super(AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceFullName());
        AnalyticsModelingOMASRegistration.registerAccessService();
    }

    public DatabaseContextHandler getDatabaseContextHandler(String serverName, String userId, String serviceOperationName) throws AnalyticsModelingCheckedException {
        try {
            AnalyticsModelingServicesInstance instance = (AnalyticsModelingServicesInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
            if (instance != null) {
                return instance.getContextBuilder();
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{serverName, userId, serviceOperationName}), ((Object)((Object)this)).getClass().getSimpleName(), serviceOperationName, error);
        }
        throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.SERVICE_NOT_INITIALIZED.getMessageDefinition(new String[]{serverName}), ((Object)((Object)this)).getClass().getSimpleName(), serviceOperationName);
    }
}

