/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabaseSchema;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerSchemaTables;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AnalyticsModelingOMASAPIResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.DatabasesResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.ErrorResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.ModuleResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.SchemaTablesResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.SchemasResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.server.AnalyticsModelingInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.slf4j.LoggerFactory;

public class AnalyticsModelingRestServices {
    private AnalyticsModelingInstanceHandler instanceHandler = new AnalyticsModelingInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AnalyticsModelingRestServices.class), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceFullName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public RESTExceptionHandler getExceptionHandler() {
        return this.restExceptionHandler;
    }

    public AnalyticsModelingInstanceHandler getHandler() {
        return this.instanceHandler;
    }

    public AnalyticsModelingOMASAPIResponse getDatabases(String serverName, String userId, Integer startFrom, Integer pageSize) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getDatabases";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            DatabasesResponse response = new DatabasesResponse();
            List<ResponseContainerDatabase> databases = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getDatabases(startFrom, pageSize);
            response.setDatabasesList(databases);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse getSchemas(String serverName, String userId, String dataSourceGuid, Integer startFrom, Integer pageSize) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getSchemas";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            SchemasResponse response = new SchemasResponse();
            List<ResponseContainerDatabaseSchema> databasesSchemas = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getDatabaseSchemas(dataSourceGuid, startFrom, pageSize);
            response.setSchemaList(databasesSchemas);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse getTables(String serverName, String userId, String databaseGuid, String schema) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getTables";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            SchemaTablesResponse response = new SchemaTablesResponse();
            ResponseContainerSchemaTables tables = this.getHandler().getDatabaseContextHandler(serverName, userId, methodName).getSchemaTables(databaseGuid, schema);
            response.setTableList(tables);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, methodName);
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    public AnalyticsModelingOMASAPIResponse getModule(String serverName, String userId, String databaseGuid, String catalog, String schema) {
        AnalyticsModelingOMASAPIResponse ret;
        String methodName = "getModule";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        try {
            ModuleResponse response = new ModuleResponse();
            ResponseContainerModule module = this.getHandler().getDatabaseContextHandler(serverName, userId, "getModule").getModule(databaseGuid, catalog, schema);
            response.setModule(module);
            ret = response;
        }
        catch (AnalyticsModelingCheckedException e) {
            ret = this.handleErrorResponse(e, "getModule");
        }
        catch (InvalidParameterException e) {
            ret = this.handleInvalidParameterResponse(e, methodName);
        }
        restCallLogger.logRESTCallReturn(token, ret.toString());
        return ret;
    }

    private AnalyticsModelingOMASAPIResponse handleErrorResponse(AnalyticsModelingCheckedException error, String methodName) {
        ErrorResponse ret = new ErrorResponse(error);
        this.getExceptionHandler().captureThrowable((FFDCResponse)ret, (Throwable)error, methodName);
        return ret;
    }

    private AnalyticsModelingOMASAPIResponse handleInvalidParameterResponse(InvalidParameterException e, String methodName) {
        AnalyticsModelingCheckedException error = new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.INVALID_REQUEST_PARAMER.getMessageDefinition(new String[]{e.getParameterName()}), this.getClass().getSimpleName(), methodName, (Throwable)e);
        ErrorResponse ret = new ErrorResponse(error);
        this.getExceptionHandler().captureThrowable((FFDCResponse)ret, (Throwable)error, methodName);
        return ret;
    }
}

