/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.ExecutionContext;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.IdentifierResolver;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.Asset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaAttribute;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaType;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.builders.AnalyticsMetadataBuilder;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.AnalyticsMetadataConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsMetadata;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AssetReference;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataContainer;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataItem;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.QualifiedNameUtils;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;

public class AnalyticsArtifactHandler {
    private AssetHandler<Asset> assetHandler;
    private SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private SchemaAttributeHandler<SchemaAttribute, SchemaType> metadataHandler;
    private ExecutionContext ctx;
    private IdentifierResolver resolver;

    public AnalyticsArtifactHandler(ExecutionContext ctx) {
        this.ctx = ctx;
        this.assetHandler = new AssetHandler((OpenMetadataAPIGenericConverter)new AssetConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), Asset.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
        this.schemaTypeHandler = new SchemaTypeHandler((OpenMetadataAPIGenericConverter)new SchemaTypeConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaType.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
        this.metadataHandler = new SchemaAttributeHandler((OpenMetadataAPIGenericConverter)new AnalyticsMetadataConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaAttribute.class, (OpenMetadataAPIGenericConverter)new SchemaTypeConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaType.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
    }

    public ResponseContainerAssets createAssets(String user, String input) throws AnalyticsModelingCheckedException {
        String methodName = "createAssets";
        this.ctx.setUserId(user);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> guids = new ArrayList<String>();
        try {
            AnalyticsAsset asset = (AnalyticsAsset)mapper.readValue(input, AnalyticsAsset.class);
            if (asset.hasMetadataModule()) {
                guids.add(this.createModuleAsset(asset));
            }
            if (asset.isVisualization()) {
                guids.add(this.createVisualizationAsset(asset));
            }
        }
        catch (JsonProcessingException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.INCORRECT_ARTIFACT_DEFINITION.getMessageDefinition(new String[]{input}), this.getClass().getSimpleName(), methodName, (Throwable)ex);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_CREATE_ARTIFACT.getMessageDefinition(), this.getClass().getSimpleName(), methodName, ex);
        }
        ResponseContainerAssets ret = new ResponseContainerAssets();
        ret.setAssetsList(guids);
        return ret;
    }

    private String createModuleAsset(AnalyticsAsset asset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.resolver = new IdentifierResolver(this.ctx, asset);
        String assetGUID = this.createAssetEntity(asset, true);
        String qualifiedName = asset.getQualifiedName();
        this.createAssetReferences(asset, assetGUID);
        String schemaTypeGUID = this.createSchemaType(asset, assetGUID);
        if (asset.getContainer() != null) {
            this.verifyOrder(asset.getContainer());
            for (MetadataContainer container : asset.getContainer()) {
                this.createContainer(container, schemaTypeGUID, assetGUID, false, qualifiedName);
            }
        }
        if (asset.getItem() != null) {
            this.verifyOrder(asset.getItem());
            HashMap<String, MetadataItem> guidToItem = new HashMap<String, MetadataItem>();
            for (MetadataItem item : asset.getItem()) {
                String itemGUID = this.createItem(item, schemaTypeGUID, assetGUID, false, qualifiedName);
                guidToItem.put(itemGUID, item);
            }
            guidToItem.forEach((k, v) -> this.createMetadataLink((MetadataItem)v, (String)k));
        }
        return assetGUID;
    }

    private void createAssetReferences(AnalyticsAsset asset, String assetGUID) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetReferences";
        List<AssetReference> refAssets = asset.getReference();
        if (refAssets == null) {
            return;
        }
        for (AssetReference ref : refAssets) {
            if (ref.getGuid() == null) continue;
            this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "b827683c-2924-4df3-a92d-7be1888e23c0", null, null, assetGUID, ref.getGuid(), null, methodName);
        }
    }

    private String createSchemaType(AnalyticsAsset asset, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createSchemaType";
        SoftwareServerCapability ssc = this.ctx.getServerSoftwareCapability();
        SchemaTypeBuilder builder = new SchemaTypeBuilder(QualifiedNameUtils.buildQualifiedName(asset.getQualifiedName(), "ComplexSchemaType", asset.getType()), "786a6199-0ce8-47bf-b006-9ace1c5510e4", "ComplexSchemaType", this.ctx.getRepositoryHelper(), this.ctx.getServiceName(), this.ctx.getServerName());
        builder.setAnchors(this.ctx.getUserId(), assetGUID, methodName);
        String schemaTypeGUID = this.schemaTypeHandler.addSchemaType(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), builder, methodName);
        this.assetHandler.attachSchemaTypeToAsset(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), assetGUID, "assetGUID", schemaTypeGUID, "schemaTypeGUID", methodName);
        return schemaTypeGUID;
    }

    private String createAssetEntity(AnalyticsAsset asset, boolean bModuleAsset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createAsset";
        SoftwareServerCapability ssc = this.ctx.getServerSoftwareCapability();
        String assetTypeName = bModuleAsset ? "InformationView" : "DeployedReport";
        String assetTypeGuid = bModuleAsset ? "68d7b905-6438-43be-88cf-5de027b4aaaf" : "e9077f4f-955b-4d7b-b1f7-12ee769ff0c3";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(ssc.getQualifiedName(), assetTypeName, asset.getUid());
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("type", asset.getType());
        asset.setQualifiedName(qualifiedName);
        String assetGUID = this.assetHandler.createAssetInRepository(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), qualifiedName, asset.getDisplayName(), asset.getDescription(), this.ctx.getSupportedZones(), null, 0, null, null, null, additionalProperties, assetTypeGuid, assetTypeName, null, methodName);
        this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "56315447-88a6-4235-ba91-fead86524ebf", null, null, ssc.getGUID(), assetGUID, null, methodName);
        return assetGUID;
    }

    private String createVisualizationAsset(AnalyticsAsset report) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.resolver == null || !report.hasMetadataModule()) {
            this.resolver = new IdentifierResolver(this.ctx, report);
        }
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("type", report.getType());
        String assetGUID = this.createAssetEntity(report, false);
        String qualifiedName = report.getQualifiedName();
        this.createAssetReferences(report, assetGUID);
        String schemaTypeGUID = this.createSchemaType(report, assetGUID);
        if (report.getVisualization() != null) {
            this.verifyOrder(report.getVisualization());
            for (MetadataContainer container : report.getVisualization()) {
                this.createContainer(container, schemaTypeGUID, assetGUID, false, qualifiedName);
            }
        }
        return assetGUID;
    }

    private void verifyOrder(List<? extends SchemaAttribute> attributes) {
        if (attributes.stream().filter(att -> att.getElementPosition() != 0).count() != (long)attributes.size()) {
            for (int i = 0; i < attributes.size(); ++i) {
                attributes.get(i).setElementPosition(i + 1);
            }
        }
    }

    private String createContainer(MetadataContainer container, String parentGUID, String anchorGUID, boolean bNested, String parentQName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guid;
        String methodName = "createContainer";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", container.getIdentifier());
        container.setQualifiedName(qualifiedName);
        String string = guid = bNested ? this.metadataHandler.createNestedSchemaAttribute(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", qualifiedName, "qualifiedName", (SchemaAttributeBuilder)this.createAnalyticsMetadataBuilder(container, anchorGUID), methodName) : this.metadataHandler.createBeanInRepository(this.ctx.getUserId(), null, null, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, (OpenMetadataAPIGenericBuilder)this.createAnalyticsMetadataBuilder(container, anchorGUID), methodName);
        if (!bNested) {
            this.assetHandler.linkElementToElement(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "ComplexSchemaType", guid, "guid", "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, methodName);
        }
        if (container.getContainer() != null) {
            this.verifyOrder(container.getContainer());
            for (MetadataContainer subContainer : container.getContainer()) {
                this.createContainer(subContainer, guid, anchorGUID, true, qualifiedName);
            }
        }
        if (container.getItem() != null) {
            this.verifyOrder(container.getItem());
            HashMap<String, MetadataItem> guidToItem = new HashMap<String, MetadataItem>();
            for (MetadataItem item : container.getItem()) {
                String itemGUID = this.createItem(item, guid, anchorGUID, true, qualifiedName);
                guidToItem.put(itemGUID, item);
            }
            guidToItem.forEach((k, v) -> this.createMetadataLink((MetadataItem)v, (String)k));
        }
        return guid;
    }

    private String createItem(MetadataItem item, String parentGUID, String anchorGUID, boolean bNested, String parentQName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guid;
        String methodName = "createItem";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", item.getIdentifier());
        item.setQualifiedName(qualifiedName);
        String string = guid = bNested ? this.metadataHandler.createNestedSchemaAttribute(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", qualifiedName, "qualifiedName", (SchemaAttributeBuilder)this.createAnalyticsMetadataBuilder(item, anchorGUID), methodName) : this.metadataHandler.createBeanInRepository(this.ctx.getUserId(), null, null, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, (OpenMetadataAPIGenericBuilder)this.createAnalyticsMetadataBuilder(item, anchorGUID), methodName);
        if (!bNested) {
            this.assetHandler.linkElementToElement(this.ctx.getUserId(), null, null, parentGUID, "parentGUID", "ComplexSchemaType", guid, "guid", "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, methodName);
        }
        if (item.getItem() != null) {
            HashMap<String, MetadataItem> guidToItem = new HashMap<String, MetadataItem>();
            for (MetadataItem nestedItem : item.getItem()) {
                String itemGUID = this.createItem(nestedItem, guid, anchorGUID, true, qualifiedName);
                guidToItem.put(itemGUID, nestedItem);
            }
            guidToItem.forEach((k, v) -> this.createMetadataLink((MetadataItem)v, (String)k));
        }
        this.resolver.addGuidForIdentifier(guid, IdentifierResolver.getIdFromQName(qualifiedName, null));
        return guid;
    }

    private void createMetadataLink(MetadataItem item, String guid) {
        String methodName = "createMetadataLink";
        List<String> metadata = this.resolver.required() ? this.resolver.getItemGUIDs(item) : item.getSourceGuid();
        metadata.forEach(srcGUID -> {
            try {
                this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", null, null, guid, srcGUID, null, methodName);
            }
            catch (PropertyServerException | UserNotAuthorizedException throwable) {
                // empty catch block
            }
        });
    }

    private AnalyticsMetadataBuilder createAnalyticsMetadataBuilder(AnalyticsMetadata src, String assetGUID) throws InvalidParameterException {
        String methodName = "createAnalyticsMetadataBuilder";
        src.prepareAnalyticsMetadataProperties();
        AnalyticsMetadataBuilder builder = new AnalyticsMetadataBuilder(src, null, this.ctx);
        if (assetGUID != null) {
            builder.setAnchors(this.ctx.getUserId(), assetGUID, methodName);
        }
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(src.getQualifiedName(), "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", this.ctx.getRepositoryHelper(), this.ctx.getServiceName(), this.ctx.getServerName());
        builder.setSchemaType(this.ctx.getUserId(), schemaTypeBuilder, methodName);
        return builder;
    }
}

