/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaAttribute;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsMetadata;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnalyticsMetadataConverter
extends OpenMetadataAPIGenericConverter<SchemaAttribute> {
    public AnalyticsMetadataConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public AnalyticsMetadata getNewBean(Class<SchemaAttribute> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        InstanceProperties instanceProperties;
        if (entity == null) {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        if ((instanceProperties = entity.getProperties()) != null) {
            String nativeClass = this.removeNativeClass(instanceProperties);
            if (nativeClass == null) {
                throw new PropertyServerException(AnalyticsModelingErrorCode.MISSING_BEAN_CLASS.getMessageDefinition(), ((Object)((Object)this)).getClass().getSimpleName(), methodName);
            }
            Object object = null;
            try {
                Class<?> c = Class.forName(nativeClass);
                Constructor<?> cons = c.getConstructor(new Class[0]);
                object = cons.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new PropertyServerException(AnalyticsModelingErrorCode.FAILED_CREATE_BEAN.getMessageDefinition(new String[]{nativeClass}), ((Object)((Object)this)).getClass().getSimpleName(), methodName);
            }
            if (object instanceof AnalyticsMetadata) {
                AnalyticsMetadata bean = (AnalyticsMetadata)object;
                bean.setDisplayName(this.removeDisplayName(instanceProperties));
                bean.setDescription(this.removeDescription(instanceProperties));
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setElementPosition(this.getPosition(instanceProperties));
                bean.setNativeJavaClass(bean.getClass().getName());
                bean.convertAnalyticsMetadataProperties();
                return bean;
            }
            throw new PropertyServerException(AnalyticsModelingErrorCode.UNEXPECTED_CLASS.getMessageDefinition(new String[]{object.getClass().getSimpleName()}), ((Object)((Object)this)).getClass().getSimpleName(), methodName);
        }
        throw new PropertyServerException(AnalyticsModelingErrorCode.MISSING_BEAN_PROPERTIES.getMessageDefinition(new String[]{entity.getGUID()}), ((Object)((Object)this)).getClass().getSimpleName(), methodName);
    }
}

