/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.ExecutionContext;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsMetadata;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AssetReference;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataContainer;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataItem;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.QualifiedNameUtils;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class IdentifierResolver {
    private static String CLIENT = "AnalyticsModelingOmas";
    public static String NAME_SEPARATOR = ".";
    private ExecutionContext ctx;
    AnalyticsAsset asset;
    Set<String> identifiersToResolve;
    Map<String, String> identifierToGuid = new HashMap<String, String>();

    public IdentifierResolver(ExecutionContext ctx, AnalyticsAsset asset) {
        this.ctx = ctx;
        this.asset = asset;
        if (!this.required()) {
            return;
        }
        this.identifiersToResolve = new HashSet<String>();
        this.buildSetOfMetadataSources();
        this.resolveAssetReferences();
    }

    public boolean addGuidForIdentifier(String guid, String id) {
        if (this.identifiersToResolve != null && this.identifiersToResolve.remove(id)) {
            this.identifierToGuid.put(id, guid);
            return true;
        }
        return false;
    }

    private void resolveSourcesGuids(AssetReference ref) {
        String methodName = "resolveSourcesGuids";
        String alias = ref.getAlias() + NAME_SEPARATOR;
        long nRefs = this.identifiersToResolve.stream().filter(id -> id.startsWith(alias)).count();
        if (nRefs == 0L) {
            return;
        }
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(this.ctx.getServerSoftwareCapability().getQualifiedName(), "InformationView", ref.getUid());
        List<EntityDetail> metadata = this.getSchemaAttributes(qualifiedName, methodName);
        for (EntityDetail entity : metadata) {
            String qName = this.ctx.getRepositoryHelper().getStringProperty(CLIENT, "qualifiedName", entity.getProperties(), methodName);
            String id2 = IdentifierResolver.getIdFromQName(qName, ref.getAlias());
            if (!this.addGuidForIdentifier(entity.getGUID(), id2) || --nRefs != 0L) continue;
            break;
        }
    }

    public static String getIdFromQName(String qName, String alias) {
        List<String> ids = QualifiedNameUtils.extractIdentifiersFromQualifiedName(qName);
        if (alias != null) {
            ids.add(0, alias);
        }
        return String.join((CharSequence)NAME_SEPARATOR, ids);
    }

    private void buildSetOfMetadataSources() {
        this.addMetadataSources(this.asset.getContainer());
        this.addMetadataSources(this.asset.getItem());
        this.addMetadataSources(this.asset.getVisualization());
    }

    private void addMetadataSources(List<? extends AnalyticsMetadata> lstMetadata) {
        if (lstMetadata == null) {
            return;
        }
        for (AnalyticsMetadata analyticsMetadata : lstMetadata) {
            if (analyticsMetadata.getSourceId() != null) {
                analyticsMetadata.getSourceId().forEach(src -> this.identifiersToResolve.add((String)src));
            }
            if (analyticsMetadata instanceof MetadataContainer) {
                this.addMetadataSources(((MetadataContainer)analyticsMetadata).getContainer());
                this.addMetadataSources(((MetadataContainer)analyticsMetadata).getItem());
                continue;
            }
            if (!(analyticsMetadata instanceof MetadataItem)) continue;
            this.addMetadataSources(((MetadataItem)analyticsMetadata).getItem());
        }
    }

    private void resolveAssetReferences() {
        String methodName = "resolveAliases";
        if (this.asset.getReference() == null) {
            return;
        }
        try {
            for (AssetReference ref : this.asset.getReference()) {
                String qualifiedName = QualifiedNameUtils.buildQualifiedName(this.ctx.getServerSoftwareCapability().getQualifiedName(), "InformationView", ref.getUid());
                List refAsset = this.ctx.getServerSoftwareCapabilityHandler().getEntitiesByValue(this.ctx.getUserId(), qualifiedName, "qualifiedName", "68d7b905-6438-43be-88cf-5de027b4aaaf", "InformationView", Arrays.asList("qualifiedName"), true, null, null, 0, 0, methodName);
                if (refAsset == null || refAsset.isEmpty() || refAsset.size() > 1) continue;
                ref.setGuid(((EntityDetail)refAsset.get(0)).getGUID());
                this.resolveSourcesGuids(ref);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
    }

    public List<EntityDetail> getSchemaAttributes(String assetQualifiedName, String methodName) {
        ArrayList<EntityDetail> metadata = new ArrayList<EntityDetail>();
        String pattern = this.ctx.getRepositoryHelper().getStartsWithRegex(assetQualifiedName + "::");
        try {
            List metadataPage;
            while ((metadataPage = this.ctx.getServerSoftwareCapabilityHandler().getEntitiesByValue(this.ctx.getUserId(), pattern, "pattern", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", Arrays.asList("qualifiedName"), false, null, null, metadata.size(), 0, methodName)) != null) {
                metadata.addAll(metadataPage);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        return metadata;
    }

    public boolean required() {
        return this.asset != null && this.asset.getReference() != null && !this.asset.getReference().isEmpty();
    }

    public List<String> getItemGUIDs(AnalyticsMetadata item) {
        List list = item.getSourceId();
        return list == null || list.isEmpty() ? Collections.emptyList() : list.stream().map(id -> this.identifierToGuid.get(id)).collect(Collectors.toList());
    }
}

