/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.assets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.analyticsmodeling.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.analyticsmodeling.converter.GlossaryTermConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.metadata.Database;
import org.odpi.openmetadata.accessservices.analyticsmodeling.metadata.GlossaryTerm;
import org.odpi.openmetadata.accessservices.analyticsmodeling.metadata.Schema;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ModuleTableFilter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabase;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerDatabaseSchema;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerSchemaTables;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.BaseObjectType;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Column;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.DataSource;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignColumn;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.ForeignKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.MetadataModule;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.PrimaryKey;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.Table;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.module.TableItem;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.response.Messages;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.ExecutionContext;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class DatabaseContextHandler {
    public static final String DATA_SOURCE_GUID = "dataSourceGUID";
    private RelationalDataHandler<Database, Schema, Object, Object, Object, Object> relationalDataHandler;
    private GlossaryTermHandler<GlossaryTerm> handlerGlossaryTerm;
    private OMEntityDao omEntityDao;
    private ExecutionContext ctx;
    private static HashMap<String, String> mapTypes = new HashMap();

    public DatabaseContextHandler(RelationalDataHandler<Database, Schema, Object, Object, Object, Object> relationalDataHandler, OMEntityDao omEntityDao, ExecutionContext ctx) {
        this.relationalDataHandler = relationalDataHandler;
        this.omEntityDao = omEntityDao;
        this.ctx = ctx;
        this.handlerGlossaryTerm = new GlossaryTermHandler((OpenMetadataAPIGenericConverter)new GlossaryTermConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), GlossaryTerm.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
    }

    void setContext(String context) {
        this.omEntityDao.setContext(context);
    }

    public List<ResponseContainerDatabase> getDatabases(String userId, Integer startFrom, Integer pageSize) throws AnalyticsModelingCheckedException, UserNotAuthorizedException {
        String methodName = "getDatabases";
        this.ctx.initialize(userId);
        this.setContext(methodName);
        List<Database> databases = this.findDatabases(userId, startFrom, pageSize, methodName);
        return ((Stream)Optional.ofNullable(databases).map(Collection::stream).orElseGet(Stream::empty).parallel()).map(this::buildDatabase).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<Database> findDatabases(String userId, Integer startFrom, Integer pageSize, String methodName) throws AnalyticsModelingCheckedException, UserNotAuthorizedException {
        try {
            return this.relationalDataHandler.getDatabases(userId, startFrom.intValue(), pageSize.intValue(), methodName);
        }
        catch (InvalidParameterException | PropertyServerException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_FETCH_DATABASES.getMessageDefinition(), this.getClass().getSimpleName(), methodName, ex);
        }
    }

    private ResponseContainerDatabase buildDatabase(Database e) {
        ResponseContainerDatabase ret = new ResponseContainerDatabase();
        ret.setDbName(e.getName());
        ret.setDbType(e.getType());
        ret.setDbVersion(e.getVersion());
        ret.setGUID(e.getGuid());
        return ret;
    }

    public List<ResponseContainerDatabaseSchema> getDatabaseSchemas(String userId, String guidDatabase, Integer startFrom, Integer pageSize) throws AnalyticsModelingCheckedException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getDatabaseSchemas";
        this.ctx.initialize(userId);
        this.setContext(methodName);
        this.ctx.getInvalidParameterHandler().validateGUID(guidDatabase, DATA_SOURCE_GUID, methodName);
        try {
            Database db = (Database)this.relationalDataHandler.getDatabaseByGUID(userId, guidDatabase, methodName);
            String dbName = db.getName();
            List schemas = this.relationalDataHandler.getSchemasForDatabase(userId, guidDatabase, startFrom.intValue(), pageSize.intValue(), methodName);
            return Optional.ofNullable(schemas).map(Collection::stream).orElseGet(Stream::empty).map(e -> this.buildSchema(dbName, (Schema)e)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (InvalidParameterException | PropertyServerException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_FETCH_DATABASE_SCHEMAS.getMessageDefinition(new String[]{guidDatabase}), this.getClass().getSimpleName(), methodName, ex);
        }
    }

    private ResponseContainerDatabaseSchema buildSchema(String catalogName, Schema dbSchema) {
        String schemaName = dbSchema.getName();
        ResponseContainerDatabaseSchema schema = new ResponseContainerDatabaseSchema();
        schema.setCatalog(catalogName);
        schema.setSchema(schemaName);
        schema.setId(schema.buildId());
        return schema;
    }

    private EntityDetail getSchemaEntityFromRelationship(Relationship r) {
        return this.getEntityByGuidNoThrow(r.getEntityTwoProxy().getGUID());
    }

    public ResponseContainerSchemaTables getSchemaTables(String userId, String guidDataSource, String schema) throws AnalyticsModelingCheckedException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        String context = "getSchemaTables";
        this.ctx.initialize(userId);
        this.setContext(context);
        this.ctx.getInvalidParameterHandler().validateGUID(guidDataSource, DATA_SOURCE_GUID, context);
        ResponseContainerSchemaTables ret = new ResponseContainerSchemaTables();
        EntityDetail dbSchemaEntity = this.getSchemaEntityByName(guidDataSource, schema);
        List tables = this.getTablesForSchema(dbSchemaEntity).parallelStream().map(t -> this.getEntityStringProperty((EntityDetail)t, "displayName")).filter(Objects::nonNull).collect(Collectors.toList());
        Collections.sort(tables);
        ret.setTablesList(tables);
        return ret;
    }

    private List<EntityDetail> getTablesForSchema(EntityDetail dbSchemaEntity) throws AnalyticsModelingCheckedException {
        List<Relationship> allDbSchemaToSchemaType = this.omEntityDao.getRelationshipsForEntity(dbSchemaEntity, "AssetSchemaType");
        if (allDbSchemaToSchemaType == null || allDbSchemaToSchemaType.isEmpty()) {
            return Collections.emptyList();
        }
        Relationship dbSchemaToSchemaType = allDbSchemaToSchemaType.get(0);
        EntityDetail dbSchemaTypeEntity = this.omEntityDao.getEntityByGuid(dbSchemaToSchemaType.getEntityTwoProxy().getGUID());
        List<Relationship> dbSchemaTypeToTableRelationships = this.omEntityDao.getRelationshipsForEntity(dbSchemaTypeEntity, "AttributeForSchema");
        return Optional.ofNullable(dbSchemaTypeToTableRelationships).map(Collection::stream).orElseGet(Stream::empty).map(this::getTableEntity).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private EntityDetail getTableEntity(Relationship relationship) {
        String tableGuid = relationship.getEntityTwoProxy().getGUID();
        return this.getEntityByGuidNoThrow(tableGuid);
    }

    public ResponseContainerModule getModule(String userId, String databaseGuid, String catalog, String schema, ModuleTableFilter filter) throws AnalyticsModelingCheckedException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        String context = "getModule";
        this.ctx.initialize(userId);
        this.ctx.getInvalidParameterHandler().validateGUID(databaseGuid, DATA_SOURCE_GUID, context);
        this.setContext(context);
        ResponseContainerModule ret = new ResponseContainerModule();
        ret.setId(catalog + "_" + schema);
        ret.setPhysicalModule(this.buildModule(databaseGuid, catalog, schema, filter));
        return ret;
    }

    private MetadataModule buildModule(String databaseGuid, String catalog, String schema, ModuleTableFilter filter) throws AnalyticsModelingCheckedException {
        MetadataModule module = new MetadataModule();
        module.setIdentifier("physicalmodule");
        module.setDataSource(Arrays.asList(this.buildDataSource(databaseGuid, catalog, schema, filter)));
        return module;
    }

    private DataSource buildDataSource(String databaseGuid, String catalog, String schema, ModuleTableFilter filter) throws AnalyticsModelingCheckedException {
        DataSource ds = new DataSource();
        ds.setCatalog(catalog);
        EntityDetail schemaEntity = this.getSchemaEntityByName(databaseGuid, schema);
        ds.setSchema(this.getEntityStringProperty(schemaEntity, "name"));
        ds.setName(catalog + "." + ds.getSchema());
        ds.setTable(this.buildTables(databaseGuid, schemaEntity, filter));
        ds.addProperty("guid", schemaEntity.getGUID());
        this.processGlossaryTerms(schemaEntity, (BaseObjectType)ds);
        return ds;
    }

    private List<Table> buildTables(String databaseGuid, EntityDetail schemaEntity, ModuleTableFilter tblFilter) throws AnalyticsModelingCheckedException {
        List<Object> tables = this.getTablesForSchema(schemaEntity);
        if (tblFilter != null) {
            tables = tables.stream().filter(tbl -> tblFilter.match(this.getEntityStringProperty((EntityDetail)tbl, "displayName"))).collect(Collectors.toList());
        }
        List<Table> ret = tables.parallelStream().map(this::buildSingleTable).filter(Objects::nonNull).collect(Collectors.toList());
        ret.sort(Comparator.comparing(Table::getName));
        return ret;
    }

    private Table buildSingleTable(EntityDetail entityTable) {
        List<Relationship> relationshipsTableColumns;
        Table ret = new Table();
        ret.setName(this.getEntityStringProperty(entityTable, "displayName"));
        ret.addProperty("guid", entityTable.getGUID());
        try {
            relationshipsTableColumns = this.omEntityDao.getRelationshipsForEntity(entityTable, "NestedSchemaAttribute");
        }
        catch (AnalyticsModelingCheckedException e) {
            if (e.getReportedCaughtException() != null) {
                this.ctx.addMessage(AnalyticsModelingErrorCode.TABLE_COLUMN_RELATIONSHIPS_EXCEPTION.getMessageDefinition(new String[]{ret.getName()}), e.getReportedCaughtException().getLocalizedMessage());
            } else {
                this.ctx.addMessage(AnalyticsModelingErrorCode.TABLE_COLUMN_RELATIONSHIPS_EXCEPTION.getMessageDefinition(new String[]{ret.getName()}));
            }
            return null;
        }
        if (relationshipsTableColumns == null || relationshipsTableColumns.isEmpty()) {
            this.ctx.addTableWithoutColumns(ret.getName());
            return null;
        }
        List<TableItem> items = ((Stream)relationshipsTableColumns.stream().parallel()).map(this::buildTableItems).filter(Objects::nonNull).collect(Collectors.toList());
        items.sort(Comparator.comparingInt(TableItem::getPosition));
        if (items.isEmpty()) {
            this.ctx.addTableWithoutColumns(ret.getName());
            return null;
        }
        ret.setTableItem(items);
        this.processGlossaryTerms(entityTable, (BaseObjectType)ret);
        this.processPrimaryKeys(ret, items);
        this.processForeignKeys(ret, items);
        return ret;
    }

    private void processGlossaryTerms(EntityDetail entity, BaseObjectType object) {
        String methodName = "processGlossaryTerms";
        try {
            RepositoryHandler handler = this.ctx.getRepositoryHandler();
            List relationships = handler.getRelationshipsByType(this.ctx.getUserId(), entity.getGUID(), entity.getType().getTypeDefName(), "e6670973-645f-441a-bec7-6f5570345b92", "SemanticAssignment", methodName);
            if (relationships == null || relationships.isEmpty()) {
                return;
            }
            for (Relationship r : relationships) {
                GlossaryTerm term = (GlossaryTerm)this.handlerGlossaryTerm.getTerm(this.ctx.getUserId(), r.getEntityTwoProxy().getGUID(), "guid", methodName);
                String value = this.buildGlossaryTerm(term);
                if (value == null) continue;
                object.addProperty("GlossaryTerm", value);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.GLOSSARY_TERM_EXCEPTION.getMessageDefinition(new String[]{entity.getGUID()}), e.getLocalizedMessage());
        }
    }

    private String buildGlossaryTerm(GlossaryTerm term) {
        if (term.getName() == null || term.getGuid() == null) {
            return null;
        }
        TreeMap<String, String> json = new TreeMap<String, String>();
        json.put("displayName", term.getName());
        json.put("guid", term.getGuid());
        if (term.getDescription() != null) {
            json.put("description", term.getDescription());
        }
        if (term.getSummary() != null) {
            json.put("summary", term.getSummary());
        }
        try {
            return new ObjectMapper().writeValueAsString(json);
        }
        catch (JsonProcessingException e) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.BUILD_GLOSSARY_TERM_EXCEPTION.getMessageDefinition(new String[]{term.getName()}), e.getLocalizedMessage());
            return null;
        }
    }

    private void processPrimaryKeys(Table ret, List<TableItem> items) {
        List pk = items.stream().filter(v -> v.getPkName() != null).collect(Collectors.toList());
        if (pk != null && !pk.isEmpty()) {
            PrimaryKey pKey = new PrimaryKey();
            pKey.setName(((TableItem)pk.get(0)).getPkName());
            pKey.setKeyedColumn(pk.stream().map(v -> v.getColumn().getName()).sorted().collect(Collectors.toList()));
            ret.setPrimaryKey(Arrays.asList(pKey));
        }
    }

    private void processForeignKeys(Table table, List<TableItem> items) {
        List<TableItem> fKeys = items.stream().filter(v -> v.getReferencedColumns() != null).collect(Collectors.toList());
        if (fKeys.isEmpty()) {
            return;
        }
        HashMap<String, List> tablesFKs = new HashMap<String, List>();
        fKeys.forEach(v -> {
            List<EntityDetail> columnEntities = v.getReferencedColumns().stream().map(this::getEntityByGuidNoThrow).filter(Objects::nonNull).collect(Collectors.toList());
            if (columnEntities.isEmpty()) {
                return;
            }
            columnEntities.forEach(ce -> {
                ForeignColumn fkColumn = new ForeignColumn();
                fkColumn.setColumnName(v.getColumn().getName());
                fkColumn.setPkColumn(this.getEntityStringProperty((EntityDetail)ce, "displayName"));
                try {
                    EntityDetail tableEntity = this.getParentEntity((EntityDetail)ce, "NestedSchemaAttribute");
                    fkColumn.setPkTable(this.getEntityStringProperty(tableEntity, "displayName"));
                    ArrayList<ForeignColumn> theTableFKs = (ArrayList<ForeignColumn>)tablesFKs.get(tableEntity.getGUID());
                    if (theTableFKs == null) {
                        theTableFKs = new ArrayList<ForeignColumn>();
                        tablesFKs.put(tableEntity.getGUID(), theTableFKs);
                    }
                    theTableFKs.add(fkColumn);
                    try {
                        EntityDetail schemaAttributesEntity = this.getParentEntity(tableEntity, "AttributeForSchema");
                        EntityDetail schemaEntity = this.getParentEntity(schemaAttributesEntity, "AssetSchemaType");
                        fkColumn.setPkSchema(this.getEntityStringProperty(schemaEntity, "name"));
                        try {
                            EntityDetail catalogEntity = this.getParentEntity(schemaEntity, "DataContentForDataSet");
                            fkColumn.setPkCatalog(this.getEntityStringProperty(catalogEntity, "name"));
                        }
                        catch (AnalyticsModelingCheckedException exCatalog) {
                            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_FOREIGN_KEY_UNKNOWN_CATALOG.getMessageDefinition(new String[]{fkColumn.getColumnName()}));
                            return;
                        }
                    }
                    catch (AnalyticsModelingCheckedException exTable) {
                        this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_FOREIGN_KEY_UNKNOWN_SCHEMA.getMessageDefinition(new String[]{fkColumn.getColumnName()}));
                        return;
                    }
                }
                catch (AnalyticsModelingCheckedException exSchema) {
                    this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_FOREIGN_KEY_UNKNOWN_TABLE.getMessageDefinition(new String[]{fkColumn.getColumnName()}));
                    return;
                }
            });
        });
        tablesFKs.forEach((key, list) -> {
            ForeignKey fk = new ForeignKey();
            String parentTable = ((ForeignColumn)list.get(0)).getPkTable();
            fk.setName("FK_" + table.getName() + "_" + parentTable + "_" + String.join((CharSequence)"_", list.stream().map(v -> v.getColumnName()).collect(Collectors.toList())));
            fk.setFkColumn(list);
            ArrayList<ForeignKey> fks = table.getForeignKey();
            if (fks == null) {
                fks = new ArrayList<ForeignKey>();
                table.setForeignKey(fks);
            }
            fks.add(fk);
        });
        if (table.getForeignKey() != null && table.getForeignKey().size() > 1) {
            table.getForeignKey().sort(Comparator.comparing(e -> e.getName()));
        }
    }

    EntityDetail getEntityByGuidNoThrow(String guid) {
        try {
            return this.omEntityDao.getEntityByGuid(guid);
        }
        catch (Exception ex) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_ENTITY_NOT_FOUND.getMessageDefinition(new String[]{guid}), ex.getLocalizedMessage());
            return null;
        }
    }

    private EntityDetail getParentEntity(EntityDetail child, String propertyName) throws AnalyticsModelingCheckedException {
        List<Relationship> columnRelationships = this.omEntityDao.getRelationshipsForEntity(child, propertyName);
        if (columnRelationships == null) {
            return null;
        }
        Relationship columnTableRelationship = columnRelationships.stream().filter(r -> child.getGUID().equals(r.getEntityTwoProxy().getGUID())).findFirst().get();
        EntityDetail tableEntity = this.omEntityDao.getEntityByGuid(columnTableRelationship.getEntityOneProxy().getGUID());
        return tableEntity;
    }

    private TableItem buildTableItems(Relationship tableTypeToColumns) {
        EntityDetail columnEntity;
        try {
            columnEntity = this.omEntityDao.getEntityByGuid(tableTypeToColumns.getEntityTwoProxy().getGUID());
        }
        catch (AnalyticsModelingCheckedException e) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_COLUMN_NOT_FOUND.getMessageDefinition(new String[]{tableTypeToColumns.getEntityTwoProxy().getGUID()}), e.getReportedCaughtException().getLocalizedMessage());
            return null;
        }
        TableItem item = new TableItem();
        Column tableColumn = new Column();
        item.setColumn(tableColumn);
        item.setPosition(this.getEntityIntProperty(columnEntity, "position"));
        tableColumn.setName(this.getEntityStringProperty(columnEntity, "displayName"));
        tableColumn.addProperty("guid", columnEntity.getGUID());
        String pkName = this.getPrimaryKeyClassification(columnEntity);
        if (pkName != null && !pkName.isEmpty()) {
            item.setPkName(pkName);
        }
        tableColumn.setNullable(this.getEntityBooleanProperty(columnEntity, "isNullable"));
        List<String> fks = this.getReferencedColumn(columnEntity);
        if (fks != null && !fks.isEmpty()) {
            item.setReferencedColumns(fks);
        }
        try {
            EntityDetail columnTypeUniverse = this.getColumnType(columnEntity);
            InstanceProperties ap = this.getAdditiomalProperty(columnTypeUniverse.getProperties());
            tableColumn.setVendorType(this.omEntityDao.getStringProperty("type", ap));
            String length = this.omEntityDao.getStringProperty("length", ap);
            String dt = this.omEntityDao.getStringProperty("odbc_type", ap);
            dt = this.mapDataType(dt);
            tableColumn.setDatatype((String)(length == null ? dt : dt + "(" + length + ")"));
        }
        catch (AnalyticsModelingCheckedException e) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_COLUMN_NOT_FOUND.getMessageDefinition(new String[]{tableColumn.getName()}), e.getReportedCaughtException().getLocalizedMessage());
            return null;
        }
        this.processGlossaryTerms(columnEntity, (BaseObjectType)tableColumn);
        return item;
    }

    private String mapDataType(String dt) {
        String newType = mapTypes.get(dt);
        return newType == null ? dt : newType;
    }

    private String getPrimaryKeyClassification(EntityDetail columnEntity) {
        List classifications = columnEntity.getClassifications();
        if (classifications == null || classifications.isEmpty()) {
            return null;
        }
        Classification classification = classifications.stream().filter(e -> e.getName().equals("PrimaryKey")).findFirst().orElse(null);
        return classification == null ? null : this.omEntityDao.getStringProperty("name", classification.getProperties());
    }

    private EntityDetail getColumnType(EntityDetail column) throws AnalyticsModelingCheckedException {
        List<Relationship> columnToColumnType = this.omEntityDao.getRelationshipsForEntity(column, "AttachedNoteLog");
        return this.omEntityDao.getEntityByGuid(columnToColumnType.get(0).getEntityTwoProxy().getGUID());
    }

    private EntityDetail getSchemaEntityByName(String databaseGuid, String schema) throws AnalyticsModelingCheckedException {
        EntityDetail dbEntity = this.omEntityDao.getEntityByGuid(databaseGuid);
        List<Relationship> databaseToDbSchemaRelationships = this.omEntityDao.getRelationshipsForEntity(dbEntity, "DataContentForDataSet");
        return Optional.ofNullable(databaseToDbSchemaRelationships).map(Collection::stream).orElseGet(Stream::empty).map(r -> {
            EntityDetail dbSchemaEntity = this.getSchemaEntityFromRelationship((Relationship)r);
            if (dbSchemaEntity != null) {
                String schemaName = this.getEntityStringProperty(dbSchemaEntity, "name");
                if (schema != null && schema.equals(schemaName)) {
                    return dbSchemaEntity;
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.SCHEMA_UNKNOWN.getMessageDefinition(new String[]{schema}), this.getClass().getSimpleName(), "getSchemaEntityByName"));
    }

    private List<String> getReferencedColumn(EntityDetail columnEntity) {
        List<Relationship> columnForeignKeys;
        try {
            columnForeignKeys = this.omEntityDao.getRelationshipsForEntity(columnEntity, "ForeignKey");
        }
        catch (AnalyticsModelingCheckedException e) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_FOREIGN_KEY.getMessageDefinition(new String[]{columnEntity.getGUID()}), e.getReportedCaughtException().getLocalizedMessage());
            return null;
        }
        if (columnForeignKeys == null || CollectionUtils.isEmpty(columnForeignKeys)) {
            return null;
        }
        String columnGuid = columnEntity.getGUID();
        return columnForeignKeys.stream().filter(v -> columnGuid.equals(v.getEntityTwoProxy().getGUID())).map(v -> v.getEntityOneProxy().getGUID()).collect(Collectors.toList());
    }

    private InstanceProperties getAdditiomalProperty(InstanceProperties properties) {
        return properties == null ? null : this.omEntityDao.getMapProperty(properties, "additionalProperties");
    }

    private String getEntityStringProperty(EntityDetail entity, String name) {
        return entity == null ? null : this.omEntityDao.getEntityStringProperty(entity, name);
    }

    private Boolean getEntityBooleanProperty(EntityDetail entity, String name) {
        return entity == null ? null : this.omEntityDao.getEntityBooleanProperty(entity, name);
    }

    private int getEntityIntProperty(EntityDetail entity, String name) {
        return entity == null ? null : Integer.valueOf(this.omEntityDao.getEntityIntProperty(entity, name));
    }

    public Messages getMessages() {
        return this.ctx.getMessages();
    }

    static {
        mapTypes.put("WVARCHAR", "NVARCHAR");
    }
}

