/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.analyticsmodeling.auditlog.AnalyticsModelingAuditCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.server.AnalyticsModelingServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AnalyticsModelingAdmin
extends AccessServiceAdmin {
    private OpenMetadataTopicConnector analyticsModelingOutTopicConnector;
    private AuditLog auditLog;
    private String serverName = null;
    private AnalyticsModelingServicesInstance instance = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Analytics Modeling OMAS service.";
        auditLog.logMessage("Initialize Analytics Modeling OMAS service.", AnalyticsModelingAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        if (enterpriseConnector != null) {
            this.serverName = enterpriseConnector.getServerName();
        }
        try {
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                this.analyticsModelingOutTopicConnector = (OpenMetadataTopicConnector)super.getTopicConnector(accessServiceConfig.getAccessServiceOutTopic(), OpenMetadataTopicConnector.class, auditLog, AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceFullName(), "Initialize Analytics Modeling OMAS service.");
                if (this.analyticsModelingOutTopicConnector != null) {
                    String outTopicName = this.getTopicName(accessServiceConfig.getAccessServiceOutTopic());
                    this.startConnector("Initialize Analytics Modeling OMAS service.", outTopicName, this.analyticsModelingOutTopicConnector);
                }
            }
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new AnalyticsModelingServicesInstance(enterpriseConnector, supportedZones, auditLog, serverUserName, enterpriseConnector.getMaxPageSize());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("Initialize Analytics Modeling OMAS service.", AnalyticsModelingAuditCode.getAuditLogMessageDefinition((MessageDefinition)OMAGAdminErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(), AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceFullName(), error.getClass().getName(), error.getMessage()), (Throwable)error);
            super.throwUnexpectedInitializationException("Initialize Analytics Modeling OMAS service.", AccessServiceDescription.ANALYTICS_MODELING_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
        auditLog.logMessage("Initialize Analytics Modeling OMAS service.", AnalyticsModelingAuditCode.SERVICE_INITIALIZED.getMessageDefinition(this.serverName));
    }

    private void startConnector(String actionDescription, String topicName, OpenMetadataTopicConnector topicConnector) throws OMAGConfigurationErrorException {
        this.auditLog.logMessage(actionDescription, AnalyticsModelingAuditCode.SERVICE_REGISTERED_WITH_OUT_TOPIC.getMessageDefinition(topicName));
        try {
            topicConnector.start();
        }
        catch (ConnectorCheckedException e) {
            this.auditLog.logException(actionDescription, AnalyticsModelingAuditCode.getAuditLogMessageDefinition((MessageDefinition)AnalyticsModelingErrorCode.ERROR_INITIALIZING_ANALYTICS_MODELING_TOPIC_CONNECTION.getMessageDefinition(), topicName, this.serverName), (Throwable)e);
            throw new OMAGConfigurationErrorException(AnalyticsModelingErrorCode.ERROR_INITIALIZING_ANALYTICS_MODELING_TOPIC_CONNECTION.getMessageDefinition(new String[]{topicName, this.serverName}), ((Object)((Object)this)).getClass().getSimpleName(), actionDescription, (Throwable)e);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        try {
            this.analyticsModelingOutTopicConnector.disconnect();
        }
        catch (ConnectorCheckedException error) {
            this.auditLog.logException("shutdown", AnalyticsModelingAuditCode.SERVICE_INSTANCE_TERMINATION_FAILURE.getMessageDefinition(this.serverName), (Throwable)error);
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", AnalyticsModelingAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
    }
}

