/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ResponseContainerAssets;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.response.Messages;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.IdentifierResolver;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaAttribute;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.beans.SchemaType;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.builders.AnalyticsMetadataBuilder;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.AnalyticsMetadataConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.AssetConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsMetadata;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AssetReference;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataContainer;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataItem;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.AnalyticsAssetUtils;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.ExecutionContext;
import org.odpi.openmetadata.accessservices.analyticsmodeling.utils.QualifiedNameUtils;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareCapability;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class AnalyticsArtifactHandler {
    private AssetHandler<AnalyticsAsset> assetHandler;
    private SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private SchemaAttributeHandler<SchemaAttribute, SchemaType> metadataHandler;
    private AnalyticsMetadataConverter analyticsMetadataConverter;
    private ExecutionContext ctx;
    private IdentifierResolver resolver;
    private Map<String, String> newItem;
    private List<String> invalidAliases = new ArrayList<String>();

    public AnalyticsArtifactHandler(ExecutionContext ctx) {
        this.ctx = ctx;
        this.assetHandler = new AssetHandler((OpenMetadataAPIGenericConverter)new AssetConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), AnalyticsAsset.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
        this.schemaTypeHandler = new SchemaTypeHandler((OpenMetadataAPIGenericConverter)new SchemaTypeConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaType.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
        this.analyticsMetadataConverter = new AnalyticsMetadataConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName());
        this.metadataHandler = new SchemaAttributeHandler((OpenMetadataAPIGenericConverter)this.analyticsMetadataConverter, SchemaAttribute.class, (OpenMetadataAPIGenericConverter)new SchemaTypeConverter(ctx.getRepositoryHelper(), ctx.getServiceName(), ctx.getServerName()), SchemaType.class, ctx.getServiceName(), ctx.getServerName(), ctx.getInvalidParameterHandler(), ctx.getRepositoryHandler(), ctx.getRepositoryHelper(), ctx.getLocalServerUserId(), ctx.getSecurityVerifier(), ctx.getSupportedZones(), ctx.getDefaultZones(), ctx.getPublishZones(), ctx.getAuditLog());
    }

    public AssetHandler<AnalyticsAsset> getAssetHandler() {
        return this.assetHandler;
    }

    public ResponseContainerAssets createAssets(String user, String serverCapability, String serverCapabilityGUID, AnalyticsAsset asset) throws AnalyticsModelingCheckedException, UserNotAuthorizedException {
        String methodName = "createAssets";
        this.ctx.initializeSoftwareServerCapability(user, serverCapability, serverCapabilityGUID);
        ArrayList<String> guids = new ArrayList<String>();
        try {
            if (AnalyticsAssetUtils.hasMetadataModule(asset) || !AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.createModuleAsset(asset));
            }
            if (AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.createVisualizationAsset(asset));
            }
        }
        catch (InvalidParameterException | PropertyServerException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_CREATE_ARTIFACT.getMessageDefinition(), this.getClass().getSimpleName(), methodName, ex);
        }
        ResponseContainerAssets ret = new ResponseContainerAssets();
        ret.setAssetsList(guids);
        return ret;
    }

    private String createModuleAsset(AnalyticsAsset asset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        this.resolver = new IdentifierResolver(this.ctx, asset);
        String assetGUID = this.createAssetEntity(asset, true);
        String qualifiedName = asset.getQualifiedName();
        this.createAssetReferences(asset, assetGUID);
        String schemaTypeGUID = this.createSchemaType(asset, assetGUID);
        if (asset.getContainer() != null) {
            this.verifyOrder(asset.getContainer());
            for (MetadataContainer container : asset.getContainer()) {
                this.createContainer(container, schemaTypeGUID, assetGUID, false, qualifiedName);
            }
        }
        this.createItems(asset.getItem(), assetGUID, qualifiedName, schemaTypeGUID, false);
        return assetGUID;
    }

    private void createAssetReferences(AnalyticsAsset asset, String assetGUID) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetReferences";
        List refAssets = asset.getReference();
        if (refAssets == null) {
            return;
        }
        for (AssetReference ref : refAssets) {
            if (ref.getGuid() != null) {
                this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "b827683c-2924-4df3-a92d-7be1888e23c0", this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), assetGUID, ref.getGuid(), null, methodName);
                continue;
            }
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_UNRESOLVED_REFERENCE.getMessageDefinition(new String[]{asset.getDisplayName(), ref.getAlias()}));
        }
    }

    private String createSchemaType(AnalyticsAsset asset, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createSchemaType";
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        SchemaTypeBuilder builder = new SchemaTypeBuilder(QualifiedNameUtils.buildQualifiedName(asset.getQualifiedName(), "ComplexSchemaType", asset.getType()), "786a6199-0ce8-47bf-b006-9ace1c5510e4", "ComplexSchemaType", this.ctx.getRepositoryHelper(), this.ctx.getServiceName(), this.ctx.getServerName());
        builder.setAnchors(this.ctx.getUserId(), assetGUID, methodName);
        String schemaTypeGUID = this.schemaTypeHandler.addSchemaType(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), builder, null, null, false, false, new Date(), methodName);
        this.assetHandler.attachSchemaTypeToAsset(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), assetGUID, "assetGUID", schemaTypeGUID, "schemaTypeGUID", null, null, false, false, new Date(), methodName);
        return schemaTypeGUID;
    }

    private String createAssetEntity(AnalyticsAsset asset, boolean bModuleAsset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createAsset";
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        String assetTypeName = bModuleAsset ? "InformationView" : "DeployedReport";
        String assetTypeGuid = bModuleAsset ? "68d7b905-6438-43be-88cf-5de027b4aaaf" : "e9077f4f-955b-4d7b-b1f7-12ee769ff0c3";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(ssc.getQualifiedName(), assetTypeName, asset.getUid());
        asset.setQualifiedName(qualifiedName);
        String assetGUID = this.assetHandler.createAssetInRepository(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), qualifiedName, asset.getDisplayName(), asset.getDescription(), this.ctx.getSupportedZones(), null, 0, null, null, null, AnalyticsAssetUtils.buildAdditionalProperties(asset), assetTypeGuid, assetTypeName, null, null, null, InstanceStatus.ACTIVE, new Date(), methodName);
        this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "56315447-88a6-4235-ba91-fead86524ebf", ssc.getGUID(), ssc.getSource(), ssc.getGUID(), assetGUID, null, methodName);
        return assetGUID;
    }

    private String createVisualizationAsset(AnalyticsAsset report) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        if (this.resolver == null || !AnalyticsAssetUtils.hasMetadataModule(report)) {
            this.resolver = new IdentifierResolver(this.ctx, report);
        }
        String assetGUID = this.createAssetEntity(report, false);
        String qualifiedName = report.getQualifiedName();
        this.createAssetReferences(report, assetGUID);
        String schemaTypeGUID = this.createSchemaType(report, assetGUID);
        if (report.getVisualization() != null) {
            this.verifyOrder(report.getVisualization());
            for (MetadataContainer container : report.getVisualization()) {
                this.createContainer(container, schemaTypeGUID, assetGUID, false, qualifiedName);
            }
        }
        return assetGUID;
    }

    private String updateVisualizationAsset(AnalyticsAsset report) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        String methodName = "updateModuleAsset";
        if (this.resolver == null || !AnalyticsAssetUtils.hasMetadataModule(report)) {
            this.resolver = new IdentifierResolver(this.ctx, report);
        }
        this.updateAssetAttributes(report, false);
        HashMap<String, EntityDetail> assetEntities = new HashMap<String, EntityDetail>();
        this.resolver.getSchemaAttributes(report.getQualifiedName(), methodName).forEach(entity -> assetEntities.put(this.ctx.getStringProperty("qualifiedName", entity.getProperties(), methodName), (EntityDetail)entity));
        String schemaTypeGUID = this.ctx.getRepositoryHandler().getEntityForRelationshipType(this.ctx.getUserId(), report.getGuid(), "DeployedReport", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName).getGUID();
        if (report.getVisualization() != null) {
            this.verifyOrder(report.getVisualization());
            for (MetadataContainer container : report.getVisualization()) {
                this.updateContainer(container, schemaTypeGUID, report.getGuid(), false, report.getQualifiedName(), assetEntities);
            }
        }
        for (EntityDetail entity2 : assetEntities.values()) {
            this.removeMetadataObject(entity2, methodName);
        }
        return report.getGuid();
    }

    private void verifyOrder(List<? extends SchemaAttribute> attributes) {
        if (attributes.stream().filter(att -> att.getElementPosition() != 0).count() != (long)attributes.size()) {
            for (int i = 0; i < attributes.size(); ++i) {
                attributes.get(i).setElementPosition(i + 1);
            }
        }
    }

    public String createContainer(MetadataContainer container, String parentGUID, String anchorGUID, boolean bNested, String parentQName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guid;
        String methodName = "createContainer";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", container.getIdentifier());
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        container.setQualifiedName(qualifiedName);
        String string = guid = bNested ? this.metadataHandler.createNestedSchemaAttribute(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), parentGUID, "parentGUID", "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", qualifiedName, "qualifiedName", (SchemaAttributeBuilder)this.createAnalyticsMetadataBuilder((AnalyticsMetadata)container, anchorGUID, true), null, null, false, false, null, methodName) : this.metadataHandler.createBeanInRepository(this.ctx.getUserId(), null, null, "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, (OpenMetadataAPIGenericBuilder)this.createAnalyticsMetadataBuilder((AnalyticsMetadata)container, anchorGUID, true), new Date(), methodName);
        if (!bNested) {
            this.assetHandler.linkElementToElement(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), parentGUID, "parentGUID", "ComplexSchemaType", guid, "guid", "SchemaAttribute", false, false, "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", (InstanceProperties)null, null, null, new Date(), methodName);
        }
        if (this.newItem != null) {
            this.newItem.put(IdentifierResolver.getIdFromQName(qualifiedName, null), guid);
        }
        if (container.getContainer() != null) {
            this.verifyOrder(container.getContainer());
            for (MetadataContainer subContainer : container.getContainer()) {
                this.createContainer(subContainer, guid, anchorGUID, true, qualifiedName);
            }
        }
        this.createItems(container.getItem(), anchorGUID, qualifiedName, guid, true);
        return guid;
    }

    private String updateContainer(MetadataContainer container, String parentGUID, String anchorGUID, boolean bNested, String parentQName, Map<String, EntityDetail> assetEntities) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateContainer";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", container.getIdentifier());
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        container.setQualifiedName(qualifiedName);
        EntityDetail entity = assetEntities.remove(qualifiedName);
        if (entity == null) {
            return this.createContainer(container, parentGUID, anchorGUID, bNested, parentQName);
        }
        AnalyticsMetadata containerOld = this.analyticsMetadataConverter.getNewBean(entity, methodName);
        AnalyticsMetadataConverter.prepareAnalyticsMetadataProperties((AnalyticsMetadata)container);
        if (!container.equals((Object)containerOld)) {
            this.metadataHandler.updateSchemaAttribute(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), entity.getGUID(), this.createAnalyticsMetadataBuilder((AnalyticsMetadata)container, null, false).getInstanceProperties(methodName), false, false, new Date(), methodName);
        }
        if (container.getContainer() != null) {
            this.verifyOrder(container.getContainer());
            for (MetadataContainer subContainer : container.getContainer()) {
                this.updateContainer(subContainer, entity.getGUID(), anchorGUID, true, qualifiedName, assetEntities);
            }
        }
        this.updateItems(container.getItem(), entity.getGUID(), anchorGUID, true, qualifiedName, assetEntities);
        return entity.getGUID();
    }

    public void createItem(MetadataItem item, String parentGUID, String anchorGUID, boolean bNested, String parentQName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createItem";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", item.getIdentifier());
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        item.setQualifiedName(qualifiedName);
        String guid = bNested ? this.metadataHandler.createNestedSchemaAttribute(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), parentGUID, "parentGUID", "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", qualifiedName, "qualifiedName", (SchemaAttributeBuilder)this.createAnalyticsMetadataBuilder((AnalyticsMetadata)item, anchorGUID, true), null, null, false, false, new Date(), methodName) : this.metadataHandler.createBeanInRepository(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", ssc.getGUID(), ssc.getSource(), (OpenMetadataAPIGenericBuilder)this.createAnalyticsMetadataBuilder((AnalyticsMetadata)item, anchorGUID, true), new Date(), methodName);
        item.setGuid(guid);
        if (!bNested) {
            this.assetHandler.linkElementToElement(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), parentGUID, "parentGUID", "ComplexSchemaType", guid, "guid", "SchemaAttribute", false, false, "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", (InstanceProperties)null, null, null, new Date(), methodName);
        }
        if (this.newItem != null) {
            this.newItem.put(IdentifierResolver.getIdFromQName(item.getQualifiedName(), null), guid);
        }
        this.createItems(item.getItem(), anchorGUID, qualifiedName, guid, true);
        this.resolver.addGuidForIdentifier(guid, IdentifierResolver.getIdFromQName(qualifiedName, null));
    }

    private void createItems(List<MetadataItem> items, String anchorGUID, String parentQName, String parentGUID, boolean bNested) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (items == null) {
            return;
        }
        ArrayList<MetadataItem> guidToItem = new ArrayList<MetadataItem>();
        for (MetadataItem item : items) {
            this.createItem(item, parentGUID, anchorGUID, bNested, parentQName);
            guidToItem.add(item);
        }
        guidToItem.forEach(this::createMetadataLink);
    }

    private boolean updateItem(MetadataItem item, String parentGUID, String anchorGUID, boolean bNested, String parentQName, Map<String, EntityDetail> assetEntities) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateItem";
        String qualifiedName = QualifiedNameUtils.buildQualifiedName(parentQName, "SchemaAttribute", item.getIdentifier());
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        item.setQualifiedName(qualifiedName);
        EntityDetail entity = assetEntities.remove(qualifiedName);
        if (entity == null) {
            this.createItem(item, parentGUID, anchorGUID, bNested, parentQName);
            return true;
        }
        AnalyticsMetadata itemOld = this.analyticsMetadataConverter.getNewBean(entity, methodName);
        AnalyticsMetadataConverter.prepareAnalyticsMetadataProperties((AnalyticsMetadata)item);
        item.setGuid(entity.getGUID());
        if (!item.equals((Object)itemOld)) {
            this.metadataHandler.updateSchemaAttribute(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), entity.getGUID(), this.createAnalyticsMetadataBuilder((AnalyticsMetadata)item, null, false).getInstanceProperties(methodName), false, false, new Date(), methodName);
        }
        this.updateItems(item.getItem(), entity.getGUID(), anchorGUID, true, qualifiedName, assetEntities);
        this.resolver.addGuidForIdentifier(entity.getGUID(), IdentifierResolver.getIdFromQName(qualifiedName, null));
        if (!Objects.equals(item.getSourceId(), itemOld.getSourceId()) || !Objects.equals(item.getSourceGuid(), itemOld.getSourceGuid())) {
            return true;
        }
        if (item.getSourceId() != null && this.invalidAliases != null) {
            for (String alias : this.invalidAliases) {
                for (String metadata : item.getSourceId()) {
                    if (!metadata.startsWith(alias)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void updateItems(List<MetadataItem> items, String parentGUID, String anchorGUID, boolean bNested, String parentQName, Map<String, EntityDetail> assetEntities) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (items == null) {
            return;
        }
        this.verifyOrder(items);
        ArrayList<MetadataItem> guidToItem = new ArrayList<MetadataItem>();
        for (MetadataItem item : items) {
            if (!this.updateItem(item, parentGUID, anchorGUID, bNested, parentQName, assetEntities)) continue;
            guidToItem.add(item);
        }
        guidToItem.forEach(this::updateMetadataLink);
    }

    private void createMetadataLink(MetadataItem item) {
        List<String> metadata;
        String methodName = "createMetadataLink";
        List<String> list = metadata = this.resolver.required() ? this.resolver.getItemGUIDs((AnalyticsMetadata)item) : item.getSourceGuid();
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < metadata.size()) {
            String srcGUID = metadata.get(i);
            try {
                this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), item.getGuid(), srcGUID, null, methodName);
                metadata.remove(i);
            }
            catch (PropertyServerException | UserNotAuthorizedException e) {
                this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_CREATE_METADATA_LINK.getMessageDefinition(new String[]{item.getGuid(), srcGUID}), e.getLocalizedMessage());
                ++i;
            }
        }
    }

    private void updateMetadataLink(MetadataItem item) {
        String methodName = "updateMetadataLink";
        List<String> metadata = this.resolver.required() ? this.resolver.getItemGUIDs((AnalyticsMetadata)item) : item.getSourceGuid();
        HashMap itemReferences = new HashMap();
        try {
            List list = this.ctx.getRepositoryHandler().getRelationshipsByType(this.ctx.getUserId(), item.getGuid(), "SchemaAttribute", "1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", methodName);
            if (list != null) {
                list.forEach(relationship -> {
                    if (relationship.getEntityOneProxy().getGUID().equals(item.getGuid())) {
                        itemReferences.put(relationship.getEntityTwoProxy().getGUID(), relationship);
                    }
                });
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e1) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_UPDATE_METADATA_LINK.getMessageDefinition(new String[]{item.getGuid(), e1.getLocalizedMessage()}));
        }
        metadata.forEach(srcGUID -> {
            Relationship relationship = (Relationship)itemReferences.remove(srcGUID);
            if (relationship == null) {
                try {
                    this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), item.getGuid(), srcGUID, null, methodName);
                }
                catch (PropertyServerException | UserNotAuthorizedException e) {
                    this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_CREATE_METADATA_LINK.getMessageDefinition(new String[]{item.getGuid(), srcGUID}), e.getLocalizedMessage());
                }
            }
        });
        itemReferences.values().forEach(relationship -> {
            try {
                this.ctx.getRepositoryHandler().removeRelationship(this.ctx.getUserId(), this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), relationship, methodName);
            }
            catch (PropertyServerException | UserNotAuthorizedException e) {
                this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_DELETE_METADATA_LINK.getMessageDefinition(new String[]{relationship.getGUID(), item.getGuid()}), e.getLocalizedMessage());
            }
        });
    }

    private AnalyticsMetadataBuilder createAnalyticsMetadataBuilder(AnalyticsMetadata src, String assetGUID, boolean bCreate) throws InvalidParameterException, PropertyServerException {
        String methodName = "createAnalyticsMetadataBuilder";
        AnalyticsMetadataConverter.prepareAnalyticsMetadataProperties(src);
        AnalyticsMetadataBuilder builder = new AnalyticsMetadataBuilder(src, null, this.ctx);
        if (assetGUID != null) {
            builder.setAnchors(this.ctx.getUserId(), assetGUID, methodName);
        }
        if (bCreate) {
            SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(src.getQualifiedName(), "f0f75fba-9136-4082-8352-0ad74f3c36ed", "PrimitiveSchemaType", this.ctx.getRepositoryHelper(), this.ctx.getServiceName(), this.ctx.getServerName());
            builder.setSchemaType(this.ctx.getUserId(), schemaTypeBuilder, methodName);
        }
        return builder;
    }

    public ResponseContainerAssets updateAssets(String user, String serverCapability, String serverCapabilityGUID, AnalyticsAsset asset) throws AnalyticsModelingCheckedException, UserNotAuthorizedException {
        String methodName = "updateAssets";
        this.ctx.initializeSoftwareServerCapability(user, serverCapability, serverCapabilityGUID);
        ArrayList<String> guids = new ArrayList<String>();
        this.newItem = new HashMap<String, String>();
        try {
            if (AnalyticsAssetUtils.hasMetadataModule(asset)) {
                String guid = this.updateModuleAsset(asset);
                guids.add(guid);
                this.updateDependentAssets(guid);
            } else if (!AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.updateModuleAsset(asset));
            }
            if (AnalyticsAssetUtils.isVisualization(asset)) {
                guids.add(this.updateVisualizationAsset(asset));
            }
        }
        catch (InvalidParameterException | PropertyServerException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_UPDATE_ARTIFACT.getMessageDefinition(new String[]{user, asset.getQualifiedName(), ex.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, ex);
        }
        ResponseContainerAssets ret = new ResponseContainerAssets();
        ret.setAssetsList(guids);
        return ret;
    }

    private void updateDependentAssets(String guid) {
        String methodName = "updateDependentAssets";
        if (this.newItem.isEmpty()) {
            return;
        }
        AnalyticsMetadataConverter converter = new AnalyticsMetadataConverter(this.ctx.getRepositoryHelper(), this.ctx.getServerName(), this.ctx.getServiceName());
        try {
            List refAssets = this.ctx.getRepositoryHandler().getRelationshipsByType(this.ctx.getUserId(), guid, "Asset", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", methodName);
            if (refAssets == null) {
                return;
            }
            List filter = refAssets.stream().map(r -> r.getEntityOneProxy().getGUID()).filter(g -> !guid.equals(g)).collect(Collectors.toList());
            List dependants = this.metadataHandler.getAttachedEntities(this.ctx.getUserId(), guid, "guid", "Asset", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", "Asset", null, null, 0, false, false, 0, 0, new Date(), methodName);
            for (EntityDetail entity : dependants) {
                if (!filter.contains(entity.getGUID())) continue;
                AnalyticsAsset assetRepo = (AnalyticsAsset)this.assetHandler.getBeanFromEntity(this.ctx.getUserId(), entity, "entity", methodName);
                Optional<AssetReference> reference = assetRepo.getReference().stream().filter(ref -> guid.equals(ref.getGuid())).findFirst();
                if (reference.isPresent()) {
                    List<EntityDetail> items;
                    String alias = reference.get().getAlias() + IdentifierResolver.NAME_SEPARATOR;
                    Map<String, String> uid2guid = this.newItem.entrySet().stream().collect(Collectors.toMap(e -> alias + (String)e.getKey(), Map.Entry::getValue));
                    try {
                        items = this.resolver.getSchemaAttributes(assetRepo.getQualifiedName(), methodName);
                    }
                    catch (AnalyticsModelingCheckedException e1) {
                        this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_ASSET_NO_UPDATE.getMessageDefinition(new String[]{assetRepo.getDisplayName(), e1.getReportedErrorMessage()}));
                        continue;
                    }
                    for (EntityDetail item : items) {
                        this.updateDependentItemRelationship(item, converter, uid2guid);
                    }
                    continue;
                }
                this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_LINKED_ASSET_NO_REFERENCE.getMessageDefinition(new String[]{guid, assetRepo.getDisplayName()}));
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e2) {
            this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_MANUAL_UPDATE_DEPENDENTS.getMessageDefinition(new String[]{guid}), e2.getLocalizedMessage());
        }
    }

    private void updateDependentItemRelationship(EntityDetail item, AnalyticsMetadataConverter converter, Map<String, String> uid2guid) throws PropertyServerException {
        String methodName = "updateDependentItemRelationship";
        AnalyticsMetadata metadata = converter.getNewBean(item, methodName);
        if (!(metadata instanceof MetadataItem)) {
            return;
        }
        List sources = metadata.getSourceId();
        if (sources != null) {
            sources.forEach(uid -> {
                String guidReferenced = (String)uid2guid.get(uid);
                if (guidReferenced != null) {
                    try {
                        this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "1c2622b7-ac21-413c-89e1-6f61f348cd19", this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), item.getGUID(), guidReferenced, null, methodName);
                    }
                    catch (PropertyServerException | UserNotAuthorizedException e) {
                        this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_FAILED_RESTORE_METADATA_LINK.getMessageDefinition(new String[]{item.getGUID(), guidReferenced}), e.getLocalizedMessage());
                    }
                }
            });
        }
    }

    private String updateModuleAsset(AnalyticsAsset asset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        String methodName = "updateModuleAsset";
        this.resolver = new IdentifierResolver(this.ctx, asset);
        this.updateAssetAttributes(asset, true);
        HashMap<String, EntityDetail> assetEntities = new HashMap<String, EntityDetail>();
        this.resolver.getSchemaAttributes(asset.getQualifiedName(), methodName).forEach(entity -> assetEntities.put(this.ctx.getStringProperty("qualifiedName", entity.getProperties(), methodName), (EntityDetail)entity));
        String assetGUID = asset.getGuid();
        String schemaTypeGUID = this.ctx.getRepositoryHandler().getEntityForRelationshipType(this.ctx.getUserId(), assetGUID, "InformationView", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName).getGUID();
        if (asset.getContainer() != null) {
            this.verifyOrder(asset.getContainer());
            for (MetadataContainer container : asset.getContainer()) {
                this.updateContainer(container, schemaTypeGUID, assetGUID, false, asset.getQualifiedName(), assetEntities);
            }
        }
        this.updateItems(asset.getItem(), schemaTypeGUID, assetGUID, false, asset.getQualifiedName(), assetEntities);
        for (EntityDetail entity2 : assetEntities.values()) {
            this.removeMetadataObject(entity2, methodName);
        }
        this.updateNewItemsReferences(asset);
        return assetGUID;
    }

    private void updateNewItemsReferences(AnalyticsAsset asset) {
        if (this.newItem.isEmpty()) {
            return;
        }
        this.updateNewItemsReferences(asset.getContainer());
        this.updateNewItemsReferences(asset.getItem());
        this.updateNewItemsReferences(asset.getVisualization());
    }

    private void updateNewItemsReferences(List<? extends AnalyticsMetadata> lstMetadata) {
        if (lstMetadata == null) {
            return;
        }
        for (AnalyticsMetadata analyticsMetadata : lstMetadata) {
            if (analyticsMetadata instanceof MetadataItem && analyticsMetadata.getSourceId() != null) {
                analyticsMetadata.getSourceId().forEach(src -> {
                    String guid = this.newItem.get(src);
                    if (guid != null) {
                        this.updateMetadataLink((MetadataItem)mtdObject);
                    }
                });
            }
            if (analyticsMetadata instanceof MetadataContainer) {
                this.updateNewItemsReferences(((MetadataContainer)analyticsMetadata).getContainer());
                this.updateNewItemsReferences(((MetadataContainer)analyticsMetadata).getItem());
                continue;
            }
            if (!(analyticsMetadata instanceof MetadataItem)) continue;
            this.updateNewItemsReferences(((MetadataItem)analyticsMetadata).getItem());
        }
    }

    public void removeMetadataObject(EntityDetail entity, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        this.ctx.getRepositoryHandler().removeEntity(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), entity.getGUID(), "entityGuid", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", null, null, methodName);
    }

    private boolean updateAssetAttributes(AnalyticsAsset asset, boolean bModuleAsset) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, AnalyticsModelingCheckedException {
        String methodName = "updateAssetAttributes";
        SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
        String assetTypeName = bModuleAsset ? "InformationView" : "DeployedReport";
        String assetTypeGuid = bModuleAsset ? "68d7b905-6438-43be-88cf-5de027b4aaaf" : "e9077f4f-955b-4d7b-b1f7-12ee769ff0c3";
        asset.setQualifiedName(QualifiedNameUtils.buildQualifiedName(ssc.getQualifiedName(), assetTypeName, asset.getUid()));
        AnalyticsAsset assetRepo = (AnalyticsAsset)this.assetHandler.getBeanByQualifiedName(this.ctx.getUserId(), assetTypeGuid, assetTypeName, asset.getQualifiedName(), "qualifiedName", false, false, new Date(), methodName);
        if (assetRepo == null) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_UPDATE_UNKNOWN_ARTIFACT.getMessageDefinition(new String[]{this.ctx.getUserId(), asset.getUid()}), this.getClass().getSimpleName(), methodName);
        }
        asset.setGuid(assetRepo.getGuid());
        this.updateAssetReferences(asset, assetRepo);
        if (!asset.equals((Object)assetRepo)) {
            this.assetHandler.updateAsset(this.ctx.getUserId(), ssc.getGUID(), ssc.getSource(), asset.getGuid(), "assetGUID", asset.getQualifiedName(), asset.getDisplayName(), asset.getDescription(), AnalyticsAssetUtils.buildAdditionalProperties(asset), assetTypeGuid, assetTypeName, null, null, null, false, false, false, new Date(), methodName);
            return true;
        }
        return false;
    }

    private void updateAssetReferences(AnalyticsAsset asset, AnalyticsAsset assetRepo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetReferences";
        List refAssets = asset.getReference();
        Map<String, Relationship> mapReferences = this.selectReferencedAssets(asset);
        if (refAssets != null) {
            for (AssetReference ref : refAssets) {
                String guid = ref.getGuid();
                if (guid != null) {
                    String alias = ref.getAlias();
                    if (alias == null || alias.isEmpty()) {
                        this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_REVERENCE_NO_ALIAS.getMessageDefinition(new String[]{asset.getDisplayName(), guid}));
                        continue;
                    }
                    Relationship assetRef = mapReferences.remove(guid);
                    if (assetRef != null) continue;
                    this.ctx.getRepositoryHandler().createRelationship(this.ctx.getUserId(), "b827683c-2924-4df3-a92d-7be1888e23c0", this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), asset.getGuid(), guid, null, methodName);
                    continue;
                }
                this.ctx.addMessage(AnalyticsModelingErrorCode.WARNING_REVERENCE_NO_GUID.getMessageDefinition(new String[]{asset.getDisplayName(), ref.getAlias()}));
            }
        }
        for (Relationship rel : mapReferences.values()) {
            AssetReference reference = AnalyticsAssetUtils.getAssetReferenceByGuid(assetRepo, rel.getEntityTwoProxy().getGUID());
            if (reference != null) {
                this.invalidAliases.add(reference.getAlias() + IdentifierResolver.NAME_SEPARATOR);
            }
            this.ctx.getRepositoryHandler().removeRelationship(this.ctx.getUserId(), this.ctx.getServerSoftwareCapability().getGUID(), this.ctx.getServerSoftwareCapability().getSource(), rel, methodName);
        }
    }

    private Map<String, Relationship> selectReferencedAssets(AnalyticsAsset asset) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        List refAssetsOld = this.ctx.getRepositoryHandler().getRelationshipsByType(this.ctx.getUserId(), asset.getGuid(), "Asset", "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", "selectReferencedAssets");
        HashMap<String, Relationship> mapReferences = new HashMap<String, Relationship>();
        if (refAssetsOld != null) {
            refAssetsOld.forEach(r -> {
                if (r.getEntityOneProxy().getGUID().equals(asset.getGuid())) {
                    mapReferences.put(r.getEntityTwoProxy().getGUID(), (Relationship)r);
                }
            });
        }
        return mapReferences;
    }

    public ResponseContainerAssets deleteAssets(String userId, String serverCapability, String serverCapabilityGUID, String identifier) throws AnalyticsModelingCheckedException, UserNotAuthorizedException {
        String methodName = "deleteAssets";
        this.ctx.initializeSoftwareServerCapability(userId, serverCapability, serverCapabilityGUID);
        this.resolver = new IdentifierResolver(this.ctx, null);
        ArrayList<String> guids = new ArrayList<String>();
        try {
            List<EntityDetail> assets = this.getArtifactAssets(identifier);
            SoftwareCapability ssc = this.ctx.getServerSoftwareCapability();
            for (EntityDetail asset : assets) {
                guids.add(asset.getGUID());
                String qName = this.ctx.getStringProperty("qualifiedName", asset.getProperties(), methodName);
                List<EntityDetail> entities = this.resolver.getSchemaAttributes(qName, methodName);
                for (EntityDetail entity : entities) {
                    this.ctx.getRepositoryHandler().removeEntity(userId, ssc.getGUID(), ssc.getSource(), entity.getGUID(), "guid", entity.getType().getTypeDefGUID(), entity.getType().getTypeDefName(), null, null, methodName);
                }
                this.assetHandler.deleteBeanInRepository(userId, ssc.getGUID(), ssc.getSource(), asset.getGUID(), "assetGUID", asset.getType().getTypeDefGUID(), asset.getType().getTypeDefName(), null, null, false, false, new Date(), methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_DELETE_ARTIFACT.getMessageDefinition(new String[]{userId, identifier, ex.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, ex);
        }
        ResponseContainerAssets ret = new ResponseContainerAssets();
        ret.setAssetsList(guids);
        return ret;
    }

    public List<EntityDetail> getArtifactAssets(String identifier) throws AnalyticsModelingCheckedException {
        String methodName = "getArtifactAssets";
        String pattern = this.ctx.getRepositoryHelper().getEndsWithRegex(")=" + identifier);
        try {
            List ret = this.ctx.getServerSoftwareCapabilityHandler().getEntitiesByValue(this.ctx.getUserId(), pattern, "pattern", "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", Arrays.asList("qualifiedName"), false, null, null, false, false, 0, 0, null, methodName);
            if (ret != null) {
                return ret.stream().filter(entity -> this.ctx.getRepositoryHelper().getStringProperty(this.ctx.getServerName(), "qualifiedName", entity.getProperties(), methodName).startsWith(this.ctx.getServerSoftwareCapability().getQualifiedName())).collect(Collectors.toList());
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_FIND_ARTIFACT_ASSETS.getMessageDefinition(new String[]{this.ctx.getUserId(), identifier, e.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, e);
        }
        return Collections.emptyList();
    }

    public Messages getMessages() {
        return this.ctx.getMessages();
    }
}

