/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AssetReference;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetConverter
extends OpenMetadataAPIGenericConverter<AnalyticsAsset> {
    public AssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public AnalyticsAsset getNewBean(Class<AnalyticsAsset> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity == null) {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        AnalyticsAsset bean = new AnalyticsAsset();
        InstanceProperties instanceProperties = entity.getProperties();
        bean.setGuid(entity.getGUID());
        if (instanceProperties != null) {
            bean.setDisplayName(this.removeName(instanceProperties));
            bean.setDescription(this.removeDescription(instanceProperties));
            bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
            Map props = this.removeAdditionalProperties(instanceProperties);
            bean.setAdditionalProperties(props);
            if (props != null) {
                bean.setUid((String)props.get("uid"));
                bean.setType((String)props.get("type"));
                bean.setLocation((String)props.get("location"));
                bean.setLastModified((String)props.get("lastModified"));
                String jsonReference = (String)props.get("reference");
                if (jsonReference != null && !jsonReference.isEmpty()) {
                    try {
                        bean.setReference((List)new ObjectMapper().readValue(jsonReference.getBytes(), (TypeReference)new TypeReference<List<AssetReference>>(){}));
                    }
                    catch (IOException iOException) {}
                } else {
                    bean.setReference(null);
                }
            }
        }
        return bean;
    }
}

