/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AssetReference;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataContainer;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.MetadataItem;

public class AnalyticsAssetUtils {
    public static void addContainer(AnalyticsAsset asset, MetadataContainer container) {
        if (asset.getContainer() == null) {
            asset.setContainer(new ArrayList());
        }
        asset.getContainer().add(container);
    }

    public static MetadataContainer removeContainer(AnalyticsAsset asset, int index) {
        if (asset.getContainer() != null && asset.getContainer().size() > index) {
            return (MetadataContainer)asset.getContainer().remove(index);
        }
        return null;
    }

    public static MetadataContainer getContainer(AnalyticsAsset asset, int index) {
        if (asset.getContainer() != null && asset.getContainer().size() > index) {
            return (MetadataContainer)asset.getContainer().get(index);
        }
        return null;
    }

    public static void addItem(AnalyticsAsset asset, MetadataItem item) {
        if (asset.getItem() == null) {
            asset.setItem(new ArrayList());
        }
        asset.getItem().add(item);
    }

    public static void addSourceGuid(AnalyticsAsset asset, String guid) {
        if (asset.getSourceGuid() == null) {
            asset.setSourceGuid(new ArrayList());
        }
        asset.getSourceGuid().add(guid);
    }

    public static void addReference(AnalyticsAsset asset, AssetReference reference) {
        if (asset.getReference() == null) {
            asset.setReference(new ArrayList());
        }
        asset.getReference().add(reference);
    }

    public static boolean isVisualization(AnalyticsAsset asset) {
        return asset.getVisualization() != null;
    }

    public static boolean hasMetadataModule(AnalyticsAsset asset) {
        return asset.getContainer() != null && !asset.getContainer().isEmpty() || asset.getItem() != null && !asset.getItem().isEmpty();
    }

    public static Map<String, String> buildAdditionalProperties(AnalyticsAsset asset) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("uid", asset.getUid());
        additionalProperties.put("type", asset.getType());
        additionalProperties.put("lastModified", asset.getLastModified());
        additionalProperties.put("location", asset.getLocation());
        if (asset.getReference() != null) {
            try {
                String references = new ObjectMapper().writeValueAsString((Object)asset.getReference());
                additionalProperties.put("reference", references);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return additionalProperties;
    }

    public static AssetReference getAssetReferenceByGuid(AnalyticsAsset asset, String guid) {
        if (asset.getReference() == null) {
            return null;
        }
        return asset.getReference().stream().filter(r -> guid.equals(r.getGuid())).findFirst().orElse(null);
    }
}

