/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.AnalyticsModelingErrorCode;
import org.odpi.openmetadata.accessservices.analyticsmodeling.ffdc.exceptions.AnalyticsModelingCheckedException;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.response.Messages;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.converters.SoftwareServerCapabilityConverter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExecutionContext {
    private String userId;
    private String serviceName;
    private String serverName;
    private InvalidParameterHandler invalidParameterHandler;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private String localServerUserId;
    private OpenMetadataServerSecurityVerifier securityVerifier;
    private List<String> supportedZones;
    private List<String> defaultZones;
    private List<String> publishZones;
    private AuditLog auditLog;
    private SoftwareServerCapabilityHandler softwareServerCapabilityHandler;
    private SoftwareServerCapability softwareServerCapability;
    private Messages messages = new Messages();
    private List<String> tablesWithoutColumns = new ArrayList<String>();
    private Map<String, List<String>> tableColumnsIgnored = new TreeMap<String, List<String>>();

    public ExecutionContext(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.localServerUserId = localServerUserId;
        this.securityVerifier = securityVerifier;
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
        this.publishZones = publishZones;
        this.auditLog = auditLog;
    }

    public void initialize(String userId) {
        this.messages = new Messages();
        this.userId = userId;
    }

    public void initializeSoftwareServerCapability(String userId, String softwareServerCapabilityName, String softwareServerCapabilityGUID) throws AnalyticsModelingCheckedException {
        String methodName = "InitializeExecutionContext";
        this.initialize(userId);
        this.softwareServerCapabilityHandler = new SoftwareServerCapabilityHandler(new SoftwareServerCapabilityConverter(this.repositoryHelper, this.serviceName, this.serverName), this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.localServerUserId, this.securityVerifier, this.supportedZones, this.defaultZones, this.publishZones, this.auditLog);
        try {
            if (softwareServerCapabilityGUID != null) {
                this.softwareServerCapability = this.softwareServerCapabilityHandler.getSoftwareServerCapability(userId, softwareServerCapabilityGUID, "guid", methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_GET_SERVER_CAPABILITY_GUID.getMessageDefinition(new String[]{userId, softwareServerCapabilityName, ex.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, ex);
        }
        try {
            if (this.softwareServerCapability == null) {
                this.softwareServerCapability = this.softwareServerCapabilityHandler.findSoftwareServerCapability(userId, softwareServerCapabilityName, methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_GET_SERVER_CAPABILITY_NAME.getMessageDefinition(new String[]{userId, softwareServerCapabilityName, ex.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, ex);
        }
        try {
            if (this.softwareServerCapability == null) {
                String guid = this.softwareServerCapabilityHandler.createSoftwareServerCapability(userId, softwareServerCapabilityName, methodName);
                this.softwareServerCapability = this.softwareServerCapabilityHandler.getSoftwareServerCapability(userId, guid, "guid", methodName);
            }
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException ex) {
            throw new AnalyticsModelingCheckedException(AnalyticsModelingErrorCode.FAILED_CREATE_SERVER_CAPABILITY.getMessageDefinition(new String[]{userId, softwareServerCapabilityName, ex.getLocalizedMessage()}), this.getClass().getSimpleName(), methodName, ex);
        }
    }

    public SoftwareServerCapability getServerSoftwareCapability() {
        return this.softwareServerCapability;
    }

    public SoftwareServerCapabilityHandler getServerSoftwareCapabilityHandler() {
        return this.softwareServerCapabilityHandler;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String value) {
        this.userId = value;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public InvalidParameterHandler getInvalidParameterHandler() {
        return this.invalidParameterHandler;
    }

    public RepositoryHandler getRepositoryHandler() {
        return this.repositoryHandler;
    }

    public OMRSRepositoryHelper getRepositoryHelper() {
        return this.repositoryHelper;
    }

    public String getLocalServerUserId() {
        return this.localServerUserId;
    }

    public OpenMetadataServerSecurityVerifier getSecurityVerifier() {
        return this.securityVerifier;
    }

    public List<String> getSupportedZones() {
        return this.supportedZones;
    }

    public List<String> getDefaultZones() {
        return this.defaultZones;
    }

    public List<String> getPublishZones() {
        return this.publishZones;
    }

    public AuditLog getAuditLog() {
        return this.auditLog;
    }

    public String getStringProperty(String propName, InstanceProperties properties, String methodName) {
        return this.repositoryHelper.getStringProperty(this.serviceName, propName, properties, methodName);
    }

    public synchronized void addTableWithoutColumns(String name) {
        this.tablesWithoutColumns.add(name);
    }

    public synchronized void addIgnoredTableColumn(String nameTable, String nameColumn) {
        List<String> columns = this.tableColumnsIgnored.get(nameTable);
        if (columns == null) {
            columns = new ArrayList<String>();
            this.tableColumnsIgnored.put(nameTable, columns);
        }
        columns.add(nameColumn);
    }

    public Messages getMessages() {
        if (!this.tablesWithoutColumns.isEmpty()) {
            ExceptionMessageDefinition def;
            if (this.tablesWithoutColumns.size() == 1) {
                def = AnalyticsModelingErrorCode.WARNING_TABLE_NO_COLUMNS.getMessageDefinition(new String[]{this.tablesWithoutColumns.get(0)});
            } else {
                this.tablesWithoutColumns.sort(null);
                def = AnalyticsModelingErrorCode.WARNING_TABLES_NO_COLUMNS.getMessageDefinition(new String[]{String.join((CharSequence)", ", this.tablesWithoutColumns)});
            }
            this.messages.addWarning(def);
            this.tablesWithoutColumns.clear();
        }
        return this.messages.getMessages() == null || this.messages.getMessages().isEmpty() ? null : this.messages;
    }

    public void addMessage(ExceptionMessageDefinition message, String detail) {
        this.messages.addWarning(message, detail);
    }

    public void addMessage(ExceptionMessageDefinition message) {
        this.messages.addWarning(message);
    }
}

