/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.analyticsmodeling.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.analyticsmodeling.model.ModuleTableFilter;
import org.odpi.openmetadata.accessservices.analyticsmodeling.responses.AnalyticsModelingOMASAPIResponse;
import org.odpi.openmetadata.accessservices.analyticsmodeling.server.AnalyticsModelingRestServices;
import org.odpi.openmetadata.accessservices.analyticsmodeling.synchronization.model.AnalyticsAsset;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/analytics-modeling/users/{userId}/"})
@Tag(name="Analytics Modeling OMAS", description="The Analytics Modeling OMAS queries RDBMS metadata from repository and creates module for database schema.", externalDocs=@ExternalDocumentation(description="Analytics Modeling Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/analytics-modeling/"))
public class AnalyticsModelingOMASResource {
    private AnalyticsModelingRestServices restAPI = new AnalyticsModelingRestServices();

    @Operation(summary="Get list of databases")
    @GetMapping(path={"/databases"})
    public AnalyticsModelingOMASAPIResponse getDatabases(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PositiveOrZero(message="startFrom should be a positive number") @RequestParam @PositiveOrZero(message="startFrom should be a positive number") Integer startFrom, @PositiveOrZero(message="pageSize should be a positive number") @RequestParam @PositiveOrZero(message="pageSize should be a positive number") Integer pageSize) {
        return this.restAPI.getDatabases(serverName, userId, startFrom, pageSize);
    }

    @Operation(summary="Get list of schemas of a given database")
    @GetMapping(path={"/{databaseGUID}/schemas"})
    public AnalyticsModelingOMASAPIResponse getSchemas(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="databaseGUID") String database, @PositiveOrZero(message="startFrom should be a positive number") @RequestParam @PositiveOrZero(message="startFrom should be a positive number") Integer startFrom, @PositiveOrZero(message="pageSize should be a positive number") @RequestParam @PositiveOrZero(message="pageSize should be a positive number") Integer pageSize) {
        return this.restAPI.getSchemas(serverName, userId, database, startFrom, pageSize);
    }

    @Operation(summary="Get list of tables of a given database, catalog and schema")
    @PostMapping(path={"/{databaseGUID}/tables"})
    public AnalyticsModelingOMASAPIResponse getTables(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="databaseGUID") String database, @RequestParam(required=false) String catalog, @RequestParam(required=true) String schema, @RequestBody(required=false) Object request) {
        return this.restAPI.getTables(serverName, userId, database, schema);
    }

    @Operation(summary="Get physical module of a given database, catalog and schema")
    @PostMapping(path={"/{databaseGUID}/physicalModule"})
    public AnalyticsModelingOMASAPIResponse getPhysicalModule(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="databaseGUID") String database, @RequestParam(required=false) String catalog, @RequestParam(required=true) String schema, @RequestBody(required=false) ModuleTableFilter request) {
        return this.restAPI.getModule(serverName, userId, database, catalog, schema, request);
    }

    @Operation(summary="Create assets representing analytics artifact.")
    @PostMapping(path={"/sync"})
    public AnalyticsModelingOMASAPIResponse createArtifact(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(required=true) String serverCapability, @RequestBody(required=true) String artifact) {
        return this.restAPI.createArtifact(serverName, userId, serverCapability, artifact);
    }

    @Operation(summary="Update assets representing analytics artifact.")
    @PutMapping(path={"/sync"})
    public AnalyticsModelingOMASAPIResponse updateArtifact(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(required=true) String serverCapability, @RequestBody(required=true) AnalyticsAsset artifact) {
        return this.restAPI.updateArtifact(serverName, userId, serverCapability, artifact);
    }

    @Operation(summary="Delete assets that represent analytics artifact.")
    @DeleteMapping(path={"/sync"})
    public AnalyticsModelingOMASAPIResponse deleteArtifact(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(required=true) String serverCapability, @RequestParam(required=true) String identifier) {
        return this.restAPI.deleteArtifact(serverName, userId, serverCapability, identifier);
    }
}

