/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.control;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.PlaceholderPropertyType;

public enum AtlasPlaceholderProperty {
    HOST_IDENTIFIER("hostIdentifier", "The host IP address or domain name of the Apache Atlas server.", "string", "coconet.com"),
    PORT_NUMBER("portNumber", "The number of the port to use to connect to the Apache Atlas server.", "string", "1234"),
    CONNECTION_USER_ID("atlasUserId", "The userId to store in the userId attribute of the connection. This is an admin user that is defined to the Apache Atlas server and is used when making REST API calls to the server.", "string", "admin"),
    CONNECTION_PASSWORD("atlasPassword", "The password to store in the clearPassword attribute of the connection.  This is the password for the atlasUserId and it is used when making REST API calls to the server.", "string", "secret"),
    SERVER_NAME("serverName", "The name of the Apache Atlas server being catalogued.", "string", "myAtlasServer");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private AtlasPlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        for (AtlasPlaceholderProperty placeholderProperty : AtlasPlaceholderProperty.values()) {
            placeholderPropertyTypes.add(placeholderProperty.getPlaceholderType());
        }
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

