/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasRegisteredIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class ApacheKafkaIntegrationModule
extends AtlasRegisteredIntegrationModuleBase {
    private static final String kafkaModuleName = "Apache Kafka Integration Module";
    private static final String egeriaKafkaTypeName = "KafkaTopic";
    private static final String atlasKafkaTypeName = "kafka_topic";
    private static final String egeriaJMSTypeName = "Topic";
    private static final String atlasJMSTypeName = "jms_topic";

    public ApacheKafkaIntegrationModule(String connectorName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        super(connectorName, kafkaModuleName, connectionProperties, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors, new String[]{atlasKafkaTypeName, atlasJMSTypeName}, null);
    }

    @Override
    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh(" + this.moduleName + ")";
        if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                this.syncAtlasDataSetsAsDataSets(atlasKafkaTypeName, egeriaKafkaTypeName);
                this.syncAtlasDataSetsAsDataSets(atlasJMSTypeName, egeriaJMSTypeName);
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException(methodName, AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
            }
        }
    }

    @Override
    public void processEvent(AssetManagerOutTopicEvent event) {
    }
}

