/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SynchronizationDirection;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.LineageExchangeService;

public class AtlasLineageIntegrationModule
extends AtlasIntegrationModuleBase {
    private static final String lineageModuleName = "Apache Atlas Lineage Integration Module";
    protected static final String egeriaDataSetTypeName = "DataSet";
    protected static final String egeriaProcessTypeName = "DeployedSoftwareComponent";
    protected static final String atlasProcessTypeName = "Process";
    protected static final String atlasProcessInputsPropertyName = "inputs";
    protected static final String atlasProcessOutputsPropertyName = "outputs";
    private final LineageExchangeService lineageExchangeService;

    public AtlasLineageIntegrationModule(String connectorName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        super(connectorName, lineageModuleName, connectionProperties, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors);
        this.lineageExchangeService = myContext.getLineageExchangeService();
        this.lineageExchangeService.setForDuplicateProcessing(true);
    }

    public void synchronizeLineage() throws ConnectorCheckedException {
        String methodName = "synchronizeLineage()";
        if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                int startFrom = 0;
                int pageSize = this.myContext.getMaxPageSize();
                List<AtlasEntityHeader> atlasSearchResult = this.atlasClient.getEntitiesForType(atlasProcessTypeName, startFrom, pageSize);
                while (atlasSearchResult != null && !atlasSearchResult.isEmpty()) {
                    for (AtlasEntityHeader atlasEntityHeader : atlasSearchResult) {
                        List<AtlasEntityWithExtInfo> atlasOutputDataSets;
                        String egeriaDataSetGUID;
                        List<AtlasEntityWithExtInfo> atlasInputDataSets;
                        String atlasProcessGUID = atlasEntityHeader.getGuid();
                        AtlasEntityWithExtInfo atlasProcessEntity = this.atlasClient.getEntityByGUID(atlasProcessGUID);
                        String egeriaProcessGUID = this.syncAtlasProcess(atlasProcessEntity);
                        if (egeriaProcessGUID == null) continue;
                        if (atlasProcessEntity != null && atlasProcessEntity.getEntity() != null && atlasProcessEntity.getEntity().getRelationshipAttributes() != null && atlasProcessEntity.getEntity().getRelationshipAttributes().get(atlasProcessInputsPropertyName) != null && (atlasInputDataSets = this.atlasClient.getRelatedEntities(atlasProcessEntity, atlasProcessInputsPropertyName)) != null) {
                            for (AtlasEntityWithExtInfo atlasInputDataSet : atlasInputDataSets) {
                                if (atlasInputDataSet == null || atlasInputDataSet.getEntity() == null) continue;
                                egeriaDataSetGUID = this.syncAtlasDataSetAsDataSet(atlasInputDataSet, atlasInputDataSet.getEntity().getTypeName(), egeriaDataSetTypeName);
                                this.auditLog.logMessage("synchronizeLineage()", AtlasIntegrationAuditCode.ADDING_LINEAGE.getMessageDefinition(this.connectorName, egeriaDataSetTypeName, egeriaDataSetGUID, egeriaProcessTypeName, egeriaProcessGUID));
                                this.lineageExchangeService.setupDataFlow(true, egeriaDataSetGUID, egeriaProcessGUID, null, null);
                            }
                        }
                        if (atlasProcessEntity == null || atlasProcessEntity.getEntity() == null || atlasProcessEntity.getEntity().getRelationshipAttributes() == null || atlasProcessEntity.getEntity().getRelationshipAttributes().get(atlasProcessOutputsPropertyName) == null || (atlasOutputDataSets = this.atlasClient.getRelatedEntities(atlasProcessEntity, atlasProcessOutputsPropertyName)) == null) continue;
                        for (AtlasEntityWithExtInfo atlasInputDataSet : atlasOutputDataSets) {
                            if (atlasInputDataSet == null || atlasInputDataSet.getEntity() == null) continue;
                            egeriaDataSetGUID = this.syncAtlasDataSetAsDataSet(atlasInputDataSet, atlasInputDataSet.getEntity().getTypeName(), egeriaDataSetTypeName);
                            this.auditLog.logMessage("synchronizeLineage()", AtlasIntegrationAuditCode.ADDING_LINEAGE.getMessageDefinition(this.connectorName, egeriaProcessTypeName, egeriaProcessGUID, egeriaDataSetTypeName, egeriaDataSetGUID));
                            this.lineageExchangeService.setupDataFlow(true, egeriaProcessGUID, egeriaDataSetGUID, null, null);
                        }
                    }
                    atlasSearchResult = this.atlasClient.getEntitiesForType(atlasProcessTypeName, startFrom += pageSize, pageSize);
                }
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("synchronizeLineage()", AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "synchronizeLineage()", error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "synchronizeLineage()", error.getMessage()), this.getClass().getName(), "synchronizeLineage()", (Throwable)error);
            }
        }
    }

    private String syncAtlasProcess(AtlasEntityWithExtInfo atlasProcessEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "syncAtlasProcess";
        if (atlasProcessEntity != null && atlasProcessEntity.getEntity() != null) {
            String egeriaProcessGUID = this.getEgeriaGUID(atlasProcessEntity);
            if (egeriaProcessGUID == null) {
                egeriaProcessGUID = this.createAtlasProcessInEgeria(atlasProcessEntity);
            } else {
                try {
                    this.dataAssetExchangeService.getDataAssetByGUID(egeriaProcessGUID, null);
                    this.updateAtlasProcessInEgeria(atlasProcessEntity, egeriaProcessGUID);
                }
                catch (InvalidParameterException notKnown) {
                    this.auditLog.logMessage("syncAtlasProcess", AtlasIntegrationAuditCode.REPLACING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaProcessTypeName, egeriaProcessGUID, atlasProcessEntity.getEntity().getGuid()));
                    this.removeEgeriaGUID(atlasProcessEntity);
                    egeriaProcessGUID = this.createAtlasProcessInEgeria(atlasProcessEntity);
                }
            }
            return egeriaProcessGUID;
        }
        return null;
    }

    protected ProcessProperties getEgeriaProcessProperties(AtlasEntity atlasEntity) {
        ProcessProperties processProperties = super.getProcessProperties(atlasEntity, egeriaProcessTypeName);
        ArrayList<String> excludedProperties = new ArrayList<String>(atlasAssetProperties);
        excludedProperties.add(atlasProcessInputsPropertyName);
        excludedProperties.add(atlasProcessOutputsPropertyName);
        processProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), excludedProperties));
        return processProperties;
    }

    protected String createAtlasProcessInEgeria(AtlasEntityWithExtInfo atlasProcessEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasProcessInEgeria";
        if (atlasProcessEntity != null && (atlasEntity = atlasProcessEntity.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), SynchronizationDirection.FROM_THIRD_PARTY);
            ProcessProperties processProperties = this.getEgeriaProcessProperties(atlasEntity);
            String egeriaProcessGUID = this.lineageExchangeService.createProcess(true, externalIdentifierProperties, processProperties, ProcessStatus.ACTIVE);
            this.auditLog.logMessage("createAtlasProcessInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaProcessTypeName, egeriaProcessGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaProcessGUID, processProperties.getQualifiedName(), egeriaProcessTypeName, false, false);
            this.setOwner(atlasProcessEntity, egeriaProcessGUID);
            return egeriaProcessGUID;
        }
        return null;
    }

    protected void updateAtlasProcessInEgeria(AtlasEntityWithExtInfo atlasProcessEntity, String egeriaProcessGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAtlasProcessInEgeria";
        if (atlasProcessEntity != null) {
            AtlasEntity atlasEntity = atlasProcessEntity.getEntity();
            ProcessElement processElement = this.lineageExchangeService.getProcessByGUID(egeriaProcessGUID, null);
            if (atlasEntity != null && this.egeriaUpdateRequired(egeriaProcessGUID, egeriaProcessTypeName, (MetadataElement)processElement, atlasEntity)) {
                ProcessProperties processProperties = this.getEgeriaProcessProperties(atlasEntity);
                this.auditLog.logMessage("updateAtlasProcessInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaProcessTypeName, egeriaProcessGUID));
                this.lineageExchangeService.updateProcess(egeriaProcessGUID, atlasEntity.getGuid(), false, processProperties, null);
            }
        }
    }
}

