/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasClassification;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasInstanceStatus;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class AtlasRelatedElementsIntegrationModule
extends AtlasIntegrationModuleBase {
    private static final String relatedElementsModuleName = "Apache Atlas Related Elements Integration Module";
    private static final String referenceValueAssignmentRelationshipName = "ReferenceValueAssignment";
    private static final String displayNamePropertyName = "displayName";
    private static final String attributeNamePropertyName = "attributeName";
    private static final String attributeNamePropertyValue = "apacheAtlasClassification";
    private final String informalTagsMappingPolicy;
    private final String relatedClassificationPolicy;
    private final List<String> ignoreClassificationList;
    private final String relatedEntityPolicy;
    private final List<String> ignoreRelationshipList;
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public AtlasRelatedElementsIntegrationModule(String connectorName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors, String informalTagsMappingPolicy, String relatedClassificationPolicy, List<String> ignoreClassificationList, String relatedEntityPolicy, List<String> ignoreRelationshipList) throws UserNotAuthorizedException {
        super(connectorName, relatedElementsModuleName, connectionProperties, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors);
        this.informalTagsMappingPolicy = informalTagsMappingPolicy;
        this.relatedClassificationPolicy = relatedClassificationPolicy;
        this.ignoreClassificationList = ignoreClassificationList != null ? ignoreClassificationList : new ArrayList<String>();
        this.relatedEntityPolicy = relatedEntityPolicy;
        this.ignoreRelationshipList = ignoreRelationshipList != null ? ignoreRelationshipList : new ArrayList<String>();
    }

    public void synchronizeRelatedElements(Map<String, ValidValueElement> referenceClassifications) {
        block5: {
            String methodName = "synchronizeRelatedElements";
            try {
                int maxPageSize = 100;
                int startFrom = 0;
                List<AtlasEntityHeader> correlationEntities = this.atlasClient.getEntitiesForType("OpenMetadataCorrelation", startFrom, 100);
                while (correlationEntities != null) {
                    for (AtlasEntityHeader correlationEntity : correlationEntities) {
                        boolean egeriaOwned;
                        if (correlationEntity == null || correlationEntity.getStatus() != AtlasInstanceStatus.ACTIVE || (egeriaOwned = super.getAtlasBooleanProperty(correlationEntity.getAttributes(), "egeriaOwned"))) continue;
                        String egeriaGUID = super.getAtlasStringProperty(correlationEntity.getAttributes(), "egeriaGUID");
                        AtlasEntityWithExtInfo atlasEntity = this.atlasClient.getRelatedEntity(correlationEntity, "associatedElement");
                        if (atlasEntity == null || atlasEntity.getEntity() == null || atlasEntity.getEntity().getStatus() != AtlasInstanceStatus.ACTIVE) continue;
                        OpenMetadataElement egeriaEntity = this.openMetadataAccess.getMetadataElementByGUID(egeriaGUID);
                        if (!"NONE".equals(this.relatedClassificationPolicy)) {
                            this.processRelatedClassifications(atlasEntity, egeriaEntity, referenceClassifications);
                        }
                        if ("NONE".equals(this.relatedEntityPolicy) && "NONE".equals(this.informalTagsMappingPolicy)) continue;
                        List<RelatedMetadataElement> relatedMetadataElements = this.getAllRelatedMetadataElements(egeriaGUID);
                        this.processRelatedEntities(atlasEntity, egeriaEntity, relatedMetadataElements);
                    }
                    correlationEntities = this.atlasClient.getEntitiesForType("OpenMetadataCorrelation", startFrom += 100, 100);
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block5;
                this.auditLog.logException("synchronizeRelatedElements", AtlasIntegrationAuditCode.UNABLE_TO_PROCESS_RELATED_ELEMENTS.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
    }

    private void processRelatedClassifications(AtlasEntityWithExtInfo atlasEntity, OpenMetadataElement egeriaEntity, Map<String, ValidValueElement> referenceClassifications) {
        block5: {
            String methodName = "processRelatedClassifications";
            if (atlasEntity != null && atlasEntity.getEntity() != null && egeriaEntity != null && atlasEntity.getEntity().getClassifications() != null) {
                try {
                    Map<String, RelatedMetadataElement> existingReferenceValueAssignments = this.getReferenceValueAssignments(egeriaEntity.getElementGUID());
                    HashSet<String> atlasClassificationNames = new HashSet<String>();
                    for (AtlasClassification atlasClassification : atlasEntity.getEntity().getClassifications()) {
                        ValidValueElement referenceValue;
                        if (atlasClassification == null) continue;
                        atlasClassificationNames.add(atlasClassification.getTypeName());
                        if (this.ignoreClassificationList.contains(atlasClassification.getTypeName()) || existingReferenceValueAssignments.get(atlasClassification.getTypeName()) != null || (referenceValue = referenceClassifications.get(atlasClassification.getTypeName())) == null) continue;
                        this.openMetadataAccess.createRelatedElementsInStore(referenceValueAssignmentRelationshipName, egeriaEntity.getElementGUID(), referenceValue.getElementHeader().getGUID(), null, null, null);
                        if (this.auditLog == null) continue;
                        this.auditLog.logMessage("processRelatedClassifications", AtlasIntegrationAuditCode.ASSIGNING_REFERENCE_VALUE.getMessageDefinition(this.connectorName, egeriaEntity.getType().getTypeName(), egeriaEntity.getElementGUID(), referenceValue.getElementHeader().getGUID(), atlasClassification.getTypeName(), atlasEntity.getEntity().getGuid()));
                    }
                    for (String classificationName : existingReferenceValueAssignments.keySet()) {
                        if (atlasClassificationNames.contains(classificationName)) continue;
                        RelatedMetadataElement relatedMetadataElement = existingReferenceValueAssignments.get(classificationName);
                        this.openMetadataAccess.deleteRelatedElementsInStore(relatedMetadataElement.getRelationshipGUID());
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block5;
                    this.auditLog.logException("processRelatedClassifications", AtlasIntegrationAuditCode.UNABLE_TO_SET_REFERENCE_VALUE_ASSIGNMENTS.getMessageDefinition(this.connectorName, error.getClass().getName(), egeriaEntity.getElementGUID(), atlasEntity.getEntity().getGuid(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private Map<String, RelatedMetadataElement> getReferenceValueAssignments(String egeriaGUID) {
        String methodName = "getReferenceValueAssignments";
        if (egeriaGUID != null) {
            HashMap<String, RelatedMetadataElement> results;
            block6: {
                results = new HashMap<String, RelatedMetadataElement>();
                try {
                    int startFrom = 0;
                    List relatedMetadataElements = this.openMetadataAccess.getRelatedMetadataElements(egeriaGUID, 1, referenceValueAssignmentRelationshipName, startFrom, this.myContext.getMaxPageSize());
                    while (relatedMetadataElements != null) {
                        for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                            String classificationName;
                            String attributeName = this.propertyHelper.getStringProperty(this.connectorName, attributeNamePropertyName, relatedMetadataElement.getRelationshipProperties(), "getReferenceValueAssignments");
                            if (!attributeNamePropertyValue.equals(attributeName) || (classificationName = this.propertyHelper.getStringProperty(this.connectorName, displayNamePropertyName, relatedMetadataElement.getElement().getElementProperties(), "getReferenceValueAssignments")) == null) continue;
                            results.put(classificationName, relatedMetadataElement);
                        }
                        relatedMetadataElements = this.openMetadataAccess.getRelatedMetadataElements(egeriaGUID, 1, referenceValueAssignmentRelationshipName, startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize());
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block6;
                    this.auditLog.logException("getReferenceValueAssignments", AtlasIntegrationAuditCode.UNABLE_TO_GET_REFERENCE_VALUE_ASSIGNMENTS.getMessageDefinition(this.connectorName, error.getClass().getName(), egeriaGUID, error.getMessage()), (Throwable)error);
                }
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private List<RelatedMetadataElement> getAllRelatedMetadataElements(String egeriaGUID) {
        String methodName = "getAllRelatedMetadataElements";
        if (egeriaGUID != null) {
            ArrayList<RelatedMetadataElement> results;
            block5: {
                results = new ArrayList<RelatedMetadataElement>();
                try {
                    int startFrom = 0;
                    List relatedMetadataElements = this.openMetadataAccess.getRelatedMetadataElements(egeriaGUID, 1, null, startFrom, this.myContext.getMaxPageSize());
                    while (relatedMetadataElements != null) {
                        results.addAll(relatedMetadataElements);
                        relatedMetadataElements = this.openMetadataAccess.getRelatedMetadataElements(egeriaGUID, 1, referenceValueAssignmentRelationshipName, startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize());
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block5;
                    this.auditLog.logException("getAllRelatedMetadataElements", AtlasIntegrationAuditCode.UNABLE_TO_GET_RELATED_ELEMENTS.getMessageDefinition(this.connectorName, error.getClass().getName(), egeriaGUID, error.getMessage()), (Throwable)error);
                }
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private void processRelatedEntities(AtlasEntityWithExtInfo atlasEntity, OpenMetadataElement egeriaEntity, List<RelatedMetadataElement> relatedMetadataElements) {
        if (relatedMetadataElements != null || !relatedMetadataElements.isEmpty()) {
            // empty if block
        }
    }
}

