/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.DatabaseIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class RDBMSIntegrationModule
extends DatabaseIntegrationModuleBase {
    private static final String rdbmsModuleName = "RDBMS Integration Module";
    private static final String rdbmsDatabaseTypeName = "rdbms_db";
    private static final String rdbmsDatabaseTablesPropertyName = "tables";
    private static final String rdbmsDatabaseTableTypeName = "rdbms_table";
    private static final String rdbmsDatabaseColumnsPropertyName = "columns";
    private static final String rdbmsDatabaseColumnTypeName = "rdbms_column";
    private static final String rdbmsInstancePropertyName = "instance";
    private static final String egeriaPathTypeName = "DataFile";

    public RDBMSIntegrationModule(String connectorName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        super(connectorName, rdbmsModuleName, rdbmsDatabaseTypeName, rdbmsDatabaseTablesPropertyName, rdbmsDatabaseTableTypeName, rdbmsDatabaseColumnsPropertyName, rdbmsDatabaseColumnTypeName, connectionProperties, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors);
    }

    @Override
    protected DataAssetProperties getEgeriaDatabaseProperties(AtlasEntity atlasEntity, String egeriaTypeName) {
        DataAssetProperties dataAssetProperties = super.getDataAssetProperties(atlasEntity, egeriaTypeName);
        dataAssetProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasAssetProperties));
        return dataAssetProperties;
    }

    @Override
    protected SchemaAttributeProperties getEgeriaDatabaseTableProperties(AtlasEntity atlasEntity, String egeriaSchemaAttributeTypeName, String egeriaSchemaTypeTypeName) {
        SchemaAttributeProperties schemaAttributeProperties = super.getSchemaAttributeProperties(atlasEntity, egeriaSchemaAttributeTypeName, egeriaSchemaTypeTypeName);
        schemaAttributeProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasAssetProperties));
        return schemaAttributeProperties;
    }

    @Override
    protected SchemaAttributeProperties getEgeriaDatabaseColumnProperties(AtlasEntity atlasEntity, String egeriaSchemaAttributeTypeName, String egeriaSchemaTypeTypeName) {
        String typeNamePropertyName = "data_type";
        SchemaAttributeProperties schemaAttributeProperties = super.getSchemaAttributeProperties(atlasEntity, egeriaSchemaAttributeTypeName, egeriaSchemaTypeTypeName);
        Map<String, Object> attributes = atlasEntity.getAttributes();
        String dataTypeName = this.getAtlasStringProperty(attributes, "data_type");
        if (dataTypeName == null) {
            dataTypeName = "string";
        }
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("dataType", dataTypeName);
        schemaAttributeProperties.getSchemaType().setExtendedProperties(extendedProperties);
        ArrayList<String> atlasColumnPropertyNames = new ArrayList<String>(atlasAssetProperties);
        atlasColumnPropertyNames.add("data_type");
        schemaAttributeProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasColumnPropertyNames));
        return schemaAttributeProperties;
    }
}

