/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum AtlasSurveyAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("APACHE-ATLAS-SURVEY-ACTION-CONNECTOR-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The {0} Apache Atlas Survey Action Service received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to continue to profile Apache Atlas.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    WRONG_REST_CONNECTOR("APACHE-ATLAS-SURVEY-ACTION-CONNECTOR-0002", AuditLogRecordSeverityLevel.ERROR, "The {0} Apache Atlas Survey Action Service has been supplied with a resource connector of class {1} rather than class {2} for asset {3}", "The connector is unable to continue to profile Apache Atlas because it can not call its REST API.", "Use the details from the error message to determine the class of the connector.  Update the connector type associated with Apache Atlas's Connection in the metadata store."),
    WRONG_ROOT_SCHEMA_TYPE("APACHE-ATLAS-SURVEY-ACTION-CONNECTOR-0003", AuditLogRecordSeverityLevel.ERROR, "The root schema type for Apache Atlas Software Server {0} is of type {1} rather than {2}. Apache Atlas Survey Connector {3} is not able to continue with its schema analysis.  The existing schema type properties are {4}", "The connector is unable to continue to define the schema for the Apache Atlas Server based on its defined types because it is unable to understand the existing root schema type.", "Use the details from the error message to determine the origin and reason for the existing schema type.  If it is correct then disable the schema analysis of this survey action service.  It the existing root schema type should not be present, then delete it, and re-run the failed survey action service."),
    MISSING_ASSET_UNIVERSE("APACHE-ATLAS-SURVEY-ACTION-CONNECTOR-0004", AuditLogRecordSeverityLevel.ERROR, "The asset universe for Apache Atlas Software Server is null. Apache Atlas Survey Connector {0} is not able to continue with its schema analysis", "The connector is unable to continue to define the schema for the Apache Atlas Server based on its defined types because it is unable to access the existing root schema type from the asset universe because it is null.", "Use the details from the error message to determine the asset universe being null.  Correct the error and re-run the failed survey action service.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private AtlasSurveyAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AtlasDiscoveryAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

