/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.controls;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum AtlasDeployedImplementationType implements DeployedImplementationTypeDefinition
{
    APACHE_ATLAS_SERVER("Apache Atlas Server", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.METADATA_SERVER_CLASSIFICATION.typeName, "A data catalog for the Hadoop ecosystem.", "https://atlas.apache.org/");

    private final String deployedImplementationType;
    private final DeployedImplementationTypeDefinition isATypeOf;
    private final String associatedTypeName;
    private final String associatedClassification;
    private final String description;
    private final String wikiLink;

    public static DeployedImplementationTypeDefinition getDefinitionFromDeployedImplementationType(String deployedImplementationType) {
        if (deployedImplementationType != null) {
            for (AtlasDeployedImplementationType definition : AtlasDeployedImplementationType.values()) {
                if (!definition.getDeployedImplementationType().equals(deployedImplementationType)) continue;
                return definition;
            }
        }
        return null;
    }

    private AtlasDeployedImplementationType(String deployedImplementationType, DeployedImplementationTypeDefinition isATypeOf, String associatedTypeName, String associatedClassification, String description, String wikiLink) {
        this.deployedImplementationType = deployedImplementationType;
        this.isATypeOf = isATypeOf;
        this.associatedTypeName = associatedTypeName;
        this.associatedClassification = associatedClassification;
        this.description = description;
        this.wikiLink = wikiLink;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationTypeDefinition getIsATypeOf() {
        return this.isATypeOf;
    }

    public String getAssociatedTypeName() {
        return this.associatedTypeName;
    }

    public String getAssociatedClassification() {
        return this.associatedClassification;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)this.deployedImplementationType);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getWikiLink() {
        return this.wikiLink;
    }

    public String toString() {
        return "DeployedImplementationType{" + this.deployedImplementationType + "}";
    }
}

