/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.ApacheHiveIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.ApacheKafkaIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasGlossaryIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasInformalTagsIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasLineageIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasReferenceClassificationsIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasRelatedElementsIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.RDBMSIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.RegisteredIntegrationModule;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTProvider;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasAttributeDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasCardinality;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasPropagateTags;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipCategory;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipEndDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasTypesDef;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefGallery;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class ApacheAtlasIntegrationConnector
extends CatalogIntegratorConnector
implements AssetManagerEventListener {
    private String targetRootURL = null;
    private CatalogIntegratorContext myContext = null;
    private ApacheAtlasRESTConnector atlasClient = null;
    private AtlasLineageIntegrationModule lineageIntegrationModule = null;
    private AtlasInformalTagsIntegrationModule informalTagsIntegrationModule = null;
    private AtlasRelatedElementsIntegrationModule relatedElementsIntegrationModule = null;
    private AtlasReferenceClassificationsIntegrationModule referenceClassificationsIntegrationModule = null;
    private final Map<String, List<RegisteredIntegrationModule>> moduleMap = new HashMap<String, List<RegisteredIntegrationModule>>();
    private final List<RegisteredIntegrationModule> moduleList = new ArrayList<RegisteredIntegrationModule>();
    public static final String OPEN_METADATA_CORRELATION_TYPE_NAME = "OpenMetadataCorrelation";
    public static final String OPEN_METADATA_CORRELATION_LINK_TYPE_NAME = "OpenMetadataCorrelationLink";
    public static final String GLOSSARY_CORRELATION_LINK_TYPE_NAME = "OpenMetadataGlossaryCorrelationLink";
    public static final String[] openMetadataTypesPolicyValidValues = new String[]{"ALL", "ON_DEMAND"};
    public static final String openMetadataTypesPolicyDefaultValue = "ON_DEMAND";
    public static final String[] informalTagsMappingValidValues = new String[]{"ENTITIES", "CLASSIFICATIONS", "LABELS", "NONE"};
    public static final String informalTagsMappingDefaultValue = "NONE";
    public static final String[] classificationReferenceSetPolicyValidValues = new String[]{"TO_ATLAS", "FROM_ATLAS", "BOTH_WAYS"};
    public static final String classificationReferenceSetPolicyDefaultValue = "FROM_ATLAS";
    public static final String[] relatedElementPolicyValidValues = new String[]{"ALL", "SELECTED", "NONE"};
    public static final String relatedElementPolicyDefaultValue = "NONE";

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.myContext = super.getContext();
        if (this.connectionProperties.getUserId() == null || this.connectionProperties.getClearPassword() == null) {
            throw new ConnectorCheckedException(AtlasIntegrationErrorCode.NULL_USER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(AtlasIntegrationErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        if (this.myContext.getAssetManagerName() == null) {
            throw new ConnectorCheckedException(AtlasIntegrationErrorCode.NULL_ASSET_MANAGER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        try {
            String openMetadataTypesPolicy;
            ApacheAtlasRESTConnector apacheAtlasRESTConnector;
            Connection atlasConnection = new Connection(this.connectionBean);
            atlasConnection.setConnectorType(new ApacheAtlasRESTProvider().getConnectorType());
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            Connector newConnector = connectorBroker.getConnector(atlasConnection);
            if (!(newConnector instanceof ApacheAtlasRESTConnector)) {
                throw new ConnectorCheckedException(AtlasIntegrationErrorCode.NULL_ATLAS_CLIENT.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
            }
            this.atlasClient = apacheAtlasRESTConnector = (ApacheAtlasRESTConnector)newConnector;
            this.atlasClient.start();
            this.setupCorrelationTypes(this.atlasClient);
            if (this.connectionProperties.getConfigurationProperties() != null && "ALL".equals(openMetadataTypesPolicy = this.getEnumConfigurationProperty("openMetadataTypesPolicy", this.connectionProperties.getConfigurationProperties().get("openMetadataTypesPolicy"), Arrays.asList(openMetadataTypesPolicyValidValues), openMetadataTypesPolicyDefaultValue))) {
                this.setupOpenMetadataTypes(this.atlasClient, this.getConfigurationPropertyList("ignoreOpenMetadataTypes", this.connectionProperties.getConfigurationProperties().get("openMetadataTypesPolicy")));
            }
            this.registerSupportedModule(new AtlasGlossaryIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.registerSupportedModule(new ApacheHiveIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.registerSupportedModule(new RDBMSIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.registerSupportedModule(new ApacheKafkaIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors));
            this.lineageIntegrationModule = new AtlasLineageIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors);
            String informalTagsMappingPolicy = "NONE";
            if (this.connectionProperties.getConfigurationProperties() != null) {
                informalTagsMappingPolicy = this.getEnumConfigurationProperty("informalTagsMappingPolicy", this.connectionProperties.getConfigurationProperties().get("informalTagsMappingPolicy"), Arrays.asList(informalTagsMappingValidValues), "NONE");
            }
            this.informalTagsIntegrationModule = new AtlasInformalTagsIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors, informalTagsMappingPolicy);
            String relatedClassificationPolicy = null;
            List<String> ignoreClassificationList = null;
            String relatedEntityPolicy = null;
            List<String> ignoreRelationshipList = null;
            if (this.connectionProperties.getConfigurationProperties() != null) {
                relatedClassificationPolicy = this.getEnumConfigurationProperty("relatedClassificationPolicy", this.connectionProperties.getConfigurationProperties().get("relatedClassificationPolicy"), Arrays.asList(relatedElementPolicyValidValues), "NONE");
                ignoreClassificationList = this.getConfigurationPropertyList("relatedClassificationIgnoreList", this.connectionProperties.getConfigurationProperties().get("relatedClassificationIgnoreList"));
                relatedEntityPolicy = this.getEnumConfigurationProperty("relatedEntityPolicy", this.connectionProperties.getConfigurationProperties().get("relatedEntityPolicy"), Arrays.asList(relatedElementPolicyValidValues), "NONE");
                ignoreRelationshipList = this.getConfigurationPropertyList("relatedRelationshipIgnoreList", this.connectionProperties.getConfigurationProperties().get("relatedRelationshipIgnoreList"));
            }
            this.relatedElementsIntegrationModule = new AtlasRelatedElementsIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors, informalTagsMappingPolicy, relatedClassificationPolicy, ignoreClassificationList, relatedEntityPolicy, ignoreRelationshipList);
            String classificationReferenceSetName = null;
            String classificationReferenceSetPolicy = classificationReferenceSetPolicyDefaultValue;
            if (this.connectionProperties.getConfigurationProperties() != null) {
                classificationReferenceSetName = this.getStringConfigurationProperty("classificationReferenceSetName", this.connectionProperties.getConfigurationProperties().get("classificationReferenceSetName"), null);
                classificationReferenceSetPolicy = this.getEnumConfigurationProperty("classificationReferenceSetPolicy", this.connectionProperties.getConfigurationProperties().get("classificationReferenceSetPolicy"), Arrays.asList(classificationReferenceSetPolicyValidValues), classificationReferenceSetPolicyDefaultValue);
            }
            this.referenceClassificationsIntegrationModule = new AtlasReferenceClassificationsIntegrationModule(this.connectorName, this.connectionProperties, this.auditLog, this.getContext(), this.targetRootURL, this.atlasClient, this.embeddedConnectors, classificationReferenceSetName, classificationReferenceSetPolicy);
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", AtlasIntegrationAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, error.getClass().getName(), this.targetRootURL, "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    private List<String> getConfigurationPropertyList(String propertyName, Object propertyValue) {
        String methodName = "getConfigurationPropertyList";
        ArrayList<String> result = null;
        if (propertyValue != null) {
            result = new ArrayList<String>();
            String propertyValuesString = propertyValue.toString().replace('[', ' ');
            propertyValuesString = propertyValuesString.replace(']', ' ');
            StringTokenizer stringTokenizer = new StringTokenizer(propertyValuesString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String value = stringTokenizer.nextToken();
                String trimmedValue = value.trim();
                if (trimmedValue.isEmpty()) continue;
                result.add(trimmedValue);
            }
            if (result.isEmpty()) {
                result = null;
            }
        }
        if (this.auditLog != null) {
            if (result == null) {
                this.auditLog.logMessage("getConfigurationPropertyList", AtlasIntegrationAuditCode.CONFIGURATION_PROPERTY_NOT_SET.getMessageDefinition(this.connectorName, "null", propertyName));
            } else {
                this.auditLog.logMessage("getConfigurationPropertyList", AtlasIntegrationAuditCode.LIST_CONFIGURATION_PROPERTY_SET.getMessageDefinition(propertyName, Integer.toString(result.size()), ((Object)result).toString(), this.connectorName));
            }
        }
        return result;
    }

    private String getStringConfigurationProperty(String propertyName, Object propertyValue, String defaultValue) {
        String methodName = "getStringConfigurationProperty";
        String result = null;
        if (propertyValue != null) {
            result = propertyValue.toString();
        }
        if (this.auditLog != null) {
            if (result == null) {
                this.auditLog.logMessage("getStringConfigurationProperty", AtlasIntegrationAuditCode.CONFIGURATION_PROPERTY_NOT_SET.getMessageDefinition(this.connectorName, defaultValue, propertyName));
            } else {
                this.auditLog.logMessage("getStringConfigurationProperty", AtlasIntegrationAuditCode.CONFIGURATION_PROPERTY_SET.getMessageDefinition(propertyName, result, this.connectorName));
            }
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private String getEnumConfigurationProperty(String propertyName, Object propertyValue, List<String> validValues, String defaultValue) {
        String methodName = "getEnumConfigurationProperty";
        String result = null;
        if (propertyValue != null && !validValues.contains(result = propertyValue.toString())) {
            result = null;
        }
        if (this.auditLog != null) {
            if (result == null) {
                this.auditLog.logMessage("getEnumConfigurationProperty", AtlasIntegrationAuditCode.CONFIGURATION_PROPERTY_NOT_SET.getMessageDefinition(this.connectorName, defaultValue, propertyName));
            } else {
                this.auditLog.logMessage("getEnumConfigurationProperty", AtlasIntegrationAuditCode.CONFIGURATION_PROPERTY_SET.getMessageDefinition(propertyName, result, this.connectorName));
            }
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private void registerSupportedModule(RegisteredIntegrationModule supportedModule) {
        this.moduleList.add(supportedModule);
        if (supportedModule.getListenForTypes() != null) {
            for (String supportedType : supportedModule.getListenForTypes()) {
                if (supportedType == null) continue;
                List<RegisteredIntegrationModule> modulesForTypeName = this.moduleMap.get(supportedType);
                if (modulesForTypeName == null) {
                    modulesForTypeName = new ArrayList<RegisteredIntegrationModule>();
                }
                modulesForTypeName.add(supportedModule);
                this.moduleMap.put(supportedType, modulesForTypeName);
            }
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        for (RegisteredIntegrationModule registeredModule : this.moduleList) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("refresh", AtlasIntegrationAuditCode.SYNC_INTEGRATION_MODULE.getMessageDefinition(this.connectorName, registeredModule.getModuleName()));
            }
            registeredModule.refresh();
        }
        this.lineageIntegrationModule.synchronizeLineage();
        this.informalTagsIntegrationModule.synchronizeInformalTags();
        Map<String, ValidValueElement> referenceClassifications = this.referenceClassificationsIntegrationModule.synchronizeClassificationDefinitions();
        this.relatedElementsIntegrationModule.synchronizeRelatedElements(referenceClassifications);
        if (!this.myContext.isListenerRegistered() && this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                this.myContext.registerListener((AssetManagerEventListener)this);
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", AtlasIntegrationAuditCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
            }
        }
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        if (!this.myContext.isRefreshInProgress()) {
            ElementHeader elementHeader = event.getElementHeader();
            for (String supportedType : this.moduleMap.keySet()) {
                List<RegisteredIntegrationModule> modulesForTypeName;
                if (!this.myContext.isTypeOf(elementHeader, supportedType) || (modulesForTypeName = this.moduleMap.get(supportedType)) == null) continue;
                for (RegisteredIntegrationModule registeredModule : modulesForTypeName) {
                    registeredModule.processEvent(event);
                }
            }
        }
    }

    private void setupCorrelationTypes(ApacheAtlasRESTConnector atlasClient) throws PropertyServerException {
        AtlasRelationshipEndDef end2;
        AtlasRelationshipEndDef end1;
        AtlasRelationshipDef relationshipDef;
        ArrayList<AtlasRelationshipDef> relationshipDefs;
        AtlasTypesDef typesDef;
        String entityDescription = "Information used in synchronizing Apache Atlas metadata with external catalogs via the Open Metadata Ecosystem supported by Egeria.";
        String egeriaQualifiedNamePropertyName = "egeriaQualifiedName";
        String egeriaQualifiedNameDescription = "Unique name of equivalent open metadata instance in the open metadata ecosystem.";
        String egeriaTypeNamePropertyName = "egeriaTypeName";
        String egeriaTypeNameDescription = "Type name of equivalent open metadata instance in the open metadata ecosystem.";
        String egeriaGUIDPropertyName = "egeriaGUID";
        String egeriaGUIDDescription = "Unique identifier of equivalent open metadata instance in the open metadata ecosystem.";
        String egeriaOwnedPropertyName = "egeriaOwned";
        String egeriaOwnedDescription = "Boolean flag indicating whether the instance originated in the open metadata ecosystem (true) or Apache Atlas (false).";
        String relationshipDescription = "Relationship to connect a referenceable to correlation information from the open metadata ecosystem.";
        String correlationEndLabel = "openMetadataCorrelation";
        String associatedElementEndLabel = "associatedElement";
        String associatedGlossaryEndLabel = "associatedMeaning";
        String referenceableTypeName = "Referenceable";
        String internalTypeName = "__internal";
        String typeVersion = "V1.0";
        atlasClient.getAllTypes();
        try {
            atlasClient.getEntityType(OPEN_METADATA_CORRELATION_TYPE_NAME);
        }
        catch (PropertyServerException notFound) {
            typesDef = new AtlasTypesDef();
            ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
            AtlasEntityDef entityDef = new AtlasEntityDef();
            ArrayList<AtlasAttributeDef> attributeDefs = new ArrayList<AtlasAttributeDef>();
            entityDef.setName(OPEN_METADATA_CORRELATION_TYPE_NAME);
            entityDef.setDescription("Information used in synchronizing Apache Atlas metadata with external catalogs via the Open Metadata Ecosystem supported by Egeria.");
            entityDef.setServiceType("open_metadata_ecosystem");
            entityDef.setTypeVersion("V1.0");
            entityDef.setVersion(1L);
            attributeDefs.add(atlasClient.getStringAttributeDef("egeriaQualifiedName", "Unique name of equivalent open metadata instance in the open metadata ecosystem."));
            attributeDefs.add(atlasClient.getStringAttributeDef("egeriaTypeName", "Type name of equivalent open metadata instance in the open metadata ecosystem."));
            attributeDefs.add(atlasClient.getStringAttributeDef("egeriaGUID", "Unique identifier of equivalent open metadata instance in the open metadata ecosystem."));
            attributeDefs.add(atlasClient.getBooleanAttributeDef("egeriaOwned", "Boolean flag indicating whether the instance originated in the open metadata ecosystem (true) or Apache Atlas (false)."));
            entityDef.setAttributeDefs(attributeDefs);
            entityDefs.add(entityDef);
            typesDef.setEntityDefs(entityDefs);
            atlasClient.addNewTypes(typesDef);
        }
        try {
            atlasClient.getRelationshipType(OPEN_METADATA_CORRELATION_LINK_TYPE_NAME);
        }
        catch (PropertyServerException notFound) {
            typesDef = new AtlasTypesDef();
            relationshipDefs = new ArrayList<AtlasRelationshipDef>();
            relationshipDef = new AtlasRelationshipDef();
            end1 = new AtlasRelationshipEndDef();
            end2 = new AtlasRelationshipEndDef();
            relationshipDef.setName(OPEN_METADATA_CORRELATION_LINK_TYPE_NAME);
            relationshipDef.setDescription("Relationship to connect a referenceable to correlation information from the open metadata ecosystem.");
            relationshipDef.setServiceType("open_metadata_ecosystem");
            relationshipDef.setTypeVersion("V1.0");
            relationshipDef.setVersion(1L);
            relationshipDef.setRelationshipCategory(AtlasRelationshipCategory.ASSOCIATION);
            relationshipDef.setPropagateTags(AtlasPropagateTags.NONE);
            end1.setType("Referenceable");
            end1.setName("openMetadataCorrelation");
            end1.setContainer(false);
            end1.setCardinality(AtlasCardinality.SINGLE);
            end1.setLegacyAttribute(false);
            end2.setType(OPEN_METADATA_CORRELATION_TYPE_NAME);
            end2.setName("associatedElement");
            end2.setContainer(false);
            end2.setCardinality(AtlasCardinality.SINGLE);
            end2.setLegacyAttribute(false);
            relationshipDef.setEndDef1(end1);
            relationshipDef.setEndDef2(end2);
            relationshipDefs.add(relationshipDef);
            typesDef.setRelationshipDefs(relationshipDefs);
            atlasClient.addNewTypes(typesDef);
        }
        try {
            atlasClient.getRelationshipType(GLOSSARY_CORRELATION_LINK_TYPE_NAME);
        }
        catch (PropertyServerException notFound) {
            typesDef = new AtlasTypesDef();
            relationshipDefs = new ArrayList();
            relationshipDef = new AtlasRelationshipDef();
            end1 = new AtlasRelationshipEndDef();
            end2 = new AtlasRelationshipEndDef();
            relationshipDef.setName(GLOSSARY_CORRELATION_LINK_TYPE_NAME);
            relationshipDef.setDescription("Relationship to connect a referenceable to correlation information from the open metadata ecosystem.");
            relationshipDef.setServiceType("open_metadata_ecosystem");
            relationshipDef.setTypeVersion("V1.0");
            relationshipDef.setVersion(1L);
            relationshipDef.setRelationshipCategory(AtlasRelationshipCategory.ASSOCIATION);
            relationshipDef.setPropagateTags(AtlasPropagateTags.NONE);
            end1.setType("__internal");
            end1.setName("openMetadataCorrelation");
            end1.setContainer(false);
            end1.setCardinality(AtlasCardinality.SINGLE);
            end1.setLegacyAttribute(false);
            end2.setType(OPEN_METADATA_CORRELATION_TYPE_NAME);
            end2.setName("associatedMeaning");
            end2.setContainer(false);
            end2.setCardinality(AtlasCardinality.SINGLE);
            end2.setLegacyAttribute(false);
            relationshipDef.setEndDef1(end1);
            relationshipDef.setEndDef2(end2);
            relationshipDefs.add(relationshipDef);
            typesDef.setRelationshipDefs(relationshipDefs);
            atlasClient.addNewTypes(typesDef);
        }
    }

    private void setupOpenMetadataTypes(ApacheAtlasRESTConnector atlasClient, List<String> typesToIgnore) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        OpenMetadataTypeDefGallery openMetadataTypeDefGallery;
        String methodName = "setupOpenMetadataTypes";
        List<String> exclusionList = typesToIgnore;
        if (exclusionList == null) {
            exclusionList = new ArrayList<String>();
        }
        if ((openMetadataTypeDefGallery = this.myContext.getIntegrationGovernanceContext().getOpenMetadataAccess().getAllTypes()) != null && openMetadataTypeDefGallery.getTypeDefs() != null) {
            for (OpenMetadataTypeDef typeDef : openMetadataTypeDefGallery.getTypeDefs()) {
                if (typeDef == null || exclusionList.contains(typeDef.getName())) continue;
                try {
                    atlasClient.addOpenMetadataType(typeDef);
                }
                catch (Exception error) {
                    if (this.auditLog == null) continue;
                    this.auditLog.logException("setupOpenMetadataTypes", AtlasIntegrationAuditCode.UNABLE_TO_DEFINE_TYPE_IN_ATLAS.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", AtlasIntegrationAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName, this.targetRootURL));
        }
        if (this.atlasClient != null) {
            this.atlasClient.disconnect();
        }
        super.disconnect();
    }
}

