/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum AtlasIntegrationErrorCode implements ExceptionMessageSet
{
    NULL_URL(400, "APACHE-ATLAS-INTEGRATION-CONNECTOR-400-001", "Integration connector {0} has been configured without the URL to Apache Atlas", "The connector is move to FAILED status and will not be called by the integration daemon until the configuration error has been corrected.", "The Apache Atlas URL is configured in the integration connector's connection endpoint in the address property.  Typically it is the host name and port where Apache Atlas is listening.  The connection is either found in the Integration Daemon's configuration, or, if the Integration Daemon is configured with integration groups, in the open metadata definition of the appropriate integration group."),
    NULL_USER(400, "APACHE-ATLAS-INTEGRATION-CONNECTOR-400-002", "Integration connector {0} has been configured with either a null userId or password for connecting to Apache Atlas", "The connector is moved to FAILED status and will no longer be called to synchronize metadata.", "Update the connection information for the connector.  This may have been supplied through the Integration Daemon's configuration, or if the Integration Daemon is using integration groups, the connection information is stored in the open metadata ecosystem.  It is possible to supply the userId and password directly in the connection object or via an embedded SecretsConnector."),
    NULL_ASSET_MANAGER(400, "APACHE-ATLAS-INTEGRATION-CONNECTOR-400-003", "Integration connector {0} has been configured without a metadataSourceQualifiedName value", "The connector uses the metadataSourceQualifiedName to identify the metadata that originated in Apache Atlas so that any updates/deletes to this metadata are reflected into the open metadata ecosystem.  Otherwise, any changes will be overridden by the values in the open metadata ecosystem. In order to ensure metadata integrity, the connector is moved to FAILED status and will no longer be called to synchronize metadata until the metadata source name has been supplied.", "Update the metadata source qualified name for the connector.  This may have been supplied through the Integration Daemon's configuration, or, if the Integration Daemon is using integration groups, the connection information is stored in the connector's RegisteredIntegrationConnector relationship in the open metadata ecosystem."),
    NULL_ATLAS_CLIENT(400, "APACHE-ATLAS-INTEGRATION-CONNECTOR-400-004", "Integration connector {0} is unable to create an Apache Atlas REST Connector", "The connector uses the Apache Atlas REST Connector to make REST calls to Apache Atlas. The connector is moved to FAILED status and will no longer be called to synchronize metadata until the problem creating the Apache Atlas REST Connector is resolved.", "Ensure that the jar file for the Apache Atlas REST Connector is in the class path of the platform."),
    MISSING_CORRELATION(404, "APACHE-ATLAS-INTEGRATION-CONNECTOR-404-001", "The {0} integration connector can not retrieve the correlation information for {1} open metadata entity {2} linked in Apache Atlas {3} to {4} entity {5}", "The correlation information that should be associated with the open metadata entity is missing and the integration connector is not able to confidently synchronize it with the Apache Atlas entity.", "Review the audit log to determine if there were errors detected when the open metadata entity was created.  The simplest resolution is to delete the open metadata entity.  However, if this entity has been enhanced with many attachments and classifications then it is also possible to add the correlation information to the open metadata entity to allow the synchronization to continue."),
    UNEXPECTED_EXCEPTION(500, "APACHE-ATLAS-INTEGRATION-CONNECTOR-500-001", "The {0} connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to work with one or more metadata elements.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private AtlasIntegrationErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

