/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.DatabaseIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataAssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class ApacheHiveIntegrationModule
extends DatabaseIntegrationModuleBase {
    private static final String hiveModuleName = "Apache Hive Integration Module";
    private static final String hiveDatabaseTypeName = "hive_db";
    private static final String hiveDatabaseTablesPropertyName = "tables";
    private static final String hiveDatabaseTableTypeName = "hive_table";
    private static final String hiveDatabaseColumnsPropertyName = "columns";
    private static final String hiveDatabaseColumnTypeName = "hive_column";
    private static final String hiveLocationPathPropertyName = "locationPath";
    private static final String egeriaPathTypeName = "DataFile";

    public ApacheHiveIntegrationModule(String connectorName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        super(connectorName, hiveModuleName, hiveDatabaseTypeName, hiveDatabaseTablesPropertyName, hiveDatabaseTableTypeName, hiveDatabaseColumnsPropertyName, hiveDatabaseColumnTypeName, connectionProperties, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors);
    }

    @Override
    protected DataAssetProperties getEgeriaDatabaseProperties(AtlasEntity atlasEntity, String egeriaTypeName) {
        DataAssetProperties dataAssetProperties = super.getDataAssetProperties(atlasEntity, egeriaTypeName);
        dataAssetProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasAssetProperties));
        return dataAssetProperties;
    }

    @Override
    protected void augmentAtlasDatabaseInEgeria(AtlasEntityWithExtInfo atlasDatabaseEntity, String egeriaDatabaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AtlasEntityWithExtInfo hivePathEntity = this.atlasClient.getRelatedEntity(atlasDatabaseEntity, hiveLocationPathPropertyName);
        if (hivePathEntity != null && hivePathEntity.getEntity() != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(hivePathEntity.getEntity().getGuid(), hivePathEntity.getEntity().getTypeName(), hivePathEntity.getEntity().getCreatedBy(), hivePathEntity.getEntity().getCreateTime(), hivePathEntity.getEntity().getUpdatedBy(), hivePathEntity.getEntity().getUpdateTime(), hivePathEntity.getEntity().getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            DataAssetProperties dataAssetProperties = this.getEgeriaDataFileProperties(hivePathEntity.getEntity(), egeriaPathTypeName);
            String dataFileGUID = this.dataAssetExchangeService.createDataAsset(true, externalIdentifierProperties, dataAssetProperties);
            this.setOwner(hivePathEntity, dataFileGUID);
        }
    }

    @Override
    protected SchemaAttributeProperties getEgeriaDatabaseTableProperties(AtlasEntity atlasEntity, String egeriaSchemaAttributeTypeName, String egeriaSchemaTypeTypeName) {
        SchemaAttributeProperties schemaAttributeProperties = super.getSchemaAttributeProperties(atlasEntity, egeriaSchemaAttributeTypeName, egeriaSchemaTypeTypeName);
        schemaAttributeProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasAssetProperties));
        return schemaAttributeProperties;
    }

    @Override
    protected SchemaAttributeProperties getEgeriaDatabaseColumnProperties(AtlasEntity atlasEntity, String egeriaSchemaAttributeTypeName, String egeriaSchemaTypeTypeName) {
        String typeNamePropertyName = "type";
        SchemaAttributeProperties schemaAttributeProperties = super.getSchemaAttributeProperties(atlasEntity, egeriaSchemaAttributeTypeName, egeriaSchemaTypeTypeName);
        Map<String, Object> attributes = atlasEntity.getAttributes();
        String dataTypeName = this.getAtlasStringProperty(attributes, "type");
        if (dataTypeName == null) {
            dataTypeName = "string";
        }
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("dataType", dataTypeName);
        schemaAttributeProperties.getSchemaType().setExtendedProperties(extendedProperties);
        ArrayList<String> atlasColumnPropertyNames = new ArrayList<String>(atlasAssetProperties);
        atlasColumnPropertyNames.add("type");
        schemaAttributeProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasColumnPropertyNames));
        return schemaAttributeProperties;
    }
}

