/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasGlossaryBaseProperties;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasInstanceStatus;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasObjectId;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationship;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataAssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataStoreProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.OwnerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.CollaborationExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.DataAssetExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.StewardshipExchangeService;

public abstract class AtlasIntegrationModuleBase {
    protected static final String openMetadataCorrelationTypeName = "OpenMetadataCorrelation";
    protected static final String openMetadataCorrelationLinkTypeName = "OpenMetadataCorrelationLink";
    protected static final String openMetadataGlossaryCorrelationLinkTypeName = "OpenMetadataGlossaryCorrelationLink";
    protected static final String openMetadataCorrelationPropertyName = "openMetadataCorrelation";
    protected static final String openMetadataAssociatedElementPropertyName = "associatedElement";
    protected static final String openMetadataAssociatedGlossaryPropertyName = "associatedMeaning";
    protected static final String egeriaGUIDPropertyName = "egeriaGUID";
    protected static final String egeriaTypeNamePropertyName = "egeriaTypeName";
    protected static final String egeriaQualifiedNamePropertyName = "egeriaQualifiedName";
    protected static final String egeriaOwnedPropertyName = "egeriaOwned";
    protected static final String atlasOwnerPropertyName = "owner";
    protected static final String egeriaOwnerTypeName = "UserIdentity";
    protected static final String egeriaOwnerPropertyName = "userId";
    protected static final String atlasQualifiedNamePropertyName = "qualifiedName";
    protected static final String atlasNamePropertyName = "name";
    protected static final String atlasDisplayNamePropertyName = "displayName";
    protected static final String atlasDescriptionPropertyName = "description";
    protected static final String atlasUserDescriptionPropertyName = "userDescription";
    protected static final String atlasPathPropertyName = "path";
    protected static final String atlasCreateTimePropertyName = "createTime";
    protected static final String atlasModifiedTimePropertyName = "modifiedTime";
    protected static final List<String> atlasAssetProperties = Arrays.asList("qualifiedName", "name", "displayName", "description", "userDescription");
    protected static final List<String> atlasDataFileProperties = Arrays.asList("qualifiedName", "name", "displayName", "description", "userDescription", "createTime", "modifiedTime", "path");
    private static final String atlasGUIDPropertyName = "atlasGUID";
    private static final String atlasTypeMappingPropertyName = "atlasType";
    private static final String atlasNameMappingPropertyName = "atlasName";
    private static final String egeriaNameMappingPropertyName = "lastKnownEgeriaDisplayName";
    private static final String modulePropertyName = "originator";
    protected final AuditLog auditLog;
    protected final String connectorName;
    protected final String moduleName;
    protected final ConnectionProperties connectionProperties;
    protected final CatalogIntegratorContext myContext;
    protected final List<Connector> embeddedConnectors;
    protected final ApacheAtlasRESTConnector atlasClient;
    protected final String targetRootURL;
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected final DataAssetExchangeService dataAssetExchangeService;
    protected final StewardshipExchangeService stewardshipExchangeService;
    protected final CollaborationExchangeService collaborationExchangeService;
    protected final OpenMetadataAccess openMetadataAccess;

    public AtlasIntegrationModuleBase(String connectorName, String moduleName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        this.auditLog = auditLog;
        this.connectorName = connectorName;
        this.moduleName = moduleName;
        this.connectionProperties = connectionProperties;
        this.myContext = myContext;
        this.targetRootURL = targetRootURL;
        this.atlasClient = atlasClient;
        this.embeddedConnectors = embeddedConnectors;
        this.dataAssetExchangeService = myContext.getDataAssetExchangeService();
        this.stewardshipExchangeService = myContext.getStewardshipExchangeService();
        this.collaborationExchangeService = myContext.getCollaborationExchangeService();
        this.openMetadataAccess = myContext.getIntegrationGovernanceContext().getOpenMetadataAccess();
        this.dataAssetExchangeService.setForDuplicateProcessing(true);
        this.stewardshipExchangeService.setForDuplicateProcessing(true);
        this.collaborationExchangeService.setForDuplicateProcessing(true);
    }

    protected boolean isAtlasOwnedElement(ElementHeader elementHeader) {
        return elementHeader.getOrigin().getHomeMetadataCollectionId() != null && elementHeader.getOrigin().getHomeMetadataCollectionId().equals(this.myContext.getAssetManagerGUID());
    }

    protected boolean isEgeriaOwned(AtlasGlossaryBaseProperties properties) {
        Map<String, Object> additionalAttributes = properties.getAdditionalAttributes();
        return additionalAttributes != null && additionalAttributes.containsKey(egeriaOwnedPropertyName) && "true".equals(additionalAttributes.get(egeriaOwnedPropertyName).toString());
    }

    protected boolean isEgeriaOwned(AtlasEntityWithExtInfo atlasEntityWithExtInfo) throws PropertyServerException {
        if (atlasEntityWithExtInfo != null && atlasEntityWithExtInfo.getEntity() != null) {
            return this.isEgeriaOwned(atlasEntityWithExtInfo.getEntity());
        }
        return false;
    }

    protected boolean isEgeriaOwned(AtlasEntity atlasEntity) throws PropertyServerException {
        AtlasEntityWithExtInfo openMetadataCorrelationEntity;
        if (atlasEntity != null && (openMetadataCorrelationEntity = this.atlasClient.getRelatedEntity(atlasEntity, openMetadataCorrelationPropertyName)) != null && openMetadataCorrelationEntity.getEntity() != null && openMetadataCorrelationEntity.getEntity().getAttributes() != null) {
            return this.getAtlasBooleanProperty(openMetadataCorrelationEntity.getEntity().getAttributes(), egeriaOwnedPropertyName);
        }
        return false;
    }

    protected void saveEgeriaGUIDInAtlas(String atlasEntityGUID, String egeriaEntityGUID, String egeriaQualifiedName, String egeriaTypeName, boolean isAtlasGlossaryEntity, boolean egeriaOwned) throws PropertyServerException {
        AtlasEntity openMetadataCorrelationEntity = new AtlasEntity();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        AtlasRelationship openMetadataCorrelationLinkRelationship = new AtlasRelationship();
        openMetadataCorrelationEntity.setTypeName(openMetadataCorrelationTypeName);
        openMetadataCorrelationEntity.setIncomplete(false);
        openMetadataCorrelationEntity.setStatus(AtlasInstanceStatus.ACTIVE);
        openMetadataCorrelationEntity.setVersion(1L);
        attributes.put(egeriaGUIDPropertyName, egeriaEntityGUID);
        attributes.put(egeriaQualifiedNamePropertyName, egeriaQualifiedName);
        attributes.put(egeriaTypeNamePropertyName, egeriaTypeName);
        attributes.put(egeriaOwnedPropertyName, egeriaOwned);
        openMetadataCorrelationEntity.setAttributes(attributes);
        String openMetadataCorrelationEntityGUID = this.atlasClient.addEntity(openMetadataCorrelationEntity);
        if (openMetadataCorrelationEntityGUID != null) {
            if (isAtlasGlossaryEntity) {
                openMetadataCorrelationLinkRelationship.setTypeName(openMetadataGlossaryCorrelationLinkTypeName);
            } else {
                openMetadataCorrelationLinkRelationship.setTypeName(openMetadataCorrelationLinkTypeName);
            }
            AtlasObjectId end1 = new AtlasObjectId();
            end1.setGuid(atlasEntityGUID);
            openMetadataCorrelationLinkRelationship.setEnd1(end1);
            AtlasObjectId end2 = new AtlasObjectId();
            end2.setGuid(openMetadataCorrelationEntityGUID);
            openMetadataCorrelationLinkRelationship.setEnd2(end2);
            this.atlasClient.addRelationship(openMetadataCorrelationLinkRelationship);
        }
    }

    protected String getAtlasGUID(CorrelatedMetadataElement metadataElement) throws InvalidParameterException {
        MetadataCorrelationHeader myMetadataCorrelationHeader = this.myContext.getMetadataCorrelationHeader(metadataElement);
        if (myMetadataCorrelationHeader != null) {
            return myMetadataCorrelationHeader.getExternalIdentifier();
        }
        return null;
    }

    protected boolean egeriaUpdateRequired(String egeriaGUID, String egeriaTypeName, CorrelatedMetadataElement egeriaMetadataElement, AtlasEntity atlasEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "egeriaUpdateRequired";
        MetadataCorrelationHeader metadataCorrelationHeader = this.myContext.getMetadataCorrelationHeader(egeriaMetadataElement);
        if (metadataCorrelationHeader == null) {
            this.auditLog.logMessage("egeriaUpdateRequired", AtlasIntegrationAuditCode.MISSING_CORRELATION.getMessageDefinition(this.connectorName, egeriaTypeName, egeriaGUID, atlasEntity.getGuid(), atlasEntity.getTypeName()));
            throw new PropertyServerException(AtlasIntegrationErrorCode.MISSING_CORRELATION.getMessageDefinition(this.connectorName, egeriaTypeName, egeriaGUID, atlasEntity.getGuid(), atlasEntity.getTypeName()), this.getClass().getName(), "egeriaUpdateRequired");
        }
        if (atlasEntity.getUpdateTime() == null) {
            this.myContext.confirmSynchronization(egeriaGUID, egeriaTypeName, atlasEntity.getGuid());
        } else {
            if (metadataCorrelationHeader.getLastSynchronized() == null || atlasEntity.getUpdateTime().after(metadataCorrelationHeader.getLastSynchronized())) {
                ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
                this.myContext.updateExternalIdentifier(egeriaGUID, egeriaTypeName, externalIdentifierProperties);
                return true;
            }
            this.myContext.confirmSynchronization(egeriaGUID, egeriaTypeName, atlasEntity.getGuid());
        }
        return false;
    }

    protected boolean atlasUpdateRequired(String egeriaGUID, String egeriaTypeName, CorrelatedMetadataElement egeriaMetadataElement, AtlasEntity atlasEntity) throws InvalidParameterException, PropertyServerException {
        String methodName = "atlasUpdateRequired";
        MetadataCorrelationHeader metadataCorrelationHeader = this.myContext.getMetadataCorrelationHeader(egeriaMetadataElement);
        if (metadataCorrelationHeader == null) {
            this.auditLog.logMessage("atlasUpdateRequired", AtlasIntegrationAuditCode.MISSING_CORRELATION.getMessageDefinition(this.connectorName, egeriaTypeName, egeriaGUID, atlasEntity.getGuid(), atlasEntity.getTypeName()));
            throw new PropertyServerException(AtlasIntegrationErrorCode.MISSING_CORRELATION.getMessageDefinition(this.connectorName, egeriaTypeName, egeriaGUID, atlasEntity.getGuid(), atlasEntity.getTypeName()), this.getClass().getName(), "atlasUpdateRequired");
        }
        return egeriaMetadataElement.getElementHeader().getVersions().getUpdateTime() != null && (metadataCorrelationHeader.getLastSynchronized() == null || egeriaMetadataElement.getElementHeader().getVersions().getUpdateTime().after(metadataCorrelationHeader.getLastSynchronized()));
    }

    protected void updateExternalIdentifierAfterAtlasUpdate(String egeriaGUID, String egeriaTypeName, AtlasEntity atlasEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
        this.myContext.updateExternalIdentifier(egeriaGUID, egeriaTypeName, externalIdentifierProperties);
    }

    protected String getEgeriaGUID(AtlasEntityWithExtInfo atlasEntity) throws PropertyServerException {
        AtlasEntityWithExtInfo openMetadataCorrelationEntity;
        if (atlasEntity != null && (openMetadataCorrelationEntity = this.atlasClient.getRelatedEntity(atlasEntity, openMetadataCorrelationPropertyName)) != null && openMetadataCorrelationEntity.getEntity() != null && openMetadataCorrelationEntity.getEntity().getAttributes() != null) {
            return this.getAtlasStringProperty(openMetadataCorrelationEntity.getEntity().getAttributes(), egeriaGUIDPropertyName);
        }
        return null;
    }

    protected void removeEgeriaGUID(AtlasEntityWithExtInfo atlasEntity) throws PropertyServerException {
        AtlasEntityWithExtInfo openMetadataCorrelationEntity;
        if (atlasEntity != null && (openMetadataCorrelationEntity = this.atlasClient.getRelatedEntity(atlasEntity, openMetadataCorrelationPropertyName)) != null && openMetadataCorrelationEntity.getEntity() != null) {
            this.atlasClient.deleteEntity(openMetadataCorrelationEntity.getEntity().getGuid());
        }
    }

    protected ExternalIdentifierProperties getExternalIdentifier(String atlasGUID, String atlasTypeName, String externalInstanceCreatedBy, Date externalInstanceCreationTime, String externalInstanceLastUpdatedBy, Date externalInstanceLastUpdateTime, long externalInstanceVersion, PermittedSynchronization permittedSynchronization) {
        return this.getExternalIdentifier(atlasGUID, atlasTypeName, null, null, externalInstanceCreatedBy, externalInstanceCreationTime, externalInstanceLastUpdatedBy, externalInstanceLastUpdateTime, externalInstanceVersion, permittedSynchronization);
    }

    protected ExternalIdentifierProperties getExternalIdentifier(String atlasGUID, String atlasTypeName, String atlasName, String lastKnownEgeriaDisplayName, String externalInstanceCreatedBy, Date externalInstanceCreationTime, String externalInstanceLastUpdatedBy, Date externalInstanceLastUpdateTime, long externalInstanceVersion, PermittedSynchronization permittedSynchronization) {
        ExternalIdentifierProperties externalIdentifierProperties = new ExternalIdentifierProperties();
        externalIdentifierProperties.setExternalIdentifier(atlasGUID);
        externalIdentifierProperties.setExternalIdentifierName(atlasGUIDPropertyName);
        externalIdentifierProperties.setKeyPattern(KeyPattern.LOCAL_KEY);
        externalIdentifierProperties.setExternalIdentifierSource(this.connectorName);
        externalIdentifierProperties.setExternalInstanceCreatedBy(externalInstanceCreatedBy);
        externalIdentifierProperties.setExternalInstanceCreationTime(externalInstanceCreationTime);
        externalIdentifierProperties.setExternalInstanceLastUpdatedBy(externalInstanceLastUpdatedBy);
        externalIdentifierProperties.setExternalInstanceLastUpdateTime(externalInstanceLastUpdateTime);
        externalIdentifierProperties.setExternalInstanceVersion(externalInstanceVersion);
        externalIdentifierProperties.setSynchronizationDirection(permittedSynchronization);
        HashMap<String, Object> mappingProperties = new HashMap<String, Object>();
        mappingProperties.put(modulePropertyName, this.connectorName + ":" + this.moduleName);
        if (atlasTypeName != null) {
            mappingProperties.put(atlasTypeMappingPropertyName, atlasTypeName);
        }
        if (atlasName != null) {
            mappingProperties.put(atlasNameMappingPropertyName, atlasName);
        }
        if (lastKnownEgeriaDisplayName != null) {
            mappingProperties.put(egeriaNameMappingPropertyName, lastKnownEgeriaDisplayName);
        }
        externalIdentifierProperties.setMappingProperties(mappingProperties);
        return externalIdentifierProperties;
    }

    protected void ensureAtlasExternalIdentifier(CorrelatedMetadataElement egeriaElement, String egeriaDisplayName, AtlasEntity atlasEntity, String atlasGUID, String atlasTypeName, String atlasName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        MetadataCorrelationHeader metadataCorrelationHeader = this.myContext.getMetadataCorrelationHeader(egeriaElement);
        if (metadataCorrelationHeader != null) {
            if (atlasGUID.equals(metadataCorrelationHeader.getExternalIdentifier())) {
                this.egeriaUpdateRequired(egeriaElement.getElementHeader().getGUID(), egeriaElement.getElementHeader().getType().getTypeName(), egeriaElement, atlasEntity);
                return;
            }
            this.myContext.removeExternalIdentifier(egeriaElement.getElementHeader().getGUID(), egeriaElement.getElementHeader().getType().getTypeName(), metadataCorrelationHeader.getExternalIdentifier());
        }
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGUID, atlasTypeName, atlasName, egeriaDisplayName, atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.TO_THIRD_PARTY);
        this.myContext.addExternalIdentifier(egeriaElement.getElementHeader().getGUID(), egeriaElement.getElementHeader().getType().getTypeName(), externalIdentifierProperties);
    }

    protected List<String> getValidAtlasGUIDs(List<AtlasEntityWithExtInfo> atlasEntities) {
        ArrayList<String> validAtlasGUIDs = new ArrayList<String>();
        if (atlasEntities != null) {
            for (AtlasEntityWithExtInfo atlasEntityWithExtInfo : atlasEntities) {
                AtlasEntity atlasEntity;
                if (atlasEntityWithExtInfo == null || (atlasEntity = atlasEntityWithExtInfo.getEntity()) == null) continue;
                validAtlasGUIDs.add(atlasEntity.getGuid());
            }
        }
        return validAtlasGUIDs;
    }

    protected String getAtlasStringProperty(Map<String, Object> attributes, String propertyName) {
        if (attributes != null && attributes.get(propertyName) != null) {
            return attributes.get(propertyName).toString();
        }
        return null;
    }

    protected boolean getAtlasBooleanProperty(Map<String, Object> attributes, String propertyName) {
        return attributes != null && attributes.get(propertyName) != null && attributes.get(propertyName).toString() == "true";
    }

    protected Map<String, String> getAtlasPropertyMap(Map<String, Object> attributes, String propertyName) {
        Object object;
        if (attributes != null && (object = attributes.get(propertyName)) instanceof Map) {
            Map propertyObjectMap = (Map)object;
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (Object propertyMapKey : propertyObjectMap.keySet()) {
                String propertyValue;
                if (propertyMapKey == null || (propertyValue = propertyObjectMap.get(propertyMapKey).toString()) == null) continue;
                propertyMap.put(propertyMapKey.toString(), propertyValue);
            }
            return propertyMap;
        }
        return null;
    }

    protected List<String> getAtlasStringArray(Map<String, Object> attributes, String propertyName) {
        Object object;
        if (attributes != null && (object = attributes.get(propertyName)) instanceof Map) {
            Map propertyObjectMap = (Map)object;
            ArrayList<String> propertyList = new ArrayList<String>();
            for (Object propertyMapKey : propertyObjectMap.keySet()) {
                String propertyValue;
                if (propertyMapKey == null || (propertyValue = propertyObjectMap.get(propertyMapKey).toString()) == null) continue;
                propertyList.add(propertyValue);
            }
            return propertyList;
        }
        return null;
    }

    protected Map<String, String> addRemainingPropertiesToAdditionalProperties(Map<String, Object> atlasAttributes, List<String> skipPropertyNames) {
        if (atlasAttributes != null) {
            HashMap<String, String> egeriaAdditionalProperties = new HashMap<String, String>();
            for (String propertyName : atlasAttributes.keySet()) {
                Object propertyValue;
                if (skipPropertyNames.contains(propertyName) || (propertyValue = atlasAttributes.get(propertyName)) == null) continue;
                egeriaAdditionalProperties.put(propertyName, propertyValue.toString());
            }
            if (!egeriaAdditionalProperties.isEmpty()) {
                return egeriaAdditionalProperties;
            }
        }
        return null;
    }

    protected void addStringArrayToAdditionalProperties(Map<String, Object> atlasAttributes, String propertyName, Map<String, String> egeriaAdditionalProperties) {
        List<String> atlasPropertyList = this.getAtlasStringArray(atlasAttributes, propertyName);
        if (atlasPropertyList != null && !atlasPropertyList.isEmpty()) {
            int index = 0;
            for (String propertyValue : atlasPropertyList) {
                if (propertyValue == null) continue;
                egeriaAdditionalProperties.put(propertyName + "." + index, propertyValue);
                ++index;
            }
        }
    }

    protected void addPropertyMapToAdditionalProperties(Map<String, Object> atlasAttributes, String propertyName, Map<String, String> egeriaAdditionalProperties) {
        Map<String, String> atlasPropertyMap = this.getAtlasPropertyMap(atlasAttributes, propertyName);
        if (atlasPropertyMap != null && !atlasPropertyMap.isEmpty()) {
            for (String propertyKey : atlasPropertyMap.keySet()) {
                String propertyValue = atlasPropertyMap.get(propertyKey);
                if (propertyValue == null) continue;
                egeriaAdditionalProperties.put(propertyName + "." + propertyKey, propertyValue);
            }
        }
    }

    protected void syncAtlasDataSetsAsDataSets(String atlasTypeName, String egeriaTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        int startFrom = 0;
        int pageSize = this.myContext.getMaxPageSize();
        List<AtlasEntityHeader> atlasSearchResult = this.atlasClient.getEntitiesForType(atlasTypeName, startFrom, pageSize);
        while (atlasSearchResult != null && !atlasSearchResult.isEmpty()) {
            for (AtlasEntityHeader atlasEntityHeader : atlasSearchResult) {
                String atlasDataSetGUID = atlasEntityHeader.getGuid();
                AtlasEntityWithExtInfo atlasDataSetEntity = this.atlasClient.getEntityByGUID(atlasDataSetGUID);
                this.syncAtlasDataSetAsDataSet(atlasDataSetEntity, atlasTypeName, egeriaTypeName);
            }
            atlasSearchResult = this.atlasClient.getEntitiesForType(atlasTypeName, startFrom += pageSize, pageSize);
        }
    }

    protected String syncAtlasDataSetAsDataSet(AtlasEntityWithExtInfo atlasDataSetEntity, String atlasTypeName, String egeriaTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "syncAtlasDataSetAsDataSet";
        if (atlasDataSetEntity != null && atlasDataSetEntity.getEntity() != null) {
            String egeriaDataSetGUID = this.getEgeriaGUID(atlasDataSetEntity);
            if (egeriaDataSetGUID == null) {
                egeriaDataSetGUID = this.createAtlasDataSetAsDataSetInEgeria(atlasDataSetEntity, atlasTypeName, egeriaTypeName);
            } else {
                try {
                    this.dataAssetExchangeService.getDataAssetByGUID(egeriaDataSetGUID, null);
                    this.updateAtlasDataSetAsDataSetInEgeria(atlasDataSetEntity, egeriaDataSetGUID, atlasTypeName, egeriaTypeName);
                }
                catch (InvalidParameterException notKnown) {
                    this.auditLog.logMessage("syncAtlasDataSetAsDataSet", AtlasIntegrationAuditCode.REPLACING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaTypeName, egeriaDataSetGUID, atlasDataSetEntity.getEntity().getGuid()));
                    this.removeEgeriaGUID(atlasDataSetEntity);
                    egeriaDataSetGUID = this.createAtlasDataSetAsDataSetInEgeria(atlasDataSetEntity, atlasTypeName, egeriaTypeName);
                }
            }
            return egeriaDataSetGUID;
        }
        return null;
    }

    protected String createAtlasDataSetAsDataSetInEgeria(AtlasEntityWithExtInfo atlasDataSetEntity, String atlasTypeName, String egeriaTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasDataSetAsDataSetInEgeria";
        if (atlasDataSetEntity != null && (atlasEntity = atlasDataSetEntity.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            DataAssetProperties dataAssetProperties = this.getEgeriaDataSetProperties(atlasEntity, egeriaTypeName);
            String egeriaDataSetGUID = this.dataAssetExchangeService.createDataAsset(true, externalIdentifierProperties, dataAssetProperties);
            this.auditLog.logMessage("createAtlasDataSetAsDataSetInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasTypeName, egeriaDataSetGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaDataSetGUID, dataAssetProperties.getQualifiedName(), egeriaTypeName, false, false);
            this.setOwner(atlasDataSetEntity, egeriaDataSetGUID);
            return egeriaDataSetGUID;
        }
        return null;
    }

    protected void updateAtlasDataSetAsDataSetInEgeria(AtlasEntityWithExtInfo atlasDataSetEntity, String egeriaDataSetGUID, String atlasTypeName, String egeriaTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAtlasDataSetAsDataSetInEgeria";
        if (atlasDataSetEntity != null) {
            AtlasEntity atlasEntity = atlasDataSetEntity.getEntity();
            DataAssetElement dataAssetElement = this.dataAssetExchangeService.getDataAssetByGUID(egeriaDataSetGUID, null);
            if (atlasEntity != null && this.egeriaUpdateRequired(egeriaDataSetGUID, egeriaTypeName, (CorrelatedMetadataElement)dataAssetElement, atlasEntity)) {
                DataAssetProperties dataAssetProperties = this.getEgeriaDataSetProperties(atlasEntity, egeriaTypeName);
                this.auditLog.logMessage("updateAtlasDataSetAsDataSetInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), atlasTypeName, egeriaDataSetGUID));
                this.dataAssetExchangeService.updateDataAsset(egeriaDataSetGUID, atlasEntity.getGuid(), false, dataAssetProperties, null);
            }
        }
    }

    protected DataAssetProperties getEgeriaDataSetProperties(AtlasEntity atlasEntity, String egeriaTypeName) {
        DataAssetProperties dataAssetProperties = this.getDataAssetProperties(atlasEntity, egeriaTypeName);
        dataAssetProperties.setAdditionalProperties(this.addRemainingPropertiesToAdditionalProperties(atlasEntity.getAttributes(), atlasAssetProperties));
        return dataAssetProperties;
    }

    protected DataAssetProperties getDataAssetProperties(AtlasEntity atlasEntity, String egeriaTypeName) {
        if (atlasEntity != null) {
            DataAssetProperties dataAssetProperties = new DataAssetProperties();
            Map<String, Object> attributes = atlasEntity.getAttributes();
            dataAssetProperties.setTypeName(egeriaTypeName);
            dataAssetProperties.setDeployedImplementationType(atlasEntity.getTypeName());
            dataAssetProperties.setQualifiedName(this.myContext.getMetadataSourceQualifiedName() + ":" + atlasEntity.getTypeName() + ":" + this.getAtlasStringProperty(attributes, atlasQualifiedNamePropertyName));
            dataAssetProperties.setName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
            dataAssetProperties.setResourceName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
            dataAssetProperties.setResourceDescription(this.getAtlasStringProperty(attributes, atlasDescriptionPropertyName));
            dataAssetProperties.setDisplayName(this.getAtlasStringProperty(attributes, atlasDisplayNamePropertyName));
            dataAssetProperties.setDisplayDescription(this.getAtlasStringProperty(attributes, atlasUserDescriptionPropertyName));
            return dataAssetProperties;
        }
        return null;
    }

    protected DataAssetProperties getEgeriaDataFileProperties(AtlasEntity atlasFSPathEntity, String egeriaTypeName) {
        String pathNamePropertyName = atlasPathPropertyName;
        DataStoreProperties dataAssetProperties = new DataStoreProperties();
        Map<String, Object> attributes = atlasFSPathEntity.getAttributes();
        dataAssetProperties.setTypeName(egeriaTypeName);
        dataAssetProperties.setDeployedImplementationType(atlasFSPathEntity.getTypeName());
        dataAssetProperties.setQualifiedName(this.myContext.getMetadataSourceQualifiedName() + ":" + atlasFSPathEntity.getTypeName() + ":" + this.getAtlasStringProperty(attributes, atlasQualifiedNamePropertyName));
        dataAssetProperties.setName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
        dataAssetProperties.setResourceName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
        dataAssetProperties.setResourceDescription(this.getAtlasStringProperty(attributes, atlasDescriptionPropertyName));
        dataAssetProperties.setDisplayName(this.getAtlasStringProperty(attributes, atlasDisplayNamePropertyName));
        dataAssetProperties.setDisplayDescription(this.getAtlasStringProperty(attributes, atlasUserDescriptionPropertyName));
        Map<String, String> additionalProperties = this.addRemainingPropertiesToAdditionalProperties(atlasFSPathEntity.getAttributes(), atlasDataFileProperties);
        dataAssetProperties.setAdditionalProperties(additionalProperties);
        return dataAssetProperties;
    }

    protected ProcessProperties getProcessProperties(AtlasEntity atlasEntity, String egeriaTypeName) {
        if (atlasEntity != null) {
            ProcessProperties processProperties = new ProcessProperties();
            Map<String, Object> attributes = atlasEntity.getAttributes();
            processProperties.setTypeName(egeriaTypeName);
            processProperties.setDeployedImplementationType(atlasEntity.getTypeName());
            processProperties.setQualifiedName(this.myContext.getMetadataSourceQualifiedName() + ":" + atlasEntity.getTypeName() + ":" + this.getAtlasStringProperty(attributes, atlasQualifiedNamePropertyName));
            processProperties.setName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
            processProperties.setResourceName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
            processProperties.setResourceDescription(this.getAtlasStringProperty(attributes, atlasDescriptionPropertyName));
            processProperties.setDisplayName(this.getAtlasStringProperty(attributes, atlasDisplayNamePropertyName));
            processProperties.setDisplayDescription(this.getAtlasStringProperty(attributes, atlasUserDescriptionPropertyName));
            return processProperties;
        }
        return null;
    }

    protected SchemaAttributeProperties getSchemaAttributeProperties(AtlasEntity atlasEntity, String egeriaSchemaAttributeTypeName, String egeriaSchemaTypeTypeName) {
        if (atlasEntity != null) {
            SchemaAttributeProperties schemaAttributeProperties = new SchemaAttributeProperties();
            SchemaTypeProperties schemaTypeProperties = new SchemaTypeProperties();
            Map<String, Object> attributes = atlasEntity.getAttributes();
            schemaAttributeProperties.setTypeName(egeriaSchemaAttributeTypeName);
            schemaAttributeProperties.setQualifiedName(this.myContext.getMetadataSourceQualifiedName() + ":" + atlasEntity.getTypeName() + ":" + this.getAtlasStringProperty(attributes, atlasQualifiedNamePropertyName));
            schemaAttributeProperties.setDisplayName(this.getAtlasStringProperty(attributes, atlasNamePropertyName));
            schemaAttributeProperties.setDescription(this.getAtlasStringProperty(attributes, atlasDescriptionPropertyName));
            schemaTypeProperties.setTypeName(egeriaSchemaTypeTypeName);
            schemaTypeProperties.setDisplayName(this.getAtlasStringProperty(attributes, atlasDisplayNamePropertyName));
            schemaTypeProperties.setDescription(this.getAtlasStringProperty(attributes, atlasUserDescriptionPropertyName));
            schemaAttributeProperties.setSchemaType(schemaTypeProperties);
            return schemaAttributeProperties;
        }
        return null;
    }

    protected void setOwner(AtlasEntityWithExtInfo atlasEntityWithExtInfo, String egeriaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String owner;
        if (atlasEntityWithExtInfo != null && atlasEntityWithExtInfo.getEntity() != null && atlasEntityWithExtInfo.getEntity().getAttributes() != null && (owner = this.getAtlasStringProperty(atlasEntityWithExtInfo.getEntity().getAttributes(), atlasOwnerPropertyName)) != null) {
            OwnerProperties properties = new OwnerProperties();
            properties.setOwner(owner);
            properties.setOwnerTypeName(egeriaOwnerTypeName);
            properties.setOwnerPropertyName(egeriaOwnerPropertyName);
            this.stewardshipExchangeService.addOwnership(egeriaGUID, atlasEntityWithExtInfo.getEntity().getGuid(), properties, null);
        }
    }
}

