/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasRegisteredIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataAssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public abstract class DatabaseIntegrationModuleBase
extends AtlasRegisteredIntegrationModuleBase {
    protected static final String egeriaDatabaseTypeName = "DeployedDatabaseSchema";
    protected static final String egeriaRootDatabaseSchemaTypeTypeName = "RelationalDBSchemaType";
    protected static final String egeriaDatabaseTableTypeName = "RelationalTable";
    protected static final String egeriaDatabaseTableTypeTypeName = "RelationalTableType";
    protected static final String egeriaDatabaseColumnTypeName = "RelationalColumn";
    protected static final String egeriaDatabaseColumnTypeTypeName = "PrimitiveSchemaType";
    private final String atlasDatabaseTypeName;
    private final String atlasDatabaseTablesPropertyName;
    private final String atlasDatabaseTableTypeName;
    private final String atlasDatabaseColumnsPropertyName;

    public DatabaseIntegrationModuleBase(String connectorName, String moduleName, String atlasDatabaseTypeName, String atlasDatabaseTablesPropertyName, String atlasDatabaseTableTypeName, String atlasDatabaseColumnsPropertyName, String atlasDatabaseColumnTypeName, ConnectionProperties connectionProperties, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        super(connectorName, moduleName, connectionProperties, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors, new String[]{atlasDatabaseTypeName, atlasDatabaseTableTypeName, atlasDatabaseColumnTypeName}, null);
        this.atlasDatabaseTypeName = atlasDatabaseTypeName;
        this.atlasDatabaseTablesPropertyName = atlasDatabaseTablesPropertyName;
        this.atlasDatabaseTableTypeName = atlasDatabaseTableTypeName;
        this.atlasDatabaseColumnsPropertyName = atlasDatabaseColumnsPropertyName;
    }

    @Override
    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh(" + this.moduleName + ")";
        if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                int startFrom = 0;
                int pageSize = this.myContext.getMaxPageSize();
                List<AtlasEntityHeader> atlasSearchResult = this.atlasClient.getEntitiesForType(this.atlasDatabaseTypeName, startFrom, pageSize);
                while (atlasSearchResult != null && !atlasSearchResult.isEmpty()) {
                    for (AtlasEntityHeader atlasEntityHeader : atlasSearchResult) {
                        List<AtlasEntityWithExtInfo> atlasDatabaseTables;
                        String atlasDatabaseGUID = atlasEntityHeader.getGuid();
                        AtlasEntityWithExtInfo atlasDatabaseEntity = this.atlasClient.getEntityByGUID(atlasDatabaseGUID);
                        String egeriaDatabaseGUID = this.syncAtlasDatabase(atlasDatabaseEntity);
                        if (egeriaDatabaseGUID == null || atlasDatabaseEntity == null || atlasDatabaseEntity.getEntity() == null || atlasDatabaseEntity.getEntity().getRelationshipAttributes() == null || atlasDatabaseEntity.getEntity().getRelationshipAttributes().get(this.atlasDatabaseTablesPropertyName) == null || (atlasDatabaseTables = this.atlasClient.getRelatedEntities(atlasDatabaseEntity, this.atlasDatabaseTablesPropertyName)) == null) continue;
                        for (AtlasEntityWithExtInfo atlasDatabaseTable : atlasDatabaseTables) {
                            List<AtlasEntityWithExtInfo> atlasDatabaseColumns;
                            String egeriaDatabaseTableGUID;
                            if (atlasDatabaseTable == null || atlasDatabaseTable.getEntity() == null || (egeriaDatabaseTableGUID = this.syncAtlasDatabaseTable(atlasDatabaseTable, egeriaDatabaseGUID)) == null || atlasDatabaseTable.getEntity().getRelationshipAttributes() == null || atlasDatabaseTable.getEntity().getRelationshipAttributes().get(this.atlasDatabaseColumnsPropertyName) == null || (atlasDatabaseColumns = this.atlasClient.getRelatedEntities(atlasDatabaseTable, this.atlasDatabaseColumnsPropertyName)) == null) continue;
                            for (AtlasEntityWithExtInfo atlasDatabaseColumn : atlasDatabaseColumns) {
                                if (atlasDatabaseColumn == null || atlasDatabaseTable.getEntity() == null) continue;
                                this.syncAtlasDatabaseColumn(atlasDatabaseColumn, egeriaDatabaseTableGUID);
                            }
                            this.checkForAdditionalEgeriaColumns(egeriaDatabaseTableGUID, atlasDatabaseColumns);
                        }
                        this.checkForAdditionalEgeriaTables(egeriaDatabaseGUID, atlasDatabaseTables);
                    }
                    atlasSearchResult = this.atlasClient.getEntitiesForType(this.atlasDatabaseTableTypeName, startFrom += pageSize, pageSize);
                }
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException(methodName, AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
            }
        }
    }

    @Override
    public void processEvent(AssetManagerOutTopicEvent event) {
    }

    protected String getEgeriaDatabaseSchemaType(String egeriaDatabaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SchemaTypeElement databaseSchemaType = this.dataAssetExchangeService.getSchemaTypeForElement(egeriaDatabaseGUID, egeriaDatabaseTypeName, null);
        if (databaseSchemaType != null) {
            return databaseSchemaType.getElementHeader().getGUID();
        }
        SchemaTypeProperties schemaTypeProperties = new SchemaTypeProperties();
        schemaTypeProperties.setTypeName(egeriaRootDatabaseSchemaTypeTypeName);
        schemaTypeProperties.setQualifiedName("RelationalDBSchemaType for " + egeriaDatabaseGUID);
        String databaseSchemaTypeGUID = this.dataAssetExchangeService.createAnchoredSchemaType(true, egeriaDatabaseGUID, null, schemaTypeProperties);
        if (databaseSchemaTypeGUID != null) {
            this.dataAssetExchangeService.setupSchemaTypeParent(true, databaseSchemaTypeGUID, egeriaDatabaseGUID, egeriaDatabaseTypeName, null, null);
        }
        return databaseSchemaTypeGUID;
    }

    private String syncAtlasDatabase(AtlasEntityWithExtInfo atlasDatabaseEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "syncAtlasDatabase";
        if (atlasDatabaseEntity != null && atlasDatabaseEntity.getEntity() != null) {
            String egeriaDatabaseGUID = super.getEgeriaGUID(atlasDatabaseEntity);
            if (egeriaDatabaseGUID == null) {
                egeriaDatabaseGUID = this.createAtlasDatabaseInEgeria(atlasDatabaseEntity);
            } else {
                try {
                    this.dataAssetExchangeService.getDataAssetByGUID(egeriaDatabaseGUID, null);
                    this.updateAtlasDatabaseInEgeria(atlasDatabaseEntity, egeriaDatabaseGUID);
                }
                catch (InvalidParameterException notKnown) {
                    this.auditLog.logMessage("syncAtlasDatabase", AtlasIntegrationAuditCode.REPLACING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseTypeName, egeriaDatabaseGUID, atlasDatabaseEntity.getEntity().getGuid()));
                    this.removeEgeriaGUID(atlasDatabaseEntity);
                    egeriaDatabaseGUID = this.createAtlasDatabaseInEgeria(atlasDatabaseEntity);
                }
            }
            this.augmentAtlasDatabaseInEgeria(atlasDatabaseEntity, egeriaDatabaseGUID);
            return egeriaDatabaseGUID;
        }
        return null;
    }

    protected String createAtlasDatabaseInEgeria(AtlasEntityWithExtInfo atlasDatabaseEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasDatabaseInEgeria";
        if (atlasDatabaseEntity != null && (atlasEntity = atlasDatabaseEntity.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = super.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            DataAssetProperties dataAssetProperties = this.getEgeriaDatabaseProperties(atlasEntity, egeriaDatabaseTypeName);
            String egeriaDatabaseGUID = this.dataAssetExchangeService.createDataAsset(true, externalIdentifierProperties, dataAssetProperties);
            this.auditLog.logMessage("createAtlasDatabaseInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseTypeName, egeriaDatabaseGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaDatabaseGUID, dataAssetProperties.getQualifiedName(), egeriaDatabaseTypeName, false, false);
            this.setOwner(atlasDatabaseEntity, egeriaDatabaseGUID);
            return egeriaDatabaseGUID;
        }
        return null;
    }

    protected void updateAtlasDatabaseInEgeria(AtlasEntityWithExtInfo atlasDatabaseEntity, String egeriaDatabaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAtlasDatabaseInEgeria";
        if (atlasDatabaseEntity != null) {
            AtlasEntity atlasEntity = atlasDatabaseEntity.getEntity();
            DataAssetElement dataAssetElement = this.dataAssetExchangeService.getDataAssetByGUID(egeriaDatabaseGUID, null);
            if (atlasEntity != null && this.egeriaUpdateRequired(egeriaDatabaseGUID, egeriaDatabaseTypeName, (CorrelatedMetadataElement)dataAssetElement, atlasEntity)) {
                DataAssetProperties dataAssetProperties = this.getEgeriaDatabaseProperties(atlasEntity, egeriaDatabaseTypeName);
                this.auditLog.logMessage("updateAtlasDatabaseInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaDatabaseTypeName, egeriaDatabaseGUID));
                this.dataAssetExchangeService.updateDataAsset(egeriaDatabaseGUID, atlasEntity.getGuid(), false, dataAssetProperties, null);
            }
        }
    }

    protected void augmentAtlasDatabaseInEgeria(AtlasEntityWithExtInfo atlasDatabaseEntity, String egeriaDatabaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    private String syncAtlasDatabaseTable(AtlasEntityWithExtInfo atlasDatabaseTableEntity, String egeriaDatabaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "syncAtlasDatabaseTable";
        if (atlasDatabaseTableEntity != null && atlasDatabaseTableEntity.getEntity() != null) {
            String egeriaDatabaseTableGUID = super.getEgeriaGUID(atlasDatabaseTableEntity);
            if (egeriaDatabaseTableGUID == null) {
                egeriaDatabaseTableGUID = this.createAtlasDatabaseTableInEgeria(atlasDatabaseTableEntity, egeriaDatabaseGUID);
            } else {
                try {
                    this.dataAssetExchangeService.getDataAssetByGUID(egeriaDatabaseTableGUID, null);
                    this.updateAtlasDatabaseTableInEgeria(atlasDatabaseTableEntity, egeriaDatabaseTableGUID);
                }
                catch (InvalidParameterException notKnown) {
                    this.auditLog.logMessage("syncAtlasDatabaseTable", AtlasIntegrationAuditCode.REPLACING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseTableTypeName, egeriaDatabaseTableGUID, atlasDatabaseTableEntity.getEntity().getGuid()));
                    this.removeEgeriaGUID(atlasDatabaseTableEntity);
                    egeriaDatabaseTableGUID = this.createAtlasDatabaseTableInEgeria(atlasDatabaseTableEntity, egeriaDatabaseGUID);
                }
            }
            this.augmentAtlasDatabaseTableInEgeria(atlasDatabaseTableEntity, egeriaDatabaseTableGUID);
            return egeriaDatabaseTableGUID;
        }
        return null;
    }

    protected String createAtlasDatabaseTableInEgeria(AtlasEntityWithExtInfo atlasDatabaseTableEntity, String egeriaDatabaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String egeriaDatabaseSchemaTypeGUID;
        AtlasEntity atlasEntity;
        String methodName = "createAtlasDatabaseTableInEgeria";
        if (atlasDatabaseTableEntity != null && (atlasEntity = atlasDatabaseTableEntity.getEntity()) != null && (egeriaDatabaseSchemaTypeGUID = this.getEgeriaDatabaseSchemaType(egeriaDatabaseGUID)) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            SchemaAttributeProperties schemaAttributeProperties = this.getEgeriaDatabaseTableProperties(atlasEntity, egeriaDatabaseTableTypeName, egeriaDatabaseTableTypeTypeName);
            String egeriaDatabaseTableGUID = this.dataAssetExchangeService.createSchemaAttribute(true, egeriaDatabaseSchemaTypeGUID, externalIdentifierProperties, schemaAttributeProperties, null);
            this.auditLog.logMessage("createAtlasDatabaseTableInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseTableTypeName, egeriaDatabaseTableGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaDatabaseGUID, schemaAttributeProperties.getQualifiedName(), egeriaDatabaseTableTypeName, false, false);
            this.setOwner(atlasDatabaseTableEntity, egeriaDatabaseTableGUID);
            return egeriaDatabaseTableGUID;
        }
        return null;
    }

    protected void updateAtlasDatabaseTableInEgeria(AtlasEntityWithExtInfo atlasDatabaseTableEntity, String egeriaDatabaseTableGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAtlasDatabaseTableInEgeria";
        if (atlasDatabaseTableEntity != null) {
            AtlasEntity atlasEntity = atlasDatabaseTableEntity.getEntity();
            DataAssetElement dataAssetElement = this.dataAssetExchangeService.getDataAssetByGUID(egeriaDatabaseTableGUID, null);
            if (atlasEntity != null && this.egeriaUpdateRequired(egeriaDatabaseTableGUID, egeriaDatabaseTableTypeName, (CorrelatedMetadataElement)dataAssetElement, atlasEntity)) {
                SchemaAttributeProperties databaseTableProperties = this.getEgeriaDatabaseTableProperties(atlasEntity, egeriaDatabaseTableTypeName, egeriaDatabaseTableTypeTypeName);
                this.auditLog.logMessage("updateAtlasDatabaseTableInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaDatabaseTableTypeName, egeriaDatabaseTableGUID));
                this.dataAssetExchangeService.updateSchemaAttribute(egeriaDatabaseTableGUID, atlasEntity.getGuid(), false, databaseTableProperties, null);
            }
        }
    }

    protected void augmentAtlasDatabaseTableInEgeria(AtlasEntityWithExtInfo atlasDatabaseTableEntity, String egeriaDatabaseTableGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    private void checkForAdditionalEgeriaTables(String egeriaDatabaseGUID, List<AtlasEntityWithExtInfo> atlasDatabaseTables) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String egeriaDatabaseSchemaTypeGUID;
        String methodName = "checkForAdditionalEgeriaTables";
        if (atlasDatabaseTables != null && !atlasDatabaseTables.isEmpty() && (egeriaDatabaseSchemaTypeGUID = this.getEgeriaDatabaseSchemaType(egeriaDatabaseGUID)) != null) {
            List<String> validAtlasGUIDs = this.getValidAtlasGUIDs(atlasDatabaseTables);
            int startFrom = 0;
            int pageSize = this.myContext.getMaxPageSize();
            List egeriaDatabaseTables = this.dataAssetExchangeService.getNestedAttributes(egeriaDatabaseSchemaTypeGUID, startFrom, pageSize, null);
            while (egeriaDatabaseTables != null) {
                for (SchemaAttributeElement egeriaDatabaseTable : egeriaDatabaseTables) {
                    String atlasDatabaseTableGUID = super.getAtlasGUID((CorrelatedMetadataElement)egeriaDatabaseTable);
                    if (validAtlasGUIDs.contains(atlasDatabaseTableGUID)) continue;
                    this.auditLog.logMessage("checkForAdditionalEgeriaTables", AtlasIntegrationAuditCode.DELETING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseTableTypeName, egeriaDatabaseTable.getElementHeader().getGUID(), atlasDatabaseTableGUID));
                    this.dataAssetExchangeService.removeDataAsset(egeriaDatabaseTable.getElementHeader().getGUID(), atlasDatabaseTableGUID, null);
                }
                egeriaDatabaseTables = this.dataAssetExchangeService.getNestedAttributes(egeriaDatabaseSchemaTypeGUID, startFrom += pageSize, pageSize, null);
            }
        }
    }

    private void syncAtlasDatabaseColumn(AtlasEntityWithExtInfo atlasDatabaseColumnEntity, String egeriaDatabaseTableGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "syncAtlasDatabaseColumn";
        if (atlasDatabaseColumnEntity != null) {
            String egeriaDatabaseColumnGUID = super.getEgeriaGUID(atlasDatabaseColumnEntity);
            if (egeriaDatabaseColumnGUID == null) {
                egeriaDatabaseColumnGUID = this.createAtlasDatabaseColumnInEgeria(atlasDatabaseColumnEntity, egeriaDatabaseTableGUID);
            } else {
                try {
                    SchemaAttributeElement egeriaDatabaseColumn = this.dataAssetExchangeService.getSchemaAttributeByGUID(egeriaDatabaseColumnGUID, null);
                    this.updateAtlasDatabaseColumnInEgeria(atlasDatabaseColumnEntity, egeriaDatabaseColumnGUID, egeriaDatabaseColumn);
                }
                catch (InvalidParameterException notKnown) {
                    this.auditLog.logMessage("syncAtlasDatabaseColumn", AtlasIntegrationAuditCode.REPLACING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseColumnTypeName, egeriaDatabaseColumnGUID, atlasDatabaseColumnEntity.getEntity().getGuid()));
                    this.removeEgeriaGUID(atlasDatabaseColumnEntity);
                    egeriaDatabaseColumnGUID = this.createAtlasDatabaseColumnInEgeria(atlasDatabaseColumnEntity, egeriaDatabaseTableGUID);
                }
            }
            this.augmentAtlasDatabaseColumnInEgeria(atlasDatabaseColumnEntity, egeriaDatabaseColumnGUID);
        }
    }

    protected String createAtlasDatabaseColumnInEgeria(AtlasEntityWithExtInfo atlasDatabaseColumnEntity, String egeriaDatabaseTableGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasDatabaseColumnInEgeria";
        if (atlasDatabaseColumnEntity != null && egeriaDatabaseTableGUID != null && (atlasEntity = atlasDatabaseColumnEntity.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasEntity.getTypeName(), atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            SchemaAttributeProperties schemaAttributeProperties = this.getEgeriaDatabaseColumnProperties(atlasEntity, egeriaDatabaseColumnTypeName, egeriaDatabaseColumnTypeTypeName);
            String egeriaDatabaseColumnGUID = this.dataAssetExchangeService.createSchemaAttribute(true, egeriaDatabaseTableGUID, externalIdentifierProperties, schemaAttributeProperties, null);
            this.auditLog.logMessage("createAtlasDatabaseColumnInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseColumnTypeName, egeriaDatabaseColumnGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaDatabaseColumnGUID, schemaAttributeProperties.getQualifiedName(), egeriaDatabaseColumnTypeName, false, false);
            this.setOwner(atlasDatabaseColumnEntity, egeriaDatabaseColumnGUID);
            return egeriaDatabaseColumnGUID;
        }
        return null;
    }

    protected void updateAtlasDatabaseColumnInEgeria(AtlasEntityWithExtInfo atlasDatabaseColumnEntity, String egeriaDatabaseColumnGUID, SchemaAttributeElement egeriaDatabaseColumn) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AtlasEntity atlasEntity;
        String methodName = "updateAtlasDatabaseColumnInEgeria";
        if (atlasDatabaseColumnEntity != null && (atlasEntity = atlasDatabaseColumnEntity.getEntity()) != null && this.egeriaUpdateRequired(egeriaDatabaseColumnGUID, egeriaDatabaseColumnTypeName, (CorrelatedMetadataElement)egeriaDatabaseColumn, atlasEntity)) {
            SchemaAttributeProperties databaseColumnProperties = this.getEgeriaDatabaseColumnProperties(atlasEntity, egeriaDatabaseColumnTypeName, egeriaDatabaseColumnTypeTypeName);
            this.auditLog.logMessage("updateAtlasDatabaseColumnInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaDatabaseColumnTypeName, egeriaDatabaseColumnGUID));
            this.dataAssetExchangeService.updateSchemaAttribute(egeriaDatabaseColumnGUID, atlasEntity.getGuid(), false, databaseColumnProperties, null);
        }
    }

    protected void augmentAtlasDatabaseColumnInEgeria(AtlasEntityWithExtInfo atlasDatabaseColumnEntity, String egeriaDatabaseColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    private void checkForAdditionalEgeriaColumns(String egeriaDatabaseTableGUID, List<AtlasEntityWithExtInfo> atlasDatabaseColumns) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "checkForAdditionalEgeriaColumns";
        if (atlasDatabaseColumns != null && !atlasDatabaseColumns.isEmpty() && egeriaDatabaseTableGUID != null) {
            List<String> validAtlasGUIDs = this.getValidAtlasGUIDs(atlasDatabaseColumns);
            int startFrom = 0;
            int pageSize = this.myContext.getMaxPageSize();
            List egeriaDatabaseColumns = this.dataAssetExchangeService.getNestedAttributes(egeriaDatabaseTableGUID, startFrom, pageSize, null);
            while (egeriaDatabaseColumns != null) {
                for (SchemaAttributeElement egeriaDatabaseColumn : egeriaDatabaseColumns) {
                    String atlasDatabaseColumnGUID = super.getAtlasGUID((CorrelatedMetadataElement)egeriaDatabaseColumn);
                    if (validAtlasGUIDs.contains(atlasDatabaseColumnGUID)) continue;
                    this.auditLog.logMessage("checkForAdditionalEgeriaColumns", AtlasIntegrationAuditCode.DELETING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaDatabaseColumnTypeName, egeriaDatabaseColumn.getElementHeader().getGUID(), atlasDatabaseColumnGUID));
                    this.dataAssetExchangeService.removeDataAsset(egeriaDatabaseColumn.getElementHeader().getGUID(), atlasDatabaseColumnGUID, null);
                }
                egeriaDatabaseColumns = this.dataAssetExchangeService.getNestedAttributes(egeriaDatabaseTableGUID, startFrom += pageSize, pageSize, null);
            }
        }
    }

    protected abstract DataAssetProperties getEgeriaDatabaseProperties(AtlasEntity var1, String var2);

    protected abstract SchemaAttributeProperties getEgeriaDatabaseTableProperties(AtlasEntity var1, String var2, String var3);

    protected abstract SchemaAttributeProperties getEgeriaDatabaseColumnProperties(AtlasEntity var1, String var2, String var3);
}

