/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ffdc.ApacheAtlasAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ffdc.ApacheAtlasErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ffdc.NameConflictException;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasAttributeDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasBusinessMetadataDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasCardinality;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasClassificationDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasElementDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityMutationResponse;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityOperation;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEnumDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasGlossaryCategoryElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasGlossaryElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasGlossaryTermElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasInstanceStatus;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasMetrics;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasObjectId;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasPropagateTags;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationship;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipCategory;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipEndDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasSearchResult;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasStructDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasTypesDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasVersion;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.restclients.spring.SpringRESTClientConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataClassificationDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEntityDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEnumDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEnumElementDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipEndCardinality;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefAttribute;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefLink;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.springframework.core.ParameterizedTypeReference;

public class ApacheAtlasRESTConnector
extends ConnectorBase
implements AuditLoggingComponent {
    public static final String OPEN_METADATA_TYPE_PREFIX = "OpenMetadata";
    public static final String SERVICE_TYPE = "open_metadata_ecosystem";
    private AuditLog auditLog = null;
    private String atlasServerName = "Apache Atlas";
    private String targetRootURL = null;
    private String connectorName = "Apache Atlas REST Connector";
    private RESTClientConnector clientConnector = null;
    private Map<String, Long> atlasTypes = new HashMap<String, Long>();

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void start() throws ConnectorCheckedException {
        EndpointProperties endpoint;
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getUserId() == null || this.connectionProperties.getClearPassword() == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_USER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        if (this.connectionProperties.getConnectionName() != null) {
            this.connectorName = this.connectionProperties.getConnectionName();
        }
        if ((endpoint = this.connectionProperties.getEndpoint()) != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null && configurationProperties.get("atlasServerName") != null) {
            this.atlasServerName = configurationProperties.get("atlasServerName").toString();
        }
        try {
            RESTClientFactory factory = new RESTClientFactory(this.atlasServerName, this.targetRootURL, this.connectionProperties.getUserId(), this.connectionProperties.getClearPassword(), this.secretsStoreConnectorMap, this.auditLog);
            this.clientConnector = factory.getClientConnector();
            this.refreshAtlasTypesList();
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", ApacheAtlasAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, error.getClass().getName(), this.targetRootURL, "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    public AtlasVersion getAtlasVersion() throws PropertyServerException {
        String methodName = "getAtlasVersion()";
        String url = this.targetRootURL + "/api/atlas/admin/version";
        return this.callGetRESTCallNoParams("getAtlasVersion()", AtlasVersion.class, url);
    }

    public AtlasMetrics getAtlasMetrics() throws PropertyServerException {
        String methodName = "getAtlasMetrics()";
        String url = this.targetRootURL + "/api/atlas/admin/metrics";
        return this.callGetRESTCallNoParams("getAtlasMetrics()", AtlasMetrics.class, url);
    }

    private synchronized void refreshAtlasTypesList() throws PropertyServerException {
        this.atlasTypes = new HashMap<String, Long>();
        this.addTypeDefinitions(this.getAllTypes());
    }

    public synchronized TypeStatus isTypeDefinedInAtlas(String atlasTypeName, long version) {
        if (!this.atlasTypes.containsKey(atlasTypeName)) {
            return TypeStatus.ADD;
        }
        if (version > this.atlasTypes.get(atlasTypeName)) {
            return TypeStatus.UPDATE;
        }
        return TypeStatus.IGNORE;
    }

    public synchronized void addTypeDefinitions(AtlasTypesDef atlasTypesDef) {
        if (atlasTypesDef != null) {
            if (atlasTypesDef.getEnumDefs() != null) {
                for (AtlasEnumDef atlasEnumDef : atlasTypesDef.getEnumDefs()) {
                    this.atlasTypes.put(atlasEnumDef.getName(), atlasEnumDef.getVersion());
                }
            }
            if (atlasTypesDef.getStructDefs() != null) {
                for (AtlasStructDef atlasStructDef : atlasTypesDef.getStructDefs()) {
                    this.atlasTypes.put(atlasStructDef.getName(), atlasStructDef.getVersion());
                }
            }
            if (atlasTypesDef.getClassificationDefs() != null) {
                for (AtlasClassificationDef atlasClassificationDef : atlasTypesDef.getClassificationDefs()) {
                    this.atlasTypes.put(atlasClassificationDef.getName(), atlasClassificationDef.getVersion());
                }
            }
            if (atlasTypesDef.getEntityDefs() != null) {
                for (AtlasEntityDef atlasEntityDef : atlasTypesDef.getEntityDefs()) {
                    this.atlasTypes.put(atlasEntityDef.getName(), atlasEntityDef.getVersion());
                }
            }
            if (atlasTypesDef.getRelationshipDefs() != null) {
                for (AtlasRelationshipDef atlasRelationshipDef : atlasTypesDef.getRelationshipDefs()) {
                    this.atlasTypes.put(atlasRelationshipDef.getName(), atlasRelationshipDef.getVersion());
                }
            }
            if (atlasTypesDef.getBusinessMetadataDefs() != null) {
                for (AtlasBusinessMetadataDef atlasBusinessMetadataDef : atlasTypesDef.getBusinessMetadataDefs()) {
                    this.atlasTypes.put(atlasBusinessMetadataDef.getName(), atlasBusinessMetadataDef.getVersion());
                }
            }
        }
    }

    public AtlasTypesDef getAllTypes() throws PropertyServerException {
        String methodName = "getAllTypes()";
        String url = this.targetRootURL + "/api/atlas/v2/types/typedefs";
        return this.callGetRESTCallNoParams("getAllTypes()", AtlasTypesDef.class, url);
    }

    public String getTypeNamesAsString(Set<String> typeNames) {
        if (typeNames != null) {
            StringBuilder resultString = new StringBuilder("[");
            boolean firstElement = true;
            for (String typeName : typeNames) {
                if (typeName == null) continue;
                if (!firstElement) {
                    resultString.append(",");
                }
                firstElement = false;
                resultString.append("\"").append(typeName).append("\"");
            }
            resultString.append("]");
            return resultString.toString();
        }
        return null;
    }

    public Set<String> getTopLevelEntityTypes() throws PropertyServerException {
        AtlasTypesDef allTypes = this.getAllTypes();
        if (allTypes != null && allTypes.getEntityDefs() != null) {
            HashSet<String> typeNames = new HashSet<String>();
            for (AtlasEntityDef entityDef : allTypes.getEntityDefs()) {
                if (entityDef == null || entityDef.getSuperTypes() != null && !entityDef.getSuperTypes().isEmpty()) continue;
                typeNames.add(entityDef.getName());
            }
            if (!typeNames.isEmpty()) {
                return typeNames;
            }
        }
        return null;
    }

    public AtlasEntityDef getEntityType(String typeName) throws PropertyServerException {
        String methodName = "getEntityTypes(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/entitydef/name/" + typeName;
        return this.callNoLogGetRESTCallNoParams(methodName, AtlasEntityDef.class, url);
    }

    public AtlasRelationshipDef getRelationshipType(String typeName) throws PropertyServerException {
        String methodName = "getRelationshipTypes(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/relationshipdef/name/" + typeName;
        return this.callNoLogGetRESTCallNoParams(methodName, AtlasRelationshipDef.class, url);
    }

    public AtlasClassificationDef getClassificationType(String typeName) throws PropertyServerException {
        String methodName = "getClassificationType(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/classificationdef/name/" + typeName;
        return this.callGetRESTCallNoParams(methodName, AtlasClassificationDef.class, url);
    }

    public AtlasBusinessMetadataDef getBusinessMetadataType(String typeName) throws PropertyServerException {
        String methodName = "getBusinessMetadataType(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/businessmetadatadef/name/" + typeName;
        return this.callGetRESTCallNoParams(methodName, AtlasBusinessMetadataDef.class, url);
    }

    public void addNewTypes(AtlasTypesDef newTypeDefinitions) throws PropertyServerException {
        String methodName = "addNewTypes()";
        String url = this.targetRootURL + "/api/atlas/v2/types/typedefs";
        AtlasTypesDef newTypes = this.callPostRESTCallNoParams("addNewTypes()", AtlasTypesDef.class, url, newTypeDefinitions);
        this.addTypeDefinitions(newTypes);
    }

    public void updateTypes(AtlasTypesDef newTypeDefinitions) throws PropertyServerException {
        String methodName = "updateTypes()";
        String url = this.targetRootURL + "/api/atlas/v2/types/typedefs";
        AtlasTypesDef newTypes = this.callPutRESTCallNoParams("updateTypes()", AtlasTypesDef.class, url, newTypeDefinitions);
        this.addTypeDefinitions(newTypes);
    }

    public String addOpenMetadataElement(OpenMetadataElement openMetadataElement) throws PropertyServerException {
        AtlasEntity atlasEntity = new AtlasEntity();
        atlasEntity.setTypeName(OPEN_METADATA_TYPE_PREFIX + openMetadataElement.getType().getTypeName());
        atlasEntity.setIncomplete(false);
        atlasEntity.setStatus(AtlasInstanceStatus.ACTIVE);
        atlasEntity.setVersion(1L);
        if (openMetadataElement.getElementProperties() != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            for (String attributeName : openMetadataElement.getElementProperties().getPropertyValueMap().keySet()) {
                PropertyValue propertyValue = (PropertyValue)openMetadataElement.getElementProperties().getPropertyValueMap().get(attributeName);
                attributes.put(attributeName, propertyValue.valueAsObject());
            }
            if (!attributes.isEmpty()) {
                atlasEntity.setAttributes(attributes);
            }
        }
        return this.addEntity(atlasEntity);
    }

    public void updateOpenMetadataElement(String atlasGUID, OpenMetadataElement openMetadataElement) throws PropertyServerException {
        AtlasEntityWithExtInfo atlasEntity = this.getEntityByGUID(atlasGUID);
        if (openMetadataElement.getElementProperties() != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            for (String attributeName : openMetadataElement.getElementProperties().getPropertyValueMap().keySet()) {
                PropertyValue propertyValue = (PropertyValue)openMetadataElement.getElementProperties().getPropertyValueMap().get(attributeName);
                attributes.put(attributeName, propertyValue.valueAsObject());
            }
            if (!attributes.isEmpty()) {
                atlasEntity.getEntity().setAttributes(attributes);
            }
        }
        this.updateEntity(atlasEntity);
    }

    public void setupRelatedMetadataEntities(String relationshipTypeName, ElementProperties relationshipProperties, String end1AtlasGUID, String end2AtlasGUID) throws PropertyServerException {
        String atlasRelationshipTypeName = OPEN_METADATA_TYPE_PREFIX + relationshipTypeName;
        AtlasEntityWithExtInfo end1EntityWithExt = this.getEntityByGUID(end1AtlasGUID);
        AtlasEntity atlasEntity = end1EntityWithExt.getEntity();
        AtlasRelationship atlasRelationship = new AtlasRelationship();
        atlasRelationship.setTypeName(atlasRelationshipTypeName);
        AtlasObjectId end1 = new AtlasObjectId();
        end1.setGuid(end1AtlasGUID);
        atlasRelationship.setEnd1(end1);
        AtlasObjectId end2 = new AtlasObjectId();
        end2.setGuid(end2AtlasGUID);
        atlasRelationship.setEnd2(end2);
        if (relationshipProperties != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            for (String attributeName : relationshipProperties.getPropertyValueMap().keySet()) {
                PropertyValue propertyValue = (PropertyValue)relationshipProperties.getPropertyValueMap().get(attributeName);
                attributes.put(attributeName, propertyValue.valueAsObject());
            }
            if (!attributes.isEmpty()) {
                atlasRelationship.setAttributes(attributes);
            }
        }
        if (atlasEntity.getRelationshipAttributes() != null) {
            Map<String, Object> relationships = atlasEntity.getRelationshipAttributes();
            boolean shouldAddRelationship = true;
            for (Object relationshipObject : relationships.values()) {
                Map relationshipDetails;
                if (!(relationshipObject instanceof Map) || !atlasRelationshipTypeName.equals((relationshipDetails = (Map)relationshipObject).get("relationshipType")) || !end2AtlasGUID.equals(relationshipDetails.get("guid"))) continue;
                shouldAddRelationship = false;
                break;
            }
            if (shouldAddRelationship) {
                this.addRelationship(atlasRelationship);
            } else {
                this.updateRelationship(atlasRelationship);
            }
        } else {
            this.addRelationship(atlasRelationship);
        }
    }

    public void addOpenMetadataType(OpenMetadataTypeDef openMetadataTypeDef) throws PropertyServerException {
        if (openMetadataTypeDef instanceof OpenMetadataEntityDef) {
            OpenMetadataEntityDef entityDef = (OpenMetadataEntityDef)openMetadataTypeDef;
            this.addOpenMetadataEntityType(entityDef);
        } else if (openMetadataTypeDef instanceof OpenMetadataRelationshipDef) {
            OpenMetadataRelationshipDef relationshipDef = (OpenMetadataRelationshipDef)openMetadataTypeDef;
            this.addOpenMetadataRelationshipType(relationshipDef);
        } else if (openMetadataTypeDef instanceof OpenMetadataClassificationDef) {
            OpenMetadataClassificationDef classificationDef = (OpenMetadataClassificationDef)openMetadataTypeDef;
            this.addOpenMetadataClassificationType(classificationDef);
        }
    }

    public void addOpenMetadataEntityType(OpenMetadataEntityDef openMetadataEntityDef) throws PropertyServerException {
        TypeStatus typeStatus;
        if (openMetadataEntityDef != null && (typeStatus = this.isTypeDefinedInAtlas(openMetadataEntityDef.getName(), openMetadataEntityDef.getVersion())) != TypeStatus.IGNORE) {
            AtlasTypesDef typesDef = new AtlasTypesDef();
            ArrayList<AtlasEntityDef> entityDefs = new ArrayList<AtlasEntityDef>();
            AtlasEntityDef entityDef = new AtlasEntityDef();
            entityDef.setName(OPEN_METADATA_TYPE_PREFIX + openMetadataEntityDef.getName());
            entityDef.setDescription(openMetadataEntityDef.getDescription());
            entityDef.setServiceType(SERVICE_TYPE);
            entityDef.setTypeVersion(openMetadataEntityDef.getVersionName());
            entityDef.setVersion(openMetadataEntityDef.getVersion());
            entityDef.setAttributeDefs(this.getAtlasAttributeDefs(openMetadataEntityDef.getAttributeDefinitions()));
            entityDefs.add(entityDef);
            typesDef.setEntityDefs(entityDefs);
            if (typeStatus == TypeStatus.ADD) {
                this.addNewTypes(typesDef);
            } else {
                this.updateTypes(typesDef);
            }
        }
    }

    public void addOpenMetadataRelationshipType(OpenMetadataRelationshipDef openMetadataRelationshipDef) throws PropertyServerException {
        TypeStatus typeStatus;
        if (openMetadataRelationshipDef != null && (typeStatus = this.isTypeDefinedInAtlas(openMetadataRelationshipDef.getName(), openMetadataRelationshipDef.getVersion())) != TypeStatus.IGNORE) {
            AtlasTypesDef typesDef = new AtlasTypesDef();
            ArrayList<AtlasRelationshipDef> relationshipDefs = new ArrayList<AtlasRelationshipDef>();
            AtlasRelationshipDef relationshipDef = new AtlasRelationshipDef();
            AtlasRelationshipEndDef end1 = new AtlasRelationshipEndDef();
            AtlasRelationshipEndDef end2 = new AtlasRelationshipEndDef();
            relationshipDef.setName(OPEN_METADATA_TYPE_PREFIX + openMetadataRelationshipDef.getName());
            relationshipDef.setDescription(openMetadataRelationshipDef.getDescription());
            relationshipDef.setServiceType(SERVICE_TYPE);
            relationshipDef.setTypeVersion(openMetadataRelationshipDef.getVersionName());
            relationshipDef.setVersion(openMetadataRelationshipDef.getVersion());
            relationshipDef.setRelationshipCategory(AtlasRelationshipCategory.ASSOCIATION);
            relationshipDef.setPropagateTags(AtlasPropagateTags.NONE);
            end1.setType(relationshipDef.getEndDef1().getType());
            end1.setName(relationshipDef.getEndDef2().getName());
            end1.setContainer(false);
            end1.setCardinality(this.getAtlasCardinality(openMetadataRelationshipDef.getEndDef1().getAttributeCardinality()));
            end1.setLegacyAttribute(false);
            end2.setType(relationshipDef.getEndDef2().getType());
            end2.setName(relationshipDef.getEndDef1().getName());
            end2.setContainer(false);
            end2.setCardinality(this.getAtlasCardinality(openMetadataRelationshipDef.getEndDef1().getAttributeCardinality()));
            end2.setLegacyAttribute(false);
            relationshipDef.setEndDef1(end1);
            relationshipDef.setEndDef2(end2);
            relationshipDef.setAttributeDefs(this.getAtlasAttributeDefs(openMetadataRelationshipDef.getAttributeDefinitions()));
            relationshipDefs.add(relationshipDef);
            typesDef.setRelationshipDefs(relationshipDefs);
            if (typeStatus == TypeStatus.ADD) {
                this.addNewTypes(typesDef);
            } else {
                this.updateTypes(typesDef);
            }
        }
    }

    private AtlasCardinality getAtlasCardinality(OpenMetadataRelationshipEndCardinality cardinality) {
        if (cardinality == OpenMetadataRelationshipEndCardinality.AT_MOST_ONE) {
            return AtlasCardinality.SINGLE;
        }
        return AtlasCardinality.LIST;
    }

    public void addOpenMetadataClassificationType(OpenMetadataClassificationDef openMetadataClassificationDef) throws PropertyServerException {
        TypeStatus typeStatus;
        if (openMetadataClassificationDef != null && (typeStatus = this.isTypeDefinedInAtlas(openMetadataClassificationDef.getName(), openMetadataClassificationDef.getVersion())) != TypeStatus.IGNORE) {
            AtlasTypesDef typesDef = new AtlasTypesDef();
            ArrayList<AtlasBusinessMetadataDef> businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>();
            AtlasBusinessMetadataDef businessMetadataDef = new AtlasBusinessMetadataDef();
            businessMetadataDef.setName(OPEN_METADATA_TYPE_PREFIX + openMetadataClassificationDef.getName());
            businessMetadataDef.setDescription(openMetadataClassificationDef.getDescription());
            businessMetadataDef.setServiceType(SERVICE_TYPE);
            businessMetadataDef.setTypeVersion(openMetadataClassificationDef.getVersionName());
            businessMetadataDef.setVersion(openMetadataClassificationDef.getVersion());
            businessMetadataDef.setAttributeDefs(this.getAtlasAttributeDefs(openMetadataClassificationDef.getAttributeDefinitions(), openMetadataClassificationDef.getValidEntityDefs()));
            businessMetadataDefs.add(businessMetadataDef);
            typesDef.setBusinessMetadataDefs(businessMetadataDefs);
            if (typeStatus == TypeStatus.ADD) {
                this.addNewTypes(typesDef);
            } else {
                this.updateTypes(typesDef);
            }
        }
    }

    public void addClassificationType(String classificationName, String classificationDescription, Map<String, String> classificationProperties) throws PropertyServerException {
        TypeStatus typeStatus;
        if (classificationName != null && (typeStatus = this.isTypeDefinedInAtlas(classificationName, 1L)) != TypeStatus.IGNORE) {
            AtlasTypesDef typesDef = new AtlasTypesDef();
            ArrayList<AtlasClassificationDef> classificationDefs = new ArrayList<AtlasClassificationDef>();
            AtlasClassificationDef classificationDef = new AtlasClassificationDef();
            classificationDef.setName(OPEN_METADATA_TYPE_PREFIX + classificationName);
            classificationDef.setDescription(classificationDescription);
            classificationDef.setServiceType(SERVICE_TYPE);
            classificationDef.setTypeVersion("V1.0");
            classificationDef.setVersion(1L);
            classificationDef.setEntityTypes(this.getTopLevelEntityTypes());
            if (classificationProperties != null) {
                ArrayList<AtlasAttributeDef> atlasAttributeDefs = new ArrayList<AtlasAttributeDef>();
                for (String propertyName : classificationProperties.keySet()) {
                    atlasAttributeDefs.add(this.getStringAttributeDef(propertyName, classificationProperties.get(propertyName)));
                }
                if (!atlasAttributeDefs.isEmpty()) {
                    classificationDef.setAttributeDefs(atlasAttributeDefs);
                }
            }
            classificationDefs.add(classificationDef);
            typesDef.setClassificationDefs(classificationDefs);
            if (typeStatus == TypeStatus.ADD) {
                this.addNewTypes(typesDef);
            } else {
                this.updateTypes(typesDef);
            }
        }
    }

    public void addOpenMetadataEnumType(OpenMetadataEnumDef openMetadataEnumDef) throws PropertyServerException {
        TypeStatus typeStatus;
        if (openMetadataEnumDef != null && (typeStatus = this.isTypeDefinedInAtlas(openMetadataEnumDef.getName(), openMetadataEnumDef.getVersion())) != TypeStatus.IGNORE) {
            AtlasTypesDef typesDef = new AtlasTypesDef();
            ArrayList<AtlasEnumDef> enumDefs = new ArrayList<AtlasEnumDef>();
            AtlasEnumDef enumDef = new AtlasEnumDef();
            enumDef.setName(OPEN_METADATA_TYPE_PREFIX + openMetadataEnumDef.getName());
            enumDef.setDescription(openMetadataEnumDef.getDescription());
            enumDef.setServiceType(SERVICE_TYPE);
            enumDef.setTypeVersion(openMetadataEnumDef.getVersionName());
            enumDef.setVersion(openMetadataEnumDef.getVersion());
            enumDef.setElementDefs(this.getElementDefs(openMetadataEnumDef.getElementDefs()));
            enumDef.setDefaultValue(openMetadataEnumDef.getDefaultValue().getValue());
            enumDefs.add(enumDef);
            typesDef.setEnumDefs(enumDefs);
            if (typeStatus == TypeStatus.ADD) {
                this.addNewTypes(typesDef);
            } else {
                this.updateTypes(typesDef);
            }
        }
    }

    private List<AtlasElementDef> getElementDefs(List<OpenMetadataEnumElementDef> openMetadataEnumElementDefs) {
        if (openMetadataEnumElementDefs != null) {
            ArrayList<AtlasElementDef> elementDefs = new ArrayList<AtlasElementDef>();
            for (OpenMetadataEnumElementDef openMetadataEnumElementDef : openMetadataEnumElementDefs) {
                if (openMetadataEnumElementDef == null) continue;
                AtlasElementDef elementDef = new AtlasElementDef();
                elementDef.setOrdinal(openMetadataEnumElementDef.getOrdinal());
                elementDef.setDescription(openMetadataEnumElementDef.getDescription());
                elementDef.setValue(openMetadataEnumElementDef.getValue());
                elementDefs.add(elementDef);
            }
            if (!elementDefs.isEmpty()) {
                return elementDefs;
            }
        }
        return null;
    }

    private Set<String> getValidEntityDefs(List<OpenMetadataTypeDefLink> openMetadataTypeDefLinks) {
        if (openMetadataTypeDefLinks != null) {
            HashSet<String> validEntityTypeNames = new HashSet<String>();
            for (OpenMetadataTypeDefLink openMetadataTypeDefLink : openMetadataTypeDefLinks) {
                if (openMetadataTypeDefLink == null || openMetadataTypeDefLink.getName() == null) continue;
                validEntityTypeNames.add(openMetadataTypeDefLink.getName());
            }
            if (!validEntityTypeNames.isEmpty()) {
                return validEntityTypeNames;
            }
        }
        return null;
    }

    private List<AtlasAttributeDef> getAtlasAttributeDefs(List<OpenMetadataTypeDefAttribute> openMetadataTypeDefAttributes) throws PropertyServerException {
        if (openMetadataTypeDefAttributes != null) {
            ArrayList<AtlasAttributeDef> atlasAttributeDefs = new ArrayList<AtlasAttributeDef>();
            for (OpenMetadataTypeDefAttribute attribute : openMetadataTypeDefAttributes) {
                AtlasAttributeDef atlasAttributeDef;
                if (attribute == null || (atlasAttributeDef = this.getAtlasAttributeDef(attribute)) == null) continue;
                atlasAttributeDefs.add(atlasAttributeDef);
            }
            if (!atlasAttributeDefs.isEmpty()) {
                return atlasAttributeDefs;
            }
        }
        return null;
    }

    private List<AtlasAttributeDef> getAtlasAttributeDefs(List<OpenMetadataTypeDefAttribute> openMetadataTypeDefAttributes, List<OpenMetadataTypeDefLink> validEntityTypes) throws PropertyServerException {
        if (openMetadataTypeDefAttributes != null) {
            ArrayList<AtlasAttributeDef> atlasAttributeDefs = new ArrayList<AtlasAttributeDef>();
            for (OpenMetadataTypeDefAttribute attribute : openMetadataTypeDefAttributes) {
                AtlasAttributeDef atlasAttributeDef;
                if (attribute == null || (atlasAttributeDef = this.getAtlasAttributeDef(attribute, 100, this.getTypeNamesAsString(this.getValidEntityDefs(validEntityTypes)))) == null) continue;
                atlasAttributeDefs.add(atlasAttributeDef);
            }
            if (!atlasAttributeDefs.isEmpty()) {
                return atlasAttributeDefs;
            }
        }
        return null;
    }

    private AtlasAttributeDef getAtlasAttributeDef(OpenMetadataTypeDefAttribute openMetadataTypeDefAttribute) throws PropertyServerException {
        if (openMetadataTypeDefAttribute != null) {
            return this.getStandardAttributeDef(openMetadataTypeDefAttribute.getAttributeName(), openMetadataTypeDefAttribute.getAttributeDescription(), openMetadataTypeDefAttribute.getAttributeType());
        }
        return null;
    }

    public AtlasAttributeDef getAtlasAttributeDef(OpenMetadataTypeDefAttribute openMetadataTypeDefAttribute, int maxStringLength, String applicableEntityTypes) throws PropertyServerException {
        if (openMetadataTypeDefAttribute != null) {
            AtlasAttributeDef attributeDef = this.getStandardAttributeDef(openMetadataTypeDefAttribute.getAttributeName(), openMetadataTypeDefAttribute.getAttributeDescription(), openMetadataTypeDefAttribute.getAttributeType());
            HashMap<String, String> options = new HashMap<String, String>();
            if ("string".equals(openMetadataTypeDefAttribute.getAttributeType().getName())) {
                options.put("maxStrLength", Integer.toString(maxStringLength));
            }
            options.put("applicableEntityTypes", applicableEntityTypes);
            attributeDef.setOptions(options);
            return attributeDef;
        }
        return null;
    }

    public AtlasAttributeDef getStandardAttributeDef(String propertyName, String propertyDescription, OpenMetadataAttributeTypeDef openMetadataAttributeTypeDef) {
        if (openMetadataAttributeTypeDef instanceof OpenMetadataEnumDef) {
            return this.getStandardAttributeDef(propertyName, propertyDescription, "string");
        }
        return this.getStandardAttributeDef(propertyName, propertyDescription, openMetadataAttributeTypeDef.getName());
    }

    public AtlasAttributeDef getStandardAttributeDef(String propertyName, String propertyDescription, String typeName) {
        AtlasAttributeDef attributeDef = new AtlasAttributeDef();
        attributeDef.setName(propertyName);
        attributeDef.setDescription(propertyDescription);
        attributeDef.setTypeName(typeName);
        attributeDef.setOptional(false);
        attributeDef.setCardinality(AtlasCardinality.SINGLE);
        attributeDef.setValuesMinCount(0);
        attributeDef.setValuesMaxCount(1);
        attributeDef.setUnique(false);
        attributeDef.setIndexable(true);
        attributeDef.setIncludeInNotification(false);
        attributeDef.setSearchWeight(10);
        return attributeDef;
    }

    public AtlasAttributeDef getStringAttributeDef(String propertyName, String propertyDescription) {
        return this.getStandardAttributeDef(propertyName, propertyDescription, "string");
    }

    public AtlasAttributeDef getStringAttributeDef(String propertyName, String propertyDescription, int maxStringLength, String applicableEntityTypes) {
        AtlasAttributeDef attributeDef = this.getStandardAttributeDef(propertyName, propertyDescription, "string");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("maxStrLength", Integer.toString(maxStringLength));
        options.put("applicableEntityTypes", applicableEntityTypes);
        attributeDef.setOptions(options);
        return attributeDef;
    }

    public AtlasAttributeDef getBooleanAttributeDef(String propertyName, String propertyDescription) {
        return this.getStandardAttributeDef(propertyName, propertyDescription, "boolean");
    }

    public AtlasAttributeDef getBooleanAttributeDef(String propertyName, String propertyDescription, String applicableEntityTypes) {
        AtlasAttributeDef attributeDef = this.getStandardAttributeDef(propertyName, propertyDescription, "boolean");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("applicableEntityTypes", applicableEntityTypes);
        attributeDef.setOptions(options);
        return attributeDef;
    }

    public String addEntity(AtlasEntity entity) throws PropertyServerException {
        List<AtlasEntityHeader> returnedEntities;
        String methodName = "addEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity";
        AtlasEntityWithExtInfo atlasEntityWithExtInfo = new AtlasEntityWithExtInfo();
        atlasEntityWithExtInfo.setEntity(entity);
        AtlasEntityMutationResponse response = this.callPostRESTCallNoParams("addEntity()", AtlasEntityMutationResponse.class, url, atlasEntityWithExtInfo);
        if (response != null && response.getMutatedEntities() != null && (returnedEntities = response.getMutatedEntities().get((Object)AtlasEntityOperation.CREATE)) != null && !returnedEntities.isEmpty()) {
            return returnedEntities.get(0).getGuid();
        }
        return null;
    }

    public AtlasEntityWithExtInfo updateEntity(AtlasEntityWithExtInfo entityWithExtInfo) throws PropertyServerException {
        String methodName = "updateEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity";
        this.callPostRESTCallNoParams("updateEntity()", AtlasEntityMutationResponse.class, url, entityWithExtInfo);
        return this.getEntityByGUID(entityWithExtInfo.getEntity().getGuid());
    }

    public void addLabelsToEntity(String entityGUID, List<String> labels) throws PropertyServerException {
        String methodName = "addLabelsToEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity/guid/{0}/labels";
        this.callPostRESTCall("addLabelsToEntity()", Object.class, url, labels, entityGUID);
    }

    public void addBusinessMetadataToEntity(String entityGUID, String businessMetadataType, Map<String, Object> attributes) throws PropertyServerException {
        String methodName = "addBusinessMetadataToEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity/guid/{0}/businessmetadata";
        HashMap<String, Map<String, Object>> requestBody = new HashMap<String, Map<String, Object>>();
        requestBody.put(businessMetadataType, attributes);
        this.callPostRESTCall("addBusinessMetadataToEntity()", Object.class, url, requestBody, entityGUID);
    }

    public AtlasEntityMutationResponse deleteEntity(String entityGUID) throws PropertyServerException {
        String methodName = "deleteEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity/guid/{0}";
        return this.callDeleteRESTCall("deleteEntity()", AtlasEntityMutationResponse.class, url, entityGUID);
    }

    public AtlasRelationship getRelationshipByGUID(String guid) throws PropertyServerException {
        String methodName = "getRelationshipByGUID(" + guid + ")";
        String url = this.targetRootURL + "/api/atlas/v2/relationship/guid/" + guid;
        AtlasRelationship relationship = this.callGetRESTCallNoParams(methodName, AtlasRelationship.class, url);
        return this.validateActiveRelationship(relationship);
    }

    public AtlasRelationship addRelationship(AtlasRelationship atlasRelationship) throws PropertyServerException {
        String methodName = "addRelationship()";
        String url = this.targetRootURL + "/api/atlas/v2/relationship";
        return this.callPostRESTCallNoParams("addRelationship()", AtlasRelationship.class, url, atlasRelationship);
    }

    public AtlasRelationship updateRelationship(AtlasRelationship atlasRelationship) throws PropertyServerException {
        String methodName = "updateRelationship()";
        String url = this.targetRootURL + "/api/atlas/v2/relationship";
        return this.callPutRESTCallNoParams("updateRelationship()", AtlasRelationship.class, url, atlasRelationship);
    }

    public void clearRelationship(String atlasRelationshipGUID) throws PropertyServerException {
        String methodName = "clearRelationship()";
        String url = this.targetRootURL + "/api/atlas/v2/relationship/" + atlasRelationshipGUID;
        this.callDeleteRESTCall("clearRelationship()", url);
    }

    private AtlasEntityWithExtInfo validateActiveEntity(AtlasEntityWithExtInfo retrievedEntity) {
        if (retrievedEntity != null && retrievedEntity.getEntity() != null && retrievedEntity.getEntity().getStatus() == AtlasInstanceStatus.ACTIVE) {
            return retrievedEntity;
        }
        return null;
    }

    private AtlasRelationship validateActiveRelationship(AtlasRelationship retrievedRelationship) {
        if (retrievedRelationship != null && retrievedRelationship.getStatus() == AtlasInstanceStatus.ACTIVE) {
            return retrievedRelationship;
        }
        return null;
    }

    public AtlasEntityWithExtInfo getEntityByGUID(String guid) throws PropertyServerException {
        String methodName = "getEntityByGUID(" + guid + ")";
        String url = this.targetRootURL + "/api/atlas/v2/entity/guid/" + guid;
        AtlasEntityWithExtInfo entity = this.callGetRESTCallNoParams(methodName, AtlasEntityWithExtInfo.class, url);
        return this.validateActiveEntity(entity);
    }

    public AtlasEntityWithExtInfo getRelatedEntity(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        if (startingEntity != null && startingEntity.getEntity() != null) {
            return this.getRelatedEntity(startingEntity.getEntity(), relationshipLabel);
        }
        return null;
    }

    public String getRelationshipGUID(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        Map<String, Object> relationshipAttributes;
        Object relatedObject;
        if (startingEntity != null && startingEntity.getEntity() != null && startingEntity.getEntity().getRelationshipAttributes() != null && (relatedObject = (relationshipAttributes = startingEntity.getEntity().getRelationshipAttributes()).get(relationshipLabel)) instanceof Map) {
            Map relationship = (Map)relatedObject;
            return relationship.get("relationshipGuid").toString();
        }
        return null;
    }

    public AtlasEntityWithExtInfo getRelatedEntity(AtlasEntity startingEntity, String relationshipLabel) throws PropertyServerException {
        Map relationship;
        String relatedEntityGUID;
        Map<String, Object> relationshipAttributes;
        Object relatedObject;
        if (startingEntity != null && startingEntity.getRelationshipAttributes() != null && (relatedObject = (relationshipAttributes = startingEntity.getRelationshipAttributes()).get(relationshipLabel)) instanceof Map && (relatedEntityGUID = (relationship = (Map)relatedObject).get("guid").toString()) != null) {
            return this.getEntityByGUID(relatedEntityGUID);
        }
        return null;
    }

    public AtlasEntityWithExtInfo getRelatedEntity(AtlasEntityHeader startingEntity, String relationshipLabel) throws PropertyServerException {
        AtlasEntityWithExtInfo atlasEntity = this.getEntityByGUID(startingEntity.getGuid());
        if (atlasEntity != null) {
            return this.getRelatedEntity(atlasEntity, relationshipLabel);
        }
        return null;
    }

    public Map<String, String> getRelationships(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        Map<String, Object> relationshipAttributes;
        Object relationshipObjects;
        HashMap<String, String> guidMap = new HashMap<String, String>();
        if (startingEntity != null && startingEntity.getEntity().getRelationshipAttributes() != null && (relationshipObjects = (relationshipAttributes = startingEntity.getEntity().getRelationshipAttributes()).get(relationshipLabel)) instanceof List) {
            List relationshipList = (List)relationshipObjects;
            for (Object relationship : relationshipList) {
                if (!(relationship instanceof Map)) continue;
                Map relationshipMap = (Map)relationship;
                String relatedEntityGUID = relationshipMap.get("guid").toString();
                String relationshipGUID = relationshipMap.get("relationshipGuid").toString();
                if (relatedEntityGUID == null) continue;
                guidMap.put(relatedEntityGUID, relationshipGUID);
            }
        }
        return guidMap;
    }

    public List<AtlasEntityWithExtInfo> getRelatedEntities(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        Map<String, Object> relationshipAttributes;
        Object relatedObjects;
        ArrayList<AtlasEntityWithExtInfo> results = new ArrayList<AtlasEntityWithExtInfo>();
        if (startingEntity != null && startingEntity.getEntity() != null && startingEntity.getEntity().getRelationshipAttributes() != null && (relatedObjects = (relationshipAttributes = startingEntity.getEntity().getRelationshipAttributes()).get(relationshipLabel)) instanceof List) {
            List relatedObjectList = (List)relatedObjects;
            for (Object relatedObject : relatedObjectList) {
                AtlasEntityWithExtInfo validatedEntity;
                Map relatedMappedAttributes;
                String relatedEntityGUID;
                if (!(relatedObject instanceof Map) || (relatedEntityGUID = (relatedMappedAttributes = (Map)relatedObject).get("guid").toString()) == null || (validatedEntity = this.validateActiveEntity(this.getEntityByGUID(relatedEntityGUID))) == null) continue;
                results.add(validatedEntity);
            }
        }
        return results;
    }

    public List<AtlasEntityHeader> getEntitiesForType(String typeName, int startFrom, int pageSize) throws PropertyServerException {
        String url;
        String methodName = "getEntity(" + typeName + ")";
        AtlasSearchResult searchResult = this.callGetRESTCallNoParams(methodName, AtlasSearchResult.class, url = this.targetRootURL + "/api/atlas/v2/search/dsl?typeName=" + typeName + "&offset=" + startFrom + "&limit=" + pageSize);
        if (searchResult != null && searchResult.getEntities() != null) {
            ArrayList<AtlasEntityHeader> results = new ArrayList<AtlasEntityHeader>();
            for (AtlasEntityHeader entityHeader : searchResult.getEntities()) {
                if (entityHeader == null || entityHeader.getStatus() != AtlasInstanceStatus.ACTIVE) continue;
                results.add(entityHeader);
            }
            return results;
        }
        return null;
    }

    public AtlasGlossaryElement getAtlasGlossary(int glossaryCount) throws PropertyServerException {
        String methodName = "getAtlasGlossary(glossaryCount)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary?limit=1&offset=" + glossaryCount + "&sort=ASC";
        ArrayList glossaryElements = this.callGetRESTCallNoParams("getAtlasGlossary(glossaryCount)", ArrayList.class, url);
        if (glossaryElements != null && !glossaryElements.isEmpty()) {
            LinkedHashMap requestedGlossary = (LinkedHashMap)glossaryElements.get(0);
            return this.getAtlasGlossary(requestedGlossary.get("guid").toString());
        }
        return null;
    }

    public AtlasGlossaryElement getAtlasGlossary(String glossaryGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossary(glossaryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/" + glossaryGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossary(glossaryGUID)", AtlasGlossaryElement.class, url);
    }

    public String createAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "createAtlasGlossary(glossary)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary";
        AtlasGlossaryElement newGlossary = this.callPostRESTCallNoParams("createAtlasGlossary(glossary)", AtlasGlossaryElement.class, url, glossary);
        if (newGlossary != null) {
            return newGlossary.getGuid();
        }
        return null;
    }

    public AtlasGlossaryElement saveAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "saveAtlasGlossary(glossary)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/{0}";
        return this.callPutRESTCall("saveAtlasGlossary(glossary)", AtlasGlossaryElement.class, url, (Object)glossary, glossary.getGuid());
    }

    public void deleteAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "deleteAtlasGlossary()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/" + glossary.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossary()", url);
    }

    public AtlasGlossaryTermElement getAtlasGlossaryTerm(String glossaryTermGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossaryTerm(glossaryTermGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term/" + glossaryTermGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossaryTerm(glossaryTermGUID)", AtlasGlossaryTermElement.class, url);
    }

    public String createAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException, NameConflictException {
        AtlasGlossaryTermElement newTerm;
        String methodName = "createAtlasGlossaryTerm()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term";
        try {
            newTerm = this.callPostRESTCallNameConflict("createAtlasGlossaryTerm()", AtlasGlossaryTermElement.class, url, term);
        }
        catch (PropertyServerException error) {
            if (error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                throw new NameConflictException(ApacheAtlasErrorCode.TERM_ALREADY_EXISTS.getMessageDefinition(term.getName()), ((Object)((Object)this)).getClass().getName(), "createAtlasGlossaryTerm()", "name", (Exception)((Object)error));
            }
            throw error;
        }
        if (newTerm != null) {
            return newTerm.getGuid();
        }
        return null;
    }

    public AtlasGlossaryTermElement saveAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException {
        String methodName = "saveAtlasGlossaryTerm()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term/{0}";
        return this.callPutRESTCall("saveAtlasGlossaryTerm()", AtlasGlossaryTermElement.class, url, (Object)term, term.getGuid());
    }

    public void deleteAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException {
        String methodName = "deleteAtlasGlossaryTerm()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term/" + term.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossaryTerm()", url);
    }

    public AtlasGlossaryCategoryElement getAtlasGlossaryCategory(String glossaryCategoryGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossaryCategory(glossaryCategoryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category/" + glossaryCategoryGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossaryCategory(glossaryCategoryGUID)", AtlasGlossaryCategoryElement.class, url);
    }

    public String createAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException, NameConflictException {
        AtlasGlossaryCategoryElement newGlossaryCategory;
        String methodName = "createAtlasGlossaryCategory(category)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category";
        try {
            newGlossaryCategory = this.callPostRESTCallNameConflict("createAtlasGlossaryCategory(category)", AtlasGlossaryCategoryElement.class, url, category);
        }
        catch (PropertyServerException error) {
            if (error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                throw new NameConflictException(ApacheAtlasErrorCode.CATEGORY_ALREADY_EXISTS.getMessageDefinition(category.getName()), ((Object)((Object)this)).getClass().getName(), "createAtlasGlossaryCategory(category)", "name", (Exception)((Object)error));
            }
            throw error;
        }
        if (newGlossaryCategory != null) {
            return newGlossaryCategory.getGuid();
        }
        return null;
    }

    public AtlasGlossaryCategoryElement saveAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException {
        String methodName = "saveAtlasGlossaryCategory(glossaryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category/{0}";
        return this.callPutRESTCall("saveAtlasGlossaryCategory(glossaryGUID)", AtlasGlossaryCategoryElement.class, url, (Object)category, category.getGuid());
    }

    public void deleteAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException {
        String methodName = "deleteAtlasGlossaryCategory(glossaryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category/" + category.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossaryCategory(glossaryGUID)", url);
    }

    private <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callNoLogGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, false, error);
            return null;
        }
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callNoLogGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, false, error);
            return null;
        }
    }

    private <T> T callPutRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPutRESTCall(methodName, returnClass, urlTemplate, requestBody, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callNoLogPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, false, error);
            return null;
        }
    }

    private <T> T callPostRESTCallNameConflict(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            if (!error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                this.logRESTCallException(methodName, true, error);
            }
            throw new PropertyServerException(ApacheAtlasErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.atlasServerName, this.targetRootURL, error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
    }

    private <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPostRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPutRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPutRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private void callDeleteRESTCall(String methodName, String urlTemplate) throws PropertyServerException {
        try {
            this.clientConnector.callDeleteRESTCallNoParams(methodName, Object.class, urlTemplate, null);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
        }
    }

    private <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callDeleteRESTCall(methodName, responseType, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, boolean logMessage, Exception error) throws PropertyServerException {
        if (this.auditLog != null && logMessage) {
            this.auditLog.logException(methodName, ApacheAtlasAuditCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.atlasServerName, this.targetRootURL, error.getMessage()), (Throwable)error);
        }
        throw new PropertyServerException(ApacheAtlasErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.atlasServerName, this.targetRootURL, error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
    }

    private static enum TypeStatus {
        ADD,
        UPDATE,
        IGNORE;

    }
}

