/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum ApacheAtlasErrorCode implements ExceptionMessageSet
{
    NULL_URL(400, "APACHE-ATLAS-REST-CONNECTOR-400-001", "Apache Atlas REST connector {0} has been configured without the URL to Apache Atlas", "The connector is move to FAILED status and will not be called by the integration daemon until the configuration error has been corrected.", "The Apache Atlas URL is configured in the Apache Atlas REST connector's connection endpoint in the address property.  Typically it is the host name and port where Apache Atlas is listening.  The connection is either found in the Integration Daemon's configuration, or, if the Integration Daemon is configured with integration groups, in the open metadata definition of the appropriate integration group."),
    NULL_USER(400, "APACHE-ATLAS-REST-CONNECTOR-400-002", "Apache Atlas REST connector {0} has been configured with either a null userId or password for connecting to Apache Atlas", "The connector is not able to call Apache Atlas without error.", "Update the connection information for the connector.  This may have been supplied through the Integration Daemon's configuration, or if the Integration Daemon is using integration groups, the connection information is stored in the open metadata ecosystem.  It is possible to supply the userId and password directly in the connection object or via an embedded SecretsConnector."),
    CATEGORY_ALREADY_EXISTS(400, "APACHE-ATLAS-REST-CONNECTOR-400-004", "Glossary category {0} already exists in Apache Atlas", "The connector attempts to add a numerical post-fix to the category name to ensure it has a unique name.", "No action is required. The connector will validate whether it has already created the category on another thread, or it will try the request with a new name."),
    TERM_ALREADY_EXISTS(400, "APACHE-ATLAS-REST-CONNECTOR-400-005", "Glossary term {0} already exists in Apache Atlas", "The connector attempts to add a numerical post-fix to the term name to ensure it has a unique name.", "No action is required. The connector will validate whether it has already created the term on another thread, or it will try the request with a new name."),
    UNEXPECTED_EXCEPTION(500, "APACHE-ATLAS-REST-CONNECTOR-500-001", "The {0} Apache Atlas REST connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to catalog one or more metadata elements.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    CLIENT_SIDE_REST_API_ERROR(503, "APACHE-ATLAS-REST-CONNECTOR-503-001", "A client-side exception of {0} was received from API call {1} to URL {2}.  The error message was {3}", "The connector has issued a call to the open metadata access service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private ApacheAtlasErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

