/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.survey;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasAttributeDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasBusinessMetadataDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasCardinality;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasClassification;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasClassificationDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasMetrics;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasMetricsGeneral;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasMetricsTag;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationship;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationshipEndDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasStructDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasTypesDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasVersion;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.controls.AtlasAnnotationType;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.controls.AtlasMetric;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.controls.AtlasRequestParameter;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.ffdc.AtlasSurveyAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.ffdc.AtlasSurveyErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.NestedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyOpenMetadataStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SchemaAnalysisAnnotation;

public class SurveyApacheAtlasConnector
extends SurveyActionServiceConnector {
    private final Map<String, String> typeNameToDataFieldGUIDMap = new HashMap<String, String>();
    private String finalAnalysisStep = AnalysisStep.PROFILE_DATA.getName();

    public void start() throws ConnectorCheckedException {
        String finalAnalysisProperty;
        String finalAnalysisProperty2;
        Object finalAnalysisStepPropertyObject;
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getConfigurationProperties() != null && (finalAnalysisStepPropertyObject = this.connectionProperties.getConfigurationProperties().get(AtlasRequestParameter.FINAL_ANALYSIS_STEP.getName())) != null && ((finalAnalysisProperty2 = finalAnalysisStepPropertyObject.toString()).equals(AnalysisStep.MEASURE_RESOURCE.getName()) || finalAnalysisProperty2.equals(AnalysisStep.SCHEMA_EXTRACTION.getName()))) {
            this.finalAnalysisStep = finalAnalysisProperty2;
        }
        if (this.surveyContext.getRequestParameters() != null && ((finalAnalysisProperty = (String)this.surveyContext.getRequestParameters().get(AtlasRequestParameter.FINAL_ANALYSIS_STEP.getName())).equals(AnalysisStep.MEASURE_RESOURCE.getName()) || finalAnalysisProperty.equals(AnalysisStep.SCHEMA_EXTRACTION.getName()))) {
            this.finalAnalysisStep = finalAnalysisProperty;
        }
        try {
            AtlasTypesDef atlasTypes;
            String assetGUID = this.surveyContext.getAssetGUID();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            this.connector = super.performCheckAssetAnalysisStep(ApacheAtlasRESTConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            ApacheAtlasRESTConnector atlasConnector = (ApacheAtlasRESTConnector)this.connector;
            AssetUniverse assetUniverse = assetStore.getAssetProperties();
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyOpenMetadataStore openMetadataStore = this.surveyContext.getOpenMetadataStore();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            AtlasVersion atlasVersion = atlasConnector.getAtlasVersion();
            AtlasMetrics atlasMetrics = atlasConnector.getAtlasMetrics();
            if (atlasMetrics != null && atlasMetrics.getData() != null) {
                AtlasMetricsGeneral atlasMetricsGeneral = atlasMetrics.getData().getGeneral();
                AtlasMetricsTag atlasMetricsTag = atlasMetrics.getData().getTag();
                atlasTypes = atlasConnector.getAllTypes();
                ResourceMeasureAnnotation measurementAnnotation = new ResourceMeasureAnnotation();
                super.setUpAnnotation((Annotation)measurementAnnotation, (AnnotationType)AtlasAnnotationType.MEASUREMENTS);
                HashMap<String, String> metrics = new HashMap<String, String>();
                if (atlasMetricsGeneral != null) {
                    metrics.put(AtlasMetric.ENTITY_INSTANCE_COUNT.getName(), Integer.toString(atlasMetricsGeneral.getEntityCount()));
                    metrics.put(AtlasMetric.CLASSIFICATION_COUNT.getName(), Integer.toString(atlasMetricsGeneral.getTagCount()));
                    metrics.put(AtlasMetric.TYPE_UNUSED_COUNT.getName(), Integer.toString(atlasMetricsGeneral.getTypeUnusedCount()));
                    metrics.put(AtlasMetric.TYPE_COUNT.getName(), Integer.toString(atlasMetricsGeneral.getTypeCount()));
                }
                if (atlasMetricsTag != null && atlasMetricsTag.getTagEntities() != null) {
                    this.addMapMetrics(atlasMetricsTag.getTagEntities(), AtlasMetric.CLASSIFIED_ENTITY_COUNT.getName(), metrics);
                }
                if (atlasMetrics.getData().getEntity() != null) {
                    this.addMapMetrics(atlasMetrics.getData().getEntity().get("entityActive"), "entityInstanceCount", metrics);
                    this.addMapMetrics(atlasMetrics.getData().getEntity().get("entityActive-typeAndSubTypes"), "entityWithSubtypesInstanceCount", metrics);
                }
                if (atlasTypes != null) {
                    metrics.put(AtlasMetric.ENTITY_DEF_COUNT.getName(), Integer.toString(atlasTypes.getEntityDefs().size()));
                    metrics.put(AtlasMetric.RELATIONSHIP_DEF_COUNT.getName(), Integer.toString(atlasTypes.getRelationshipDefs().size()));
                    metrics.put(AtlasMetric.CLASSIFICATION_DEF_COUNT.getName(), Integer.toString(atlasTypes.getClassificationDefs().size()));
                    if (atlasTypes.getBusinessMetadataDefs() != null) {
                        metrics.put(AtlasMetric.BUSINESS_METADATA_DEF_COUNT.getName(), Integer.toString(atlasTypes.getBusinessMetadataDefs().size()));
                    }
                }
                measurementAnnotation.setResourceProperties(metrics);
                annotationStore.addAnnotation((Annotation)measurementAnnotation, null);
            }
            if (!AnalysisStep.MEASURE_RESOURCE.getName().equals(this.finalAnalysisStep)) {
                NestedSchemaType graphSchemaType;
                Object existingTypeSchemaAttributes;
                annotationStore.setAnalysisStep(AnalysisStep.SCHEMA_EXTRACTION.getName());
                SchemaAnalysisAnnotation schemaAnalysisAnnotation = new SchemaAnalysisAnnotation();
                super.setUpAnnotation((Annotation)schemaAnalysisAnnotation, (AnnotationType)AtlasAnnotationType.TYPE_ANALYSIS);
                schemaAnalysisAnnotation.setSchemaName("Apache Atlas Types: " + atlasVersion.getVersion());
                schemaAnalysisAnnotation.setSchemaTypeName(atlasVersion.getName());
                annotationStore.addAnnotation((Annotation)schemaAnalysisAnnotation, null);
                this.upsertRootSchemaType(assetGUID, assetUniverse, (OpenMetadataStore)openMetadataStore);
                assetUniverse = assetStore.getAssetProperties();
                if (assetUniverse != null && assetUniverse.getRootSchemaType() != null && (atlasTypes = assetUniverse.getRootSchemaType()) instanceof NestedSchemaType && (existingTypeSchemaAttributes = (graphSchemaType = (NestedSchemaType)atlasTypes).getSchemaAttributes()) != null) {
                    while (existingTypeSchemaAttributes.hasNext()) {
                        SchemaAttribute existingType = existingTypeSchemaAttributes.next();
                        this.typeNameToDataFieldGUIDMap.put(existingType.getDisplayName(), existingType.getGUID());
                    }
                }
                AtlasTypesDef atlasTypesDef = atlasConnector.getAllTypes();
                for (AtlasEntityDef atlasEntityDef : atlasTypesDef.getEntityDefs()) {
                    if (atlasEntityDef == null) continue;
                    this.getSchemaAttributeForAtlasEntityDef(atlasEntityDef, assetUniverse, (OpenMetadataStore)openMetadataStore);
                }
                for (AtlasClassificationDef atlasClassificationDef : atlasTypesDef.getClassificationDefs()) {
                    if (atlasClassificationDef == null) continue;
                    this.getSchemaAttributeForAtlasClassificationDef(atlasClassificationDef, assetUniverse, (OpenMetadataStore)openMetadataStore);
                }
                for (AtlasRelationshipDef atlasRelationshipDef : atlasTypesDef.getRelationshipDefs()) {
                    if (atlasRelationshipDef == null) continue;
                    this.getSchemaAttributeForAtlasRelationshipDef(atlasRelationshipDef, assetUniverse, (OpenMetadataStore)openMetadataStore);
                }
                if (atlasTypesDef.getBusinessMetadataDefs() != null) {
                    for (AtlasBusinessMetadataDef atlasBusinessMetadataDef : atlasTypesDef.getBusinessMetadataDefs()) {
                        if (atlasBusinessMetadataDef == null) continue;
                        this.getSchemaAttributeForAtlasBusinessMetadataDef(atlasBusinessMetadataDef, assetUniverse, (OpenMetadataStore)openMetadataStore);
                    }
                }
                if (AnalysisStep.SCHEMA_EXTRACTION.getName().equals(this.finalAnalysisStep)) {
                    ResourceProfileAnnotation resourceProfileAnnotation;
                    ResourceProfileAnnotation resourceProfileAnnotation2;
                    HashMap<String, String> additionalProperties;
                    String dataFieldGUID;
                    annotationStore.setAnalysisStep(AnalysisStep.PROFILE_DATA.getName());
                    HashMap<String, EntityTypeMetrics> entityTypeMetricsMap = new HashMap<String, EntityTypeMetrics>();
                    HashMap<String, TagTypeMetrics> classificationTypeMetricsMap = new HashMap<String, TagTypeMetrics>();
                    HashMap<String, TagTypeMetrics> businessMetadataMetricsMap = new HashMap<String, TagTypeMetrics>();
                    HashMap<String, RelationshipTypeMetrics> relationshipTypeMetricsMap = new HashMap<String, RelationshipTypeMetrics>();
                    int maxPageSize = 100;
                    for (AtlasEntityDef entityType : atlasTypesDef.getEntityDefs()) {
                        if (entityType.getSuperTypes() != null && !entityType.getSuperTypes().isEmpty()) continue;
                        int startFrom = 0;
                        List<AtlasEntityHeader> entities = atlasConnector.getEntitiesForType(entityType.getName(), startFrom, 100);
                        while (entities != null && !entities.isEmpty()) {
                            for (AtlasEntityHeader entityHeader : entities) {
                                AtlasEntityWithExtInfo atlasEntityWithExtInfo = atlasConnector.getEntityByGUID(entityHeader.getGuid());
                                this.addEntityProfile(atlasEntityWithExtInfo.getEntity(), this.getAtlasRelationships(atlasEntityWithExtInfo.getEntity(), atlasConnector), entityTypeMetricsMap, classificationTypeMetricsMap, businessMetadataMetricsMap, relationshipTypeMetricsMap);
                            }
                            entities = atlasConnector.getEntitiesForType(entityType.getName(), startFrom += 100, 100);
                        }
                    }
                    for (String entityTypeName : entityTypeMetricsMap.keySet()) {
                        EntityTypeMetrics entityTypeMetrics = (EntityTypeMetrics)entityTypeMetricsMap.get(entityTypeName);
                        dataFieldGUID = this.typeNameToDataFieldGUIDMap.get(entityTypeName);
                        additionalProperties = new HashMap<String, String>();
                        additionalProperties.put("entityInstanceCount", Integer.toString(entityTypeMetrics.instanceCount));
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.ENTITY_ATTACHED_CLASSIFICATIONS);
                        resourceProfileAnnotation2.setValueCount(entityTypeMetrics.classificationCount);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.ENTITY_ATTACHED_TO_END1);
                        resourceProfileAnnotation2.setValueCount(entityTypeMetrics.relationshipEnd1Count);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.ENTITY_ATTACHED_TO_END2);
                        resourceProfileAnnotation2.setValueCount(entityTypeMetrics.relationshipEnd2Count);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.ENTITY_ATTACHED_LABELS);
                        resourceProfileAnnotation2.setValueCount(entityTypeMetrics.labelCount);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.ENTITY_ATTACHED_BIZ_METADATA);
                        resourceProfileAnnotation2.setValueCount(entityTypeMetrics.labelCount);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                    }
                    for (String classificationName : classificationTypeMetricsMap.keySet()) {
                        TagTypeMetrics classificationTypeMetrics = (TagTypeMetrics)classificationTypeMetricsMap.get(classificationName);
                        resourceProfileAnnotation = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation, (AnnotationType)AtlasAnnotationType.CLASSIFICATION_ATTACHED_ENTITIES);
                        resourceProfileAnnotation.setValueCount(classificationTypeMetrics.entityCount);
                        additionalProperties = new HashMap();
                        additionalProperties.put("classificationInstanceCount", Integer.toString(classificationTypeMetrics.instanceCount));
                        resourceProfileAnnotation.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, this.typeNameToDataFieldGUIDMap.get(classificationName));
                    }
                    for (String businessMetadataName : businessMetadataMetricsMap.keySet()) {
                        TagTypeMetrics businessMetadataMetrics = (TagTypeMetrics)businessMetadataMetricsMap.get(businessMetadataName);
                        resourceProfileAnnotation = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation, (AnnotationType)AtlasAnnotationType.CLASSIFICATION_ATTACHED_ENTITIES);
                        resourceProfileAnnotation.setValueCount(businessMetadataMetrics.entityCount);
                        additionalProperties = new HashMap();
                        additionalProperties.put("businessMetadataInstanceCount", Integer.toString(businessMetadataMetrics.instanceCount));
                        resourceProfileAnnotation.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, this.typeNameToDataFieldGUIDMap.get(businessMetadataName));
                    }
                    for (String relationshipTypeName : relationshipTypeMetricsMap.keySet()) {
                        RelationshipTypeMetrics relationshipTypeMetrics = (RelationshipTypeMetrics)relationshipTypeMetricsMap.get(relationshipTypeName);
                        dataFieldGUID = this.typeNameToDataFieldGUIDMap.get(relationshipTypeName);
                        additionalProperties = new HashMap();
                        additionalProperties.put("relationshipInstanceCount", Integer.toString(relationshipTypeMetrics.instanceCount));
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.END1_ENTITY_TYPES);
                        resourceProfileAnnotation2.setValueCount(relationshipTypeMetrics.entityAtEnd1Count);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.END2_ENTITY_TYPES);
                        resourceProfileAnnotation2.setValueCount(relationshipTypeMetrics.entityAtEnd2Count);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                        resourceProfileAnnotation2 = new ResourceProfileAnnotation();
                        super.setUpAnnotation((Annotation)resourceProfileAnnotation2, (AnnotationType)AtlasAnnotationType.PAIRED_ENTITY_TYPES);
                        resourceProfileAnnotation2.setValueCount(relationshipTypeMetrics.entityPairCount);
                        resourceProfileAnnotation2.setAdditionalProperties(additionalProperties);
                        annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, dataFieldGUID);
                    }
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(AtlasSurveyErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }

    private List<AtlasRelationship> getAtlasRelationships(AtlasEntity atlasEntity, ApacheAtlasRESTConnector atlasConnector) throws PropertyServerException {
        if (atlasEntity.getRelationshipAttributes() != null || !atlasEntity.getRelationshipAttributes().isEmpty()) {
            ArrayList<AtlasRelationship> relationships = new ArrayList<AtlasRelationship>();
            for (String relationshipAttribute : atlasEntity.getRelationshipAttributes().keySet()) {
                AtlasRelationship relationship;
                Map relationshipProperties;
                Object relationshipGUID;
                Object object = atlasEntity.getRelationshipAttributes().get(relationshipAttribute);
                if (!(object instanceof Map) || (relationshipGUID = (relationshipProperties = (Map)object).get("relationshipGuid")) == null || (relationship = atlasConnector.getRelationshipByGUID(relationshipGUID.toString())) == null) continue;
                relationships.add(relationship);
            }
            if (!relationships.isEmpty()) {
                return relationships;
            }
        }
        return null;
    }

    private void addEntityProfile(AtlasEntity atlasEntity, List<AtlasRelationship> atlasRelationships, Map<String, EntityTypeMetrics> entityTypeMetricsMap, Map<String, TagTypeMetrics> classificationTypeMetricsMap, Map<String, TagTypeMetrics> businessMetadataTypeMetricsMap, Map<String, RelationshipTypeMetrics> relationshipTypeMetricsMap) {
        if (atlasEntity != null) {
            String entityTypeName = atlasEntity.getTypeName();
            EntityTypeMetrics entityTypeMetrics = entityTypeMetricsMap.get(entityTypeName);
            if (entityTypeMetrics == null) {
                entityTypeMetrics = new EntityTypeMetrics();
                entityTypeMetricsMap.put(entityTypeName, entityTypeMetrics);
            }
            entityTypeMetrics.incrementInstanceCount();
            if (atlasEntity.getLabels() != null) {
                for (String label : atlasEntity.getLabels()) {
                    entityTypeMetrics.incrementLabelCount(label);
                }
            }
            if (atlasEntity.getClassifications() != null) {
                for (AtlasClassification classification : atlasEntity.getClassifications()) {
                    String classificationName = classification.getTypeName();
                    entityTypeMetrics.incrementClassificationCount(classificationName);
                    TagTypeMetrics classificationTypeMetrics = classificationTypeMetricsMap.get(classificationName);
                    if (classificationTypeMetrics == null) {
                        classificationTypeMetrics = new TagTypeMetrics();
                        classificationTypeMetricsMap.put(classificationName, classificationTypeMetrics);
                    }
                    classificationTypeMetrics.incrementInstanceCount();
                    classificationTypeMetrics.incrementEntityCount(entityTypeName);
                }
            }
            if (atlasEntity.getBusinessAttributes() != null) {
                for (String businessMetadataName : atlasEntity.getBusinessAttributes().keySet()) {
                    entityTypeMetrics.incrementBusinessMetadataCount(businessMetadataName);
                    TagTypeMetrics businessMetadataMetrics = businessMetadataTypeMetricsMap.get(businessMetadataName);
                    if (businessMetadataMetrics == null) {
                        businessMetadataMetrics = new TagTypeMetrics();
                        classificationTypeMetricsMap.put(businessMetadataName, businessMetadataMetrics);
                    }
                    businessMetadataMetrics.incrementInstanceCount();
                    businessMetadataMetrics.incrementEntityCount(entityTypeName);
                }
            }
            if (atlasRelationships != null && !atlasRelationships.isEmpty()) {
                for (AtlasRelationship relationship : atlasRelationships) {
                    String relationshipTypeName = relationship.getTypeName();
                    RelationshipTypeMetrics relationshipTypeMetrics = relationshipTypeMetricsMap.get(relationshipTypeName);
                    if (relationshipTypeMetrics == null) {
                        relationshipTypeMetrics = new RelationshipTypeMetrics();
                        relationshipTypeMetricsMap.put(relationshipTypeName, relationshipTypeMetrics);
                    }
                    if (relationship.getEnd1().getGuid().equals(atlasEntity.getGuid())) {
                        relationshipTypeMetrics.incrementInstanceCount();
                        relationshipTypeMetrics.incrementEntityPairCount(relationship.getEnd1().getTypeName(), relationship.getEnd2().getTypeName());
                        relationshipTypeMetrics.incrementEntityAtEnd1Count(entityTypeName);
                        entityTypeMetrics.incrementRelationshipEnd1Count(relationshipTypeName);
                        continue;
                    }
                    relationshipTypeMetrics.incrementEntityAtEnd2Count(entityTypeName);
                    entityTypeMetrics.incrementRelationshipEnd2Count(relationshipTypeName);
                }
            }
        }
    }

    private void addMapMetrics(Map<String, Integer> namedMetrics, String metricNamePrefix, Map<String, String> consolidatedMetrics) {
        int elementCount = 0;
        for (String elementName : namedMetrics.keySet()) {
            ++elementCount;
            consolidatedMetrics.put(metricNamePrefix + ": " + elementName, Integer.toString(namedMetrics.get(elementName)));
        }
        consolidatedMetrics.put(metricNamePrefix, Integer.toString(elementCount));
    }

    private void upsertRootSchemaType(String assetGUID, AssetUniverse assetUniverse, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "addRootSchemaType";
        if (assetUniverse != null) {
            if (assetUniverse.getRootSchemaType() != null) {
                if (this.propertyHelper.isTypeOf((ElementControlHeader)assetUniverse.getRootSchemaType(), OpenMetadataType.GRAPH_SCHEMA_TYPE.typeName)) {
                    return;
                }
                if (this.auditLog != null) {
                    this.auditLog.logMessage("addRootSchemaType", AtlasSurveyAuditCode.WRONG_ROOT_SCHEMA_TYPE.getMessageDefinition(assetGUID, assetUniverse.getRootSchemaType().getType().getTypeName(), OpenMetadataType.GRAPH_SCHEMA_TYPE.typeName, this.surveyActionServiceName, assetUniverse.getRootSchemaType().toString()));
                }
                throw new ConnectorCheckedException(AtlasSurveyErrorCode.WRONG_ROOT_SCHEMA_TYPE.getMessageDefinition(assetGUID, assetUniverse.getRootSchemaType().getType().getTypeName(), OpenMetadataType.GRAPH_SCHEMA_TYPE.typeName, this.surveyActionServiceName, assetUniverse.getRootSchemaType().toString()), ((Object)((Object)this)).getClass().getName(), "addRootSchemaType");
            }
        } else {
            if (this.auditLog != null) {
                this.auditLog.logMessage("addRootSchemaType", AtlasSurveyAuditCode.MISSING_ASSET_UNIVERSE.getMessageDefinition(this.surveyActionServiceName));
            }
            throw new ConnectorCheckedException(AtlasSurveyErrorCode.MISSING_ASSET_UNIVERSE.getMessageDefinition(this.surveyActionServiceName), ((Object)((Object)this)).getClass().getName(), "addRootSchemaType");
        }
        ElementProperties properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, assetUniverse.getQualifiedName() + "_rootSchemaType");
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.DISPLAY_NAME.name, "Root schema type for " + assetUniverse.getResourceName());
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.DESCRIPTION.name, "Graph schema showing the Apache Atlas Types and how they link together.");
        openMetadataStore.createMetadataElementInStore(OpenMetadataType.GRAPH_SCHEMA_TYPE.typeName, ElementStatus.ACTIVE, null, assetGUID, false, null, null, properties, assetGUID, "AssetSchemaType", null, true);
    }

    private void getSchemaAttributeForAtlasEntityDef(AtlasEntityDef atlasEntityDef, AssetUniverse assetUniverse, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.getSchemaAttributeForTypeDef(OpenMetadataType.GRAPH_VERTEX.typeName, assetUniverse, atlasEntityDef, "ENTITY", atlasEntityDef.getSuperTypes(), openMetadataStore);
    }

    private void getSchemaAttributeForAtlasClassificationDef(AtlasClassificationDef atlasClassificationDef, AssetUniverse assetUniverse, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUID = this.getSchemaAttributeForTypeDef(OpenMetadataType.GRAPH_VERTEX.typeName, assetUniverse, atlasClassificationDef, "CLASSIFICATION", atlasClassificationDef.getSuperTypes(), openMetadataStore);
        if (atlasClassificationDef.getEntityTypes() != null) {
            for (String entityType : atlasClassificationDef.getEntityTypes()) {
                if (entityType == null || this.typeNameToDataFieldGUIDMap.get(entityType) == null) continue;
                openMetadataStore.createRelatedElementsInStore(OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.typeName, schemaAttributeGUID, this.typeNameToDataFieldGUIDMap.get(entityType), null, null, null);
            }
        }
    }

    private void getSchemaAttributeForAtlasBusinessMetadataDef(AtlasBusinessMetadataDef atlasBusinessMetadataDef, AssetUniverse assetUniverse, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.getSchemaAttributeForTypeDef(OpenMetadataType.GRAPH_VERTEX.typeName, assetUniverse, atlasBusinessMetadataDef, "BUSINESS_METADATA", null, openMetadataStore);
    }

    private void getSchemaAttributeForAtlasRelationshipDef(AtlasRelationshipDef atlasRelationshipDef, AssetUniverse assetUniverse, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String dataFieldGUID = this.getSchemaAttributeForTypeDef(OpenMetadataType.GRAPH_EDGE.typeName, assetUniverse, atlasRelationshipDef, "RELATIONSHIP", null, openMetadataStore);
        this.addRelationshipEnd(dataFieldGUID, true, atlasRelationshipDef.getEndDef1(), openMetadataStore);
        this.addRelationshipEnd(dataFieldGUID, false, atlasRelationshipDef.getEndDef2(), openMetadataStore);
    }

    private void addRelationshipEnd(String relationshipSchemaAttributeGUID, boolean isEnd1, AtlasRelationshipEndDef endDef, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (endDef != null) {
            ElementProperties linkProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, endDef.getName());
            linkProperties = this.propertyHelper.addStringProperty(linkProperties, OpenMetadataProperty.OPEN_METADATA_TYPE_NAME.name, endDef.getType());
            linkProperties = this.propertyHelper.addStringProperty(linkProperties, OpenMetadataProperty.DESCRIPTION.name, endDef.getDescription());
            linkProperties = isEnd1 ? this.propertyHelper.addIntProperty(linkProperties, OpenMetadataProperty.RELATIONSHIP_END.name, 1) : this.propertyHelper.addIntProperty(linkProperties, OpenMetadataProperty.RELATIONSHIP_END.name, 2);
            if (endDef.getCardinality() == AtlasCardinality.SINGLE) {
                linkProperties = this.propertyHelper.addIntProperty(linkProperties, OpenMetadataProperty.MAX_CARDINALITY.name, 1);
            }
            openMetadataStore.createRelatedElementsInStore(OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.typeName, relationshipSchemaAttributeGUID, this.typeNameToDataFieldGUIDMap.get(endDef.getType()), null, null, linkProperties);
        }
    }

    private String getSchemaAttributeForTypeDef(String openMetadataTypeName, AssetUniverse assetUniverse, AtlasStructDef atlasTypeDef, String atlasCategoryName, Set<String> atlasSuperTypes, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (atlasTypeDef != null) {
            String typeAttributeGUID = this.typeNameToDataFieldGUIDMap.get(atlasTypeDef.getName());
            if (typeAttributeGUID == null) {
                String qualifiedName = assetUniverse.getQualifiedName() + "_" + atlasCategoryName + "_" + atlasTypeDef.getName();
                ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, atlasTypeDef.getName());
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, atlasTypeDef.getDescription());
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, atlasTypeDef.getDescription());
                elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, "aliases", new ArrayList<String>(atlasSuperTypes));
                ElementProperties typeProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName + "_type");
                typeProperties = this.propertyHelper.addStringProperty(typeProperties, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, "ComplexSchemaType");
                typeProperties = this.propertyHelper.addStringProperty(typeProperties, OpenMetadataProperty.DISPLAY_NAME.name, atlasCategoryName);
                typeProperties = this.propertyHelper.addStringProperty(typeProperties, "namespace", atlasTypeDef.getServiceType());
                typeProperties = this.propertyHelper.addStringProperty(typeProperties, "versionNumber", atlasTypeDef.getTypeVersion());
                HashMap<String, ElementProperties> initialClassifications = new HashMap<String, ElementProperties>();
                initialClassifications.put("TypeEmbeddedAttribute", typeProperties);
                typeAttributeGUID = openMetadataStore.createMetadataElementInStore(openMetadataTypeName, ElementStatus.ACTIVE, initialClassifications, assetUniverse.getGUID(), false, null, null, elementProperties, assetUniverse.getRootSchemaType().getGUID(), "AttributeForSchema", null, true);
                this.typeNameToDataFieldGUIDMap.put(atlasTypeDef.getName(), typeAttributeGUID);
                this.setUpAttributeSchemaAttributes(typeAttributeGUID, qualifiedName, assetUniverse.getGUID(), atlasTypeDef.getAttributeDefs(), openMetadataStore);
            }
            return typeAttributeGUID;
        }
        return null;
    }

    private void setUpAttributeSchemaAttributes(String typeSchemaAttributeGUID, String typeSchemaAttributeQualifiedName, String anchorGUID, List<AtlasAttributeDef> attributeDefs, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (attributeDefs != null) {
            for (AtlasAttributeDef attributeDef : attributeDefs) {
                if (attributeDef == null) continue;
                this.setUpAttributeSchemaAttribute(typeSchemaAttributeGUID, typeSchemaAttributeQualifiedName, anchorGUID, attributeDef, openMetadataStore);
            }
        }
    }

    private void setUpAttributeSchemaAttribute(String typeSchemaAttributeGUID, String typeSchemaAttributeQualifiedName, String anchorGUID, AtlasAttributeDef attributeDef, OpenMetadataStore openMetadataStore) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, typeSchemaAttributeQualifiedName + "_attribute_" + attributeDef.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, attributeDef.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, attributeDef.getDescription());
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, "minCardinality", attributeDef.getValuesMinCount());
        elementProperties = this.propertyHelper.addIntProperty(elementProperties, "maxCardinality", attributeDef.getValuesMaxCount());
        HashMap<String, ElementProperties> initialClassifications = new HashMap<String, ElementProperties>();
        ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, "PrimitiveSchemaType");
        classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.DATA_TYPE.name, attributeDef.getTypeName());
        classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, "defaultValue", attributeDef.getDefaultValue());
        initialClassifications.put("TypeEmbeddedAttribute", classificationProperties);
        String schemaAttributeGUID = openMetadataStore.createMetadataElementInStore(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, ElementStatus.ACTIVE, initialClassifications, anchorGUID, false, null, null, elementProperties, typeSchemaAttributeGUID, "NestedSchemaAttribute", null, true);
        openMetadataStore.createRelatedElementsInStore("NestedSchemaAttribute", typeSchemaAttributeGUID, schemaAttributeGUID, null, null, null);
    }

    public static class EntityTypeMetrics {
        private int instanceCount = 0;
        private final Map<String, Integer> classificationCount = new HashMap<String, Integer>();
        private final Map<String, Integer> businessMetadataCount = new HashMap<String, Integer>();
        private final Map<String, Integer> labelCount = new HashMap<String, Integer>();
        private final Map<String, Integer> relationshipEnd1Count = new HashMap<String, Integer>();
        private final Map<String, Integer> relationshipEnd2Count = new HashMap<String, Integer>();

        void incrementInstanceCount() {
            ++this.instanceCount;
        }

        void incrementClassificationCount(String classificationName) {
            Integer currentCount = this.classificationCount.get(classificationName);
            if (currentCount == null) {
                this.classificationCount.put(classificationName, 0);
            } else {
                this.classificationCount.put(classificationName, currentCount + 1);
            }
        }

        void incrementBusinessMetadataCount(String businessMetadataName) {
            Integer currentCount = this.businessMetadataCount.get(businessMetadataName);
            if (currentCount == null) {
                this.businessMetadataCount.put(businessMetadataName, 0);
            } else {
                this.businessMetadataCount.put(businessMetadataName, currentCount + 1);
            }
        }

        void incrementLabelCount(String label) {
            Integer currentCount = this.labelCount.get(label);
            if (currentCount == null) {
                this.labelCount.put(label, 0);
            } else {
                this.labelCount.put(label, currentCount + 1);
            }
        }

        void incrementRelationshipEnd1Count(String relationshipTypeName) {
            Integer currentCount = this.relationshipEnd1Count.get(relationshipTypeName);
            if (currentCount == null) {
                this.relationshipEnd1Count.put(relationshipTypeName, 0);
            } else {
                this.relationshipEnd1Count.put(relationshipTypeName, currentCount + 1);
            }
        }

        void incrementRelationshipEnd2Count(String relationshipTypeName) {
            Integer currentCount = this.relationshipEnd2Count.get(relationshipTypeName);
            if (currentCount == null) {
                this.relationshipEnd2Count.put(relationshipTypeName, 0);
            } else {
                this.relationshipEnd2Count.put(relationshipTypeName, currentCount + 1);
            }
        }
    }

    public static class TagTypeMetrics {
        private int instanceCount = 0;
        private final Map<String, Integer> entityCount = new HashMap<String, Integer>();

        void incrementInstanceCount() {
            ++this.instanceCount;
        }

        void incrementEntityCount(String entityTypeName) {
            Integer currentCount = this.entityCount.get(entityTypeName);
            if (currentCount == null) {
                this.entityCount.put(entityTypeName, 0);
            } else {
                this.entityCount.put(entityTypeName, currentCount + 1);
            }
        }
    }

    public static class RelationshipTypeMetrics {
        private int instanceCount = 0;
        private final Map<String, Integer> entityAtEnd1Count = new HashMap<String, Integer>();
        private final Map<String, Integer> entityAtEnd2Count = new HashMap<String, Integer>();
        private final Map<String, Integer> entityPairCount = new HashMap<String, Integer>();

        void incrementInstanceCount() {
            ++this.instanceCount;
        }

        void incrementEntityAtEnd1Count(String entityTypeName) {
            Integer currentCount = this.entityAtEnd1Count.get(entityTypeName);
            if (currentCount == null) {
                this.entityAtEnd1Count.put(entityTypeName, 0);
            } else {
                this.entityAtEnd1Count.put(entityTypeName, currentCount + 1);
            }
        }

        void incrementEntityAtEnd2Count(String entityTypeName) {
            Integer currentCount = this.entityAtEnd2Count.get(entityTypeName);
            if (currentCount == null) {
                this.entityAtEnd2Count.put(entityTypeName, 0);
            } else {
                this.entityAtEnd2Count.put(entityTypeName, currentCount + 1);
            }
        }

        void incrementEntityPairCount(String entityOneTypeName, String entityTwoTypeName) {
            String pairName = entityOneTypeName + ":" + entityTwoTypeName;
            Integer currentCount = this.entityPairCount.get(pairName);
            if (currentCount == null) {
                this.entityPairCount.put(pairName, 0);
            } else {
                this.entityPairCount.put(entityOneTypeName, currentCount + 1);
            }
        }
    }
}

