/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.survey;

import java.util.ArrayList;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.controls.AtlasDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.controls.AtlasAnnotationType;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.controls.AtlasRequestParameter;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.connectors.controls.SupportedTechnologyType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceProvider;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;

public class SurveyApacheAtlasProvider
extends SurveyActionServiceProvider {
    private static final int connectorComponentId = 665;
    private static final String connectorTypeGUID = "095de44e-fe18-4849-bf08-4d91d9ea3e35";
    private static final String connectorQualifiedName = "Egeria:SurveyActionService:SurveyApacheAtlas";
    private static final String connectorDisplayName = "Apache Atlas Survey Action Service";
    private static final String connectorDescription = "Discovers the types and number of instances within an Apache Atlas server.";
    private static final String connectorWikiPage = "https://egeria-project.org/connectors/apache-atlas/apache-atlas-survey-action-service/";
    private static final String connectorClassName = "org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.SurveyApacheAtlasConnector";

    public SurveyApacheAtlasProvider() {
        super.setConnectorClassName(connectorClassName);
        ConnectorType connectorType = new ConnectorType();
        connectorType.setType(ConnectorType.getConnectorTypeType());
        connectorType.setGUID(connectorTypeGUID);
        connectorType.setQualifiedName(connectorQualifiedName);
        connectorType.setDisplayName(connectorDisplayName);
        connectorType.setDescription(connectorDescription);
        connectorType.setConnectorProviderClassName(((Object)((Object)this)).getClass().getName());
        connectorType.setSupportedAssetTypeName(SurveyActionServiceProvider.supportedAssetTypeName);
        connectorType.setSupportedDeployedImplementationType(supportedDeployedImplementationType);
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(AtlasRequestParameter.FINAL_ANALYSIS_STEP.getName());
        connectorType.setRecognizedConfigurationProperties(recognizedConfigurationProperties);
        this.connectorTypeBean = connectorType;
        this.supportedAnalysisSteps = AnalysisStep.getAnalysisStepTypes((AnalysisStep[])new AnalysisStep[]{AnalysisStep.CHECK_ASSET, AnalysisStep.MEASURE_RESOURCE, AnalysisStep.SCHEMA_EXTRACTION, AnalysisStep.PROFILE_DATA});
        this.producedAnnotationTypes = AtlasAnnotationType.getAnnotationTypeTypes();
        this.supportedRequestParameters = AtlasRequestParameter.getRequestParameterTypes();
        this.supportedActionTargetTypes = new ArrayList();
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName("*");
        actionTargetType.setDescription("Any Software Server entity that represents an Apache Atlas server linked to the connection for the Apache Atlas REST API connector.");
        actionTargetType.setTypeName(AtlasDeployedImplementationType.APACHE_ATLAS_SERVER.getAssociatedTypeName());
        actionTargetType.setDeployedImplementationType(AtlasDeployedImplementationType.APACHE_ATLAS_SERVER.getDeployedImplementationType());
        this.supportedActionTargetTypes.add(actionTargetType);
        this.supportedTechnologyTypes = SupportedTechnologyType.getSupportedTechnologyTypes((DeployedImplementationTypeDefinition[])new DeployedImplementationTypeDefinition[]{AtlasDeployedImplementationType.APACHE_ATLAS_SERVER});
        AuditLogReportingComponent componentDescription = new AuditLogReportingComponent();
        componentDescription.setComponentId(665);
        componentDescription.setComponentDevelopmentStatus(ComponentDevelopmentStatus.STABLE);
        componentDescription.setComponentName(connectorDisplayName);
        componentDescription.setComponentDescription(connectorDescription);
        componentDescription.setComponentWikiURL(connectorWikiPage);
        super.setConnectorComponentDescription((ComponentDescription)componentDescription);
    }
}

