/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.controls;

import java.util.ArrayList;
import java.util.List;

public enum AtlasMetric {
    ENTITY_INSTANCE_COUNT("entityInstanceCount", "Number of entities stored in the Apache Atlas server."),
    CLASSIFICATION_COUNT("classificationCount", "Number of tags (classifications) attached to entities stored in the Apache Atlas server."),
    TYPE_UNUSED_COUNT("typeUnusedCount", "Number of types that are not used in the Apache Atlas server."),
    TYPE_COUNT("typeCount", "Number of types defined in the Apache Atlas server."),
    CLASSIFIED_ENTITY_COUNT("classifiedEntityCount:", "Number of entities with tags (classifications) attached in the Apache Atlas server."),
    ENTITY_TYPE_INSTANCE_COUNT("entityInstanceCount:typeName", "Number of active entity instances stored in the Apache Atlas server for each entity type."),
    ENTITY_WITH_SUB_TYPE_INSTANCE_COUNT("entityWithSubtypesInstanceCount:typeName", "Number of active entity instances stored in the Apache Atlas server for each entity type (with its subtypes included in the count)."),
    ENTITY_DEF_COUNT("entityDefs", "Number of entity type definitions (EntityDefs) defined in the Apache Atlas server."),
    RELATIONSHIP_DEF_COUNT("relationshipDefs", "Number of relationship type definitions (RelationshipDefs) defined in the Apache Atlas server."),
    CLASSIFICATION_DEF_COUNT("classificationDefs", "Number of classification type definitions (ClassificationDefs) defined in the Apache Atlas server."),
    BUSINESS_METADATA_DEF_COUNT("businessMetadataDefs", "Number of business metadata type definitions (BusinessMetadataDefs) defined in the Apache Atlas server.");

    public final String name;
    public final String description;

    private AtlasMetric(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    static List<AtlasMetric> getAtlasMetrics() {
        return new ArrayList<AtlasMetric>(List.of(AtlasMetric.values()));
    }

    public String toString() {
        return "AtlasMetric{" + this.name + "}";
    }
}

