/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationErrorCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasRegisteredIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasObjectId;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasRelationship;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CorrelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryCategoryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.GlossaryExchangeService;

public class AtlasGlossaryIntegrationModule
extends AtlasRegisteredIntegrationModuleBase {
    private static final String moduleName = "Glossary Integration Module";
    private static final String atlasGlossaryTypeName = "AtlasGlossary";
    private static final String atlasGlossaryCategoriesPropertyName = "categories";
    private static final String atlasGlossaryCategoryTypeName = "AtlasGlossaryCategory";
    private static final String atlasParentCategoryPropertyName = "parentCategory";
    private static final String atlasGlossaryTermsPropertyName = "terms";
    private static final String atlasGlossaryTermTypeName = "AtlasGlossaryTerm";
    private static final String atlasSemanticAssignmentTypeName = "AtlasGlossarySemanticAssignment";
    private static final String atlasTermCategorizationTypeName = "AtlasGlossaryTermCategorization";
    private static final String atlasCategoryHierarchyTypeName = "AtlasGlossaryCategoryHierarchyLink";
    private static final String atlasGlossaryAnchorPropertyName = "anchor";
    private static final String atlasShortDescriptionPropertyName = "shortDescription";
    private static final String atlasLongDescriptionPropertyName = "longDescription";
    private static final String atlasAdditionalAttributesPropertyName = "additionalAttributes";
    private static final String atlasLanguagePropertyName = "language";
    private static final String atlasUsagePropertyName = "usage";
    private static final String atlasExamplesPropertyName = "examples";
    private static final String atlasAbbreviationPropertyName = "abbreviation";
    private static final String egeriaGlossaryTypeName = "Glossary";
    private static final String egeriaGlossaryCategoryTypeName = "GlossaryCategory";
    private static final String egeriaGlossaryTermTypeName = "GlossaryTerm";
    private String fixedEgeriaGlossaryQualifiedName = null;
    private String fixedEgeriaGlossaryGUID = null;
    private String atlasGlossaryName = null;
    private final GlossaryExchangeService glossaryExchangeService;

    public AtlasGlossaryIntegrationModule(String connectorName, ConnectionDetails connectionDetails, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors) throws UserNotAuthorizedException {
        super(connectorName, moduleName, connectionDetails, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors, new String[]{egeriaGlossaryTypeName, egeriaGlossaryCategoryTypeName, egeriaGlossaryTermTypeName}, new String[]{egeriaGlossaryTypeName, egeriaGlossaryCategoryTypeName, egeriaGlossaryTermTypeName});
        String methodName = "AtlasGlossaryIntegrationModule()";
        Map configurationProperties = connectionDetails.getConfigurationProperties();
        if (configurationProperties != null) {
            if (configurationProperties.get("egeriaGlossaryQualifiedName") != null) {
                this.fixedEgeriaGlossaryQualifiedName = configurationProperties.get("egeriaGlossaryQualifiedName").toString();
            }
            if (configurationProperties.get("atlasGlossaryName") != null) {
                this.atlasGlossaryName = configurationProperties.get("atlasGlossaryName").toString();
            }
        }
        if (auditLog != null) {
            if (this.fixedEgeriaGlossaryQualifiedName == null) {
                auditLog.logMessage("AtlasGlossaryIntegrationModule()", AtlasIntegrationAuditCode.CONNECTOR_CONFIGURATION_ALL_EGERIA_GLOSSARIES.getMessageDefinition(connectorName, targetRootURL));
            } else {
                auditLog.logMessage("AtlasGlossaryIntegrationModule()", AtlasIntegrationAuditCode.CONNECTOR_CONFIGURATION_SPECIFIC_EGERIA_GLOSSARIES.getMessageDefinition(connectorName, targetRootURL, this.fixedEgeriaGlossaryQualifiedName));
            }
            if (this.atlasGlossaryName == null) {
                auditLog.logMessage("AtlasGlossaryIntegrationModule()", AtlasIntegrationAuditCode.CONNECTOR_CONFIGURATION_ALL_ATLAS_GLOSSARIES.getMessageDefinition(connectorName, targetRootURL));
            } else {
                auditLog.logMessage("AtlasGlossaryIntegrationModule()", AtlasIntegrationAuditCode.CONNECTOR_CONFIGURATION_SPECIFIC_ATLAS_GLOSSARIES.getMessageDefinition(connectorName, targetRootURL, this.atlasGlossaryName));
            }
        }
        this.glossaryExchangeService = myContext.getGlossaryExchangeService();
        this.glossaryExchangeService.setForDuplicateProcessing(true);
    }

    @Override
    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        try {
            if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
                if (this.fixedEgeriaGlossaryQualifiedName == null) {
                    List glossaries = this.glossaryExchangeService.findGlossaries(".*", 0, 0, new Date());
                    if (glossaries != null) {
                        for (GlossaryElement glossary : glossaries) {
                            this.processGlossaryFromEgeria(glossary);
                        }
                    }
                } else {
                    GlossaryElement glossary = this.getGlossaryByQualifiedName(this.fixedEgeriaGlossaryQualifiedName, "refresh");
                    if (glossary != null) {
                        this.processGlossaryFromEgeria(glossary);
                    } else if (this.auditLog != null) {
                        this.auditLog.logMessage("refresh", AtlasIntegrationAuditCode.UNABLE_TO_RETRIEVE_EGERIA_GLOSSARY.getMessageDefinition(this.connectorName, this.fixedEgeriaGlossaryQualifiedName));
                    }
                }
            }
            if (this.myContext.getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || this.myContext.getPermittedSynchronization() == PermittedSynchronization.FROM_THIRD_PARTY) {
                boolean requestedAtlasGlossaryMissing = this.atlasGlossaryName != null;
                int startFrom = 0;
                int pageSize = this.myContext.getMaxPageSize();
                List<AtlasEntityHeader> atlasSearchResult = this.atlasClient.getEntitiesForType(atlasGlossaryTypeName, startFrom, pageSize);
                while (atlasSearchResult != null && !atlasSearchResult.isEmpty()) {
                    for (AtlasEntityHeader atlasEntityHeader : atlasSearchResult) {
                        String atlasGlossaryGUID = atlasEntityHeader.getGuid();
                        AtlasEntityWithExtInfo atlasGlossaryEntity = this.atlasClient.getEntityByGUID(atlasGlossaryGUID);
                        if (this.atlasGlossaryName == null) {
                            this.processGlossaryFromAtlas(atlasGlossaryEntity);
                        } else if (this.atlasGlossaryName.equals(this.getAtlasStringProperty(atlasGlossaryEntity.getEntity().getAttributes(), "name"))) {
                            this.processGlossaryFromAtlas(atlasGlossaryEntity);
                            requestedAtlasGlossaryMissing = false;
                        }
                        atlasSearchResult = this.atlasClient.getEntitiesForType(atlasGlossaryTypeName, startFrom += pageSize, pageSize);
                    }
                }
                if (requestedAtlasGlossaryMissing && this.auditLog != null) {
                    this.auditLog.logMessage("refresh", AtlasIntegrationAuditCode.UNABLE_TO_RETRIEVE_ATLAS_GLOSSARY.getMessageDefinition(this.connectorName, this.atlasGlossaryName));
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("refresh", AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), this.getClass().getName(), "refresh", error);
        }
    }

    @Override
    public void processEvent(AssetManagerOutTopicEvent event) {
        block12: {
            if (!this.myContext.isRefreshInProgress()) {
                try {
                    ElementHeader elementHeader = event.getElementHeader();
                    if (elementHeader != null && !this.isAtlasOwnedElement(elementHeader)) {
                        GlossaryElement egeriaGlossary;
                        GlossaryCategoryElement egeriaGlossaryCategory;
                        if (this.myContext.isTypeOf(elementHeader, egeriaGlossaryTypeName)) {
                            if (this.validGlossaryElement(elementHeader)) {
                                this.processGlossaryFromEgeria(this.glossaryExchangeService.getGlossaryByGUID(elementHeader.getGUID(), null));
                            }
                        } else if (this.myContext.isTypeOf(elementHeader, egeriaGlossaryTermTypeName)) {
                            GlossaryElement egeriaGlossary2;
                            GlossaryTermElement egeriaGlossaryTerm = this.glossaryExchangeService.getGlossaryTermByGUID(elementHeader.getGUID(), null);
                            if (egeriaGlossaryTerm != null && (egeriaGlossary2 = this.glossaryExchangeService.getGlossaryForTerm(elementHeader.getGUID(), null)) != null && this.validGlossaryElement(egeriaGlossary2.getElementHeader())) {
                                AtlasEntityWithExtInfo atlasGlossary = this.getAtlasDestinationGlossaryForEgeriaEntity(egeriaGlossary2);
                                this.processGlossaryTermFromEgeria(egeriaGlossaryTerm, egeriaGlossary2, atlasGlossary);
                            }
                        } else if (this.myContext.isTypeOf(elementHeader, egeriaGlossaryCategoryTypeName) && (egeriaGlossaryCategory = this.glossaryExchangeService.getGlossaryCategoryByGUID(elementHeader.getGUID(), null)) != null && (egeriaGlossary = this.glossaryExchangeService.getGlossaryForCategory(elementHeader.getGUID(), null)) != null) {
                            AtlasEntityWithExtInfo atlasGlossary = this.getAtlasDestinationGlossaryForEgeriaEntity(egeriaGlossary);
                            this.processGlossaryCategoryFromEgeria(egeriaGlossaryCategory, atlasGlossary);
                        }
                    }
                }
                catch (InvalidParameterException elementHeader) {
                }
                catch (Exception error) {
                    String methodName = "processEvent";
                    if (this.auditLog == null) break block12;
                    this.auditLog.logException("processEvent", AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processEvent", error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private boolean validGlossaryElement(ElementHeader elementHeader) throws ConnectorCheckedException {
        String methodName = "validGlossaryElement";
        if (this.fixedEgeriaGlossaryQualifiedName != null) {
            GlossaryElement glossaryElement;
            String glossaryGUID = elementHeader.getGUID();
            if (this.fixedEgeriaGlossaryGUID == null && (glossaryElement = this.getGlossaryByQualifiedName(this.fixedEgeriaGlossaryQualifiedName, "validGlossaryElement")) != null) {
                this.fixedEgeriaGlossaryGUID = glossaryElement.getElementHeader().getGUID();
            }
            return glossaryGUID.equals(this.fixedEgeriaGlossaryGUID);
        }
        return true;
    }

    private String retryGetAtlasGUID(GlossaryTermElement metadataElement) {
        try {
            GlossaryTermElement refreshedTerm = this.glossaryExchangeService.getGlossaryTermByGUID(metadataElement.getElementHeader().getGUID(), null);
            return this.getAtlasGUID((CorrelatedMetadataElement)refreshedTerm);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void processGlossaryFromEgeria(GlossaryElement egeriaGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "processGlossaryFromEgeria";
        if (egeriaGlossary != null) {
            if (this.isAtlasOwnedElement(egeriaGlossary.getElementHeader())) {
                String atlasGlossaryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaGlossary);
                if (atlasGlossaryGUID != null) {
                    AtlasEntityWithExtInfo atlasGlossary = this.atlasClient.getEntityByGUID(atlasGlossaryGUID);
                    this.updateAtlasGlossaryInEgeria(atlasGlossary, egeriaGlossary.getElementHeader().getGUID());
                    this.processGlossaryCategoriesFromEgeria(egeriaGlossary, atlasGlossary);
                    this.processGlossaryTermsFromEgeria(egeriaGlossary, atlasGlossary);
                } else {
                    this.auditLog.logMessage("processGlossaryFromEgeria", AtlasIntegrationAuditCode.EGERIA_GUID_MISSING.getMessageDefinition(egeriaGlossaryTypeName, egeriaGlossary.getElementHeader().getGUID()));
                }
            } else {
                AtlasEntityWithExtInfo atlasGlossary = this.syncEgeriaGlossaryInAtlas(egeriaGlossary);
                this.processGlossaryCategoriesFromEgeria(egeriaGlossary, atlasGlossary);
                this.processGlossaryTermsFromEgeria(egeriaGlossary, atlasGlossary);
            }
        }
    }

    private void processGlossaryTermsFromEgeria(GlossaryElement egeriaGlossary, AtlasEntityWithExtInfo atlasGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (egeriaGlossary != null) {
            int startFrom = 0;
            List egeriaGlossaryTerms = this.glossaryExchangeService.getTermsForGlossary(egeriaGlossary.getElementHeader().getGUID(), startFrom, this.myContext.getMaxPageSize(), new Date());
            while (egeriaGlossaryTerms != null) {
                for (GlossaryTermElement egeriaGlossaryTerm : egeriaGlossaryTerms) {
                    this.processGlossaryTermFromEgeria(egeriaGlossaryTerm, egeriaGlossary, atlasGlossary);
                }
                egeriaGlossaryTerms = this.glossaryExchangeService.getTermsForGlossary(egeriaGlossary.getElementHeader().getGUID(), startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
            }
        }
    }

    private void processGlossaryTermFromEgeria(GlossaryTermElement egeriaGlossaryTerm, GlossaryElement egeriaGlossary, AtlasEntityWithExtInfo atlasGlossary) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (egeriaGlossaryTerm != null) {
            String methodName = "processGlossaryTermFromEgeria";
            if (this.isAtlasOwnedElement(egeriaGlossaryTerm.getElementHeader())) {
                String atlasGlossaryTermGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaGlossaryTerm);
                if (atlasGlossaryTermGUID != null) {
                    this.updateAtlasGlossaryTermInEgeria(this.atlasClient.getEntityByGUID(atlasGlossaryTermGUID), egeriaGlossaryTerm);
                } else if (this.auditLog != null) {
                    this.auditLog.logMessage("processGlossaryTermFromEgeria", AtlasIntegrationAuditCode.EGERIA_GUID_MISSING.getMessageDefinition(egeriaGlossaryTermTypeName, egeriaGlossaryTerm.getElementHeader().getGUID()));
                }
            } else {
                this.syncEgeriaGlossaryTermInAtlas(egeriaGlossaryTerm, atlasGlossary);
            }
        }
    }

    private void processGlossaryCategoriesFromEgeria(GlossaryElement egeriaGlossary, AtlasEntityWithExtInfo atlasGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (egeriaGlossary != null) {
            int startFrom = 0;
            List egeriaGlossaryCategories = this.glossaryExchangeService.getCategoriesForGlossary(egeriaGlossary.getElementHeader().getGUID(), startFrom, this.myContext.getMaxPageSize(), new Date());
            while (egeriaGlossaryCategories != null) {
                for (GlossaryCategoryElement egeriaGlossaryCategory : egeriaGlossaryCategories) {
                    this.processGlossaryCategoryFromEgeria(egeriaGlossaryCategory, atlasGlossary);
                }
                egeriaGlossaryCategories = this.glossaryExchangeService.getCategoriesForGlossary(egeriaGlossary.getElementHeader().getGUID(), startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
            }
        }
    }

    private void processGlossaryCategoryFromEgeria(GlossaryCategoryElement glossaryCategoryElement, AtlasEntityWithExtInfo atlasGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "processGlossaryCategoryFromEgeria";
        if (this.isAtlasOwnedElement(glossaryCategoryElement.getElementHeader())) {
            String atlasGlossaryCategoryGUID = this.getAtlasGUID((CorrelatedMetadataElement)glossaryCategoryElement);
            if (atlasGlossaryCategoryGUID != null) {
                this.updateAtlasGlossaryCategoryInEgeria(this.atlasClient.getEntityByGUID(atlasGlossaryCategoryGUID), glossaryCategoryElement);
            } else {
                this.auditLog.logMessage("processGlossaryCategoryFromEgeria", AtlasIntegrationAuditCode.EGERIA_GUID_MISSING.getMessageDefinition(egeriaGlossaryCategoryTypeName, glossaryCategoryElement.getElementHeader().getGUID()));
            }
        } else {
            this.syncEgeriaGlossaryCategoryInAtlas(glossaryCategoryElement, atlasGlossary);
        }
    }

    private void processGlossaryFromAtlas(AtlasEntityWithExtInfo atlasGlossaryElement) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "processGlossaryFromAtlas";
        String egeriaGlossaryGUID = this.getEgeriaGUID(atlasGlossaryElement);
        if (egeriaGlossaryGUID == null) {
            egeriaGlossaryGUID = this.createAtlasGlossaryInEgeria(atlasGlossaryElement);
            GlossaryElement egeriaGlossary = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, null);
            this.processGlossaryCategoriesFromAtlas(atlasGlossaryElement, egeriaGlossary);
            this.processGlossaryTermsFromAtlas(atlasGlossaryElement, egeriaGlossary);
        } else if (this.isEgeriaOwned(atlasGlossaryElement)) {
            GlossaryElement egeriaGlossary;
            block12: {
                egeriaGlossary = null;
                try {
                    egeriaGlossary = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, null);
                }
                catch (InvalidParameterException missingGlossary) {
                    if (this.auditLog == null) break block12;
                    this.auditLog.logMessage("processGlossaryFromAtlas", AtlasIntegrationAuditCode.EGERIA_GLOSSARY_DELETED.getMessageDefinition(egeriaGlossaryGUID, this.getAtlasStringProperty(atlasGlossaryElement.getEntity().getAttributes(), "name")));
                }
            }
            if (egeriaGlossary == null) {
                this.atlasClient.deleteEntity(atlasGlossaryElement.getEntity().getGuid());
            } else {
                AtlasEntityWithExtInfo atlasGlossary = this.syncEgeriaGlossaryInAtlas(egeriaGlossary);
                this.processGlossaryCategoriesFromEgeria(egeriaGlossary, atlasGlossary);
                this.processGlossaryTermsFromEgeria(egeriaGlossary, atlasGlossary);
            }
        } else {
            GlossaryElement egeriaGlossary = null;
            try {
                egeriaGlossary = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, new Date());
            }
            catch (InvalidParameterException missingGlossary) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processGlossaryFromAtlas", AtlasIntegrationAuditCode.REPLACING_EGERIA_GLOSSARY.getMessageDefinition(egeriaGlossaryGUID, this.getAtlasStringProperty(atlasGlossaryElement.getEntity().getAttributes(), "name"), this.connectorName));
                }
                this.removeEgeriaGUID(atlasGlossaryElement);
            }
            egeriaGlossary = this.syncAtlasGlossaryInEgeria(atlasGlossaryElement);
            if (egeriaGlossary != null) {
                this.processGlossaryCategoriesFromAtlas(atlasGlossaryElement, egeriaGlossary);
                this.processGlossaryTermsFromAtlas(atlasGlossaryElement, egeriaGlossary);
            }
        }
    }

    private void processGlossaryTermsFromAtlas(AtlasEntityWithExtInfo atlasGlossaryElement, GlossaryElement egeriaGlossary) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        List<AtlasEntityWithExtInfo> terms;
        if (atlasGlossaryElement != null && atlasGlossaryElement.getEntity() != null && atlasGlossaryElement.getEntity().getRelationshipAttributes() != null && (terms = this.atlasClient.getRelatedEntities(atlasGlossaryElement, atlasGlossaryTermsPropertyName)) != null) {
            for (AtlasEntityWithExtInfo relatedAtlasTerm : terms) {
                this.processGlossaryTermFromAtlas(relatedAtlasTerm, atlasGlossaryElement, egeriaGlossary);
            }
        }
    }

    private void processGlossaryTermFromAtlas(AtlasEntityWithExtInfo atlasGlossaryTerm, AtlasEntityWithExtInfo atlasGlossary, GlossaryElement egeriaGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "processAtlasGlossaryTerm";
        String egeriaTermGUID = this.getEgeriaGUID(atlasGlossaryTerm);
        if (egeriaTermGUID == null) {
            this.createAtlasGlossaryTermInEgeria(atlasGlossaryTerm, egeriaGlossary);
        } else if (this.isEgeriaOwned(atlasGlossaryTerm)) {
            GlossaryTermElement egeriaGlossaryTerm = null;
            try {
                egeriaGlossaryTerm = this.glossaryExchangeService.getGlossaryTermByGUID(egeriaTermGUID, new Date());
            }
            catch (InvalidParameterException missingTerm) {
                this.auditLog.logMessage("processAtlasGlossaryTerm", AtlasIntegrationAuditCode.EGERIA_GLOSSARY_TERM_DELETED.getMessageDefinition(egeriaTermGUID, this.getAtlasStringProperty(atlasGlossaryTerm.getEntity().getAttributes(), "qualifiedName")));
            }
            if (egeriaGlossaryTerm == null) {
                this.atlasClient.deleteEntity(atlasGlossaryTerm.getEntity().getGuid());
            } else {
                this.syncEgeriaGlossaryTermInAtlas(egeriaGlossaryTerm, atlasGlossary);
            }
        } else {
            GlossaryTermElement egeriaGlossaryTerm = null;
            try {
                egeriaGlossaryTerm = this.glossaryExchangeService.getGlossaryTermByGUID(egeriaTermGUID, new Date());
            }
            catch (InvalidParameterException missingTerm) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processAtlasGlossaryTerm", AtlasIntegrationAuditCode.REPLACING_EGERIA_GLOSSARY_TERM.getMessageDefinition(egeriaTermGUID, this.getAtlasStringProperty(atlasGlossaryTerm.getEntity().getAttributes(), "name"), this.connectorName));
                }
                this.removeEgeriaGUID(atlasGlossaryTerm);
            }
            if (egeriaGlossaryTerm == null) {
                this.createAtlasGlossaryTermInEgeria(atlasGlossaryTerm, egeriaGlossary);
            } else {
                this.updateAtlasGlossaryTermInEgeria(atlasGlossaryTerm, egeriaGlossaryTerm);
            }
        }
    }

    private void processGlossaryCategoriesFromAtlas(AtlasEntityWithExtInfo atlasGlossaryElement, GlossaryElement egeriaGlossary) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        List<AtlasEntityWithExtInfo> categories;
        if (atlasGlossaryElement != null && (categories = this.atlasClient.getRelatedEntities(atlasGlossaryElement, atlasGlossaryCategoriesPropertyName)) != null) {
            for (AtlasEntityWithExtInfo relatedAtlasCategory : categories) {
                this.processGlossaryCategoryFromAtlas(relatedAtlasCategory, atlasGlossaryElement, egeriaGlossary);
            }
        }
    }

    private void processGlossaryCategoryFromAtlas(AtlasEntityWithExtInfo atlasGlossaryCategory, AtlasEntityWithExtInfo atlasGlossary, GlossaryElement egeriaGlossary) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "processGlossaryCategoryFromAtlas";
        String egeriaCategoryGUID = this.getEgeriaGUID(atlasGlossaryCategory);
        if (egeriaCategoryGUID == null) {
            this.createAtlasGlossaryCategoryInEgeria(atlasGlossaryCategory, egeriaGlossary);
        } else if (this.isEgeriaOwned(atlasGlossaryCategory)) {
            GlossaryCategoryElement egeriaGlossaryCategory;
            block13: {
                egeriaGlossaryCategory = null;
                try {
                    egeriaGlossaryCategory = this.glossaryExchangeService.getGlossaryCategoryByGUID(egeriaCategoryGUID, new Date());
                }
                catch (InvalidParameterException missingCategory) {
                    if (this.auditLog == null) break block13;
                    this.auditLog.logMessage("processGlossaryCategoryFromAtlas", AtlasIntegrationAuditCode.EGERIA_GLOSSARY_CATEGORY_DELETED.getMessageDefinition(egeriaCategoryGUID, this.getAtlasStringProperty(atlasGlossaryCategory.getEntity().getAttributes(), "name")));
                }
            }
            if (egeriaGlossaryCategory == null) {
                this.atlasClient.deleteEntity(atlasGlossaryCategory.getEntity().getGuid());
            } else {
                this.syncEgeriaGlossaryCategoryInAtlas(egeriaGlossaryCategory, atlasGlossary);
            }
        } else {
            GlossaryCategoryElement egeriaGlossaryCategory = null;
            try {
                egeriaGlossaryCategory = this.glossaryExchangeService.getGlossaryCategoryByGUID(egeriaCategoryGUID, new Date());
            }
            catch (InvalidParameterException missingCategory) {
                if (this.auditLog != null) {
                    this.auditLog.logMessage("processGlossaryCategoryFromAtlas", AtlasIntegrationAuditCode.REPLACING_EGERIA_GLOSSARY_CATEGORY.getMessageDefinition(egeriaCategoryGUID, this.getAtlasStringProperty(atlasGlossaryCategory.getEntity().getAttributes(), "name"), this.connectorName));
                }
                this.removeEgeriaGUID(atlasGlossaryCategory);
            }
            if (egeriaGlossaryCategory == null) {
                this.createAtlasGlossaryCategoryInEgeria(atlasGlossaryCategory, egeriaGlossary);
            } else {
                this.updateAtlasGlossaryCategoryInEgeria(atlasGlossaryCategory, egeriaGlossaryCategory);
            }
        }
    }

    private AtlasEntityWithExtInfo syncEgeriaGlossaryInAtlas(GlossaryElement egeriaGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (egeriaGlossary != null) {
            AtlasEntityWithExtInfo atlasGlossary;
            String atlasGlossaryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaGlossary);
            atlasGlossary = atlasGlossaryGUID == null ? this.createEgeriaGlossaryInAtlas(egeriaGlossary) : ((atlasGlossary = this.atlasClient.getEntityByGUID(atlasGlossaryGUID)) != null ? this.updateEgeriaGlossaryInAtlas(egeriaGlossary, atlasGlossary) : this.createEgeriaGlossaryInAtlas(egeriaGlossary));
            return atlasGlossary;
        }
        return null;
    }

    AtlasEntityWithExtInfo createEgeriaGlossaryInAtlas(GlossaryElement egeriaGlossary) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createEgeriaGlossaryInAtlas";
        AtlasEntityWithExtInfo atlasGlossary = this.prepareGlossaryMemberEntity(null, atlasGlossaryTypeName, this.getAtlasGlossaryProperties(egeriaGlossary), null);
        String atlasGlossaryGUID = this.atlasClient.addEntity(atlasGlossary.getEntity());
        this.auditLog.logMessage("createEgeriaGlossaryInAtlas", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryTypeName, egeriaGlossary.getElementHeader().getGUID(), atlasGlossary.getEntity().getTypeName(), atlasGlossaryGUID));
        this.saveEgeriaGUIDInAtlas(atlasGlossaryGUID, egeriaGlossary.getElementHeader().getGUID(), egeriaGlossary.getGlossaryProperties().getQualifiedName(), egeriaGlossaryTypeName, true, true);
        atlasGlossary = this.atlasClient.getEntityByGUID(atlasGlossaryGUID);
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryGUID, atlasGlossaryTypeName, super.getAtlasStringProperty(atlasGlossary.getEntity().getAttributes(), "name"), egeriaGlossary.getGlossaryProperties().getDisplayName(), atlasGlossary.getEntity().getCreatedBy(), atlasGlossary.getEntity().getCreateTime(), atlasGlossary.getEntity().getUpdatedBy(), atlasGlossary.getEntity().getUpdateTime(), atlasGlossary.getEntity().getVersion(), PermittedSynchronization.TO_THIRD_PARTY);
        this.myContext.addExternalIdentifier(egeriaGlossary.getElementHeader().getGUID(), egeriaGlossary.getElementHeader().getType().getTypeName(), externalIdentifierProperties);
        return atlasGlossary;
    }

    private AtlasEntityWithExtInfo updateEgeriaGlossaryInAtlas(GlossaryElement egeriaGlossaryElement, AtlasEntityWithExtInfo atlasGlossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEgeriaGlossaryInAtlas";
        if (egeriaGlossaryElement != null) {
            if (this.atlasUpdateRequired(atlasGlossary.getEntity().getGuid(), atlasGlossaryTypeName, (CorrelatedMetadataElement)egeriaGlossaryElement, atlasGlossary.getEntity())) {
                AtlasEntityWithExtInfo latestAtlasGlossary = this.prepareGlossaryMemberEntity(atlasGlossary.getEntity().getGuid(), atlasGlossaryTypeName, this.getAtlasGlossaryProperties(egeriaGlossaryElement), null);
                latestAtlasGlossary = this.atlasClient.updateEntity(latestAtlasGlossary);
                this.updateExternalIdentifierAfterAtlasUpdate(egeriaGlossaryElement.getElementHeader().getGUID(), egeriaGlossaryTypeName, latestAtlasGlossary.getEntity());
                this.auditLog.logMessage("updateEgeriaGlossaryInAtlas", AtlasIntegrationAuditCode.UPDATING_ATLAS_ENTITY.getMessageDefinition(this.connectorName, atlasGlossaryTypeName, egeriaGlossaryElement.getElementHeader().getGUID(), atlasGlossary.getEntity().getGuid()));
                return latestAtlasGlossary;
            }
            this.myContext.confirmSynchronization(egeriaGlossaryElement.getElementHeader().getGUID(), egeriaGlossaryTypeName, atlasGlossary.getEntity().getGuid());
        }
        return atlasGlossary;
    }

    private AtlasEntityWithExtInfo syncEgeriaGlossaryTermInAtlas(GlossaryTermElement egeriaGlossaryTerm, AtlasEntityWithExtInfo atlasGlossaryDestination) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (egeriaGlossaryTerm != null) {
            AtlasEntityWithExtInfo atlasGlossaryTerm;
            String atlasGlossaryTermGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaGlossaryTerm);
            atlasGlossaryTerm = atlasGlossaryTermGUID == null ? this.createEgeriaGlossaryTermInAtlas(egeriaGlossaryTerm, atlasGlossaryDestination) : ((atlasGlossaryTerm = this.atlasClient.getEntityByGUID(atlasGlossaryTermGUID)) != null ? this.updateEgeriaGlossaryTermInAtlas(egeriaGlossaryTerm, atlasGlossaryTerm, atlasGlossaryDestination) : this.createEgeriaGlossaryTermInAtlas(egeriaGlossaryTerm, atlasGlossaryDestination));
            this.syncEgeriaGlossaryTermCategoriesInAtlas(egeriaGlossaryTerm, atlasGlossaryTerm);
            return atlasGlossaryTerm;
        }
        return null;
    }

    AtlasEntityWithExtInfo createEgeriaGlossaryTermInAtlas(GlossaryTermElement egeriaGlossaryTerm, AtlasEntityWithExtInfo atlasGlossaryDestination) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createEgeriaGlossaryTermInAtlas";
        AtlasEntityWithExtInfo atlasGlossaryTerm = this.prepareGlossaryMemberEntity(null, atlasGlossaryTermTypeName, this.getAtlasGlossaryTermProperties(egeriaGlossaryTerm, egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), null, null, atlasGlossaryDestination), atlasGlossaryDestination);
        String atlasGlossaryTermGUID = this.atlasClient.addEntity(atlasGlossaryTerm.getEntity());
        this.auditLog.logMessage("createEgeriaGlossaryTermInAtlas", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryTermTypeName, egeriaGlossaryTerm.getElementHeader().getGUID(), atlasGlossaryTerm.getEntity().getTypeName(), atlasGlossaryTermGUID));
        this.saveEgeriaGUIDInAtlas(atlasGlossaryTermGUID, egeriaGlossaryTerm.getElementHeader().getGUID(), egeriaGlossaryTerm.getGlossaryTermProperties().getQualifiedName(), egeriaGlossaryTermTypeName, true, true);
        atlasGlossaryTerm = this.atlasClient.getEntityByGUID(atlasGlossaryTermGUID);
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryTermGUID, atlasGlossaryTermTypeName, super.getAtlasStringProperty(atlasGlossaryTerm.getEntity().getAttributes(), "name"), egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), atlasGlossaryTerm.getEntity().getCreatedBy(), atlasGlossaryTerm.getEntity().getCreateTime(), atlasGlossaryTerm.getEntity().getUpdatedBy(), atlasGlossaryTerm.getEntity().getUpdateTime(), atlasGlossaryTerm.getEntity().getVersion(), PermittedSynchronization.TO_THIRD_PARTY);
        this.myContext.addExternalIdentifier(egeriaGlossaryTerm.getElementHeader().getGUID(), egeriaGlossaryTerm.getElementHeader().getType().getTypeName(), externalIdentifierProperties);
        return atlasGlossaryTerm;
    }

    private AtlasEntityWithExtInfo updateEgeriaGlossaryTermInAtlas(GlossaryTermElement egeriaGlossaryTerm, AtlasEntityWithExtInfo atlasGlossaryTerm, AtlasEntityWithExtInfo atlasGlossaryDestination) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEgeriaGlossaryTermInAtlas";
        if (egeriaGlossaryTerm != null) {
            if (this.atlasUpdateRequired(atlasGlossaryTerm.getEntity().getGuid(), atlasGlossaryTermTypeName, (CorrelatedMetadataElement)egeriaGlossaryTerm, atlasGlossaryTerm.getEntity())) {
                AtlasEntityWithExtInfo latestAtlasGlossaryTerm = this.prepareGlossaryMemberEntity(atlasGlossaryTerm.getEntity().getGuid(), atlasGlossaryTermTypeName, this.getAtlasGlossaryTermProperties(egeriaGlossaryTerm, egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), atlasGlossaryTerm.getEntity().getGuid(), atlasGlossaryTerm.getEntity().getTypeName(), atlasGlossaryTerm), atlasGlossaryDestination);
                latestAtlasGlossaryTerm = this.atlasClient.updateEntity(latestAtlasGlossaryTerm);
                this.updateExternalIdentifierAfterAtlasUpdate(egeriaGlossaryTerm.getElementHeader().getGUID(), egeriaGlossaryTermTypeName, latestAtlasGlossaryTerm.getEntity());
                this.auditLog.logMessage("updateEgeriaGlossaryTermInAtlas", AtlasIntegrationAuditCode.UPDATING_ATLAS_ENTITY.getMessageDefinition(this.connectorName, atlasGlossaryTermTypeName, egeriaGlossaryTerm.getElementHeader().getGUID(), atlasGlossaryTerm.getEntity().getGuid()));
                return latestAtlasGlossaryTerm;
            }
            this.myContext.confirmSynchronization(egeriaGlossaryTerm.getElementHeader().getGUID(), egeriaGlossaryTermTypeName, atlasGlossaryTerm.getEntity().getGuid());
        }
        return atlasGlossaryTerm;
    }

    private void syncEgeriaGlossaryTermCategoriesInAtlas(GlossaryTermElement egeriaGlossaryTerm, AtlasEntityWithExtInfo atlasGlossaryTerm) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (egeriaGlossaryTerm != null) {
            String egeriaGlossaryTermGUID = egeriaGlossaryTerm.getElementHeader().getGUID();
            String atlasGlossaryTermGUID = atlasGlossaryTerm.getEntity().getGuid();
            if (atlasGlossaryTermGUID != null) {
                ArrayList<String> atlasRelationshipGUIDsToKeep = new ArrayList<String>();
                int startFrom = 0;
                List egeriaCategories = this.glossaryExchangeService.getCategoriesForTerm(egeriaGlossaryTermGUID, startFrom, this.myContext.getMaxPageSize(), null);
                Map<String, String> relatedAtlasCategoryMap = this.atlasClient.getRelationships(atlasGlossaryTerm, atlasGlossaryCategoriesPropertyName);
                while (egeriaCategories != null) {
                    for (GlossaryCategoryElement egeriaCategory : egeriaCategories) {
                        String atlasCategoryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaCategory);
                        if (atlasCategoryGUID == null) continue;
                        String matchingAtlasCategoryGUID = null;
                        if (!relatedAtlasCategoryMap.isEmpty()) {
                            for (String relatedCategoryGUID : relatedAtlasCategoryMap.keySet()) {
                                if (!relatedCategoryGUID.equals(atlasCategoryGUID)) continue;
                                matchingAtlasCategoryGUID = relatedCategoryGUID;
                                break;
                            }
                        }
                        if (matchingAtlasCategoryGUID == null) {
                            AtlasRelationship atlasRelationship = new AtlasRelationship();
                            atlasRelationship.setTypeName(atlasTermCategorizationTypeName);
                            AtlasObjectId end1 = new AtlasObjectId();
                            end1.setGuid(atlasCategoryGUID);
                            atlasRelationship.setEnd1(end1);
                            AtlasObjectId end2 = new AtlasObjectId();
                            end2.setGuid(atlasGlossaryTermGUID);
                            atlasRelationship.setEnd2(end2);
                            this.atlasClient.addRelationship(atlasRelationship);
                            continue;
                        }
                        atlasRelationshipGUIDsToKeep.add(matchingAtlasCategoryGUID);
                    }
                    egeriaCategories = this.glossaryExchangeService.getCategoriesForTerm(egeriaGlossaryTermGUID, startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), null);
                }
                if (!relatedAtlasCategoryMap.isEmpty()) {
                    for (String relatedAtlasCategoryGUID : relatedAtlasCategoryMap.keySet()) {
                        if (atlasRelationshipGUIDsToKeep.contains(relatedAtlasCategoryGUID)) continue;
                        this.atlasClient.clearRelationship(relatedAtlasCategoryMap.get(relatedAtlasCategoryGUID));
                    }
                }
            }
        }
    }

    private AtlasEntityWithExtInfo syncEgeriaGlossaryCategoryInAtlas(GlossaryCategoryElement egeriaGlossaryCategory, AtlasEntityWithExtInfo atlasGlossaryDestination) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (egeriaGlossaryCategory != null) {
            AtlasEntityWithExtInfo atlasGlossaryCategory;
            String atlasGlossaryCategoryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaGlossaryCategory);
            atlasGlossaryCategory = atlasGlossaryCategoryGUID == null ? this.createEgeriaGlossaryCategoryInAtlas(egeriaGlossaryCategory, atlasGlossaryDestination) : ((atlasGlossaryCategory = this.atlasClient.getEntityByGUID(atlasGlossaryCategoryGUID)) != null ? this.updateEgeriaGlossaryCategoryInAtlas(egeriaGlossaryCategory, atlasGlossaryCategory, atlasGlossaryDestination) : this.createEgeriaGlossaryCategoryInAtlas(egeriaGlossaryCategory, atlasGlossaryDestination));
            this.syncEgeriaGlossaryCategoryHierarchyInAtlas(egeriaGlossaryCategory, atlasGlossaryCategory);
            return atlasGlossaryCategory;
        }
        return null;
    }

    AtlasEntityWithExtInfo createEgeriaGlossaryCategoryInAtlas(GlossaryCategoryElement egeriaGlossaryCategory, AtlasEntityWithExtInfo atlasGlossaryDestination) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createEgeriaGlossaryCategoryInAtlas";
        AtlasEntityWithExtInfo atlasGlossaryCategory = this.prepareGlossaryMemberEntity(null, atlasGlossaryCategoryTypeName, this.getAtlasGlossaryCategoryProperties(egeriaGlossaryCategory, egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), null, null, atlasGlossaryDestination), atlasGlossaryDestination);
        String atlasGlossaryCategoryGUID = this.atlasClient.addEntity(atlasGlossaryCategory.getEntity());
        this.auditLog.logMessage("createEgeriaGlossaryCategoryInAtlas", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryCategoryTypeName, egeriaGlossaryCategory.getElementHeader().getGUID(), atlasGlossaryCategory.getEntity().getTypeName(), atlasGlossaryCategoryGUID));
        this.saveEgeriaGUIDInAtlas(atlasGlossaryCategoryGUID, egeriaGlossaryCategory.getElementHeader().getGUID(), egeriaGlossaryCategory.getGlossaryCategoryProperties().getQualifiedName(), egeriaGlossaryCategoryTypeName, true, true);
        atlasGlossaryCategory = this.atlasClient.getEntityByGUID(atlasGlossaryCategoryGUID);
        ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryCategoryGUID, atlasGlossaryCategoryTypeName, super.getAtlasStringProperty(atlasGlossaryCategory.getEntity().getAttributes(), "name"), egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), atlasGlossaryCategory.getEntity().getCreatedBy(), atlasGlossaryCategory.getEntity().getCreateTime(), atlasGlossaryCategory.getEntity().getUpdatedBy(), atlasGlossaryCategory.getEntity().getUpdateTime(), atlasGlossaryCategory.getEntity().getVersion(), PermittedSynchronization.TO_THIRD_PARTY);
        this.myContext.addExternalIdentifier(egeriaGlossaryCategory.getElementHeader().getGUID(), egeriaGlossaryCategory.getElementHeader().getType().getTypeName(), externalIdentifierProperties);
        return atlasGlossaryCategory;
    }

    private AtlasEntityWithExtInfo updateEgeriaGlossaryCategoryInAtlas(GlossaryCategoryElement egeriaGlossaryCategory, AtlasEntityWithExtInfo atlasGlossaryCategory, AtlasEntityWithExtInfo atlasGlossaryDestination) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEgeriaGlossaryCategoryInAtlas";
        if (egeriaGlossaryCategory != null) {
            if (this.atlasUpdateRequired(atlasGlossaryCategory.getEntity().getGuid(), atlasGlossaryCategoryTypeName, (CorrelatedMetadataElement)egeriaGlossaryCategory, atlasGlossaryCategory.getEntity())) {
                AtlasEntityWithExtInfo latestAtlasGlossaryCategory = this.prepareGlossaryMemberEntity(atlasGlossaryCategory.getEntity().getGuid(), atlasGlossaryCategoryTypeName, this.getAtlasGlossaryCategoryProperties(egeriaGlossaryCategory, egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), atlasGlossaryCategory.getEntity().getGuid(), atlasGlossaryCategory.getEntity().getTypeName(), atlasGlossaryCategory), atlasGlossaryDestination);
                latestAtlasGlossaryCategory = this.atlasClient.updateEntity(latestAtlasGlossaryCategory);
                this.updateExternalIdentifierAfterAtlasUpdate(egeriaGlossaryCategory.getElementHeader().getGUID(), egeriaGlossaryCategoryTypeName, latestAtlasGlossaryCategory.getEntity());
                this.auditLog.logMessage("updateEgeriaGlossaryCategoryInAtlas", AtlasIntegrationAuditCode.UPDATING_ATLAS_ENTITY.getMessageDefinition(this.connectorName, atlasGlossaryCategoryTypeName, egeriaGlossaryCategory.getElementHeader().getGUID(), atlasGlossaryCategory.getEntity().getGuid()));
                return latestAtlasGlossaryCategory;
            }
            this.myContext.confirmSynchronization(egeriaGlossaryCategory.getElementHeader().getGUID(), egeriaGlossaryCategoryTypeName, atlasGlossaryCategory.getEntity().getGuid());
        }
        return atlasGlossaryCategory;
    }

    private void syncEgeriaGlossaryCategoryHierarchyInAtlas(GlossaryCategoryElement egeriaGlossaryCategory, AtlasEntityWithExtInfo atlasGlossaryCategory) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "syncEgeriaGlossaryCategoryHierarchyInAtlas";
        if (egeriaGlossaryCategory != null) {
            String egeriaGlossaryCategoryGUID = egeriaGlossaryCategory.getElementHeader().getGUID();
            String atlasGlossaryCategoryGUID = atlasGlossaryCategory.getEntity().getGuid();
            if (atlasGlossaryCategoryGUID != null) {
                GlossaryCategoryElement egeriaParentCategory = this.glossaryExchangeService.getGlossaryCategoryParent(egeriaGlossaryCategoryGUID, null);
                AtlasEntityWithExtInfo atlasParentCategory = this.atlasClient.getRelatedEntity(atlasGlossaryCategory, atlasParentCategoryPropertyName);
                if (egeriaParentCategory != null) {
                    String atlasParentCategoryGUID;
                    if (atlasParentCategory != null && !egeriaParentCategory.getElementHeader().getGUID().equals(atlasParentCategory.getEntity().getGuid())) {
                        block9: {
                            String currentAtlasParentRelationshipGUID = this.atlasClient.getRelationshipGUID(atlasGlossaryCategory, atlasParentCategoryPropertyName);
                            try {
                                this.atlasClient.clearRelationship(currentAtlasParentRelationshipGUID);
                            }
                            catch (Exception error) {
                                if (this.auditLog == null) break block9;
                                this.auditLog.logException("syncEgeriaGlossaryCategoryHierarchyInAtlas", AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "syncEgeriaGlossaryCategoryHierarchyInAtlas", error.getMessage()), (Throwable)error);
                            }
                        }
                        atlasParentCategory = null;
                    }
                    if (atlasParentCategory == null && (atlasParentCategoryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaParentCategory)) != null) {
                        AtlasRelationship atlasRelationship = new AtlasRelationship();
                        atlasRelationship.setTypeName(atlasCategoryHierarchyTypeName);
                        AtlasObjectId end1 = new AtlasObjectId();
                        end1.setGuid(atlasParentCategoryGUID);
                        atlasRelationship.setEnd1(end1);
                        AtlasObjectId end2 = new AtlasObjectId();
                        end2.setGuid(atlasGlossaryCategoryGUID);
                        atlasRelationship.setEnd2(end2);
                        this.atlasClient.addRelationship(atlasRelationship);
                    }
                } else if (atlasParentCategory != null) {
                    String currentAtlasParentRelationshipGUID = this.atlasClient.getRelationshipGUID(atlasGlossaryCategory, atlasParentCategoryPropertyName);
                    this.atlasClient.clearRelationship(currentAtlasParentRelationshipGUID);
                }
            }
        }
    }

    private GlossaryElement syncAtlasGlossaryInEgeria(AtlasEntityWithExtInfo atlasGlossaryEntity) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "syncAtlasGlossaryInEgeria";
        if (atlasGlossaryEntity != null && atlasGlossaryEntity.getEntity() != null) {
            String egeriaGlossaryGUID = super.getEgeriaGUID(atlasGlossaryEntity);
            if (egeriaGlossaryGUID == null) {
                egeriaGlossaryGUID = this.createAtlasGlossaryInEgeria(atlasGlossaryEntity);
            } else {
                try {
                    this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, null);
                    this.updateAtlasGlossaryInEgeria(atlasGlossaryEntity, egeriaGlossaryGUID);
                }
                catch (InvalidParameterException notKnown) {
                    this.auditLog.logMessage("syncAtlasGlossaryInEgeria", AtlasIntegrationAuditCode.REPLACING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryTypeName, egeriaGlossaryGUID, atlasGlossaryEntity.getEntity().getGuid()));
                    this.removeEgeriaGUID(atlasGlossaryEntity);
                    egeriaGlossaryGUID = this.createAtlasGlossaryInEgeria(atlasGlossaryEntity);
                }
            }
            if (egeriaGlossaryGUID != null) {
                this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, null);
            }
        }
        return null;
    }

    private String createAtlasGlossaryInEgeria(AtlasEntityWithExtInfo atlasGlossaryEntity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasGlossaryInEgeria";
        if (atlasGlossaryEntity != null && (atlasEntity = atlasGlossaryEntity.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasEntity.getGuid(), atlasGlossaryTypeName, atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            GlossaryProperties glossaryProperties = this.getEgeriaGlossaryProperties(atlasGlossaryEntity);
            String egeriaGlossaryGUID = this.glossaryExchangeService.createGlossary(true, externalIdentifierProperties, glossaryProperties);
            this.auditLog.logMessage("createAtlasGlossaryInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryTypeName, egeriaGlossaryGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            super.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaGlossaryGUID, glossaryProperties.getQualifiedName(), egeriaGlossaryTypeName, true, false);
            return egeriaGlossaryGUID;
        }
        return null;
    }

    private void updateAtlasGlossaryInEgeria(AtlasEntityWithExtInfo atlasGlossaryEntity, String egeriaGlossaryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAtlasGlossaryInEgeria";
        if (atlasGlossaryEntity != null) {
            AtlasEntity atlasEntity = atlasGlossaryEntity.getEntity();
            GlossaryElement glossaryElement = this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, null);
            if (atlasEntity == null && this.egeriaUpdateRequired(egeriaGlossaryGUID, egeriaGlossaryTypeName, (CorrelatedMetadataElement)glossaryElement, atlasEntity)) {
                GlossaryProperties egeriaGlossaryProperties = this.getEgeriaGlossaryProperties(atlasGlossaryEntity);
                this.auditLog.logMessage("updateAtlasGlossaryInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaGlossaryTypeName, egeriaGlossaryGUID));
                this.glossaryExchangeService.updateGlossary(egeriaGlossaryGUID, atlasEntity.getGuid(), false, egeriaGlossaryProperties, null);
            }
        }
    }

    private void createAtlasGlossaryTermInEgeria(AtlasEntityWithExtInfo atlasGlossaryTerm, GlossaryElement destinationGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasGlossaryTermInEgeria";
        if (atlasGlossaryTerm != null && (atlasEntity = atlasGlossaryTerm.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryTerm.getEntity().getGuid(), atlasGlossaryTermTypeName, atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            GlossaryTermProperties glossaryTermProperties = this.getEgeriaGlossaryTermProperties(atlasGlossaryTerm);
            String egeriaTermGUID = this.glossaryExchangeService.createGlossaryTerm(destinationGlossary.getElementHeader().getGUID(), true, externalIdentifierProperties, glossaryTermProperties, null);
            this.auditLog.logMessage("createAtlasGlossaryTermInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryTermTypeName, egeriaTermGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaTermGUID, glossaryTermProperties.getQualifiedName(), egeriaGlossaryTermTypeName, true, false);
            this.setUpTermCategoriesInEgeria(egeriaTermGUID, atlasGlossaryTerm);
            this.setUpTermRelationshipsInEgeria(egeriaTermGUID, atlasGlossaryTerm);
        }
    }

    private void updateAtlasGlossaryTermInEgeria(AtlasEntityWithExtInfo atlasGlossaryTerm, GlossaryTermElement egeriaGlossaryTerm) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaGlossaryTermGUID;
        AtlasEntity atlasEntity;
        String methodName = "syncAtlasGlossaryTermInEgeria";
        if (atlasGlossaryTerm != null && (atlasEntity = atlasGlossaryTerm.getEntity()) != null && this.egeriaUpdateRequired(egeriaGlossaryTermGUID = egeriaGlossaryTerm.getElementHeader().getGUID(), egeriaGlossaryTermTypeName, (CorrelatedMetadataElement)egeriaGlossaryTerm, atlasEntity)) {
            GlossaryTermProperties glossaryTermProperties = this.getEgeriaGlossaryTermProperties(atlasGlossaryTerm);
            this.auditLog.logMessage("syncAtlasGlossaryTermInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaGlossaryTermTypeName, egeriaGlossaryTermGUID));
            this.glossaryExchangeService.updateGlossaryTerm(egeriaGlossaryTermGUID, atlasEntity.getGuid(), false, glossaryTermProperties, "Change made by Apache Atlas user " + atlasEntity.getUpdatedBy(), new Date());
            this.setUpTermCategoriesInEgeria(egeriaGlossaryTermGUID, atlasGlossaryTerm);
            this.setUpTermRelationshipsInEgeria(egeriaGlossaryTermGUID, atlasGlossaryTerm);
        }
    }

    private GlossaryElement getEgeriaDestinationGlossaryForAtlasEntity(AtlasEntityWithExtInfo atlasGlossaryMember) throws PropertyServerException {
        block4: {
            AtlasEntityWithExtInfo glossaryAnchorElement;
            if (atlasGlossaryMember != null && (glossaryAnchorElement = this.atlasClient.getRelatedEntity(atlasGlossaryMember, atlasGlossaryAnchorPropertyName)) != null) {
                try {
                    String egeriaGlossaryGUID;
                    AtlasEntityWithExtInfo atlasGlossary = this.atlasClient.getEntityByGUID(glossaryAnchorElement.getEntity().getGuid());
                    if (atlasGlossary != null && (egeriaGlossaryGUID = this.getEgeriaGUID(atlasGlossary)) != null) {
                        return this.glossaryExchangeService.getGlossaryByGUID(egeriaGlossaryGUID, new Date());
                    }
                }
                catch (Exception notFound) {
                    if (this.auditLog == null) break block4;
                    String methodName = "getEgeriaDestinationGlossaryForElement";
                    this.auditLog.logException("getEgeriaDestinationGlossaryForElement", AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, notFound.getClass().getName(), "getEgeriaDestinationGlossaryForElement", notFound.getMessage()), (Throwable)notFound);
                }
            }
        }
        return null;
    }

    private AtlasEntityWithExtInfo getAtlasDestinationGlossaryForEgeriaEntity(GlossaryElement egeriaGlossary) {
        block5: {
            try {
                if (egeriaGlossary != null && egeriaGlossary.getGlossaryProperties() != null) {
                    String atlasGlossaryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaGlossary);
                    if (atlasGlossaryGUID == null) {
                        AtlasEntityWithExtInfo atlasGlossary = this.prepareGlossaryMemberEntity(null, atlasGlossaryTypeName, this.getAtlasGlossaryProperties(egeriaGlossary), null);
                        atlasGlossaryGUID = this.atlasClient.addEntity(atlasGlossary.getEntity());
                        this.saveEgeriaGUIDInAtlas(atlasGlossaryGUID, egeriaGlossary.getElementHeader().getGUID(), egeriaGlossary.getGlossaryProperties().getQualifiedName(), egeriaGlossaryTypeName, true, true);
                        this.ensureAtlasExternalIdentifier((CorrelatedMetadataElement)egeriaGlossary, egeriaGlossary.getGlossaryProperties().getDisplayName(), atlasGlossary.getEntity(), atlasGlossaryGUID, atlasGlossaryTypeName, super.getAtlasStringProperty(atlasGlossary.getEntity().getAttributes(), "name"));
                    }
                    if (atlasGlossaryGUID != null) {
                        return this.atlasClient.getEntityByGUID(atlasGlossaryGUID);
                    }
                }
            }
            catch (Exception notFound) {
                String methodName = "getAtlasDestinationGlossaryForEgeriaEntity";
                if (this.auditLog == null) break block5;
                this.auditLog.logException("getAtlasDestinationGlossaryForEgeriaEntity", AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, notFound.getClass().getName(), "getAtlasDestinationGlossaryForEgeriaEntity(" + egeriaGlossary.getElementHeader().getGUID() + ")", notFound.getMessage()), (Throwable)notFound);
            }
        }
        return null;
    }

    private void setUpTermCategoriesInEgeria(String egeriaTermGUID, AtlasEntityWithExtInfo atlasGlossaryTerm) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<AtlasEntityWithExtInfo> atlasGlossaryTermCategories = this.atlasClient.getRelatedEntities(atlasGlossaryTerm, atlasGlossaryCategoriesPropertyName);
        ArrayList<String> atlasGlossaryTermCategoryGUIDs = new ArrayList<String>();
        if (atlasGlossaryTermCategories != null) {
            for (AtlasEntityWithExtInfo relatedCategory : atlasGlossaryTermCategories) {
                String egeriaCategoryGUID;
                String atlasCategoryGUID = relatedCategory.getEntity().getGuid();
                atlasGlossaryTermCategoryGUIDs.add(atlasCategoryGUID);
                AtlasEntityWithExtInfo atlasGlossaryCategory = this.atlasClient.getEntityByGUID(atlasCategoryGUID);
                if (atlasGlossaryCategory == null || (egeriaCategoryGUID = this.getEgeriaGUID(atlasGlossaryCategory)) == null) continue;
                this.glossaryExchangeService.setupTermCategory(egeriaCategoryGUID, egeriaTermGUID, null, new Date());
            }
        }
        int startFrom = 0;
        List linkedCategories = this.glossaryExchangeService.getCategoriesForTerm(egeriaTermGUID, startFrom, this.myContext.getMaxPageSize(), new Date());
        while (linkedCategories != null) {
            for (GlossaryCategoryElement egeriaCategory : linkedCategories) {
                String atlasCategoryGUID;
                if (!this.isAtlasOwnedElement(egeriaCategory.getElementHeader()) || atlasGlossaryTermCategoryGUIDs.contains(atlasCategoryGUID = this.getAtlasGUID((CorrelatedMetadataElement)egeriaCategory))) continue;
                this.glossaryExchangeService.clearTermCategory(egeriaCategory.getElementHeader().getGUID(), egeriaTermGUID, new Date());
            }
            linkedCategories = this.glossaryExchangeService.getCategoriesForTerm(egeriaTermGUID, startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
        }
    }

    private void setUpTermRelationshipsInEgeria(String egeriaTermGUID, AtlasEntityWithExtInfo atlasGlossaryTerm) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    private void createAtlasGlossaryCategoryInEgeria(AtlasEntityWithExtInfo atlasGlossaryCategory, GlossaryElement destinationGlossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AtlasEntity atlasEntity;
        String methodName = "createAtlasGlossaryCategoryInEgeria";
        if (atlasGlossaryCategory != null && (atlasEntity = atlasGlossaryCategory.getEntity()) != null) {
            ExternalIdentifierProperties externalIdentifierProperties = this.getExternalIdentifier(atlasGlossaryCategory.getEntity().getGuid(), atlasGlossaryCategoryTypeName, atlasEntity.getCreatedBy(), atlasEntity.getCreateTime(), atlasEntity.getUpdatedBy(), atlasEntity.getUpdateTime(), atlasEntity.getVersion(), PermittedSynchronization.FROM_THIRD_PARTY);
            GlossaryCategoryProperties glossaryCategoryProperties = this.getEgeriaGlossaryCategoryProperties(atlasGlossaryCategory);
            String egeriaCategoryGUID = this.glossaryExchangeService.createGlossaryCategory(destinationGlossary.getElementHeader().getGUID(), true, externalIdentifierProperties, glossaryCategoryProperties, this.isTopLevelCategory(atlasGlossaryCategory), null);
            this.auditLog.logMessage("createAtlasGlossaryCategoryInEgeria", AtlasIntegrationAuditCode.CREATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, egeriaGlossaryCategoryTypeName, egeriaCategoryGUID, atlasEntity.getTypeName(), atlasEntity.getGuid()));
            this.saveEgeriaGUIDInAtlas(atlasEntity.getGuid(), egeriaCategoryGUID, glossaryCategoryProperties.getQualifiedName(), egeriaGlossaryCategoryTypeName, true, false);
            this.setUpCategoryHierarchyInEgeria(egeriaCategoryGUID, atlasGlossaryCategory);
        }
    }

    private void updateAtlasGlossaryCategoryInEgeria(AtlasEntityWithExtInfo atlasCategory, GlossaryCategoryElement egeriaCategory) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        AtlasEntity atlasEntity;
        String methodName = "updateAtlasGlossaryCategoryInEgeria";
        if (atlasCategory != null && (atlasEntity = atlasCategory.getEntity()) != null && this.egeriaUpdateRequired(egeriaCategory.getElementHeader().getGUID(), egeriaGlossaryCategoryTypeName, (CorrelatedMetadataElement)egeriaCategory, atlasEntity)) {
            GlossaryCategoryProperties glossaryCategoryProperties = this.getEgeriaGlossaryCategoryProperties(atlasCategory);
            this.auditLog.logMessage("updateAtlasGlossaryCategoryInEgeria", AtlasIntegrationAuditCode.UPDATING_EGERIA_ENTITY.getMessageDefinition(this.connectorName, atlasEntity.getTypeName(), atlasEntity.getGuid(), egeriaGlossaryCategoryTypeName, egeriaCategory.getElementHeader().getGUID()));
            this.glossaryExchangeService.updateGlossaryCategory(egeriaCategory.getElementHeader().getGUID(), atlasCategory.getEntity().getGuid(), false, glossaryCategoryProperties, null);
            this.setUpCategoryHierarchyInEgeria(egeriaCategory.getElementHeader().getGUID(), atlasCategory);
        }
    }

    private boolean isTopLevelCategory(AtlasEntityWithExtInfo atlasGlossaryCategory) {
        Map<String, Object> relationshipAttributes;
        if (atlasGlossaryCategory != null && atlasGlossaryCategory.getEntity() != null && (relationshipAttributes = atlasGlossaryCategory.getEntity().getRelationshipAttributes()) != null) {
            return relationshipAttributes.get(atlasParentCategoryPropertyName) == null;
        }
        return true;
    }

    private void setUpCategoryHierarchyInEgeria(String egeriaCategoryGUID, AtlasEntityWithExtInfo atlasGlossaryCategory) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryCategoryElement egeriaParentCategory = this.glossaryExchangeService.getGlossaryCategoryParent(egeriaCategoryGUID, null);
        AtlasEntityWithExtInfo atlasParentCategory = this.atlasClient.getRelatedEntity(atlasGlossaryCategory, atlasParentCategoryPropertyName);
        if (egeriaParentCategory == null) {
            String egeriaParentCategoryGUIDFromAtlas;
            if (atlasParentCategory != null && (egeriaParentCategoryGUIDFromAtlas = this.getEgeriaGUID(atlasParentCategory)) != null) {
                this.glossaryExchangeService.setupCategoryParent(egeriaParentCategoryGUIDFromAtlas, egeriaCategoryGUID, null);
            }
        } else if (atlasParentCategory != null) {
            String egeriaParentCategoryGUIDFromAtlas = this.getEgeriaGUID(atlasParentCategory);
            if (!egeriaParentCategory.getElementHeader().getGUID().equals(egeriaParentCategoryGUIDFromAtlas)) {
                this.glossaryExchangeService.clearCategoryParent(egeriaParentCategory.getElementHeader().getGUID(), egeriaCategoryGUID, null);
                this.glossaryExchangeService.setupCategoryParent(egeriaParentCategoryGUIDFromAtlas, egeriaCategoryGUID, null);
            }
        } else if (this.isAtlasOwnedElement(egeriaParentCategory.getElementHeader())) {
            this.glossaryExchangeService.clearCategoryParent(egeriaParentCategory.getElementHeader().getGUID(), egeriaCategoryGUID, null);
        }
    }

    private GlossaryElement getGlossaryByQualifiedName(String glossaryQualifiedName, String methodName) throws ConnectorCheckedException {
        try {
            List egeriaGlossaries = this.glossaryExchangeService.getGlossariesByName(glossaryQualifiedName, 0, 0, null);
            if (egeriaGlossaries != null) {
                for (GlossaryElement glossaryElement : egeriaGlossaries) {
                    String qualifiedName = glossaryElement.getGlossaryProperties().getQualifiedName();
                    if (!glossaryQualifiedName.equals(qualifiedName)) continue;
                    return glossaryElement;
                }
            }
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException(methodName, AtlasIntegrationAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(AtlasIntegrationErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName, error);
        }
        return null;
    }

    private GlossaryProperties getEgeriaGlossaryProperties(AtlasEntityWithExtInfo atlasGlossaryElement) {
        GlossaryProperties glossaryProperties = new GlossaryProperties();
        Map<String, Object> atlasAttributes = atlasGlossaryElement.getEntity().getAttributes();
        glossaryProperties.setQualifiedName("AtlasGlossary." + this.getAtlasStringProperty(atlasAttributes, "qualifiedName"));
        glossaryProperties.setDisplayName(this.getAtlasStringProperty(atlasAttributes, "name"));
        String shortDescription = this.getAtlasStringProperty(atlasAttributes, atlasShortDescriptionPropertyName);
        if (shortDescription != null) {
            glossaryProperties.setDescription(shortDescription + "\n\n" + this.getAtlasStringProperty(atlasAttributes, atlasLongDescriptionPropertyName));
        } else {
            glossaryProperties.setDescription(this.getAtlasStringProperty(atlasAttributes, atlasLongDescriptionPropertyName));
        }
        glossaryProperties.setLanguage(this.getAtlasStringProperty(atlasAttributes, atlasLanguagePropertyName));
        glossaryProperties.setUsage(this.getAtlasStringProperty(atlasAttributes, atlasUsagePropertyName));
        return glossaryProperties;
    }

    Map<String, Object> getAtlasGlossaryProperties(GlossaryElement egeriaGlossary) {
        String[] descriptionSentences;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("qualifiedName", egeriaGlossary.getGlossaryProperties().getQualifiedName());
        properties.put("name", egeriaGlossary.getGlossaryProperties().getDisplayName());
        if (egeriaGlossary.getGlossaryProperties().getDescription() != null && (descriptionSentences = egeriaGlossary.getGlossaryProperties().getDescription().split(Pattern.quote(". "))).length > 0) {
            properties.put(atlasShortDescriptionPropertyName, descriptionSentences[0]);
        }
        properties.put(atlasLongDescriptionPropertyName, egeriaGlossary.getGlossaryProperties().getDescription());
        properties.put(atlasLanguagePropertyName, egeriaGlossary.getGlossaryProperties().getLanguage());
        properties.put(atlasUsagePropertyName, egeriaGlossary.getGlossaryProperties().getUsage());
        if (egeriaGlossary.getGlossaryProperties().getAdditionalProperties() != null) {
            properties.put(atlasAdditionalAttributesPropertyName, egeriaGlossary.getGlossaryProperties().getAdditionalProperties());
        }
        return properties;
    }

    private GlossaryTermProperties getEgeriaGlossaryTermProperties(AtlasEntityWithExtInfo atlasGlossaryTermElement) {
        GlossaryTermProperties glossaryTermProperties = new GlossaryTermProperties();
        Map<String, Object> atlasAttributes = atlasGlossaryTermElement.getEntity().getAttributes();
        glossaryTermProperties.setQualifiedName("AtlasGlossaryTerm." + this.getAtlasStringProperty(atlasAttributes, "qualifiedName"));
        glossaryTermProperties.setDisplayName(this.getAtlasStringProperty(atlasAttributes, "name"));
        String shortDescription = this.getAtlasStringProperty(atlasAttributes, atlasShortDescriptionPropertyName);
        if (shortDescription != null) {
            glossaryTermProperties.setDescription(shortDescription + "\n\n" + this.getAtlasStringProperty(atlasAttributes, atlasLongDescriptionPropertyName));
        } else {
            glossaryTermProperties.setDescription(this.getAtlasStringProperty(atlasAttributes, atlasLongDescriptionPropertyName));
        }
        glossaryTermProperties.setExamples(this.getAtlasStringProperty(atlasAttributes, atlasExamplesPropertyName));
        glossaryTermProperties.setAbbreviation(this.getAtlasStringProperty(atlasAttributes, atlasAbbreviationPropertyName));
        glossaryTermProperties.setUsage(this.getAtlasStringProperty(atlasAttributes, atlasUsagePropertyName));
        return glossaryTermProperties;
    }

    Map<String, Object> getAtlasGlossaryTermProperties(GlossaryTermElement egeriaGlossaryTerm, String egeriaGlossaryTermLastKnownName, String atlasGlossaryTermGUID, String atlasGlossaryTermName, AtlasEntityWithExtInfo atlasGlossary) throws PropertyServerException {
        String[] descriptionSentences;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String name = atlasGlossaryTermGUID == null ? this.getUniqueNameForNewAtlasGlossaryMember(egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), atlasGlossary, atlasGlossaryTermsPropertyName) : (egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName().equals(egeriaGlossaryTermLastKnownName) ? atlasGlossaryTermName : this.getUniqueNameForRenamedAtlasGlossaryMember(egeriaGlossaryTerm.getGlossaryTermProperties().getDisplayName(), atlasGlossaryTermGUID, atlasGlossary, atlasGlossaryTermsPropertyName));
        properties.put("qualifiedName", this.getAtlasStringProperty(atlasGlossary.getEntity().getAttributes(), "qualifiedName") + "@" + name);
        properties.put("name", name);
        if (egeriaGlossaryTerm.getGlossaryTermProperties().getDescription() != null && (descriptionSentences = egeriaGlossaryTerm.getGlossaryTermProperties().getDescription().split(Pattern.quote(". "))).length > 0) {
            properties.put(atlasShortDescriptionPropertyName, descriptionSentences[0]);
        }
        properties.put(atlasLongDescriptionPropertyName, egeriaGlossaryTerm.getGlossaryTermProperties().getDescription());
        properties.put(atlasAbbreviationPropertyName, egeriaGlossaryTerm.getGlossaryTermProperties().getAbbreviation());
        properties.put(atlasUsagePropertyName, egeriaGlossaryTerm.getGlossaryTermProperties().getUsage());
        if (egeriaGlossaryTerm.getGlossaryTermProperties().getAdditionalProperties() != null) {
            properties.put(atlasAdditionalAttributesPropertyName, egeriaGlossaryTerm.getGlossaryTermProperties().getAdditionalProperties());
        }
        return properties;
    }

    private GlossaryCategoryProperties getEgeriaGlossaryCategoryProperties(AtlasEntityWithExtInfo atlasGlossaryCategory) {
        GlossaryCategoryProperties glossaryCategoryProperties = new GlossaryCategoryProperties();
        Map<String, Object> atlasAttributes = atlasGlossaryCategory.getEntity().getAttributes();
        glossaryCategoryProperties.setQualifiedName("AtlasGlossaryCategory." + this.getAtlasStringProperty(atlasAttributes, "qualifiedName"));
        glossaryCategoryProperties.setDisplayName(this.getAtlasStringProperty(atlasAttributes, "name"));
        String shortDescription = this.getAtlasStringProperty(atlasAttributes, atlasShortDescriptionPropertyName);
        if (shortDescription != null) {
            glossaryCategoryProperties.setDescription(shortDescription + "\n\n" + this.getAtlasStringProperty(atlasAttributes, atlasLongDescriptionPropertyName));
        } else {
            glossaryCategoryProperties.setDescription(this.getAtlasStringProperty(atlasAttributes, atlasLongDescriptionPropertyName));
        }
        return glossaryCategoryProperties;
    }

    Map<String, Object> getAtlasGlossaryCategoryProperties(GlossaryCategoryElement egeriaGlossaryCategory, String egeriaGlossaryCategoryLastKnownName, String atlasGlossaryCategoryGUID, String atlasGlossaryCategoryName, AtlasEntityWithExtInfo atlasGlossary) throws PropertyServerException {
        String[] descriptionSentences;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String name = atlasGlossaryCategoryGUID == null ? this.getUniqueNameForNewAtlasGlossaryMember(egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), atlasGlossary, atlasGlossaryCategoriesPropertyName) : (egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName().equals(egeriaGlossaryCategoryLastKnownName) ? atlasGlossaryCategoryName : this.getUniqueNameForRenamedAtlasGlossaryMember(egeriaGlossaryCategory.getGlossaryCategoryProperties().getDisplayName(), atlasGlossaryCategoryGUID, atlasGlossary, atlasGlossaryCategoriesPropertyName));
        properties.put("qualifiedName", this.getAtlasStringProperty(atlasGlossary.getEntity().getAttributes(), "qualifiedName") + "@" + name);
        properties.put("name", name);
        if (egeriaGlossaryCategory.getGlossaryCategoryProperties().getDescription() != null && (descriptionSentences = egeriaGlossaryCategory.getGlossaryCategoryProperties().getDescription().split(Pattern.quote(". "))).length > 0) {
            properties.put(atlasShortDescriptionPropertyName, descriptionSentences[0]);
        }
        properties.put(atlasLongDescriptionPropertyName, egeriaGlossaryCategory.getGlossaryCategoryProperties().getDescription());
        if (egeriaGlossaryCategory.getGlossaryCategoryProperties().getAdditionalProperties() != null) {
            properties.put(atlasAdditionalAttributesPropertyName, egeriaGlossaryCategory.getGlossaryCategoryProperties().getAdditionalProperties());
        }
        return properties;
    }

    AtlasEntityWithExtInfo prepareGlossaryMemberEntity(String memberGUID, String memberTypeName, Map<String, Object> memberAttributes, AtlasEntityWithExtInfo destinationGlossary) {
        AtlasEntityWithExtInfo atlasEntityWithExtInfo = new AtlasEntityWithExtInfo();
        AtlasEntity atlasEntity = new AtlasEntity();
        atlasEntity.setGuid(memberGUID);
        atlasEntity.setTypeName(memberTypeName);
        atlasEntity.setAttributes(memberAttributes);
        HashMap<String, Object> relationshipAttributes = new HashMap<String, Object>();
        if (destinationGlossary != null) {
            relationshipAttributes.put(atlasGlossaryAnchorPropertyName, this.getAnchorAttributes(memberTypeName, destinationGlossary));
            atlasEntity.setRelationshipAttributes(relationshipAttributes);
        }
        atlasEntityWithExtInfo.setEntity(atlasEntity);
        return atlasEntityWithExtInfo;
    }

    private Map<String, Object> getAnchorAttributes(String memberTypeName, AtlasEntityWithExtInfo destinationGlossary) {
        HashMap<String, Object> anchorAttributes = new HashMap<String, Object>();
        anchorAttributes.put("guid", destinationGlossary.getEntity().getGuid());
        if (atlasGlossaryTermTypeName.equals(memberTypeName)) {
            anchorAttributes.put("relationshipType", "AtlasGlossaryTermAnchor");
        } else {
            anchorAttributes.put("relationshipType", "AtlasGlossaryCategoryAnchor");
        }
        anchorAttributes.put("relationshipStatus", "ACTIVE");
        return anchorAttributes;
    }

    private String getUniqueNameForNewAtlasGlossaryMember(String egeriaMemberName, AtlasEntityWithExtInfo atlasGlossary, String existingEntitiesParameterName) throws PropertyServerException {
        List<AtlasEntityWithExtInfo> existingEntities = this.atlasClient.getRelatedEntities(atlasGlossary, existingEntitiesParameterName);
        return this.getUniqueNameForAtlasEntity(egeriaMemberName, existingEntities);
    }

    private String getUniqueNameForRenamedAtlasGlossaryMember(String newEgeriaMemberName, String atlasMemberGUID, AtlasEntityWithExtInfo atlasGlossary, String existingEntitiesParameterName) throws PropertyServerException {
        List<AtlasEntityWithExtInfo> existingEntities = this.atlasClient.getRelatedEntities(atlasGlossary, existingEntitiesParameterName);
        ArrayList<AtlasEntityWithExtInfo> otherExistingEntities = null;
        if (existingEntities != null) {
            otherExistingEntities = new ArrayList<AtlasEntityWithExtInfo>();
            for (AtlasEntityWithExtInfo existingEntity : existingEntities) {
                if (existingEntity == null || existingEntity.getEntity() == null || atlasMemberGUID.equals(existingEntity.getEntity().getGuid())) continue;
                otherExistingEntities.add(existingEntity);
            }
        }
        return this.getUniqueNameForAtlasEntity(newEgeriaMemberName, otherExistingEntities);
    }

    private String getUniqueNameForAtlasEntity(String egeriaName, List<AtlasEntityWithExtInfo> existingEntities) {
        if (existingEntities == null || existingEntities.isEmpty()) {
            return egeriaName;
        }
        int matchingNameCount = 0;
        for (AtlasEntityWithExtInfo existingAtlasEntity : existingEntities) {
            String existingEntityName = this.getAtlasStringProperty(existingAtlasEntity.getEntity().getAttributes(), "name");
            if (!egeriaName.equals(existingEntityName)) {
                String[] termEndingParts;
                String[] termNameParts = existingEntityName.split(Pattern.quote(" ("));
                if (termNameParts.length <= 1 || !egeriaName.equals(termNameParts[0]) || (termEndingParts = termNameParts[termNameParts.length - 1].split(Pattern.quote(")"))).length != 1) continue;
                try {
                    int matchingNameIndex = Integer.parseInt(termEndingParts[0]);
                    if (matchingNameIndex < matchingNameCount) continue;
                    matchingNameCount = matchingNameIndex + 1;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            ++matchingNameCount;
        }
        if (matchingNameCount == 0) {
            return egeriaName;
        }
        return egeriaName + " (" + matchingNameCount + ")";
    }
}

