/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ffdc.AtlasIntegrationAuditCode;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.modules.AtlasIntegrationModuleBase;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTConnector;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasAttributeDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasClassificationDef;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.properties.AtlasTypesDef;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.ValidValuesExchangeService;

public class AtlasReferenceClassificationsIntegrationModule
extends AtlasIntegrationModuleBase {
    private static final String referenceClassificationsModuleName = "Apache Atlas Reference Classifications Integration Module";
    private static final String classificationQualifiedNamePrefix = "Apache Atlas Reference Classification: ";
    private final String classificationReferenceSetName;
    private final String classificationReferenceSetPolicy;
    private String classificationReferenceSetGUID = null;
    private final Map<String, ValidValueElement> classificationNameToReferenceElement = new HashMap<String, ValidValueElement>();
    private final ValidValuesExchangeService validValuesExchangeService;

    public AtlasReferenceClassificationsIntegrationModule(String connectorName, ConnectionDetails connectionDetails, AuditLog auditLog, CatalogIntegratorContext myContext, String targetRootURL, ApacheAtlasRESTConnector atlasClient, List<Connector> embeddedConnectors, String classificationReferenceSetName, String classificationReferenceSetPolicy) throws UserNotAuthorizedException {
        super(connectorName, referenceClassificationsModuleName, connectionDetails, auditLog, myContext, targetRootURL, atlasClient, embeddedConnectors);
        this.classificationReferenceSetName = classificationReferenceSetName;
        this.classificationReferenceSetPolicy = classificationReferenceSetPolicy;
        this.validValuesExchangeService = myContext.getValidValuesExchangeService();
        this.validValuesExchangeService.setForLineage(false);
        this.validValuesExchangeService.setForDuplicateProcessing(false);
    }

    public Map<String, ValidValueElement> synchronizeClassificationDefinitions() {
        block23: {
            String methodName = "synchronizeClassificationDefinitions";
            if (this.classificationReferenceSetName != null) {
                HashSet<String> atlasClassificationNames;
                block22: {
                    if (this.classificationReferenceSetGUID == null) {
                        try {
                            this.classificationReferenceSetGUID = this.getClassificationReferenceSetGUID();
                        }
                        catch (Exception error) {
                            if (this.auditLog != null) {
                                this.auditLog.logException("synchronizeClassificationDefinitions", AtlasIntegrationAuditCode.UNABLE_TO_SET_UP_CLASSIFICATION_REFERENCE_SET.getMessageDefinition(this.connectorName, error.getClass().getName(), this.classificationReferenceSetName, error.getMessage()), (Throwable)error);
                            }
                            return this.classificationNameToReferenceElement;
                        }
                    }
                    try {
                        List referenceClassifications = this.validValuesExchangeService.getValidValueSetMembers(this.classificationReferenceSetGUID, 0, this.myContext.getMaxPageSize(), new Date());
                        int startFrom = 0;
                        while (referenceClassifications != null) {
                            for (Object referenceClassification : referenceClassifications) {
                                if (referenceClassification == null) continue;
                                this.classificationNameToReferenceElement.put(referenceClassification.getValidValueElement().getValidValueProperties().getDisplayName(), referenceClassification.getValidValueElement());
                            }
                            referenceClassifications = this.validValuesExchangeService.getValidValueSetMembers(this.classificationReferenceSetGUID, startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize(), new Date());
                        }
                    }
                    catch (Exception error) {
                        if (this.auditLog != null) {
                            this.auditLog.logException("synchronizeClassificationDefinitions", AtlasIntegrationAuditCode.UNABLE_TO_GET_CLASSIFICATION_REFERENCE_SET_MEMBERS.getMessageDefinition(this.connectorName, error.getClass().getName(), this.classificationReferenceSetName, error.getMessage()), (Throwable)error);
                        }
                        return this.classificationNameToReferenceElement;
                    }
                    atlasClassificationNames = new HashSet<String>();
                    if (this.classificationReferenceSetPolicy.equals("FROM_ATLAS") || this.classificationReferenceSetPolicy.equals("BOTH_WAYS")) {
                        try {
                            List<AtlasClassificationDef> atlasClassifications;
                            AtlasTypesDef atlasTypes = this.atlasClient.getAllTypes();
                            if (atlasTypes != null && (atlasClassifications = atlasTypes.getClassificationDefs()) != null) {
                                for (AtlasClassificationDef atlasClassification : atlasClassifications) {
                                    String classificationReferenceGUID;
                                    if (atlasClassification == null) continue;
                                    atlasClassificationNames.add(atlasClassification.getName());
                                    if (this.classificationNameToReferenceElement.get(atlasClassification.getName()) != null) continue;
                                    ValidValueProperties properties = new ValidValueProperties();
                                    properties.setQualifiedName(classificationQualifiedNamePrefix + atlasClassification.getName());
                                    properties.setDisplayName(atlasClassification.getName());
                                    properties.setDescription(atlasClassification.getDescription());
                                    if (atlasClassification.getAttributeDefs() != null) {
                                        HashMap<String, String> additionalProperties = new HashMap<String, String>();
                                        for (AtlasAttributeDef atlasAttributeDef : atlasClassification.getAttributeDefs()) {
                                            if (atlasAttributeDef == null) continue;
                                            additionalProperties.put(atlasAttributeDef.getName(), atlasAttributeDef.getDescription());
                                        }
                                        if (!additionalProperties.isEmpty()) {
                                            properties.setAdditionalProperties(additionalProperties);
                                        }
                                    }
                                    if ((classificationReferenceGUID = this.validValuesExchangeService.createValidValueDefinition(this.classificationReferenceSetGUID, null, properties, new Date())) == null) continue;
                                    this.classificationNameToReferenceElement.put(atlasClassification.getName(), this.validValuesExchangeService.getValidValueByGUID(classificationReferenceGUID, null));
                                }
                            }
                        }
                        catch (Exception error) {
                            if (this.auditLog == null) break block22;
                            this.auditLog.logException("synchronizeClassificationDefinitions", AtlasIntegrationAuditCode.UNABLE_TO_BUILD_CLASSIFICATION_REFERENCE_SET_FROM_ATLAS.getMessageDefinition(this.connectorName, error.getClass().getName(), this.classificationReferenceSetName, error.getMessage()), (Throwable)error);
                        }
                    }
                }
                if (this.classificationReferenceSetPolicy.equals("TO_ATLAS") || this.classificationReferenceSetPolicy.equals("BOTH_WAYS")) {
                    try {
                        for (String referenceClassificationName : this.classificationNameToReferenceElement.keySet()) {
                            Object referenceClassification;
                            if (referenceClassificationName == null || atlasClassificationNames.contains(referenceClassificationName)) continue;
                            referenceClassification = this.classificationNameToReferenceElement.get(referenceClassificationName);
                            this.atlasClient.addClassificationType(referenceClassificationName, referenceClassification.getValidValueProperties().getDescription(), referenceClassification.getValidValueProperties().getAdditionalProperties());
                            atlasClassificationNames.add(referenceClassificationName);
                        }
                    }
                    catch (Exception error) {
                        if (this.auditLog == null) break block23;
                        this.auditLog.logException("synchronizeClassificationDefinitions", AtlasIntegrationAuditCode.UNABLE_TO_ADD_CLASSIFICATION_REFERENCE_SET_TO_ATLAS.getMessageDefinition(this.connectorName, error.getClass().getName(), this.classificationReferenceSetName, error.getMessage()), (Throwable)error);
                    }
                }
            }
        }
        return this.classificationNameToReferenceElement;
    }

    public String getClassificationReferenceSetGUID() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List matchingValidValues = this.validValuesExchangeService.getValidValueByName(this.classificationReferenceSetName, 0, 0, new Date());
        if (matchingValidValues != null) {
            for (ValidValueElement validValueElement : matchingValidValues) {
                if (validValueElement == null || !this.classificationReferenceSetName.equals(validValueElement.getValidValueProperties().getQualifiedName())) continue;
                return validValueElement.getElementHeader().getGUID();
            }
        }
        ValidValueProperties validValueProperties = new ValidValueProperties();
        validValueProperties.setQualifiedName(this.classificationReferenceSetName);
        return this.validValuesExchangeService.createValidValueSet(null, validValueProperties, new Date());
    }
}

