/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.apacheatlas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.ffdc.ApacheAtlasAuditCode;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.ffdc.ApacheAtlasErrorCode;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.ffdc.NameConflictException;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasBusinessMetadataDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasClassificationDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntity;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntityDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntityHeader;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntityMutationResponse;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntityOperation;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasEntityWithExtInfo;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasGlossaryCategoryElement;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasGlossaryElement;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasGlossaryTermElement;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasInstanceStatus;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasRelationship;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasRelationshipDef;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasSearchResult;
import org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties.AtlasTypesDef;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.restclients.spring.SpringRESTClientConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.springframework.core.ParameterizedTypeReference;

public class ApacheAtlasRESTConnector
extends ConnectorBase
implements AuditLoggingComponent,
VirtualConnectorExtension {
    private AuditLog auditLog = null;
    private String atlasServerName = "Apache Atlas";
    private String targetRootURL = null;
    private List<Connector> embeddedConnectors = null;
    private String connectorName = "Apache Atlas REST Connector";
    private RESTClientConnector clientConnector = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public void start() throws ConnectorCheckedException {
        EndpointProperties endpoint;
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getUserId() == null || this.connectionProperties.getClearPassword() == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_USER.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        if (this.connectionProperties.getConnectionName() != null) {
            this.connectorName = this.connectionProperties.getConnectionName();
        }
        if ((endpoint = this.connectionProperties.getEndpoint()) != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        Map configurationProperties = this.connectionProperties.getConfigurationProperties();
        if (configurationProperties != null && configurationProperties.get("atlasServerName") != null) {
            this.atlasServerName = configurationProperties.get("atlasServerName").toString();
        }
        try {
            RESTClientFactory factory = new RESTClientFactory(this.atlasServerName, this.targetRootURL, this.connectionProperties.getUserId(), this.connectionProperties.getClearPassword());
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", ApacheAtlasAuditCode.BAD_CONFIGURATION.getMessageDefinition(this.connectorName, error.getClass().getName(), this.targetRootURL, "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(ApacheAtlasErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    public AtlasTypesDef getAllTypes() throws PropertyServerException {
        String methodName = "getAllTypes()";
        String url = this.targetRootURL + "/api/atlas/v2/types/typedefs";
        return this.callGetRESTCallNoParams("getAllTypes()", AtlasTypesDef.class, url);
    }

    public AtlasEntityDef getEntityType(String typeName) throws PropertyServerException {
        String methodName = "getEntityTypes(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/entitydef/name/" + typeName;
        return this.callNoLogGetRESTCallNoParams(methodName, AtlasEntityDef.class, url);
    }

    public AtlasRelationshipDef getRelationshipType(String typeName) throws PropertyServerException {
        String methodName = "getRelationshipTypes(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/relationshipdef/name/" + typeName;
        return this.callNoLogGetRESTCallNoParams(methodName, AtlasRelationshipDef.class, url);
    }

    public AtlasClassificationDef getClassificationType(String typeName) throws PropertyServerException {
        String methodName = "getClassificationType(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/classificationdef/name/" + typeName;
        return this.callGetRESTCallNoParams(methodName, AtlasClassificationDef.class, url);
    }

    public AtlasBusinessMetadataDef getBusinessMetadataType(String typeName) throws PropertyServerException {
        String methodName = "getBusinessMetadataType(" + typeName + "}";
        String url = this.targetRootURL + "/api/atlas/v2/types/businessmetadatadef/name/" + typeName;
        return this.callGetRESTCallNoParams(methodName, AtlasBusinessMetadataDef.class, url);
    }

    public AtlasTypesDef addNewTypes(AtlasTypesDef newTypeDefinitions) throws PropertyServerException {
        String methodName = "addNewTypes()";
        String url = this.targetRootURL + "/api/atlas/v2/types/typedefs";
        return this.callPostRESTCallNoParams("addNewTypes()", AtlasTypesDef.class, url, newTypeDefinitions);
    }

    public String addEntity(AtlasEntity entity) throws PropertyServerException {
        List<AtlasEntityHeader> returnedEntities;
        String methodName = "addEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity";
        AtlasEntityWithExtInfo atlasEntityWithExtInfo = new AtlasEntityWithExtInfo();
        atlasEntityWithExtInfo.setEntity(entity);
        AtlasEntityMutationResponse response = this.callPostRESTCallNoParams("addEntity()", AtlasEntityMutationResponse.class, url, atlasEntityWithExtInfo);
        if (response != null && response.getMutatedEntities() != null && (returnedEntities = response.getMutatedEntities().get((Object)AtlasEntityOperation.CREATE)) != null && !returnedEntities.isEmpty()) {
            return returnedEntities.get(0).getGuid();
        }
        return null;
    }

    public AtlasEntityWithExtInfo updateEntity(AtlasEntityWithExtInfo entityWithExtInfo) throws PropertyServerException {
        String methodName = "updateEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity";
        this.callPostRESTCallNoParams("updateEntity()", AtlasEntityMutationResponse.class, url, entityWithExtInfo);
        return this.getEntityByGUID(entityWithExtInfo.getEntity().getGuid());
    }

    public AtlasEntityMutationResponse deleteEntity(String entityGUID) throws PropertyServerException {
        String methodName = "deleteEntity()";
        String url = this.targetRootURL + "/api/atlas/v2/entity/guid/{0}";
        return this.callDeleteRESTCall("deleteEntity()", AtlasEntityMutationResponse.class, url, entityGUID);
    }

    public AtlasRelationship addRelationship(AtlasRelationship atlasRelationship) throws PropertyServerException {
        String methodName = "addRelationship()";
        String url = this.targetRootURL + "/api/atlas/v2/relationship";
        return this.callPostRESTCallNoParams("addRelationship()", AtlasRelationship.class, url, atlasRelationship);
    }

    public void clearRelationship(String atlasRelationshipGUID) throws PropertyServerException {
        String methodName = "clearRelationship()";
        String url = this.targetRootURL + "/api/atlas/v2/relationship/" + atlasRelationshipGUID;
        this.callDeleteRESTCall("clearRelationship()", url);
    }

    private AtlasEntityWithExtInfo validateActiveEntity(AtlasEntityWithExtInfo retrievedEntity) {
        if (retrievedEntity != null && retrievedEntity.getEntity() != null && retrievedEntity.getEntity().getStatus() == AtlasInstanceStatus.ACTIVE) {
            return retrievedEntity;
        }
        return null;
    }

    public AtlasEntityWithExtInfo getEntityByGUID(String guid) throws PropertyServerException {
        String methodName = "getEntity(" + guid + ")";
        String url = this.targetRootURL + "/api/atlas/v2/entity/guid/" + guid;
        AtlasEntityWithExtInfo entity = this.callGetRESTCallNoParams(methodName, AtlasEntityWithExtInfo.class, url);
        return this.validateActiveEntity(entity);
    }

    public AtlasEntityWithExtInfo getRelatedEntity(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        if (startingEntity != null && startingEntity.getEntity() != null) {
            return this.getRelatedEntity(startingEntity.getEntity(), relationshipLabel);
        }
        return null;
    }

    public String getRelationshipGUID(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        Map<String, Object> relationshipAttributes;
        Object relatedObject;
        if (startingEntity != null && startingEntity.getEntity() != null && startingEntity.getEntity().getRelationshipAttributes() != null && (relatedObject = (relationshipAttributes = startingEntity.getEntity().getRelationshipAttributes()).get(relationshipLabel)) instanceof Map) {
            Map relationship = (Map)relatedObject;
            return relationship.get("relationshipGuid").toString();
        }
        return null;
    }

    public AtlasEntityWithExtInfo getRelatedEntity(AtlasEntity startingEntity, String relationshipLabel) throws PropertyServerException {
        Map relationship;
        String relatedEntityGUID;
        Map<String, Object> relationshipAttributes;
        Object relatedObject;
        if (startingEntity != null && startingEntity.getRelationshipAttributes() != null && (relatedObject = (relationshipAttributes = startingEntity.getRelationshipAttributes()).get(relationshipLabel)) instanceof Map && (relatedEntityGUID = (relationship = (Map)relatedObject).get("guid").toString()) != null) {
            return this.getEntityByGUID(relatedEntityGUID);
        }
        return null;
    }

    public Map<String, String> getRelationships(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        Map<String, Object> relationshipAttributes;
        Object relationshipObjects;
        HashMap<String, String> guidMap = new HashMap<String, String>();
        if (startingEntity != null && startingEntity.getEntity().getRelationshipAttributes() != null && (relationshipObjects = (relationshipAttributes = startingEntity.getEntity().getRelationshipAttributes()).get(relationshipLabel)) instanceof List) {
            List relationshipList = (List)relationshipObjects;
            for (Object relationship : relationshipList) {
                if (!(relationship instanceof Map)) continue;
                Map relationshipMap = (Map)relationship;
                String relatedEntityGUID = relationshipMap.get("guid").toString();
                String relationshipGUID = relationshipMap.get("relationshipGuid").toString();
                if (relatedEntityGUID == null) continue;
                guidMap.put(relatedEntityGUID, relationshipGUID);
            }
        }
        return guidMap;
    }

    public List<AtlasEntityWithExtInfo> getRelatedEntities(AtlasEntityWithExtInfo startingEntity, String relationshipLabel) throws PropertyServerException {
        Map<String, Object> relationshipAttributes;
        Object relatedObjects;
        ArrayList<AtlasEntityWithExtInfo> results = new ArrayList<AtlasEntityWithExtInfo>();
        if (startingEntity != null && startingEntity.getEntity() != null && startingEntity.getEntity().getRelationshipAttributes() != null && (relatedObjects = (relationshipAttributes = startingEntity.getEntity().getRelationshipAttributes()).get(relationshipLabel)) instanceof List) {
            List relatedObjectList = (List)relatedObjects;
            for (Object relatedObject : relatedObjectList) {
                AtlasEntityWithExtInfo validatedEntity;
                Map relatedMappedAttributes;
                String relatedEntityGUID;
                if (!(relatedObject instanceof Map) || (relatedEntityGUID = (relatedMappedAttributes = (Map)relatedObject).get("guid").toString()) == null || (validatedEntity = this.validateActiveEntity(this.getEntityByGUID(relatedEntityGUID))) == null) continue;
                results.add(validatedEntity);
            }
        }
        return results;
    }

    public List<AtlasEntityHeader> getEntitiesForType(String typeName, int startFrom, int pageSize) throws PropertyServerException {
        String url;
        String methodName = "getEntity(" + typeName + ")";
        AtlasSearchResult searchResult = this.callGetRESTCallNoParams(methodName, AtlasSearchResult.class, url = this.targetRootURL + "/api/atlas/v2/search/dsl?typeName=" + typeName + "&offset=" + startFrom + "&limit=" + pageSize);
        if (searchResult != null && searchResult.getEntities() != null) {
            ArrayList<AtlasEntityHeader> results = new ArrayList<AtlasEntityHeader>();
            for (AtlasEntityHeader entityHeader : searchResult.getEntities()) {
                if (entityHeader == null || entityHeader.getStatus() != AtlasInstanceStatus.ACTIVE) continue;
                results.add(entityHeader);
            }
            return results;
        }
        return null;
    }

    public AtlasGlossaryElement getAtlasGlossary(int glossaryCount) throws PropertyServerException {
        String methodName = "getAtlasGlossary(glossaryCount)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary?limit=1&offset=" + glossaryCount + "&sort=ASC";
        ArrayList glossaryElements = this.callGetRESTCallNoParams("getAtlasGlossary(glossaryCount)", ArrayList.class, url);
        if (glossaryElements != null && !glossaryElements.isEmpty()) {
            LinkedHashMap requestedGlossary = (LinkedHashMap)glossaryElements.get(0);
            return this.getAtlasGlossary(requestedGlossary.get("guid").toString());
        }
        return null;
    }

    public AtlasGlossaryElement getAtlasGlossary(String glossaryGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossary(glossaryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/" + glossaryGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossary(glossaryGUID)", AtlasGlossaryElement.class, url);
    }

    public String createAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "createAtlasGlossary(glossary)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary";
        AtlasGlossaryElement newGlossary = this.callPostRESTCallNoParams("createAtlasGlossary(glossary)", AtlasGlossaryElement.class, url, glossary);
        if (newGlossary != null) {
            return newGlossary.getGuid();
        }
        return null;
    }

    public AtlasGlossaryElement saveAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "saveAtlasGlossary(glossary)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/{0}";
        return this.callPutRESTCall("saveAtlasGlossary(glossary)", AtlasGlossaryElement.class, url, (Object)glossary, glossary.getGuid());
    }

    public void deleteAtlasGlossary(AtlasGlossaryElement glossary) throws PropertyServerException {
        String methodName = "deleteAtlasGlossary()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/" + glossary.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossary()", url);
    }

    public AtlasGlossaryTermElement getAtlasGlossaryTerm(String glossaryTermGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossaryTerm(glossaryTermGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term/" + glossaryTermGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossaryTerm(glossaryTermGUID)", AtlasGlossaryTermElement.class, url);
    }

    public String createAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException, NameConflictException {
        AtlasGlossaryTermElement newTerm;
        String methodName = "createAtlasGlossaryTerm()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term";
        try {
            newTerm = this.callPostRESTCallNameConflict("createAtlasGlossaryTerm()", AtlasGlossaryTermElement.class, url, term);
        }
        catch (PropertyServerException error) {
            if (error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                throw new NameConflictException(ApacheAtlasErrorCode.TERM_ALREADY_EXISTS.getMessageDefinition(term.getName()), ((Object)((Object)this)).getClass().getName(), "createAtlasGlossaryTerm()", "name", (Exception)((Object)error));
            }
            throw error;
        }
        if (newTerm != null) {
            return newTerm.getGuid();
        }
        return null;
    }

    public AtlasGlossaryTermElement saveAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException {
        String methodName = "saveAtlasGlossaryTerm()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term/{0}";
        return this.callPutRESTCall("saveAtlasGlossaryTerm()", AtlasGlossaryTermElement.class, url, (Object)term, term.getGuid());
    }

    public void deleteAtlasGlossaryTerm(AtlasGlossaryTermElement term) throws PropertyServerException {
        String methodName = "deleteAtlasGlossaryTerm()";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/term/" + term.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossaryTerm()", url);
    }

    public AtlasGlossaryCategoryElement getAtlasGlossaryCategory(String glossaryCategoryGUID) throws PropertyServerException {
        String methodName = "getAtlasGlossaryCategory(glossaryCategoryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category/" + glossaryCategoryGUID;
        return this.callGetRESTCallNoParams("getAtlasGlossaryCategory(glossaryCategoryGUID)", AtlasGlossaryCategoryElement.class, url);
    }

    public String createAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException, NameConflictException {
        AtlasGlossaryCategoryElement newGlossaryCategory;
        String methodName = "createAtlasGlossaryCategory(category)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category";
        try {
            newGlossaryCategory = this.callPostRESTCallNameConflict("createAtlasGlossaryCategory(category)", AtlasGlossaryCategoryElement.class, url, category);
        }
        catch (PropertyServerException error) {
            if (error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                throw new NameConflictException(ApacheAtlasErrorCode.CATEGORY_ALREADY_EXISTS.getMessageDefinition(category.getName()), ((Object)((Object)this)).getClass().getName(), "createAtlasGlossaryCategory(category)", "name", (Exception)((Object)error));
            }
            throw error;
        }
        if (newGlossaryCategory != null) {
            return newGlossaryCategory.getGuid();
        }
        return null;
    }

    public AtlasGlossaryCategoryElement saveAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException {
        String methodName = "saveAtlasGlossaryCategory(glossaryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category/{0}";
        return this.callPutRESTCall("saveAtlasGlossaryCategory(glossaryGUID)", AtlasGlossaryCategoryElement.class, url, (Object)category, category.getGuid());
    }

    public void deleteAtlasGlossaryCategory(AtlasGlossaryCategoryElement category) throws PropertyServerException {
        String methodName = "deleteAtlasGlossaryCategory(glossaryGUID)";
        String url = this.targetRootURL + "/api/atlas/v2/glossary/category/" + category.getGuid();
        this.callDeleteRESTCall("deleteAtlasGlossaryCategory(glossaryGUID)", url);
    }

    private <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callNoLogGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, false, error);
            return null;
        }
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callNoLogGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, false, error);
            return null;
        }
    }

    private <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callNoLogPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, false, error);
            return null;
        }
    }

    private <T> T callPostRESTCallNameConflict(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            if (!error.getMessage().contains("org.springframework.web.client.HttpClientErrorException$Conflict")) {
                this.logRESTCallException(methodName, true, error);
            }
            throw new PropertyServerException(ApacheAtlasErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.atlasServerName, this.targetRootURL, error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
        }
    }

    private <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPostRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPutRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPutRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private void callDeleteRESTCall(String methodName, String urlTemplate) throws PropertyServerException {
        try {
            this.clientConnector.callDeleteRESTCallNoParams(methodName, Object.class, urlTemplate, null);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
        }
    }

    private <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callDeleteRESTCall(methodName, responseType, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, boolean logMessage, Exception error) throws PropertyServerException {
        if (this.auditLog != null && logMessage) {
            this.auditLog.logException(methodName, ApacheAtlasAuditCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.atlasServerName, this.targetRootURL, error.getMessage()), (Throwable)error);
        }
        throw new PropertyServerException(ApacheAtlasErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.atlasServerName, this.targetRootURL, error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
    }
}

