/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum ApacheAtlasAuditCode implements AuditLogMessageSet
{
    BAD_CONFIGURATION("APACHE-ATLAS-REST-CONNECTOR-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The {0} Apache Atlas REST Connector encountered an {1} exception when connecting to {2} during the {3} method.  The exception message included was {4}", "The exception is passed back to the Catalog Integrator OMIS in the integration daemon that is hosting this connector to enable it to perform error handling.  More messages are likely to follow describing the error handling that was performed.  These can help to determine how to recover from this error", "This message contains the exception that was the original cause of the problem. Use the information from the exception stack trace to determine why the connector is not able to access the event broker and resolve that issue.  Use the messages that where subsequently logged during the error handling to discover how to restart the connector in the integration daemon once the original cause of the error has been corrected."),
    UNEXPECTED_EXCEPTION("APACHE-ATLAS-REST-CONNECTOR-0008", OMRSAuditLogRecordSeverity.EXCEPTION, "The {0} Apache Atlas REST Connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to catalog one or more metadata elements.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    CONNECTOR_STOPPING("APACHE-ATLAS-REST-CONNECTOR-0009", OMRSAuditLogRecordSeverity.INFO, "The {0} Apache Atlas REST Connector has stopped its monitoring of Apache Atlas at {1} and is shutting down", "The connector is disconnecting.", "No action is required unless there are errors that follow indicating that there were problems shutting down."),
    CLIENT_SIDE_REST_API_ERROR("APACHE-ATLAS-REST-CONNECTOR-0031", OMRSAuditLogRecordSeverity.EXCEPTION, "A client-side exception was received from API call {0} to server {1} at {2}.  The error message was {3}", "The server has issued a call to the open metadata access service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error.");

    private final String logMessageId;
    private final OMRSAuditLogRecordSeverity severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private ApacheAtlasAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ApacheAtlasAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

