/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.resource.apacheatlas.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AtlasOperator {
    LT(new String[]{"<", "lt"}),
    GT(new String[]{">", "gt"}),
    LTE(new String[]{"<=", "lte"}),
    GTE(new String[]{">=", "gte"}),
    EQ(new String[]{"=", "eq"}),
    NEQ(new String[]{"!=", "neq"}),
    IN(new String[]{"in", "IN"}),
    LIKE(new String[]{"like", "LIKE"}),
    STARTS_WITH(new String[]{"startsWith", "STARTSWITH", "begins_with", "BEGINS_WITH"}),
    ENDS_WITH(new String[]{"endsWith", "ENDSWITH", "ends_with", "ENDS_WITH"}),
    CONTAINS(new String[]{"contains", "CONTAINS"}),
    NOT_CONTAINS(new String[]{"not_contains", "NOT_CONTAINS"}),
    CONTAINS_ANY(new String[]{"containsAny", "CONTAINSANY", "contains_any", "CONTAINS_ANY"}),
    CONTAINS_ALL(new String[]{"containsAll", "CONTAINSALL", "contains_all", "CONTAINS_ALL"}),
    IS_NULL(new String[]{"isNull", "ISNULL", "is_null", "IS_NULL"}),
    NOT_NULL(new String[]{"notNull", "NOTNULL", "not_null", "NOT_NULL"}),
    TIME_RANGE(new String[]{"timerange", "TIMERANGE", "time_range", "TIME_RANGE"}),
    NOT_EMPTY(new String[]{"notEmpty", "NOTEMPTY", "not_empty", "NOT_EMPTY"});

    static final Map<String, AtlasOperator> operatorsMap;
    private final String[] symbols;

    private AtlasOperator(String[] symbols) {
        this.symbols = symbols;
    }

    public static AtlasOperator fromString(String symbol) {
        return operatorsMap.get(symbol);
    }

    public String getSymbol() {
        return this.symbols[0];
    }

    public String[] getSymbols() {
        return this.symbols;
    }

    public String toString() {
        return this.getSymbol();
    }

    static {
        operatorsMap = new HashMap<String, AtlasOperator>();
        for (AtlasOperator operator : AtlasOperator.values()) {
            for (String s : operator.symbols) {
                operatorsMap.put(s, operator);
            }
        }
    }
}

