/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.api.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.APIManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIOperationElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIParameterElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIOperationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListType;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class APIIntegratorContext {
    private APIManagerClient client;
    private DataManagerEventClient eventClient;
    private String userId;
    private String apiManagerGUID;
    private String apiManagerName;
    private boolean apiManagerIsHome = true;

    public APIIntegratorContext(APIManagerClient client, DataManagerEventClient eventClient, String userId, String apiManagerGUID, String apiManagerName) {
        this.client = client;
        this.eventClient = eventClient;
        this.userId = userId;
        this.apiManagerGUID = apiManagerGUID;
        this.apiManagerName = apiManagerName;
    }

    public void setAPIManagerIsHome(boolean apiManagerIsHome) {
        this.apiManagerIsHome = apiManagerIsHome;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createAPI(APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createAPI(this.userId, this.apiManagerGUID, this.apiManagerName, this.apiManagerIsHome, apiProperties);
    }

    public String createAPIFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.createAPIFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, this.apiManagerIsHome, templateGUID, templateProperties);
    }

    public void updateAPI(String apiGUID, boolean isMergeUpdate, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateAPI(this.userId, this.apiManagerGUID, this.apiManagerName, apiGUID, isMergeUpdate, apiProperties);
    }

    public void publishAPI(String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.publishAPI(this.userId, apiGUID);
    }

    public void withdrawAPI(String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.withdrawAPI(this.userId, apiGUID);
    }

    public void removeAPI(String apiGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeAPI(this.userId, this.apiManagerGUID, this.apiManagerName, apiGUID, qualifiedName);
    }

    public List<APIElement> findAPIs(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findAPIs(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIElement> getAPIsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIsByName(this.userId, name, startFrom, pageSize);
    }

    public List<APIElement> getMyAPIs(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIsForAPIManager(this.userId, this.apiManagerGUID, this.apiManagerName, startFrom, pageSize);
    }

    public APIElement getAPIByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIByGUID(this.userId, guid);
    }

    public String createAPIOperation(String apiGUID, APIOperationProperties apiOperationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createAPIOperation(this.userId, this.apiManagerGUID, this.apiManagerName, apiGUID, apiOperationProperties);
        }
        return this.client.createAPIOperation(this.userId, null, null, apiGUID, apiOperationProperties);
    }

    public String createAPIOperationFromTemplate(String templateGUID, String apiGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createAPIOperationFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, templateGUID, apiGUID, templateProperties);
        }
        return this.client.createAPIOperationFromTemplate(this.userId, null, null, templateGUID, apiGUID, templateProperties);
    }

    public void updateAPIOperation(String apiOperationGUID, boolean isMergeUpdate, APIOperationProperties apiOperationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateAPIOperation(this.userId, this.apiManagerGUID, this.apiManagerName, apiOperationGUID, isMergeUpdate, apiOperationProperties);
    }

    public void removeAPIOperation(String apiOperationGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeAPIOperation(this.userId, this.apiManagerGUID, this.apiManagerName, apiOperationGUID, qualifiedName);
    }

    public List<APIOperationElement> findAPIOperations(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findAPIOperations(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIOperationElement> getOperationsForAPI(String apiGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getOperationsForAPI(this.userId, apiGUID, startFrom, pageSize);
    }

    public List<APIOperationElement> getAPIOperationsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIOperationsByName(this.userId, name, startFrom, pageSize);
    }

    public APIOperationElement getAPIOperationByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIOperationByGUID(this.userId, guid);
    }

    public String createAPIParameterList(String apiOperationGUID, APIParameterListType parameterListType, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createAPIParameterList(this.userId, this.apiManagerGUID, this.apiManagerName, apiOperationGUID, parameterListType, properties);
        }
        return this.client.createAPIParameterList(this.userId, null, null, apiOperationGUID, parameterListType, properties);
    }

    public String createAPIParameterListFromTemplate(String templateGUID, String apiOperationGUID, APIParameterListType parameterListType, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createAPIParameterListFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, templateGUID, apiOperationGUID, parameterListType, templateProperties);
        }
        return this.client.createAPIParameterListFromTemplate(this.userId, null, null, templateGUID, apiOperationGUID, parameterListType, templateProperties);
    }

    public void updateAPIParameterList(String apiParameterListGUID, boolean isMergeUpdate, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateAPIParameterList(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterListGUID, isMergeUpdate, properties);
    }

    public void removeAPIParameterList(String apiParameterListGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeAPIParameterList(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterListGUID, qualifiedName);
    }

    public List<APIParameterListElement> findAPIParameterLists(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findAPIParameterLists(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIParameterListElement> getParameterListsForAPIOperation(String apiOperationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getParameterListsForAPIOperation(this.userId, apiOperationGUID, startFrom, pageSize);
    }

    public List<APIParameterListElement> getAPIParameterListsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIParameterListsByName(this.userId, name, startFrom, pageSize);
    }

    public APIParameterListElement getAPIParameterListByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIParameterListByGUID(this.userId, guid);
    }

    public String createAPIParameter(String schemaElementGUID, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createAPIParameter(this.userId, this.apiManagerGUID, this.apiManagerName, schemaElementGUID, apiParameterProperties);
        }
        return this.client.createAPIParameter(this.userId, null, null, schemaElementGUID, apiParameterProperties);
    }

    public String createAPIParameterFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createAPIParameterFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, schemaElementGUID, templateGUID, templateProperties);
        }
        return this.client.createAPIParameterFromTemplate(this.userId, null, null, schemaElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String relationshipTypeName, String apiParameterGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            this.client.setupSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        } else {
            this.client.setupSchemaType(this.userId, null, null, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        }
    }

    public void clearSchemaTypes(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.clearSchemaTypes(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterGUID);
    }

    public void updateAPIParameter(String apiParameterGUID, boolean isMergeUpdate, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateAPIParameter(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterGUID, isMergeUpdate, apiParameterProperties);
    }

    public void removeAPIParameter(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeAPIParameter(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterGUID);
    }

    public List<APIParameterElement> findAPIParameters(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findAPIParameters(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<APIParameterElement> getNestedAPIParameters(String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getNestedAPIParameters(this.userId, parentElementGUID, startFrom, pageSize);
    }

    public List<APIParameterElement> getAPIParametersByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIParametersByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public APIParameterElement getAPIParameterByGUID(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getAPIParameterByGUID(this.userId, apiParameterGUID);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createPrimitiveSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties);
        }
        return this.client.createPrimitiveSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createLiteralSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties);
        }
        return this.client.createLiteralSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createEnumSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties, validValuesSetGUID);
        }
        return this.client.createEnumSchemaType(this.userId, null, null, schemaTypeProperties, validValuesSetGUID);
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createStructSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties);
        }
        return this.client.createStructSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createSchemaTypeChoice(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties, schemaTypeOptionGUIDs);
        }
        return this.client.createSchemaTypeChoice(this.userId, null, null, schemaTypeProperties, schemaTypeOptionGUIDs);
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createMapSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        }
        return this.client.createMapSchemaType(this.userId, null, null, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.client.createSchemaTypeFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, templateGUID, templateProperties);
        }
        return this.client.createSchemaTypeFromTemplate(this.userId, null, null, templateGUID, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.updateSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.removeSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeGUID);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.client.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }
}

