/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.api.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.APIManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIOperationElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIParameterElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIOperationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListType;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EnumSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.MapSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.StructSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

public class APIIntegratorContext {
    private final APIManagerClient apiManagerClient;
    private final ConnectionManagerClient connectionManagerClient;
    private final DataManagerEventClient eventClient;
    private final String userId;
    private final String apiManagerGUID;
    private final String apiManagerName;
    private boolean apiManagerIsHome = true;

    public APIIntegratorContext(APIManagerClient apiManagerClient, ConnectionManagerClient connectionManagerClient, DataManagerEventClient eventClient, String userId, String apiManagerGUID, String apiManagerName) {
        this.apiManagerClient = apiManagerClient;
        this.connectionManagerClient = connectionManagerClient;
        this.eventClient = eventClient;
        this.userId = userId;
        this.apiManagerGUID = apiManagerGUID;
        this.apiManagerName = apiManagerName;
    }

    public String getAPIManagerName() {
        return this.apiManagerName;
    }

    public void setAPIManagerIsHome(boolean apiManagerIsHome) {
        this.apiManagerIsHome = apiManagerIsHome;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createEndpoint(EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpoint(this.userId, null, null, endpointProperties);
    }

    public String createEndpointFromTemplate(String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpointFromTemplate(this.userId, null, null, networkAddress, templateGUID, templateProperties);
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateEndpoint(this.userId, this.apiManagerGUID, this.apiManagerName, isMergeUpdate, endpointGUID, endpointProperties);
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeEndpoint(this.userId, this.apiManagerGUID, this.apiManagerName, endpointGUID);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public String createAPI(String endpointGUID, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.createAPI(this.userId, this.apiManagerGUID, this.apiManagerName, this.apiManagerIsHome, endpointGUID, apiProperties);
    }

    public String createAPIFromTemplate(String endpointGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.createAPIFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, this.apiManagerIsHome, endpointGUID, templateGUID, templateProperties);
    }

    public void updateAPI(String apiGUID, boolean isMergeUpdate, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPI(this.userId, this.apiManagerGUID, this.apiManagerName, apiGUID, isMergeUpdate, apiProperties);
    }

    public void publishAPI(String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.publishAPI(this.userId, apiGUID);
    }

    public void withdrawAPI(String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.withdrawAPI(this.userId, apiGUID);
    }

    public void removeAPI(String apiGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPI(this.userId, this.apiManagerGUID, this.apiManagerName, apiGUID, qualifiedName);
    }

    public List<APIElement> findAPIs(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIs(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIElement> getAPIsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIsByName(this.userId, name, startFrom, pageSize);
    }

    public List<APIElement> getMyAPIs(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIsForAPIManager(this.userId, this.apiManagerGUID, this.apiManagerName, startFrom, pageSize);
    }

    public APIElement getAPIByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIByGUID(this.userId, guid);
    }

    public String createAPIOperation(String apiGUID, APIOperationProperties apiOperationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createAPIOperation(this.userId, this.apiManagerGUID, this.apiManagerName, apiGUID, apiOperationProperties);
        }
        return this.apiManagerClient.createAPIOperation(this.userId, null, null, apiGUID, apiOperationProperties);
    }

    public String createAPIOperationFromTemplate(String templateGUID, String apiGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createAPIOperationFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, templateGUID, apiGUID, templateProperties);
        }
        return this.apiManagerClient.createAPIOperationFromTemplate(this.userId, null, null, templateGUID, apiGUID, templateProperties);
    }

    public void updateAPIOperation(String apiOperationGUID, boolean isMergeUpdate, APIOperationProperties apiOperationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPIOperation(this.userId, this.apiManagerGUID, this.apiManagerName, apiOperationGUID, isMergeUpdate, apiOperationProperties);
    }

    public void removeAPIOperation(String apiOperationGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPIOperation(this.userId, this.apiManagerGUID, this.apiManagerName, apiOperationGUID, qualifiedName);
    }

    public List<APIOperationElement> findAPIOperations(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIOperations(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIOperationElement> getOperationsForAPI(String apiGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getOperationsForAPI(this.userId, apiGUID, startFrom, pageSize);
    }

    public List<APIOperationElement> getAPIOperationsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIOperationsByName(this.userId, name, startFrom, pageSize);
    }

    public APIOperationElement getAPIOperationByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIOperationByGUID(this.userId, guid);
    }

    public String createAPIParameterList(String apiOperationGUID, APIParameterListType parameterListType, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createAPIParameterList(this.userId, this.apiManagerGUID, this.apiManagerName, apiOperationGUID, parameterListType, properties);
        }
        return this.apiManagerClient.createAPIParameterList(this.userId, null, null, apiOperationGUID, parameterListType, properties);
    }

    public String createAPIParameterListFromTemplate(String templateGUID, String apiOperationGUID, APIParameterListType parameterListType, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createAPIParameterListFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, templateGUID, apiOperationGUID, parameterListType, templateProperties);
        }
        return this.apiManagerClient.createAPIParameterListFromTemplate(this.userId, null, null, templateGUID, apiOperationGUID, parameterListType, templateProperties);
    }

    public void updateAPIParameterList(String apiParameterListGUID, boolean isMergeUpdate, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPIParameterList(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterListGUID, isMergeUpdate, properties);
    }

    public void removeAPIParameterList(String apiParameterListGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPIParameterList(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterListGUID, qualifiedName);
    }

    public List<APIParameterListElement> findAPIParameterLists(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIParameterLists(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIParameterListElement> getParameterListsForAPIOperation(String apiOperationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getParameterListsForAPIOperation(this.userId, apiOperationGUID, startFrom, pageSize);
    }

    public List<APIParameterListElement> getAPIParameterListsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParameterListsByName(this.userId, name, startFrom, pageSize);
    }

    public APIParameterListElement getAPIParameterListByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParameterListByGUID(this.userId, guid);
    }

    public String createAPIParameter(String schemaElementGUID, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createAPIParameter(this.userId, this.apiManagerGUID, this.apiManagerName, schemaElementGUID, apiParameterProperties);
        }
        return this.apiManagerClient.createAPIParameter(this.userId, null, null, schemaElementGUID, apiParameterProperties);
    }

    public String createAPIParameterFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createAPIParameterFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, schemaElementGUID, templateGUID, templateProperties);
        }
        return this.apiManagerClient.createAPIParameterFromTemplate(this.userId, null, null, schemaElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String relationshipTypeName, String apiParameterGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            this.apiManagerClient.setupSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        } else {
            this.apiManagerClient.setupSchemaType(this.userId, null, null, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        }
    }

    public void clearSchemaTypes(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.clearSchemaTypes(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterGUID);
    }

    public void updateAPIParameter(String apiParameterGUID, boolean isMergeUpdate, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPIParameter(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterGUID, isMergeUpdate, apiParameterProperties);
    }

    public void removeAPIParameter(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPIParameter(this.userId, this.apiManagerGUID, this.apiManagerName, apiParameterGUID);
    }

    public List<APIParameterElement> findAPIParameters(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIParameters(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<APIParameterElement> getNestedAPIParameters(String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getNestedAPIParameters(this.userId, parentElementGUID, startFrom, pageSize);
    }

    public List<APIParameterElement> getAPIParametersByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParametersByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public APIParameterElement getAPIParameterByGUID(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParameterByGUID(this.userId, apiParameterGUID);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createPrimitiveSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties);
        }
        return this.apiManagerClient.createPrimitiveSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createLiteralSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties);
        }
        return this.apiManagerClient.createLiteralSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createEnumSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties, validValuesSetGUID);
        }
        return this.apiManagerClient.createEnumSchemaType(this.userId, null, null, schemaTypeProperties, validValuesSetGUID);
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createStructSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties);
        }
        return this.apiManagerClient.createStructSchemaType(this.userId, null, null, schemaTypeProperties);
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createSchemaTypeChoice(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties, schemaTypeOptionGUIDs);
        }
        return this.apiManagerClient.createSchemaTypeChoice(this.userId, null, null, schemaTypeProperties, schemaTypeOptionGUIDs);
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createMapSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        }
        return this.apiManagerClient.createMapSchemaType(this.userId, null, null, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.apiManagerIsHome) {
            return this.apiManagerClient.createSchemaTypeFromTemplate(this.userId, this.apiManagerGUID, this.apiManagerName, templateGUID, templateProperties);
        }
        return this.apiManagerClient.createSchemaTypeFromTemplate(this.userId, null, null, templateGUID, templateProperties);
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeSchemaType(this.userId, this.apiManagerGUID, this.apiManagerName, schemaTypeGUID);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }
}

