/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.api.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.APIManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.ValidValueManagement;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.openmetadata.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.openmetadata.enums.APIParameterListType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIOperationElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIParameterElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIParameterListElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EndpointElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.apis.APIProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.EnumSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.MapSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeChoiceProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.StructSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIOperationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIParameterListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIParameterProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueProperties;

public class APIIntegratorContext
extends IntegrationContext {
    private final APIManagerClient apiManagerClient;
    private final ConnectionManagerClient connectionManagerClient;
    private final DataManagerEventClient eventClient;
    private final ValidValueManagement validValueManagement;

    public APIIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, GovernanceConfiguration governanceConfiguration, OpenMetadataClient openMetadataStoreClient, ActionControlInterface actionControlInterface, APIManagerClient apiManagerClient, ConnectionManagerClient connectionManagerClient, ValidValueManagement validValueManagement, DataManagerEventClient eventClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String externalSourceGUID, String externalSourceName, AuditLog auditLog, int maxPageSize) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, governanceConfiguration, openMetadataStoreClient, actionControlInterface, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID, auditLog, maxPageSize);
        this.apiManagerClient = apiManagerClient;
        this.connectionManagerClient = connectionManagerClient;
        this.validValueManagement = validValueManagement;
        this.eventClient = eventClient;
    }

    public String getAPIManagerName() {
        return this.externalSourceName;
    }

    public void setAPIManagerIsHome(boolean apiManagerIsHome) {
        this.externalSourceIsHome = apiManagerIsHome;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createEndpoint(EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUID = this.connectionManagerClient.createEndpoint(this.userId, null, null, endpointProperties);
        if (endpointGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(endpointGUID);
        }
        return endpointGUID;
    }

    public String createEndpointFromTemplate(String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endpointGUID = this.connectionManagerClient.createEndpointFromTemplate(this.userId, null, null, networkAddress, templateGUID, templateProperties);
        if (endpointGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(endpointGUID);
        }
        return endpointGUID;
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, isMergeUpdate, endpointGUID, endpointProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(endpointGUID);
        }
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, endpointGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(endpointGUID);
        }
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public String createAPI(String endpointGUID, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiGUID = this.apiManagerClient.createAPI(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, endpointGUID, apiProperties);
        if (apiGUID != null && this.integrationReportWriter != null) {
            if (apiProperties != null && apiProperties.getTypeName() != null) {
                this.integrationReportWriter.reportElementCreation(apiGUID);
            } else {
                this.integrationReportWriter.reportElementCreation(apiGUID);
            }
        }
        return apiGUID;
    }

    public String createAPIFromTemplate(String endpointGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiGUID = this.apiManagerClient.createAPIFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, this.externalSourceIsHome, endpointGUID, templateGUID, templateProperties);
        if (apiGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(apiGUID);
        }
        return apiGUID;
    }

    public void updateAPI(String apiGUID, boolean isMergeUpdate, APIProperties apiProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPI(this.userId, this.externalSourceGUID, this.externalSourceName, apiGUID, isMergeUpdate, apiProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(apiGUID);
        }
    }

    public void publishAPI(String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.publishAPI(this.userId, apiGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(apiGUID);
        }
    }

    public void withdrawAPI(String apiGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.withdrawAPI(this.userId, apiGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(apiGUID);
        }
    }

    public void removeAPI(String apiGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPI(this.userId, this.externalSourceGUID, this.externalSourceName, apiGUID, qualifiedName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(apiGUID);
        }
    }

    public List<APIElement> findAPIs(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIs(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIElement> getAPIsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIsByName(this.userId, name, startFrom, pageSize);
    }

    public List<APIElement> getMyAPIs(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIsForAPIManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize);
    }

    public APIElement getAPIByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIByGUID(this.userId, guid);
    }

    public String createAPIOperation(String apiGUID, APIOperationProperties apiOperationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiOperationGUID = this.externalSourceIsHome ? this.apiManagerClient.createAPIOperation(this.userId, this.externalSourceGUID, this.externalSourceName, apiGUID, apiOperationProperties) : this.apiManagerClient.createAPIOperation(this.userId, null, null, apiGUID, apiOperationProperties);
        if (apiOperationGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(apiOperationGUID);
        }
        return apiOperationGUID;
    }

    public String createAPIOperationFromTemplate(String templateGUID, String apiGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiOperationGUID = this.externalSourceIsHome ? this.apiManagerClient.createAPIOperationFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, apiGUID, templateProperties) : this.apiManagerClient.createAPIOperationFromTemplate(this.userId, null, null, templateGUID, apiGUID, templateProperties);
        if (apiOperationGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(apiOperationGUID);
        }
        return apiOperationGUID;
    }

    public void updateAPIOperation(String apiOperationGUID, boolean isMergeUpdate, APIOperationProperties apiOperationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPIOperation(this.userId, this.externalSourceGUID, this.externalSourceName, apiOperationGUID, isMergeUpdate, apiOperationProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(apiOperationGUID);
        }
    }

    public void removeAPIOperation(String apiOperationGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPIOperation(this.userId, this.externalSourceGUID, this.externalSourceName, apiOperationGUID, qualifiedName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(apiOperationGUID);
        }
    }

    public List<APIOperationElement> findAPIOperations(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIOperations(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIOperationElement> getOperationsForAPI(String apiGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getOperationsForAPI(this.userId, apiGUID, startFrom, pageSize);
    }

    public List<APIOperationElement> getAPIOperationsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIOperationsByName(this.userId, name, startFrom, pageSize);
    }

    public APIOperationElement getAPIOperationByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIOperationByGUID(this.userId, guid);
    }

    public String createAPIParameterList(String apiOperationGUID, APIParameterListType parameterListType, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiParameterListGUID = this.externalSourceIsHome ? this.apiManagerClient.createAPIParameterList(this.userId, this.externalSourceGUID, this.externalSourceName, apiOperationGUID, parameterListType, properties) : this.apiManagerClient.createAPIParameterList(this.userId, null, null, apiOperationGUID, parameterListType, properties);
        return apiParameterListGUID;
    }

    public String createAPIParameterListFromTemplate(String templateGUID, String apiOperationGUID, APIParameterListType parameterListType, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiParameterListGUID = this.externalSourceIsHome ? this.apiManagerClient.createAPIParameterListFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, apiOperationGUID, parameterListType, templateProperties) : this.apiManagerClient.createAPIParameterListFromTemplate(this.userId, null, null, templateGUID, apiOperationGUID, parameterListType, templateProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(apiParameterListGUID);
        }
        return apiParameterListGUID;
    }

    public void updateAPIParameterList(String apiParameterListGUID, boolean isMergeUpdate, APIParameterListProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPIParameterList(this.userId, this.externalSourceGUID, this.externalSourceName, apiParameterListGUID, isMergeUpdate, properties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(apiParameterListGUID);
        }
    }

    public void removeAPIParameterList(String apiParameterListGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPIParameterList(this.userId, this.externalSourceGUID, this.externalSourceName, apiParameterListGUID, qualifiedName);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(apiParameterListGUID);
        }
    }

    public List<APIParameterListElement> findAPIParameterLists(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIParameterLists(this.userId, searchString, startFrom, pageSize);
    }

    public List<APIParameterListElement> getParameterListsForAPIOperation(String apiOperationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getParameterListsForAPIOperation(this.userId, apiOperationGUID, startFrom, pageSize);
    }

    public List<APIParameterListElement> getAPIParameterListsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParameterListsByName(this.userId, name, startFrom, pageSize);
    }

    public APIParameterListElement getAPIParameterListByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParameterListByGUID(this.userId, guid);
    }

    public String createAPIParameter(String schemaElementGUID, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiParameterGUID = this.externalSourceIsHome ? this.apiManagerClient.createAPIParameter(this.userId, this.externalSourceGUID, this.externalSourceName, schemaElementGUID, apiParameterProperties) : this.apiManagerClient.createAPIParameter(this.userId, null, null, schemaElementGUID, apiParameterProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(apiParameterGUID);
        }
        return apiParameterGUID;
    }

    public String createAPIParameterFromTemplate(String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiParameterGUID = this.externalSourceIsHome ? this.apiManagerClient.createAPIParameterFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, schemaElementGUID, templateGUID, templateProperties) : this.apiManagerClient.createAPIParameterFromTemplate(this.userId, null, null, schemaElementGUID, templateGUID, templateProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(apiParameterGUID);
        }
        return apiParameterGUID;
    }

    public void setupSchemaType(String relationshipTypeName, String apiParameterGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.externalSourceIsHome) {
            this.apiManagerClient.setupSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        } else {
            this.apiManagerClient.setupSchemaType(this.userId, null, null, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        }
    }

    public void clearSchemaTypes(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.clearSchemaTypes(this.userId, this.externalSourceGUID, this.externalSourceName, apiParameterGUID);
    }

    public void updateAPIParameter(String apiParameterGUID, boolean isMergeUpdate, APIParameterProperties apiParameterProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateAPIParameter(this.userId, this.externalSourceGUID, this.externalSourceName, apiParameterGUID, isMergeUpdate, apiParameterProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(apiParameterGUID);
        }
    }

    public void removeAPIParameter(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeAPIParameter(this.userId, this.externalSourceGUID, this.externalSourceName, apiParameterGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(apiParameterGUID);
        }
    }

    public List<APIParameterElement> findAPIParameters(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findAPIParameters(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public List<APIParameterElement> getNestedAPIParameters(String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getNestedAPIParameters(this.userId, parentElementGUID, startFrom, pageSize);
    }

    public List<APIParameterElement> getAPIParametersByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParametersByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public APIParameterElement getAPIParameterByGUID(String apiParameterGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getAPIParameterByGUID(this.userId, apiParameterGUID);
    }

    public String createPrimitiveSchemaType(PrimitiveSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createPrimitiveSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties) : this.apiManagerClient.createPrimitiveSchemaType(this.userId, null, null, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createLiteralSchemaType(LiteralSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createLiteralSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties) : this.apiManagerClient.createLiteralSchemaType(this.userId, null, null, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createEnumSchemaType(EnumSchemaTypeProperties schemaTypeProperties, String validValuesSetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createEnumSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties, validValuesSetGUID) : this.apiManagerClient.createEnumSchemaType(this.userId, null, null, schemaTypeProperties, validValuesSetGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public List<ValidValueSetElement> getValidValueSetByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getValidValueSetByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueSetElement> findValidValueSet(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findValidValueSet(this.userId, searchString, startFrom, pageSize);
    }

    public String createStructSchemaType(StructSchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createStructSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties) : this.apiManagerClient.createStructSchemaType(this.userId, null, null, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createSchemaTypeChoice(SchemaTypeChoiceProperties schemaTypeProperties, List<String> schemaTypeOptionGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createSchemaTypeChoice(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties, schemaTypeOptionGUIDs) : this.apiManagerClient.createSchemaTypeChoice(this.userId, null, null, schemaTypeProperties, schemaTypeOptionGUIDs);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createMapSchemaType(MapSchemaTypeProperties schemaTypeProperties, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createMapSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID) : this.apiManagerClient.createMapSchemaType(this.userId, null, null, schemaTypeProperties, mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public String createSchemaTypeFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUID = this.externalSourceIsHome ? this.apiManagerClient.createSchemaTypeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, templateGUID, templateProperties) : this.apiManagerClient.createSchemaTypeFromTemplate(this.userId, null, null, templateGUID, templateProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(schemaTypeGUID);
        }
        return schemaTypeGUID;
    }

    public void updateSchemaType(String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.updateSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID, isMergeUpdate, schemaTypeProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(schemaTypeGUID);
        }
    }

    public void removeSchemaType(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.removeSchemaType(this.userId, this.externalSourceGUID, this.externalSourceName, schemaTypeGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(schemaTypeGUID);
        }
    }

    public void setupSchemaElementRelationship(String endOneGUID, String endTwoGUID, String relationshipTypeName, RelationshipProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.setupSchemaElementRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, endOneGUID, endTwoGUID, relationshipTypeName, properties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(endOneGUID);
        }
    }

    public void clearSchemaElementRelationship(String endOneGUID, String endTwoGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.apiManagerClient.clearSchemaElementRelationship(this.userId, this.externalSourceGUID, this.externalSourceName, endOneGUID, endTwoGUID, relationshipTypeName);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.findSchemaType(this.userId, searchString, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeForElement(this.userId, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeByName(this.userId, name, typeName, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeByGUID(this.userId, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.apiManagerClient.getSchemaTypeParent(this.userId, schemaTypeGUID);
    }

    public String createValidValue(ValidValueProperties validValueProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUID = this.validValueManagement.createValidValue(this.userId, this.externalSourceGUID, this.externalSourceName, validValueProperties);
        if (validValueGUID != null && this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(validValueGUID);
        }
        return validValueGUID;
    }

    public void updateValidValue(String validValueGUID, boolean isMergeUpdate, ValidValueProperties validValueProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.updateValidValue(this.userId, this.externalSourceGUID, this.externalSourceName, validValueGUID, isMergeUpdate, validValueProperties);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(validValueGUID);
        }
    }

    public void setupValidValueMember(String validValueSetGUID, ValidValueMembershipProperties properties, String validValueMemberGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.setupValidValueMember(this.userId, this.externalSourceGUID, this.externalSourceName, validValueSetGUID, properties, validValueMemberGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(validValueSetGUID);
        }
    }

    public void clearValidValueMember(String validValueSetGUID, String validValueMemberGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.clearValidValueMember(this.userId, this.externalSourceGUID, this.externalSourceName, validValueSetGUID, validValueMemberGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(validValueSetGUID);
        }
    }

    public void setupValidValues(String elementGUID, ValidValueAssignmentProperties properties, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.setupValidValues(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, properties, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void clearValidValues(String elementGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.clearValidValues(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void setupReferenceValueTag(String elementGUID, ReferenceValueAssignmentProperties properties, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.setupReferenceValueTag(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, properties, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void clearReferenceValueTag(String elementGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.clearReferenceValueTag(this.userId, this.externalSourceGUID, this.externalSourceName, elementGUID, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    public void removeValidValue(String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.validValueManagement.removeValidValue(this.userId, this.externalSourceGUID, this.externalSourceName, validValueGUID);
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(validValueGUID);
        }
    }

    public List<ValidValueElement> findValidValues(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.findValidValues(this.userId, searchString, startFrom, pageSize);
    }

    public List<ValidValueElement> getValidValuesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValuesByName(this.userId, name, startFrom, pageSize);
    }

    public List<ValidValueElement> getAllValidValues(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getAllValidValues(this.userId, startFrom, pageSize);
    }

    public List<ValidValueElement> getValidValueSetMembers(String validValueSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValueSetMembers(this.userId, validValueSetGUID, startFrom, pageSize);
    }

    public List<ValidValueElement> getSetsForValidValue(String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getSetsForValidValue(this.userId, validValueGUID, startFrom, pageSize);
    }

    public ValidValueElement getValidValuesForConsumer(String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValuesForConsumer(this.userId, elementGUID);
    }

    public List<RelatedElementStub> getConsumersOfValidValue(String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getConsumersOfValidValue(this.userId, validValueGUID, startFrom, pageSize);
    }

    public List<ValidValueElement> getReferenceValues(String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getReferenceValues(this.userId, elementGUID, startFrom, pageSize);
    }

    public List<RelatedElementStub> getAssigneesOfReferenceValue(String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getAssigneesOfReferenceValue(this.userId, validValueGUID, startFrom, pageSize);
    }

    public ValidValueElement getValidValueByGUID(String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValueManagement.getValidValueByGUID(this.userId, validValueGUID);
    }
}

